/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.util.HashMap;
import java.util.Map;
import org.deepsymmetry.beatlink.CdjStatus;
import org.deepsymmetry.beatlink.data.DataReference;

public class SlotReference {
    public final int player;
    public final CdjStatus.TrackSourceSlot slot;
    private static final Map<Integer, Map<CdjStatus.TrackSourceSlot, SlotReference>> instances = new HashMap<Integer, Map<CdjStatus.TrackSourceSlot, SlotReference>>();

    private SlotReference(int player, CdjStatus.TrackSourceSlot slot) {
        this.player = player;
        this.slot = slot;
    }

    public static synchronized SlotReference getSlotReference(int player, CdjStatus.TrackSourceSlot slot) {
        SlotReference result;
        Map<CdjStatus.TrackSourceSlot, SlotReference> playerMap = instances.get(player);
        if (playerMap == null) {
            playerMap = new HashMap<CdjStatus.TrackSourceSlot, SlotReference>();
            instances.put(player, playerMap);
        }
        if ((result = playerMap.get((Object)slot)) == null) {
            result = new SlotReference(player, slot);
            playerMap.put(slot, result);
        }
        return result;
    }

    public static SlotReference getSlotReference(DataReference dataReference) {
        return SlotReference.getSlotReference(dataReference.player, dataReference.slot);
    }

    public String toString() {
        return "SlotReference[player:" + this.player + ", slot:" + (Object)((Object)this.slot) + "]";
    }
}

