/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink;

import java.net.DatagramPacket;
import org.deepsymmetry.beatlink.DeviceUpdate;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.VirtualCdj;

public class PrecisePosition
extends DeviceUpdate {
    private final int trackLength;
    private final int playbackPosition;
    private final int pitch;
    private final int bpm;

    public PrecisePosition(DatagramPacket packet) {
        super(packet, "Precise position", 60);
        this.trackLength = (int)Util.bytesToNumber(this.packetBytes, 36, 4);
        this.playbackPosition = (int)Util.bytesToNumber(this.packetBytes, 40, 4);
        long rawPitch = Util.bytesToNumber(this.packetBytes, 44, 4);
        if (rawPitch > 0x80000000L) {
            rawPitch -= 0x100000000L;
        }
        this.pitch = (int)Util.percentageToPitch((double)rawPitch / 100.0);
        this.bpm = (int)Util.bytesToNumber(this.packetBytes, 56, 4) * 10;
    }

    public int getTrackLength() {
        return this.trackLength;
    }

    public int getPlaybackPosition() {
        return this.playbackPosition;
    }

    @Override
    public int getPitch() {
        return this.pitch;
    }

    @Override
    public int getBpm() {
        return (int)Math.round((double)this.bpm / Util.pitchToMultiplier(this.pitch));
    }

    @Override
    public String toString() {
        return "Precise position: Device " + this.deviceNumber + ", name: " + this.deviceName + ", pitch: " + String.format("%+.2f%%", Util.pitchToPercentage(this.pitch)) + ", track BPM: " + String.format("%.1f", (double)this.bpm / 100.0) + ", effective BPM: " + String.format("%.1f", this.getEffectiveTempo());
    }

    @Override
    public boolean isTempoMaster() {
        DeviceUpdate master = VirtualCdj.getInstance().getTempoMaster();
        return master != null && master.getAddress().equals(this.address) && master.getDeviceNumber() == this.deviceNumber;
    }

    @Override
    public boolean isSynced() {
        return VirtualCdj.getInstance().getLatestStatusFor(this).isSynced();
    }

    @Override
    public Integer getDeviceMasterIsBeingYieldedTo() {
        return null;
    }

    @Override
    public double getEffectiveTempo() {
        return (double)this.bpm / 100.0;
    }

    @Override
    public int getBeatWithinBar() {
        return VirtualCdj.getInstance().getLatestStatusFor(this).getBeatWithinBar();
    }

    @Override
    public boolean isBeatWithinBarMeaningful() {
        return VirtualCdj.getInstance().getLatestStatusFor(this).isBeatWithinBarMeaningful();
    }
}

