/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import io.kaitai.struct.ByteBufferKaitaiStream;
import io.kaitai.struct.KaitaiStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.deepsymmetry.beatlink.CdjStatus;
import org.deepsymmetry.beatlink.DeviceAnnouncement;
import org.deepsymmetry.beatlink.DeviceAnnouncementListener;
import org.deepsymmetry.beatlink.DeviceFinder;
import org.deepsymmetry.beatlink.DeviceUpdate;
import org.deepsymmetry.beatlink.LifecycleListener;
import org.deepsymmetry.beatlink.LifecycleParticipant;
import org.deepsymmetry.beatlink.MediaDetails;
import org.deepsymmetry.beatlink.data.AnalysisTagListener;
import org.deepsymmetry.beatlink.data.AnalysisTagUpdate;
import org.deepsymmetry.beatlink.data.CueList;
import org.deepsymmetry.beatlink.data.DataReference;
import org.deepsymmetry.beatlink.data.DeckReference;
import org.deepsymmetry.beatlink.data.MetadataFinder;
import org.deepsymmetry.beatlink.data.MountListener;
import org.deepsymmetry.beatlink.data.SlotReference;
import org.deepsymmetry.beatlink.data.TrackMetadata;
import org.deepsymmetry.beatlink.data.TrackMetadataListener;
import org.deepsymmetry.beatlink.data.TrackMetadataUpdate;
import org.deepsymmetry.beatlink.dbserver.BinaryField;
import org.deepsymmetry.beatlink.dbserver.Client;
import org.deepsymmetry.beatlink.dbserver.ConnectionManager;
import org.deepsymmetry.beatlink.dbserver.Message;
import org.deepsymmetry.beatlink.dbserver.NumberField;
import org.deepsymmetry.cratedigger.pdb.RekordboxAnlz;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalysisTagFinder
extends LifecycleParticipant {
    private static final Logger logger = LoggerFactory.getLogger(AnalysisTagFinder.class);
    private final ConcurrentHashMap<DeckReference, ConcurrentHashMap<String, CacheEntry>> hotCache = new ConcurrentHashMap();
    private final LinkedBlockingDeque<TrackMetadataUpdate> pendingUpdates = new LinkedBlockingDeque(100);
    private final TrackMetadataListener metadataListener = new TrackMetadataListener(){

        @Override
        public void metadataChanged(TrackMetadataUpdate update) {
            logger.debug("Received metadata update {}", (Object)update);
            if (!AnalysisTagFinder.this.pendingUpdates.offerLast(update)) {
                logger.warn("Discarding metadata update because our queue is backed up.");
            }
        }
    };
    private final MountListener mountListener = new MountListener(){

        @Override
        public void mediaMounted(SlotReference slot) {
            logger.debug("AnalysisTagFinder doesn't yet need to do anything in response to a media mount.");
        }

        @Override
        public void mediaUnmounted(SlotReference slot) {
            for (Map.Entry deckEntry : new HashMap(AnalysisTagFinder.this.hotCache).entrySet()) {
                for (Map.Entry typeEntry : new HashMap((Map)deckEntry.getValue()).entrySet()) {
                    if (slot != SlotReference.getSlotReference(((CacheEntry)typeEntry.getValue()).dataReference)) continue;
                    logger.debug("Evicting cached track analysis sections in response to unmount report {}", typeEntry.getValue());
                    Map deckCache = (Map)AnalysisTagFinder.this.hotCache.get(deckEntry.getKey());
                    CacheEntry removed = null;
                    if (deckCache != null) {
                        removed = (CacheEntry)deckCache.remove(typeEntry.getKey());
                    }
                    if (((DeckReference)deckEntry.getKey()).hotCue != 0 || removed == null) continue;
                    AnalysisTagFinder.this.deliverAnalysisTagUpdate(((DeckReference)deckEntry.getKey()).player, removed.fileExtension, removed.typeTag, null);
                }
            }
        }
    };
    private final DeviceAnnouncementListener announcementListener = new DeviceAnnouncementListener(){

        @Override
        public void deviceFound(DeviceAnnouncement announcement) {
            logger.debug("Currently nothing for WaveformFinder to do when devices appear.");
        }

        @Override
        public void deviceLost(DeviceAnnouncement announcement) {
            logger.info("Clearing song structures in response to the loss of a device, {}", (Object)announcement);
            AnalysisTagFinder.this.clearTags(announcement);
        }
    };
    private final AtomicBoolean running = new AtomicBoolean(false);
    private Thread queueHandler;
    private final Set<String> activeRequests = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<String, Set<AnalysisTagListener>> analysisTagListeners = new ConcurrentHashMap<String, Set<AnalysisTagListener>>();
    private final LifecycleListener lifecycleListener = new LifecycleListener(){

        @Override
        public void started(LifecycleParticipant sender) {
            logger.debug("The AnalysisTagFinder does not auto-start when {} does.", (Object)sender);
        }

        @Override
        public void stopped(LifecycleParticipant sender) {
            if (AnalysisTagFinder.this.isRunning()) {
                logger.info("AnalysisTagFinder stopping because {} has.", (Object)sender);
                AnalysisTagFinder.this.stop();
            }
        }
    };
    private static final AnalysisTagFinder ourInstance = new AnalysisTagFinder();

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    private void clearDeckTags(TrackMetadataUpdate update) {
        Map oldTags = this.hotCache.remove(DeckReference.getDeckReference(update.player, 0));
        if (oldTags != null) {
            this.deliverTagLossUpdate(update.player, oldTags);
        }
    }

    private void clearTags(DeviceAnnouncement announcement) {
        int player = announcement.getDeviceNumber();
        for (DeckReference deck : new HashSet(this.hotCache.keySet())) {
            if (deck.player != player) continue;
            Map oldTags = this.hotCache.remove(deck);
            if (deck.hotCue != 0) continue;
            this.deliverTagLossUpdate(player, oldTags);
        }
    }

    private void updateAnalysisTag(TrackMetadataUpdate update, String fileExtension, String typeTag, RekordboxAnlz.TaggedSection analysisTag) {
        CacheEntry cacheEntry = new CacheEntry(update.metadata.trackReference, fileExtension, typeTag, analysisTag);
        String tagKey = typeTag + fileExtension;
        ConcurrentHashMap newDeckMap = new ConcurrentHashMap();
        ConcurrentHashMap<String, CacheEntry> deckMap = this.hotCache.putIfAbsent(DeckReference.getDeckReference(update.player, 0), newDeckMap);
        if (deckMap == null) {
            deckMap = newDeckMap;
        }
        deckMap.put(tagKey, cacheEntry);
        if (update.metadata.getCueList() != null) {
            for (CueList.Entry entry : update.metadata.getCueList().entries) {
                if (entry.hotCueNumber == 0) continue;
                newDeckMap = new ConcurrentHashMap();
                deckMap = this.hotCache.putIfAbsent(DeckReference.getDeckReference(update.player, entry.hotCueNumber), newDeckMap);
                if (deckMap == null) {
                    deckMap = newDeckMap;
                }
                deckMap.put(tagKey, cacheEntry);
            }
        }
        this.deliverAnalysisTagUpdate(update.player, fileExtension, typeTag, analysisTag);
    }

    public Map<DeckReference, Map<String, CacheEntry>> getLoadedAnalysisTags() {
        this.ensureRunning();
        HashMap result = new HashMap();
        for (Map.Entry<DeckReference, ConcurrentHashMap<String, CacheEntry>> entry : new HashMap<DeckReference, ConcurrentHashMap<String, CacheEntry>>(this.hotCache).entrySet()) {
            result.put(entry.getKey(), Collections.unmodifiableMap(new HashMap(entry.getValue())));
        }
        return Collections.unmodifiableMap(result);
    }

    public RekordboxAnlz.TaggedSection getLatestTrackAnalysisFor(int player, String fileExtension, String typeTag) {
        this.ensureRunning();
        Map deckTags = this.hotCache.get(DeckReference.getDeckReference(player, 0));
        if (deckTags == null) {
            return null;
        }
        CacheEntry entry = (CacheEntry)deckTags.get(typeTag + fileExtension);
        if (entry == null) {
            return null;
        }
        return entry.taggedSection;
    }

    public RekordboxAnlz.TaggedSection getLatestTrackAnalysisFor(DeviceUpdate update, String fileExtension, String typeTag) {
        return this.getLatestTrackAnalysisFor(update.getDeviceNumber(), fileExtension, typeTag);
    }

    private RekordboxAnlz.TaggedSection requestAnalysisTagInternal(final DataReference trackReference, final String fileExtension, final String typeTag, boolean failIfPassive) {
        RekordboxAnlz.TaggedSection provided;
        logger.debug("Trying to obtain: {} {}{}", new Object[]{trackReference, typeTag, fileExtension});
        MediaDetails sourceDetails = MetadataFinder.getInstance().getMediaDetailsFor(trackReference.getSlotReference());
        if (sourceDetails != null && (provided = MetadataFinder.getInstance().allMetadataProviders.getAnalysisSection(sourceDetails, trackReference, fileExtension, typeTag)) != null) {
            return provided;
        }
        logger.debug("Did not obtain via registered metadata providers; sourceDetails: {}", (Object)sourceDetails);
        if (MetadataFinder.getInstance().isPassive() && failIfPassive && trackReference.slot != CdjStatus.TrackSourceSlot.COLLECTION) {
            logger.debug("Giving up on trying to obtain: {} {}{}", new Object[]{trackReference, typeTag, fileExtension});
            return null;
        }
        ConnectionManager.ClientTask<RekordboxAnlz.TaggedSection> task = new ConnectionManager.ClientTask<RekordboxAnlz.TaggedSection>(){

            @Override
            public RekordboxAnlz.TaggedSection useClient(Client client) {
                logger.debug("tag task running");
                return AnalysisTagFinder.this.getTagViaDbServer(trackReference.rekordboxId, SlotReference.getSlotReference(trackReference), fileExtension, typeTag, client);
            }
        };
        try {
            logger.debug("submitting tag task");
            return ConnectionManager.getInstance().invokeWithClientSession(trackReference.player, task, "requesting analysis tag of type " + typeTag + " from file with extension " + fileExtension);
        }
        catch (Exception e) {
            logger.error("Problem requesting analysis tag, returning null", (Throwable)e);
            return null;
        }
    }

    public RekordboxAnlz.TaggedSection requestAnalysisTagFrom(DataReference dataReference, String fileExtension, String typeTag) {
        this.ensureRunning();
        String tagKey = typeTag + fileExtension;
        for (Map map : this.hotCache.values()) {
            CacheEntry cached = (CacheEntry)map.get(tagKey);
            if (cached == null || !cached.dataReference.equals(dataReference)) continue;
            return cached.taggedSection;
        }
        return this.requestAnalysisTagInternal(dataReference, fileExtension, typeTag, false);
    }

    public NumberField stringToProtocolNumber(String s) {
        long fourcc = 0L;
        for (int i = 3; i >= 0; --i) {
            fourcc *= 256L;
            if (i >= s.length()) continue;
            fourcc += (long)s.charAt(i);
        }
        return new NumberField(fourcc);
    }

    RekordboxAnlz.TaggedSection getTagViaDbServer(int rekordboxId, SlotReference slot, String fileExtension, String typeTag, Client client) {
        NumberField idField = new NumberField(rekordboxId);
        NumberField fileField = this.stringToProtocolNumber(fileExtension.substring(1));
        NumberField tagField = this.stringToProtocolNumber(typeTag);
        try {
            logger.debug("Sending tag request to db server, tag: {}, file: {}", (Object)tagField.getValue(), (Object)fileField.getValue());
            Message response = client.simpleRequest(Message.KnownType.ANLZ_TAG_REQ, Message.KnownType.ANLZ_TAG, client.buildRMST(Message.MenuIdentifier.MAIN_MENU, slot.slot), idField, tagField, fileField);
            if (response.knownType != Message.KnownType.UNAVAILABLE && response.arguments.get(3).getSize() > 0L) {
                ByteBuffer data = ((BinaryField)response.arguments.get(3)).getValue();
                data.position(4);
                data = data.slice();
                logger.debug("Received usable tag response from db server: {}", (Object)response);
                return new RekordboxAnlz.TaggedSection((KaitaiStream)new ByteBufferKaitaiStream(data));
            }
            logger.warn("Did not receive usable tag response from db server: {}", (Object)response);
        }
        catch (Exception e) {
            logger.warn("Problem requesting song structure information for slot " + slot + ", id " + rekordboxId, (Throwable)e);
        }
        return null;
    }

    public synchronized void addAnalysisTagListener(AnalysisTagListener listener, String fileExtension, String typeTag) {
        if (listener != null) {
            String tagKey = typeTag + fileExtension;
            boolean trackingNewTag = false;
            Set<AnalysisTagListener> specificTagListeners = this.analysisTagListeners.get(tagKey);
            if (specificTagListeners == null) {
                trackingNewTag = true;
                specificTagListeners = Collections.newSetFromMap(new ConcurrentHashMap());
                this.analysisTagListeners.put(tagKey, specificTagListeners);
            }
            specificTagListeners.add(listener);
            if (trackingNewTag) {
                this.primeCache();
            }
        }
    }

    public synchronized void removeAnalysisTagListener(AnalysisTagListener listener, String fileExtension, String typeTag) {
        String tagKey;
        Set<AnalysisTagListener> specificTagListeners;
        if (listener != null && (specificTagListeners = this.analysisTagListeners.get(tagKey = typeTag + fileExtension)) != null) {
            specificTagListeners.remove(listener);
            if (specificTagListeners.isEmpty()) {
                this.analysisTagListeners.remove(tagKey);
            }
        }
    }

    public Map<String, Set<AnalysisTagListener>> getTagListeners() {
        HashMap result = new HashMap();
        for (Map.Entry<String, Set<AnalysisTagListener>> entry : new HashMap<String, Set<AnalysisTagListener>>(this.analysisTagListeners).entrySet()) {
            result.put(entry.getKey(), Collections.unmodifiableSet(new HashSet(entry.getValue())));
        }
        return Collections.unmodifiableMap(result);
    }

    private void deliverAnalysisTagUpdate(final int player, final String fileExtension, final String typeTag, final RekordboxAnlz.TaggedSection taggedSection) {
        HashSet<AnalysisTagListener> listeners;
        Set<AnalysisTagListener> currentListeners = this.analysisTagListeners.get(typeTag + fileExtension);
        if (currentListeners != null && !(listeners = new HashSet<AnalysisTagListener>(currentListeners)).isEmpty()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AnalysisTagUpdate update = new AnalysisTagUpdate(player, fileExtension, typeTag, taggedSection);
                    for (AnalysisTagListener listener : listeners) {
                        try {
                            listener.analysisChanged(update);
                        }
                        catch (Throwable t) {
                            logger.warn("Problem delivering track analysis tag update to listener", t);
                        }
                    }
                }
            });
        }
    }

    private void deliverTagLossUpdate(int player, Map<String, CacheEntry> tags) {
        for (CacheEntry entry : tags.values()) {
            this.deliverAnalysisTagUpdate(player, entry.fileExtension, entry.typeTag, null);
        }
    }

    private void handleUpdate(final TrackMetadataUpdate update) {
        logger.debug("handleUpdate: {}", (Object)update);
        if (update.metadata == null || update.metadata.trackType != CdjStatus.TrackType.REKORDBOX) {
            this.clearDeckTags(update);
        } else {
            for (String trackedTag : this.analysisTagListeners.keySet()) {
                CacheEntry lastStructure;
                final String fileExtension = trackedTag.substring(trackedTag.indexOf("."));
                final String typeTag = trackedTag.substring(0, trackedTag.indexOf("."));
                Map deckCache = this.hotCache.get(DeckReference.getDeckReference(update.player, 0));
                CacheEntry cacheEntry = lastStructure = deckCache != null ? (CacheEntry)deckCache.get(trackedTag) : null;
                if (lastStructure != null && lastStructure.dataReference.equals(update.metadata.trackReference)) continue;
                boolean foundInCache = false;
                for (Map map : this.hotCache.values()) {
                    CacheEntry cached = (CacheEntry)map.get(trackedTag);
                    if (cached == null || !cached.dataReference.equals(update.metadata.trackReference)) continue;
                    this.updateAnalysisTag(update, fileExtension, typeTag, cached.taggedSection);
                    foundInCache = true;
                    break;
                }
                final String activeKey = update.player + ":" + trackedTag;
                if (!foundInCache && this.activeRequests.add(activeKey)) {
                    this.clearDeckTags(update);
                }
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            RekordboxAnlz.TaggedSection structure = AnalysisTagFinder.this.requestAnalysisTagInternal(update.metadata.trackReference, fileExtension, typeTag, true);
                            if (structure != null) {
                                AnalysisTagFinder.this.updateAnalysisTag(update, fileExtension, typeTag, structure);
                            }
                        }
                        catch (Exception e) {
                            logger.warn("Problem requesting analysis tag of type " + typeTag + " in file with extension " + fileExtension + " from update" + update, (Throwable)e);
                        }
                        finally {
                            AnalysisTagFinder.this.activeRequests.remove(activeKey);
                        }
                    }
                }).start();
            }
        }
    }

    private void primeCache() {
        logger.debug("primeCache() running");
        if (this.isRunning()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (Map.Entry<DeckReference, TrackMetadata> entry : MetadataFinder.getInstance().getLoadedTracks().entrySet()) {
                        if (entry.getKey().hotCue != 0) continue;
                        AnalysisTagFinder.this.handleUpdate(new TrackMetadataUpdate(entry.getKey().player, entry.getValue()));
                    }
                }
            });
        }
    }

    public synchronized void start() throws Exception {
        if (!this.isRunning()) {
            ConnectionManager.getInstance().addLifecycleListener(this.lifecycleListener);
            ConnectionManager.getInstance().start();
            DeviceFinder.getInstance().addDeviceAnnouncementListener(this.announcementListener);
            MetadataFinder.getInstance().addLifecycleListener(this.lifecycleListener);
            MetadataFinder.getInstance().start();
            MetadataFinder.getInstance().addTrackMetadataListener(this.metadataListener);
            MetadataFinder.getInstance().addMountListener(this.mountListener);
            this.queueHandler = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (AnalysisTagFinder.this.isRunning()) {
                        try {
                            AnalysisTagFinder.this.handleUpdate((TrackMetadataUpdate)AnalysisTagFinder.this.pendingUpdates.take());
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (Throwable t) {
                            logger.error("Problem processing metadata update", t);
                        }
                    }
                }
            });
            this.running.set(true);
            this.queueHandler.start();
            this.deliverLifecycleAnnouncement(logger, true);
            this.primeCache();
        }
    }

    public synchronized void stop() {
        if (this.isRunning()) {
            MetadataFinder.getInstance().removeTrackMetadataListener(this.metadataListener);
            this.running.set(false);
            this.pendingUpdates.clear();
            this.queueHandler.interrupt();
            this.queueHandler = null;
            final HashMap<DeckReference, ConcurrentHashMap<String, CacheEntry>> dyingCache = new HashMap<DeckReference, ConcurrentHashMap<String, CacheEntry>>(this.hotCache);
            this.hotCache.clear();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (Map.Entry entry : dyingCache.entrySet()) {
                        if (((DeckReference)entry.getKey()).hotCue != 0) continue;
                        AnalysisTagFinder.this.deliverTagLossUpdate(((DeckReference)entry.getKey()).player, (Map)entry.getValue());
                    }
                }
            });
            this.deliverLifecycleAnnouncement(logger, false);
        }
    }

    public static AnalysisTagFinder getInstance() {
        return ourInstance;
    }

    private AnalysisTagFinder() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AnalysisTagFinder[running:").append(this.isRunning()).append(", passive:");
        sb.append(MetadataFinder.getInstance().isPassive());
        if (this.isRunning()) {
            sb.append(", loadedAnalysisTags:").append(this.getLoadedAnalysisTags());
        }
        return sb.append("]").toString();
    }

    public static class CacheEntry {
        public final DataReference dataReference;
        public final String fileExtension;
        public final String typeTag;
        public final RekordboxAnlz.TaggedSection taggedSection;

        CacheEntry(DataReference dataReference, String fileExtension, String typeTag, RekordboxAnlz.TaggedSection taggedSection) {
            this.dataReference = dataReference;
            this.fileExtension = fileExtension;
            this.typeTag = typeTag;
            this.taggedSection = taggedSection;
        }
    }
}

