/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.data.DataReference;
import org.deepsymmetry.beatlink.dbserver.BinaryField;
import org.deepsymmetry.beatlink.dbserver.Message;
import org.deepsymmetry.cratedigger.pdb.RekordboxAnlz;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeatGrid {
    private static final Logger logger = LoggerFactory.getLogger(BeatGrid.class);
    public final DataReference dataReference;
    private final ByteBuffer rawData;
    public final int beatCount;
    private final int[] beatWithinBarValues;
    private final int[] bpmValues;
    private final long[] timeWithinTrackValues;

    public ByteBuffer getRawData() {
        if (this.rawData != null) {
            this.rawData.rewind();
            return this.rawData.slice();
        }
        return null;
    }

    public BeatGrid(DataReference reference, Message message) {
        this(reference, ((BinaryField)message.arguments.get(3)).getValue());
    }

    public BeatGrid(DataReference reference, ByteBuffer buffer) {
        this.dataReference = reference;
        this.rawData = buffer;
        byte[] gridBytes = new byte[this.rawData.remaining()];
        this.rawData.get(gridBytes);
        this.beatCount = Math.max(0, (gridBytes.length - 20) / 16);
        this.beatWithinBarValues = new int[this.beatCount];
        this.bpmValues = new int[this.beatCount];
        this.timeWithinTrackValues = new long[this.beatCount];
        for (int beatNumber = 0; beatNumber < this.beatCount; ++beatNumber) {
            int base = 20 + beatNumber * 16;
            this.beatWithinBarValues[beatNumber] = (int)Util.bytesToNumberLittleEndian(gridBytes, base, 2);
            this.bpmValues[beatNumber] = (int)Util.bytesToNumberLittleEndian(gridBytes, base + 2, 2);
            this.timeWithinTrackValues[beatNumber] = Util.bytesToNumberLittleEndian(gridBytes, base + 4, 4);
        }
    }

    private RekordboxAnlz.BeatGridTag findTag(RekordboxAnlz anlzFile) {
        for (RekordboxAnlz.TaggedSection section : anlzFile.sections()) {
            if (!(section.body() instanceof RekordboxAnlz.BeatGridTag)) continue;
            return (RekordboxAnlz.BeatGridTag)section.body();
        }
        throw new IllegalArgumentException("No beat grid found inside analysis file " + anlzFile);
    }

    public BeatGrid(DataReference reference, RekordboxAnlz anlzFile) {
        this.dataReference = reference;
        this.rawData = null;
        RekordboxAnlz.BeatGridTag tag = this.findTag(anlzFile);
        this.beatCount = (int)tag.lenBeats();
        this.beatWithinBarValues = new int[this.beatCount];
        this.bpmValues = new int[this.beatCount];
        this.timeWithinTrackValues = new long[this.beatCount];
        for (int beatNumber = 0; beatNumber < this.beatCount; ++beatNumber) {
            RekordboxAnlz.BeatGridBeat beat = (RekordboxAnlz.BeatGridBeat)tag.beats().get(beatNumber);
            this.beatWithinBarValues[beatNumber] = beat.beatNumber();
            this.bpmValues[beatNumber] = beat.tempo();
            this.timeWithinTrackValues[beatNumber] = beat.time();
        }
    }

    public BeatGrid(DataReference reference, int[] beatWithinBarValues, int[] bpmValues, long[] timeWithinTrackValues) {
        this.dataReference = reference;
        this.rawData = null;
        this.beatCount = beatWithinBarValues.length;
        if (this.beatCount != timeWithinTrackValues.length) {
            throw new IllegalArgumentException("Arrays must contain the same number of beats.");
        }
        this.beatWithinBarValues = new int[this.beatCount];
        System.arraycopy(beatWithinBarValues, 0, this.beatWithinBarValues, 0, this.beatCount);
        this.bpmValues = new int[this.beatCount];
        System.arraycopy(bpmValues, 0, this.bpmValues, 0, this.beatCount);
        this.timeWithinTrackValues = new long[this.beatCount];
        System.arraycopy(timeWithinTrackValues, 0, this.timeWithinTrackValues, 0, this.beatCount);
    }

    private int beatOffset(int beatNumber) {
        if (this.beatCount == 0) {
            throw new IllegalStateException("There are no beats in this beat grid.");
        }
        if (beatNumber < 1) {
            logger.debug("Offset for nonexistent beat, " + beatNumber + " requested; returning offset for beat 1");
            return 0;
        }
        if (beatNumber > this.beatCount) {
            logger.debug("Offset for nonexistent beat, " + beatNumber + " requested; returning offset for last beat, " + this.beatCount);
            return this.beatCount - 1;
        }
        return beatNumber - 1;
    }

    public long getTimeWithinTrack(int beatNumber) {
        if (beatNumber == 0) {
            return 0L;
        }
        return this.timeWithinTrackValues[this.beatOffset(beatNumber)];
    }

    public int getBeatWithinBar(int beatNumber) {
        return this.beatWithinBarValues[this.beatOffset(beatNumber)];
    }

    public int getBpm(int beatNumber) {
        return this.bpmValues[this.beatOffset(beatNumber)];
    }

    public int getBarNumber(int beatNumber) {
        int offset = this.getBeatWithinBar(1) - 1;
        int bar = (offset + this.beatOffset(beatNumber)) / 4;
        if (offset == 0) {
            return bar + 1;
        }
        if (bar == 0) {
            return -1;
        }
        return bar;
    }

    public int findBeatAtTime(long milliseconds) {
        int found = Arrays.binarySearch(this.timeWithinTrackValues, milliseconds);
        if (found >= 0) {
            return found + 1;
        }
        if (found == -1) {
            return found;
        }
        return -(found + 1);
    }

    public String toString() {
        return "BeatGrid[dataReference:" + this.dataReference + ", beats:" + this.beatCount + "]";
    }
}

