/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apiguardian.api.API;
import org.deepsymmetry.beatlink.Beat;
import org.deepsymmetry.beatlink.BeatListener;
import org.deepsymmetry.beatlink.DeviceFinder;
import org.deepsymmetry.beatlink.FaderStartListener;
import org.deepsymmetry.beatlink.LifecycleParticipant;
import org.deepsymmetry.beatlink.MasterHandoffListener;
import org.deepsymmetry.beatlink.OnAirListener;
import org.deepsymmetry.beatlink.PrecisePosition;
import org.deepsymmetry.beatlink.PrecisePositionListener;
import org.deepsymmetry.beatlink.SyncListener;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.VirtualCdj;
import org.deepsymmetry.beatlink.data.TimeFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.STABLE)
public class BeatFinder
extends LifecycleParticipant {
    private static final Logger logger = LoggerFactory.getLogger(BeatFinder.class);
    @API(status=API.Status.STABLE)
    public static final int BEAT_PORT = 50001;
    private final AtomicReference<DatagramSocket> socket = new AtomicReference<Object>(null);
    private static final Map<String, Set<Integer>> sizeWarningsIssued = new HashMap<String, Set<Integer>>();
    private final AtomicReference<BeatListener> timeFinderBeatListener = new AtomicReference();
    private final Set<BeatListener> beatListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<PrecisePositionListener> precisePositionListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<SyncListener> syncListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<MasterHandoffListener> masterHandoffListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<OnAirListener> onAirListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<FaderStartListener> faderStartListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final BeatFinder ourInstance = new BeatFinder();

    @Override
    @API(status=API.Status.STABLE)
    public boolean isRunning() {
        return this.socket.get() != null;
    }

    private static synchronized boolean shouldWarn(String packetName, int unexpectedLength) {
        Set<Integer> sizeSet = sizeWarningsIssued.get(packetName);
        if (sizeSet == null) {
            sizeSet = new HashSet<Integer>();
            sizeSet.add(unexpectedLength);
            sizeWarningsIssued.put(packetName, sizeSet);
            return true;
        }
        if (sizeSet.contains(unexpectedLength)) {
            return false;
        }
        sizeSet.add(unexpectedLength);
        return true;
    }

    private boolean isPacketLongEnough(DatagramPacket packet, int expectedLength, String name) {
        int length = packet.getLength();
        if (length < expectedLength && BeatFinder.shouldWarn(name, length)) {
            logger.warn("Ignoring too-short {} packet; expecting {} bytes and got {}.", new Object[]{name, expectedLength, length});
            return false;
        }
        if (length > expectedLength && BeatFinder.shouldWarn(name, length)) {
            logger.warn("Processing too-long {} packet; expecting {} bytes and got {}.", new Object[]{name, expectedLength, length});
        }
        return true;
    }

    @API(status=API.Status.STABLE)
    public synchronized void start() throws SocketException {
        if (!this.isRunning()) {
            this.socket.set(new DatagramSocket(50001));
            this.deliverLifecycleAnnouncement(logger, true);
            byte[] buffer = new byte[512];
            DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
            Thread receiver = new Thread(null, () -> {
                block18: while (this.isRunning()) {
                    boolean received;
                    try {
                        this.socket.get().receive(packet);
                        received = !DeviceFinder.getInstance().isAddressIgnored(packet.getAddress());
                    }
                    catch (IOException e) {
                        if (this.isRunning()) {
                            logger.warn("Problem reading from beat/sync socket, stopping", (Throwable)e);
                            this.stop();
                        }
                        received = false;
                    }
                    try {
                        Util.PacketType kind;
                        if (!received || (kind = Util.validateHeader(packet, 50001)) == null) continue;
                        switch (kind) {
                            case BEAT: {
                                if (!this.isPacketLongEnough(packet, 96, "beat")) continue block18;
                                this.deliverBeat(new Beat(packet));
                                continue block18;
                            }
                            case PRECISE_POSITION: {
                                if (!this.isPacketLongEnough(packet, 60, "precise position")) continue block18;
                                this.deliverPrecisePosition(new PrecisePosition(packet));
                                continue block18;
                            }
                            case CHANNELS_ON_AIR: {
                                if (packet.getLength() != 53 && !this.isPacketLongEnough(packet, 45, "channels on-air")) continue block18;
                                Set<Integer> audibleChannels = BeatFinder.getAudibleChannels(packet);
                                this.deliverOnAirUpdate(audibleChannels);
                                continue block18;
                            }
                            case SYNC_CONTROL: {
                                if (!this.isPacketLongEnough(packet, 44, "sync control command")) continue block18;
                                this.deliverSyncCommand(packet.getData()[43]);
                                continue block18;
                            }
                            case MASTER_HANDOFF_REQUEST: {
                                if (!this.isPacketLongEnough(packet, 40, "tempo master handoff request")) continue block18;
                                this.deliverMasterYieldCommand(packet.getData()[33]);
                                continue block18;
                            }
                            case MASTER_HANDOFF_RESPONSE: {
                                if (!this.isPacketLongEnough(packet, 44, "tempo master handoff response")) continue block18;
                                byte[] data = packet.getData();
                                this.deliverMasterYieldResponse(data[33], data[43] == 1);
                                continue block18;
                            }
                            case FADER_START_COMMAND: {
                                if (!this.isPacketLongEnough(packet, 40, "fader start command")) continue block18;
                                byte[] data = packet.getData();
                                Set<Integer> playersToStart = new TreeSet();
                                Set<Integer> playersToStop = new TreeSet();
                                block19: for (int channel = 1; channel <= 4; ++channel) {
                                    switch (data[35 + channel]) {
                                        case 0: {
                                            playersToStart.add(channel);
                                            continue block19;
                                        }
                                        case 1: {
                                            playersToStop.add(channel);
                                            continue block19;
                                        }
                                        case 2: {
                                            continue block19;
                                        }
                                        default: {
                                            logger.warn("Ignoring unrecognized fader start command, {}, for channel {}", (Object)data[35 + channel], (Object)channel);
                                        }
                                    }
                                }
                                playersToStart = Collections.unmodifiableSet(playersToStart);
                                playersToStop = Collections.unmodifiableSet(playersToStop);
                                this.deliverFaderStartCommand(playersToStart, playersToStop);
                                continue block18;
                            }
                        }
                        logger.warn("Ignoring packet received on beat port with unexpected type: {}", (Object)kind);
                    }
                    catch (Throwable t) {
                        logger.warn("Problem processing beat packet", t);
                    }
                }
            }, "beat-link BeatFinder receiver");
            receiver.setDaemon(true);
            receiver.setPriority(10);
            receiver.start();
        }
    }

    private static Set<Integer> getAudibleChannels(DatagramPacket packet) {
        int channel;
        byte[] data = packet.getData();
        TreeSet<Integer> audibleChannels = new TreeSet<Integer>();
        for (channel = 1; channel <= 4; ++channel) {
            if (data[35 + channel] == 0) continue;
            audibleChannels.add(channel);
        }
        if (packet.getLength() >= 53) {
            for (channel = 5; channel <= 6; ++channel) {
                if (data[40 + channel] == 0) continue;
                audibleChannels.add(channel);
            }
        }
        audibleChannels = Collections.unmodifiableSet(audibleChannels);
        return audibleChannels;
    }

    @API(status=API.Status.STABLE)
    public synchronized void stop() {
        if (this.isRunning()) {
            this.socket.get().close();
            this.socket.set(null);
            this.deliverLifecycleAnnouncement(logger, false);
        }
    }

    @API(status=API.Status.STABLE)
    public void addBeatListener(BeatListener listener) {
        if (TimeFinder.getInstance().isOwnBeatListener(listener)) {
            this.timeFinderBeatListener.set(listener);
        } else if (listener != null) {
            this.beatListeners.add(listener);
        }
    }

    @API(status=API.Status.STABLE)
    public void removeBeatListener(BeatListener listener) {
        if (TimeFinder.getInstance().isOwnBeatListener(listener)) {
            this.timeFinderBeatListener.set(null);
        } else if (listener != null) {
            this.beatListeners.remove(listener);
        }
    }

    @API(status=API.Status.STABLE)
    public Set<BeatListener> getBeatListeners() {
        HashSet<BeatListener> result = new HashSet<BeatListener>(this.beatListeners);
        BeatListener timeFinderListener = this.timeFinderBeatListener.get();
        if (timeFinderListener != null) {
            result.add(timeFinderListener);
        }
        return Collections.unmodifiableSet(result);
    }

    private void deliverBeat(Beat beat) {
        VirtualCdj.getInstance().processBeat(beat);
        BeatListener timeFinderListener = this.timeFinderBeatListener.get();
        if (timeFinderListener != null) {
            try {
                timeFinderListener.newBeat(beat);
            }
            catch (Throwable t) {
                logger.warn("Problem delivering beat announcement to TimeFinder listener", t);
            }
        }
        for (BeatListener listener : new LinkedList<BeatListener>(this.beatListeners)) {
            try {
                listener.newBeat(beat);
            }
            catch (Throwable t) {
                logger.warn("Problem delivering beat announcement to listener", t);
            }
        }
    }

    @API(status=API.Status.STABLE)
    public void addPrecisePositionListener(PrecisePositionListener listener) {
        if (listener != null) {
            this.precisePositionListeners.add(listener);
        }
    }

    @API(status=API.Status.STABLE)
    public void removePrecisePositionListener(PrecisePositionListener listener) {
        if (listener != null) {
            this.precisePositionListeners.remove(listener);
        }
    }

    @API(status=API.Status.STABLE)
    public Set<PrecisePositionListener> getPrecisePositionListeners() {
        return Set.copyOf(this.precisePositionListeners);
    }

    private void deliverPrecisePosition(PrecisePosition position) {
        for (PrecisePositionListener listener : this.getPrecisePositionListeners()) {
            try {
                listener.positionReported(position);
            }
            catch (Throwable t) {
                logger.warn("Problem delivering precise position update to listener", t);
            }
        }
    }

    @API(status=API.Status.STABLE)
    public void addSyncListener(SyncListener listener) {
        if (listener != null) {
            this.syncListeners.add(listener);
        }
    }

    @API(status=API.Status.STABLE)
    public void removeSyncListener(SyncListener listener) {
        if (listener != null) {
            this.syncListeners.remove(listener);
        }
    }

    @API(status=API.Status.STABLE)
    public Set<SyncListener> getSyncListeners() {
        return Set.copyOf(this.syncListeners);
    }

    private void deliverSyncCommand(byte command) {
        for (SyncListener listener : this.getSyncListeners()) {
            try {
                switch (command) {
                    case 1: {
                        listener.becomeMaster();
                    }
                    case 16: {
                        listener.setSyncMode(true);
                        break;
                    }
                    case 32: {
                        listener.setSyncMode(false);
                    }
                }
            }
            catch (Throwable t) {
                logger.warn("Problem delivering sync command to listener", t);
            }
        }
    }

    @API(status=API.Status.STABLE)
    public void addMasterHandoffListener(MasterHandoffListener listener) {
        if (listener != null) {
            this.masterHandoffListeners.add(listener);
        }
    }

    @API(status=API.Status.STABLE)
    public void removeMasterHandoffListener(MasterHandoffListener listener) {
        if (listener != null) {
            this.masterHandoffListeners.remove(listener);
        }
    }

    @API(status=API.Status.STABLE)
    public Set<MasterHandoffListener> getMasterHandoffListeners() {
        return Set.copyOf(this.masterHandoffListeners);
    }

    private void deliverMasterYieldCommand(int toPlayer) {
        for (MasterHandoffListener listener : this.getMasterHandoffListeners()) {
            try {
                listener.yieldMasterTo(toPlayer);
            }
            catch (Throwable t) {
                logger.warn("Problem delivering master yield command to listener", t);
            }
        }
    }

    private void deliverMasterYieldResponse(int fromPlayer, boolean yielded) {
        for (MasterHandoffListener listener : this.getMasterHandoffListeners()) {
            try {
                listener.yieldResponse(fromPlayer, yielded);
            }
            catch (Throwable t) {
                logger.warn("Problem delivering master yield response to listener", t);
            }
        }
    }

    @API(status=API.Status.STABLE)
    public void addOnAirListener(OnAirListener listener) {
        if (listener != null) {
            this.onAirListeners.add(listener);
        }
    }

    @API(status=API.Status.STABLE)
    public void removeOnAirListener(OnAirListener listener) {
        if (listener != null) {
            this.onAirListeners.remove(listener);
        }
    }

    @API(status=API.Status.STABLE)
    public Set<OnAirListener> getOnAirListeners() {
        return Set.copyOf(this.onAirListeners);
    }

    private void deliverOnAirUpdate(Set<Integer> audibleChannels) {
        for (OnAirListener listener : this.getOnAirListeners()) {
            try {
                listener.channelsOnAir(audibleChannels);
            }
            catch (Throwable t) {
                logger.warn("Problem delivering channels on-air update to listener", t);
            }
        }
    }

    @API(status=API.Status.STABLE)
    public void addFaderStartListener(FaderStartListener listener) {
        if (listener != null) {
            this.faderStartListeners.add(listener);
        }
    }

    @API(status=API.Status.STABLE)
    public void removeFaderStartListener(FaderStartListener listener) {
        if (listener != null) {
            this.faderStartListeners.remove(listener);
        }
    }

    @API(status=API.Status.STABLE)
    public Set<FaderStartListener> getFaderStartListeners() {
        return Set.copyOf(this.faderStartListeners);
    }

    private void deliverFaderStartCommand(Set<Integer> playersToStart, Set<Integer> playersToStop) {
        for (FaderStartListener listener : this.getFaderStartListeners()) {
            try {
                listener.fadersChanged(playersToStart, playersToStop);
            }
            catch (Throwable t) {
                logger.warn("Problem delivering fader start command to listener", t);
            }
        }
    }

    @API(status=API.Status.STABLE)
    public static BeatFinder getInstance() {
        return ourInstance;
    }

    private BeatFinder() {
    }

    public String toString() {
        return "BeatFinder[active:" + this.isRunning() + "]";
    }
}

