/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink;

import java.net.DatagramPacket;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apiguardian.api.API;
import org.deepsymmetry.beatlink.DeviceUpdate;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.VirtualRekordbox;
import org.deepsymmetry.beatlink.data.OpusProvider;
import org.deepsymmetry.beatlink.data.SlotReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.STABLE)
public class CdjStatus
extends DeviceUpdate {
    private static final Logger logger = LoggerFactory.getLogger(CdjStatus.class);
    @API(status=API.Status.STABLE)
    public static final int STATUS_FLAGS = 137;
    @API(status=API.Status.STABLE)
    public static final int MASTER_HAND_OFF = 159;
    @API(status=API.Status.STABLE)
    public static final int BPM_SYNC_FLAG = 2;
    @API(status=API.Status.STABLE)
    public static final int ON_AIR_FLAG = 8;
    @API(status=API.Status.STABLE)
    public static final int SYNCED_FLAG = 16;
    @API(status=API.Status.STABLE)
    public static final int MASTER_FLAG = 32;
    @API(status=API.Status.STABLE)
    public static final int PLAYING_FLAG = 64;
    public static final int LOCAL_CD_STATE = 55;
    @API(status=API.Status.STABLE)
    public static final int LOCAL_USB_STATE = 111;
    public static final int LOCAL_SD_STATE = 115;
    private final int trackSourcePlayer;
    @API(status=API.Status.STABLE)
    public static final Map<Byte, TrackSourceSlot> TRACK_SOURCE_SLOT_MAP;
    private final TrackSourceSlot trackSourceSlot;
    @API(status=API.Status.STABLE)
    public static final Map<Byte, TrackType> TRACK_TYPE_MAP;
    private final TrackType trackType;
    private final int rekordboxId;
    @API(status=API.Status.STABLE)
    public static final Map<Byte, PlayState1> PLAY_STATE_1_MAP;
    private final PlayState1 playState1;
    @API(status=API.Status.STABLE)
    public static final Map<Byte, PlayState2> PLAY_STATE_2_MAP;
    private final PlayState2 playState2;
    @API(status=API.Status.STABLE)
    public static final Map<Byte, PlayState3> PLAY_STATE_3_MAP;
    private final PlayState3 playState3;
    private final int pitch;
    private final int bpm;
    private final String firmwareVersion;
    private final int handingMasterToDevice;
    private static final Set<Integer> expectedStatusPacketSizes;
    private static final Set<String> misreportedPacketSizes;
    @API(status=API.Status.STABLE)
    public static final int MINIMUM_PACKET_SIZE = 204;
    @API(status=API.Status.EXPERIMENTAL)
    public final boolean statusFlagsWereReplayed;

    @API(status=API.Status.STABLE)
    public int getTrackSourcePlayer() {
        return this.trackSourcePlayer;
    }

    public TrackSourceSlot getTrackSourceSlot() {
        return this.trackSourceSlot;
    }

    @API(status=API.Status.STABLE)
    public TrackType getTrackType() {
        return this.trackType;
    }

    @API(status=API.Status.STABLE)
    public int getRekordboxId() {
        return this.rekordboxId;
    }

    @API(status=API.Status.STABLE)
    public PlayState1 getPlayState1() {
        return this.playState1;
    }

    @API(status=API.Status.STABLE)
    public PlayState2 getPlayState2() {
        return this.playState2;
    }

    @API(status=API.Status.STABLE)
    public PlayState3 getPlayState3() {
        return this.playState3;
    }

    private TrackSourceSlot findTrackSourceSlot() {
        TrackSourceSlot result = TRACK_SOURCE_SLOT_MAP.get(this.packetBytes[41]);
        if (result == null) {
            return TrackSourceSlot.UNKNOWN;
        }
        return result;
    }

    private TrackType findTrackType() {
        TrackType result = TRACK_TYPE_MAP.get(this.packetBytes[42]);
        if (result == null) {
            return TrackType.UNKNOWN;
        }
        return result;
    }

    private PlayState1 findPlayState1() {
        PlayState1 result = PLAY_STATE_1_MAP.get(this.packetBytes[123]);
        if (result == null) {
            return PlayState1.UNKNOWN;
        }
        return result;
    }

    private PlayState2 findPlayState2() {
        switch (this.packetBytes[139]) {
            case -6: 
            case 106: 
            case 122: {
                return PlayState2.MOVING;
            }
            case -2: 
            case 110: 
            case 126: {
                return PlayState2.STOPPED;
            }
        }
        return PlayState2.UNKNOWN;
    }

    private PlayState3 findPlayState3() {
        PlayState3 result = PLAY_STATE_3_MAP.get(this.packetBytes[157]);
        if (result == null) {
            return PlayState3.UNKNOWN;
        }
        return result;
    }

    @API(status=API.Status.STABLE)
    public CdjStatus(DatagramPacket packet) {
        this(packet, false);
    }

    CdjStatus(DatagramPacket packet, boolean statusFlagsReplayed) {
        super(packet, "CDJ status", packet.getLength());
        String reportedKey;
        this.statusFlagsWereReplayed = statusFlagsReplayed;
        if (this.packetBytes.length < 204) {
            throw new IllegalArgumentException("Unable to create a CdjStatus object, packet too short: we need 204 bytes and were given only " + this.packetBytes.length);
        }
        int payloadLength = (int)Util.bytesToNumber(this.packetBytes, 34, 2);
        int reportedPacketSize = payloadLength + 36;
        if (this.packetBytes.length != reportedPacketSize && misreportedPacketSizes.add(reportedKey = reportedPacketSize + "," + this.packetBytes.length)) {
            logger.warn("Received CDJ status packet with reported payload length of {} and actual payload length of {}", (Object)payloadLength, (Object)(this.packetBytes.length - 36));
        }
        if (expectedStatusPacketSizes.add(this.packetBytes.length)) {
            logger.warn("Processing CDJ Status packets with unexpected lengths {}.", (Object)this.packetBytes.length);
        }
        this.trackType = this.findTrackType();
        int maybeRekordboxId = (int)Util.bytesToNumber(this.packetBytes, 44, 4);
        this.pitch = (int)Util.bytesToNumber(this.packetBytes, 141, 3);
        this.bpm = (int)Util.bytesToNumber(this.packetBytes, 146, 2);
        this.playState1 = this.findPlayState1();
        this.playState2 = this.findPlayState2();
        this.playState3 = this.findPlayState3();
        this.firmwareVersion = new String(this.packetBytes, 124, 4).trim();
        this.handingMasterToDevice = Util.unsign(this.packetBytes[159]);
        int trackSourceByte = this.packetBytes[40];
        if (this.isFromOpusQuad && trackSourceByte < 16) {
            int sourcePlayer = Util.translateOpusPlayerNumbers(trackSourceByte);
            int player = Util.translateOpusPlayerNumbers(trackSourceByte);
            if (sourcePlayer != 0) {
                int deviceSqlRekordboxId;
                SlotReference matchedSourceSlot = VirtualRekordbox.getInstance().findMatchedTrackSourceSlotForPlayer(this.deviceNumber);
                if (matchedSourceSlot != null) {
                    sourcePlayer = matchedSourceSlot.player;
                }
                maybeRekordboxId = deviceSqlRekordboxId = VirtualRekordbox.getInstance().findDeviceSqlRekordboxIdForPlayer(player);
            }
            this.trackSourcePlayer = sourcePlayer;
            this.trackSourceSlot = TrackSourceSlot.USB_SLOT;
            this.packetBytes[111] = (byte)(OpusProvider.getInstance().findArchive(this.deviceNumber) == null ? 4 : 0);
        } else {
            this.trackSourcePlayer = trackSourceByte;
            this.trackSourceSlot = this.findTrackSourceSlot();
        }
        this.rekordboxId = maybeRekordboxId;
    }

    @Override
    public int getPitch() {
        return this.pitch;
    }

    @API(status=API.Status.STABLE)
    public int getPitch(int number) {
        switch (number) {
            case 1: {
                return this.pitch;
            }
            case 2: {
                return (int)Util.bytesToNumber(this.packetBytes, 153, 3);
            }
            case 3: {
                return (int)Util.bytesToNumber(this.packetBytes, 193, 3);
            }
            case 4: {
                return (int)Util.bytesToNumber(this.packetBytes, 197, 3);
            }
        }
        throw new IllegalArgumentException("Pitch number must be between 1 and 4");
    }

    @Override
    @API(status=API.Status.STABLE)
    public int getBpm() {
        return this.bpm;
    }

    @Override
    @API(status=API.Status.STABLE)
    public int getBeatWithinBar() {
        return this.packetBytes[166];
    }

    @Override
    public boolean isBeatWithinBarMeaningful() {
        return this.getBeatWithinBar() > 0;
    }

    @Override
    public boolean isTempoMaster() {
        return (this.packetBytes[137] & 0x20) > 0;
    }

    @Override
    public Integer getDeviceMasterIsBeingYieldedTo() {
        if (this.handingMasterToDevice == 255) {
            return null;
        }
        return this.handingMasterToDevice;
    }

    @Override
    public double getEffectiveTempo() {
        return (double)this.bpm * Util.pitchToMultiplier(this.pitch) / 100.0;
    }

    @API(status=API.Status.STABLE)
    public boolean isPlaying() {
        if (this.packetBytes.length >= 212) {
            return (this.packetBytes[137] & 0x40) > 0;
        }
        return this.playState1 == PlayState1.PLAYING || this.playState1 == PlayState1.LOOPING || this.playState1 == PlayState1.SEARCHING && this.playState2 == PlayState2.MOVING;
    }

    @API(status=API.Status.STABLE)
    public boolean isBpmOnlySynced() {
        return (this.packetBytes[137] & 2) > 0;
    }

    @Override
    public boolean isSynced() {
        return (this.packetBytes[137] & 0x10) > 0;
    }

    @API(status=API.Status.STABLE)
    public boolean isOnAir() {
        return (this.packetBytes[137] & 8) > 0;
    }

    @API(status=API.Status.STABLE)
    public boolean isLocalUsbLoaded() {
        return this.packetBytes[111] == 0;
    }

    @API(status=API.Status.STABLE)
    public boolean isLocalUsbUnloading() {
        return this.packetBytes[111] == 2;
    }

    @API(status=API.Status.STABLE)
    public boolean isLocalUsbEmpty() {
        return this.packetBytes[111] == 4;
    }

    @API(status=API.Status.STABLE)
    public boolean isLocalSdLoaded() {
        return this.packetBytes[115] == 0;
    }

    @API(status=API.Status.STABLE)
    public boolean isLocalSdUnloading() {
        return this.packetBytes[115] == 2;
    }

    @API(status=API.Status.STABLE)
    public boolean isLocalSdEmpty() {
        return this.packetBytes[115] == 4;
    }

    @API(status=API.Status.STABLE)
    public boolean isDiscSlotEmpty() {
        return this.packetBytes[55] != 30 && this.packetBytes[55] != 17;
    }

    @API(status=API.Status.STABLE)
    public boolean isDiscSlotAsleep() {
        return this.packetBytes[55] == 1;
    }

    @API(status=API.Status.STABLE)
    public int getDiscTrackCount() {
        return (int)Util.bytesToNumber(this.packetBytes, 70, 2);
    }

    @API(status=API.Status.STABLE)
    public boolean isTrackLoaded() {
        return this.playState1 != PlayState1.NO_TRACK;
    }

    @API(status=API.Status.STABLE)
    public boolean isLooping() {
        return this.playState1 == PlayState1.LOOPING;
    }

    @API(status=API.Status.STABLE)
    public boolean isPaused() {
        return this.playState1 == PlayState1.PAUSED || this.playState1 == PlayState1.CUED;
    }

    @API(status=API.Status.STABLE)
    public boolean isCued() {
        return this.playState1 == PlayState1.CUED;
    }

    @API(status=API.Status.STABLE)
    public boolean isSearching() {
        return this.playState1 == PlayState1.SEARCHING;
    }

    @API(status=API.Status.STABLE)
    public boolean isAtEnd() {
        return this.playState1 == PlayState1.ENDED;
    }

    @API(status=API.Status.STABLE)
    public boolean isPlayingForwards() {
        return this.playState1 == PlayState1.PLAYING && this.playState3 != PlayState3.PAUSED_OR_REVERSE;
    }

    @API(status=API.Status.STABLE)
    public boolean isPlayingBackwards() {
        return this.playState1 == PlayState1.PLAYING && this.playState3 == PlayState3.PAUSED_OR_REVERSE;
    }

    @API(status=API.Status.STABLE)
    public boolean isPlayingVinylMode() {
        return this.playState3 == PlayState3.FORWARD_VINYL;
    }

    @API(status=API.Status.STABLE)
    public boolean isPlayingCdjMode() {
        return this.playState3 == PlayState3.FORWARD_CDJ;
    }

    @API(status=API.Status.STABLE)
    public boolean isLinkMediaAvailable() {
        return this.packetBytes[117] != 0;
    }

    @API(status=API.Status.STABLE)
    public boolean isBusy() {
        return this.packetBytes[39] != 0;
    }

    @API(status=API.Status.STABLE)
    public int getTrackNumber() {
        return (int)Util.bytesToNumber(this.packetBytes, 50, 2);
    }

    @API(status=API.Status.STABLE)
    public int getSyncNumber() {
        return (int)Util.bytesToNumber(this.packetBytes, 132, 4);
    }

    @API(status=API.Status.STABLE)
    public int getBeatNumber() {
        long result = Util.bytesToNumber(this.packetBytes, 160, 4);
        if (result != 0xFFFFFFFFL) {
            return (int)result;
        }
        return -1;
    }

    @API(status=API.Status.STABLE)
    public int getCueCountdown() {
        return (int)Util.bytesToNumber(this.packetBytes, 164, 2);
    }

    @API(status=API.Status.STABLE)
    public String formatCueCountdown() {
        int count = this.getCueCountdown();
        if (count == 511) {
            return "--.-";
        }
        if (count >= 1 && count <= 256) {
            int bars = (count - 1) / 4;
            int beats = (count - 1) % 4 + 1;
            return String.format("%02d.%d", bars, beats);
        }
        if (count == 0) {
            return "00.0";
        }
        return "??.?";
    }

    @API(status=API.Status.STABLE)
    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    @API(status=API.Status.STABLE)
    public long getPacketNumber() {
        return Util.bytesToNumber(this.packetBytes, 200, 4);
    }

    @API(status=API.Status.STABLE)
    public boolean canReportLooping() {
        return this.packetBytes.length >= 458;
    }

    @API(status=API.Status.STABLE)
    public int getActiveLoopBeats() {
        if (this.canReportLooping()) {
            return (int)Util.bytesToNumber(this.packetBytes, 456, 2);
        }
        return 0;
    }

    @API(status=API.Status.STABLE)
    public long getLoopStart() {
        if (this.canReportLooping()) {
            return Util.bytesToNumber(this.packetBytes, 438, 4) * 65536L / 1000L;
        }
        return 0L;
    }

    @API(status=API.Status.STABLE)
    public long getLoopEnd() {
        if (this.canReportLooping()) {
            return Util.bytesToNumber(this.packetBytes, 446, 4) * 65536L / 1000L;
        }
        return 0L;
    }

    @Override
    public String toString() {
        return "CdjStatus[device:" + this.deviceNumber + ", name:" + this.deviceName + ", address:" + this.address.getHostAddress() + ", timestamp:" + this.timestamp + ", busy? " + this.isBusy() + ", pitch:" + String.format("%+.2f%%", Util.pitchToPercentage(this.pitch)) + ", rekordboxId:" + this.getRekordboxId() + ", from player:" + this.getTrackSourcePlayer() + ", in slot:" + this.getTrackSourceSlot() + ", track type:" + this.getTrackType() + ", track:" + this.getTrackNumber() + ", track BPM:" + String.format("%.1f", (double)this.bpm / 100.0) + ", effective BPM:" + String.format("%.1f", this.getEffectiveTempo()) + ", beat:" + this.getBeatNumber() + ", beatWithinBar:" + this.getBeatWithinBar() + ", isBeatWithinBarMeaningful? " + this.isBeatWithinBarMeaningful() + ", cue: " + this.formatCueCountdown() + ", Playing? " + this.isPlaying() + ", Master? " + this.isTempoMaster() + ", Synced? " + this.isSynced() + ", On-Air? " + this.isOnAir() + ", handingMasterToDevice: " + this.handingMasterToDevice + ", statusFlagsWereReplayed: " + this.statusFlagsWereReplayed + "]";
    }

    static {
        HashMap<Byte, Enum> scratch = new HashMap<Byte, Enum>();
        for (TrackSourceSlot trackSourceSlot : TrackSourceSlot.values()) {
            scratch.put(trackSourceSlot.protocolValue, trackSourceSlot);
        }
        TRACK_SOURCE_SLOT_MAP = Collections.unmodifiableMap(scratch);
        scratch = new HashMap();
        for (Enum enum_ : TrackType.values()) {
            scratch.put(((TrackType)enum_).protocolValue, enum_);
        }
        TRACK_TYPE_MAP = Collections.unmodifiableMap(scratch);
        scratch = new HashMap();
        for (Enum enum_ : PlayState1.values()) {
            scratch.put(((PlayState1)enum_).protocolValue, enum_);
        }
        PLAY_STATE_1_MAP = Collections.unmodifiableMap(scratch);
        scratch = new HashMap();
        for (Enum enum_ : PlayState2.values()) {
            scratch.put(((PlayState2)enum_).protocolValue, enum_);
        }
        PLAY_STATE_2_MAP = Collections.unmodifiableMap(scratch);
        scratch = new HashMap();
        for (Enum enum_ : PlayState3.values()) {
            scratch.put(((PlayState3)enum_).protocolValue, enum_);
        }
        PLAY_STATE_3_MAP = Collections.unmodifiableMap(scratch);
        expectedStatusPacketSizes = Collections.newSetFromMap(new ConcurrentHashMap());
        expectedStatusPacketSizes.addAll(Arrays.asList(208, 212, 284, 292));
        misreportedPacketSizes = Collections.newSetFromMap(new HashMap());
    }

    @API(status=API.Status.STABLE)
    public static enum PlayState3 {
        NO_TRACK(0),
        PAUSED_OR_REVERSE(1),
        FORWARD_VINYL(9),
        FORWARD_CDJ(13),
        UNKNOWN(-1);

        public final byte protocolValue;

        private PlayState3(int value) {
            this.protocolValue = (byte)value;
        }
    }

    @API(status=API.Status.STABLE)
    public static enum PlayState2 {
        MOVING(122),
        STOPPED(126),
        OPUS_MOVING(250),
        UNKNOWN(-1);

        @API(status=API.Status.STABLE)
        public final byte protocolValue;

        private PlayState2(int value) {
            this.protocolValue = (byte)value;
        }
    }

    @API(status=API.Status.STABLE)
    public static enum PlayState1 {
        NO_TRACK(0),
        LOADING(2),
        PLAYING(3),
        LOOPING(4),
        PAUSED(5),
        CUED(6),
        CUE_PLAYING(7),
        CUE_SCRATCHING(8),
        SEARCHING(9),
        ENDED(17),
        UNKNOWN(-1);

        @API(status=API.Status.STABLE)
        public final byte protocolValue;

        private PlayState1(int value) {
            this.protocolValue = (byte)value;
        }
    }

    @API(status=API.Status.STABLE)
    public static enum TrackType {
        NO_TRACK(0),
        REKORDBOX(1),
        UNANALYZED(2),
        CD_DIGITAL_AUDIO(5),
        UNKNOWN(-1);

        @API(status=API.Status.STABLE)
        public final byte protocolValue;

        private TrackType(int value) {
            this.protocolValue = (byte)value;
        }
    }

    @API(status=API.Status.STABLE)
    public static enum TrackSourceSlot {
        NO_TRACK(0),
        CD_SLOT(1),
        SD_SLOT(2),
        USB_SLOT(3),
        COLLECTION(4),
        UNKNOWN(-1);

        public final byte protocolValue;

        private TrackSourceSlot(int value) {
            this.protocolValue = (byte)value;
        }
    }
}

