/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink;

import java.net.DatagramPacket;
import java.net.InetAddress;
import org.apiguardian.api.API;
import org.deepsymmetry.beatlink.Util;

@API(status=API.Status.STABLE)
public class DeviceAnnouncement {
    private final InetAddress address;
    private final long timestamp;
    private final String name;
    private final int number;
    private final byte[] packetBytes;
    @API(status=API.Status.EXPERIMENTAL)
    public final boolean isOpusQuad;

    @API(status=API.Status.STABLE)
    public DeviceAnnouncement(DatagramPacket packet) {
        if (packet.getLength() != 54) {
            throw new IllegalArgumentException("Device announcement packet must be 54 bytes long");
        }
        this.address = packet.getAddress();
        this.packetBytes = new byte[packet.getLength()];
        System.arraycopy(packet.getData(), 0, this.packetBytes, 0, packet.getLength());
        this.timestamp = System.currentTimeMillis();
        this.name = new String(this.packetBytes, 12, 20).trim();
        this.isOpusQuad = this.name.equals("OPUS-QUAD");
        this.number = Util.unsign(this.packetBytes[36]);
    }

    @API(status=API.Status.EXPERIMENTAL)
    public DeviceAnnouncement(DatagramPacket packet, int deviceNumber) {
        if (packet.getLength() != 54) {
            throw new IllegalArgumentException("Device announcement packet must be 54 bytes long");
        }
        this.address = packet.getAddress();
        this.packetBytes = new byte[packet.getLength()];
        System.arraycopy(packet.getData(), 0, this.packetBytes, 0, packet.getLength());
        this.timestamp = System.currentTimeMillis();
        this.name = new String(this.packetBytes, 12, 20).trim();
        this.isOpusQuad = this.name.equals("OPUS-QUAD");
        this.number = deviceNumber;
    }

    @API(status=API.Status.STABLE)
    public InetAddress getAddress() {
        return this.address;
    }

    @API(status=API.Status.STABLE)
    public long getTimestamp() {
        return this.timestamp;
    }

    @API(status=API.Status.STABLE)
    public String getDeviceName() {
        return this.name;
    }

    @API(status=API.Status.STABLE)
    public int getDeviceNumber() {
        return this.number;
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED)
    public String getName() {
        return this.name;
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED)
    public int getNumber() {
        return this.number;
    }

    @API(status=API.Status.STABLE)
    public byte[] getHardwareAddress() {
        byte[] result = new byte[6];
        System.arraycopy(this.packetBytes, 38, result, 0, 6);
        return result;
    }

    @API(status=API.Status.EXPERIMENTAL)
    public int getPeerCount() {
        return Util.unsign(this.packetBytes[48]);
    }

    @API(status=API.Status.STABLE)
    public byte[] getPacketBytes() {
        byte[] result = new byte[this.packetBytes.length];
        System.arraycopy(this.packetBytes, 0, result, 0, this.packetBytes.length);
        return result;
    }

    public String toString() {
        return "DeviceAnnouncement[device:" + this.number + ", name:" + this.name + ", address:" + this.address.getHostAddress() + ", peers:" + this.getPeerCount() + "]";
    }
}

