/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;
import org.apiguardian.api.API;
import org.deepsymmetry.beatlink.DeviceAnnouncement;
import org.deepsymmetry.beatlink.DeviceAnnouncementListener;
import org.deepsymmetry.beatlink.DeviceReference;
import org.deepsymmetry.beatlink.LifecycleParticipant;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.VirtualCdj;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.STABLE)
public class DeviceFinder
extends LifecycleParticipant {
    private static final Logger logger = LoggerFactory.getLogger(DeviceFinder.class);
    @API(status=API.Status.STABLE)
    public static final int ANNOUNCEMENT_PORT = 50000;
    @API(status=API.Status.STABLE)
    public static final int MAXIMUM_AGE = 10000;
    private final AtomicReference<DatagramSocket> socket = new AtomicReference<Object>(null);
    private static final AtomicLong startTime = new AtomicLong();
    private static final AtomicLong firstDeviceTime = new AtomicLong(0L);
    private static final AtomicBoolean limit3PlayersSeen = new AtomicBoolean(false);
    private final Map<DeviceReference, DeviceAnnouncement> devices = new ConcurrentHashMap<DeviceReference, DeviceAnnouncement>();
    private final Set<InetAddress> ignoredAddresses = Collections.newSetFromMap(new ConcurrentHashMap());
    public final Set<String> METADATA_FLEXIBLE_DEVICES = Set.of("CDJ-3000", "XDJ-AZ");
    private final Set<DeviceAnnouncementListener> deviceListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final DeviceFinder ourInstance = new DeviceFinder();

    @Override
    @API(status=API.Status.STABLE)
    public boolean isRunning() {
        return this.socket.get() != null;
    }

    @API(status=API.Status.STABLE)
    public long getStartTime() {
        this.ensureRunning();
        return startTime.get();
    }

    @API(status=API.Status.STABLE)
    public long getFirstDeviceTime() {
        this.ensureRunning();
        long result = firstDeviceTime.get();
        if (result == 0L) {
            throw new IllegalStateException("No device announcements have yet been seen");
        }
        return result;
    }

    private void expireDevices() {
        long now = System.currentTimeMillis();
        HashMap<DeviceReference, DeviceAnnouncement> copy = new HashMap<DeviceReference, DeviceAnnouncement>(this.devices);
        for (Map.Entry entry : copy.entrySet()) {
            if (now - ((DeviceAnnouncement)entry.getValue()).getTimestamp() <= 10000L) continue;
            logger.debug("Expiring: {}", entry.getValue());
            this.devices.remove(entry.getKey());
            this.deliverLostAnnouncement((DeviceAnnouncement)entry.getValue());
        }
        if (this.devices.isEmpty()) {
            firstDeviceTime.set(0L);
        }
    }

    private void updateDevices(DeviceAnnouncement announcement) {
        firstDeviceTime.compareAndSet(0L, System.currentTimeMillis());
        this.devices.put(DeviceReference.getDeviceReference(announcement), announcement);
    }

    private boolean isDeviceNew(DeviceAnnouncement announcement) {
        return !this.devices.containsKey(DeviceReference.getDeviceReference(announcement));
    }

    @API(status=API.Status.STABLE)
    public void addIgnoredAddress(InetAddress address) {
        this.ignoredAddresses.add(address);
    }

    @API(status=API.Status.STABLE)
    public void removeIgnoredAddress(InetAddress address) {
        this.ignoredAddresses.remove(address);
    }

    @API(status=API.Status.STABLE)
    public boolean isAddressIgnored(InetAddress address) {
        return this.ignoredAddresses.contains(address);
    }

    private void processAnnouncement(DeviceAnnouncement announcement) {
        boolean foundNewDevice = this.isDeviceNew(announcement);
        logger.debug("Announcement (new? {}): {}", (Object)foundNewDevice, (Object)announcement);
        this.updateDevices(announcement);
        if (foundNewDevice) {
            this.deliverFoundAnnouncement(announcement);
        }
    }

    private void createAndProcessOpusAnnouncements(DatagramPacket packet) {
        for (int i = 1; i <= 4; ++i) {
            DeviceAnnouncement opusAnnouncement = new DeviceAnnouncement(packet, i);
            this.updateDevices(opusAnnouncement);
            if (!this.isDeviceNew(opusAnnouncement)) continue;
            this.deliverFoundAnnouncement(opusAnnouncement);
        }
    }

    @API(status=API.Status.STABLE)
    public synchronized void start() throws SocketException {
        if (!this.isRunning()) {
            startTime.set(System.currentTimeMillis());
            this.deliverLifecycleAnnouncement(logger, true);
            this.socket.set(new DatagramSocket(50000));
            byte[] buffer = new byte[512];
            DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
            Thread receiver = new Thread(null, () -> {
                while (this.isRunning()) {
                    boolean received;
                    try {
                        if (this.getCurrentDevices().isEmpty()) {
                            this.socket.get().setSoTimeout(60000);
                        } else {
                            this.socket.get().setSoTimeout(1000);
                        }
                        this.socket.get().receive(packet);
                        received = !this.ignoredAddresses.contains(packet.getAddress());
                    }
                    catch (SocketTimeoutException ste) {
                        received = false;
                    }
                    catch (IOException e) {
                        if (this.isRunning()) {
                            logger.warn("Problem reading from DeviceAnnouncement socket, stopping", (Throwable)e);
                            this.stop();
                        }
                        received = false;
                    }
                    try {
                        if (received) {
                            Util.PacketType kind = Util.validateHeader(packet, 50000);
                            if (kind == Util.PacketType.DEVICE_KEEP_ALIVE) {
                                if (packet.getLength() < 54) {
                                    logger.warn("Ignoring too-short {} packet; expected 54 bytes, but only got {}.", (Object)kind.name, (Object)packet.getLength());
                                } else {
                                    if (packet.getLength() > 54) {
                                        logger.warn("Processing too-long {} packet; expected 54 bytes, but got {}.", (Object)kind.name, (Object)packet.getLength());
                                    }
                                    DeviceAnnouncement announcement = new DeviceAnnouncement(packet);
                                    if (announcement.isOpusQuad) {
                                        this.createAndProcessOpusAnnouncements(packet);
                                    } else {
                                        this.processAnnouncement(announcement);
                                        if (VirtualCdj.getInstance().isRunning() && announcement.getDeviceNumber() == VirtualCdj.getInstance().getDeviceNumber()) {
                                            VirtualCdj.getInstance().defendDeviceNumber(announcement.getAddress());
                                        }
                                    }
                                }
                            } else if (kind == Util.PacketType.DEVICE_HELLO) {
                                logger.debug("Received device hello packet.");
                            } else if (kind != null) {
                                VirtualCdj.getInstance().handleSpecialAnnouncementPacket(kind, packet);
                            }
                        }
                        this.expireDevices();
                    }
                    catch (Throwable t) {
                        logger.warn("Problem processing DeviceAnnouncement packet", t);
                    }
                }
            }, "beat-link DeviceFinder receiver");
            receiver.setDaemon(true);
            receiver.start();
        }
    }

    synchronized void flush() {
        HashSet<DeviceAnnouncement> lastDevices = new HashSet<DeviceAnnouncement>(this.devices.values());
        this.devices.clear();
        firstDeviceTime.set(0L);
        SwingUtilities.invokeLater(() -> {
            for (DeviceAnnouncement announcement : lastDevices) {
                this.deliverLostAnnouncement(announcement);
            }
        });
    }

    @API(status=API.Status.STABLE)
    public synchronized void stop() {
        if (this.isRunning()) {
            this.socket.get().close();
            this.socket.set(null);
            this.flush();
            this.deliverLifecycleAnnouncement(logger, false);
        }
    }

    @API(status=API.Status.STABLE)
    public Set<DeviceAnnouncement> getCurrentDevices() {
        if (!this.isRunning()) {
            throw new IllegalStateException("DeviceFinder is not active");
        }
        this.expireDevices();
        return Set.copyOf(this.devices.values());
    }

    @API(status=API.Status.EXPERIMENTAL)
    public boolean isAnyDeviceLimitedToThreeDatabaseClients() {
        return limit3PlayersSeen.get();
    }

    @API(status=API.Status.STABLE)
    public DeviceAnnouncement getLatestAnnouncementFrom(int deviceNumber) {
        this.ensureRunning();
        for (DeviceAnnouncement announcement : this.getCurrentDevices()) {
            if (announcement.getDeviceNumber() != deviceNumber) continue;
            return announcement;
        }
        return null;
    }

    @API(status=API.Status.STABLE)
    public void addDeviceAnnouncementListener(DeviceAnnouncementListener listener) {
        if (listener != null) {
            this.deviceListeners.add(listener);
        }
    }

    public void removeDeviceAnnouncementListener(DeviceAnnouncementListener listener) {
        if (listener != null) {
            this.deviceListeners.remove(listener);
        }
    }

    @API(status=API.Status.STABLE)
    public Set<DeviceAnnouncementListener> getDeviceAnnouncementListeners() {
        return Set.copyOf(this.deviceListeners);
    }

    @API(status=API.Status.EXPERIMENTAL)
    public boolean isDeviceMetadataLimited(DeviceAnnouncement announcement) {
        return announcement.getDeviceNumber() < 7 && !this.METADATA_FLEXIBLE_DEVICES.contains(announcement.getDeviceName());
    }

    private void deliverFoundAnnouncement(DeviceAnnouncement announcement) {
        if (this.isDeviceMetadataLimited(announcement)) {
            limit3PlayersSeen.set(true);
        }
        for (DeviceAnnouncementListener listener : this.getDeviceAnnouncementListeners()) {
            SwingUtilities.invokeLater(() -> {
                try {
                    listener.deviceFound(announcement);
                }
                catch (Throwable t) {
                    logger.warn("Problem delivering device found announcement to listener", t);
                }
            });
        }
    }

    @API(status=API.Status.EXPERIMENTAL)
    private void deliverLostAnnouncement(DeviceAnnouncement announcement) {
        if (this.isDeviceMetadataLimited(announcement) && this.getCurrentDevices().stream().noneMatch(this::isDeviceMetadataLimited)) {
            limit3PlayersSeen.set(false);
        }
        for (DeviceAnnouncementListener listener : this.getDeviceAnnouncementListeners()) {
            SwingUtilities.invokeLater(() -> {
                try {
                    listener.deviceLost(announcement);
                }
                catch (Throwable t) {
                    logger.warn("Problem delivering device lost announcement to listener", t);
                }
            });
        }
    }

    @API(status=API.Status.STABLE)
    public static DeviceFinder getInstance() {
        return ourInstance;
    }

    private DeviceFinder() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DeviceFinder[active:").append(this.isRunning());
        if (this.isRunning()) {
            sb.append(", startTime:").append(this.getStartTime()).append(", firstDeviceTime:").append(this.getFirstDeviceTime());
            sb.append(", currentDevices:").append(this.getCurrentDevices());
        }
        return sb.append("]").toString();
    }
}

