/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apiguardian.api.API;
import org.deepsymmetry.beatlink.DeviceAnnouncement;
import org.deepsymmetry.beatlink.DeviceUpdate;

@API(status=API.Status.STABLE)
public class DeviceReference {
    @API(status=API.Status.STABLE)
    public final int deviceNumber;
    @API(status=API.Status.STABLE)
    public final InetAddress address;
    private final int hashcode;
    private static final Map<InetAddress, Map<Integer, DeviceReference>> instances = new HashMap<InetAddress, Map<Integer, DeviceReference>>();

    private DeviceReference(int number, InetAddress address) {
        this.deviceNumber = number;
        this.address = address;
        this.hashcode = Objects.hash(this.deviceNumber, address);
    }

    @API(status=API.Status.STABLE)
    public static synchronized DeviceReference getDeviceReference(int number, InetAddress address) {
        Map playerMap = instances.computeIfAbsent(address, k -> new HashMap());
        return playerMap.computeIfAbsent(number, n -> new DeviceReference((int)n, address));
    }

    @API(status=API.Status.STABLE)
    public static DeviceReference getDeviceReference(DeviceAnnouncement announcement) {
        return DeviceReference.getDeviceReference(announcement.getDeviceNumber(), announcement.getAddress());
    }

    @API(status=API.Status.STABLE)
    public static DeviceReference getDeviceReference(DeviceUpdate update) {
        return DeviceReference.getDeviceReference(update.deviceNumber, update.address);
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        return obj instanceof DeviceReference && ((DeviceReference)obj).deviceNumber == this.deviceNumber && ((DeviceReference)obj).address.equals(this.address);
    }

    public String toString() {
        return "DeckReference[deviceNumber:" + this.deviceNumber + ", address:" + this.address + "]";
    }
}

