/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink;

import java.net.DatagramPacket;
import java.net.InetAddress;
import org.apiguardian.api.API;
import org.deepsymmetry.beatlink.Util;

@API(status=API.Status.STABLE)
public abstract class DeviceUpdate {
    public static final int DEVICE_NUMBER_OFFSET = 33;
    final InetAddress address;
    final long timestamp = System.nanoTime();
    final String deviceName;
    final int deviceNumber;
    final byte[] packetBytes;
    final boolean preNexusCdj;
    @API(status=API.Status.EXPERIMENTAL)
    public final boolean isFromOpusQuad;

    @API(status=API.Status.STABLE)
    public DeviceUpdate(DatagramPacket packet, String name, int length) {
        if (packet.getLength() != length) {
            throw new IllegalArgumentException(name + " packet must be " + length + " bytes long");
        }
        this.address = packet.getAddress();
        this.packetBytes = new byte[packet.getLength()];
        System.arraycopy(packet.getData(), 0, this.packetBytes, 0, packet.getLength());
        this.deviceName = new String(this.packetBytes, 11, 20).trim();
        this.isFromOpusQuad = this.deviceName.equals("OPUS-QUAD");
        this.preNexusCdj = this.deviceName.startsWith("CDJ") && (this.deviceName.endsWith("900") || this.deviceName.endsWith("2000"));
        this.deviceNumber = this.isFromOpusQuad ? Util.translateOpusPlayerNumbers(this.packetBytes[33]) : Util.unsign(this.packetBytes[33]);
    }

    @API(status=API.Status.STABLE)
    public InetAddress getAddress() {
        return this.address;
    }

    @API(status=API.Status.STABLE)
    public long getTimestamp() {
        return this.timestamp;
    }

    @API(status=API.Status.STABLE)
    public String getDeviceName() {
        return this.deviceName;
    }

    @API(status=API.Status.STABLE)
    public boolean isPreNexusCdj() {
        return this.preNexusCdj;
    }

    @API(status=API.Status.STABLE)
    public int getDeviceNumber() {
        return this.deviceNumber;
    }

    @API(status=API.Status.STABLE)
    public byte[] getPacketBytes() {
        byte[] result = new byte[this.packetBytes.length];
        System.arraycopy(this.packetBytes, 0, result, 0, this.packetBytes.length);
        return result;
    }

    public abstract int getPitch();

    public abstract int getBpm();

    public abstract boolean isTempoMaster();

    public abstract boolean isSynced();

    public abstract Integer getDeviceMasterIsBeingYieldedTo();

    public abstract double getEffectiveTempo();

    public abstract int getBeatWithinBar();

    public abstract boolean isBeatWithinBarMeaningful();

    public String toString() {
        return "DeviceUpdate[deviceNumber:" + this.deviceNumber + ", deviceName:" + this.deviceName + ", address:" + this.address.getHostAddress() + ", timestamp:" + this.timestamp + ", beatWithinBar:" + this.getBeatWithinBar() + ", isBeatWithinBarMeaningful: " + this.isBeatWithinBarMeaningful() + ", effectiveTempo:" + this.getEffectiveTempo() + ", isTempoMaster:" + this.isTempoMaster();
    }
}

