/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apiguardian.api.API;
import org.deepsymmetry.beatlink.LifecycleListener;
import org.slf4j.Logger;

@API(status=API.Status.STABLE)
public abstract class LifecycleParticipant {
    private final Set<LifecycleListener> lifecycleListeners = Collections.newSetFromMap(new ConcurrentHashMap());

    @API(status=API.Status.STABLE)
    public void addLifecycleListener(LifecycleListener listener) {
        if (listener != null) {
            this.lifecycleListeners.add(listener);
        }
    }

    @API(status=API.Status.STABLE)
    public void removeLifecycleListener(LifecycleListener listener) {
        if (listener != null) {
            this.lifecycleListeners.remove(listener);
        }
    }

    @API(status=API.Status.STABLE)
    public Set<LifecycleListener> getLifecycleListeners() {
        return Set.copyOf(this.lifecycleListeners);
    }

    protected void deliverLifecycleAnnouncement(Logger logger, boolean starting) {
        new Thread(() -> {
            for (LifecycleListener listener : this.getLifecycleListeners()) {
                try {
                    if (starting) {
                        listener.started(this);
                        continue;
                    }
                    listener.stopped(this);
                }
                catch (Throwable t) {
                    logger.warn("Problem delivering lifecycle announcement to listener", t);
                }
            }
        }, "Lifecycle announcement delivery").start();
    }

    @API(status=API.Status.STABLE)
    public abstract boolean isRunning();

    protected void ensureRunning() {
        if (!this.isRunning()) {
            throw new IllegalStateException(this.getClass().getName() + " is not running");
        }
    }
}

