/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink;

import java.awt.Color;
import java.net.DatagramPacket;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apiguardian.api.API;
import org.deepsymmetry.beatlink.CdjStatus;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.data.ColorItem;
import org.deepsymmetry.beatlink.data.OpusProvider;
import org.deepsymmetry.beatlink.data.SlotReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.STABLE)
public class MediaDetails {
    private static final Logger logger = LoggerFactory.getLogger(MediaDetails.class);
    @API(status=API.Status.STABLE)
    public final SlotReference slotReference;
    @API(status=API.Status.STABLE)
    public final CdjStatus.TrackType mediaType;
    @API(status=API.Status.STABLE)
    public final String name;
    @API(status=API.Status.STABLE)
    public final String creationDate;
    @API(status=API.Status.STABLE)
    public final int trackCount;
    @API(status=API.Status.STABLE)
    public final int playlistCount;
    @API(status=API.Status.STABLE)
    public final Color color;
    @API(status=API.Status.STABLE)
    public final boolean hasMySettings;
    @API(status=API.Status.STABLE)
    public final long totalSize;
    @API(status=API.Status.STABLE)
    public final long freeSpace;
    private final ByteBuffer rawBytes;
    private static final Set<Integer> expectedMediaPacketSizes = new HashSet<Integer>(Collections.singletonList(192));
    @API(status=API.Status.STABLE)
    public static final int MINIMUM_PACKET_SIZE = 192;

    @API(status=API.Status.STABLE)
    public ByteBuffer getRawBytes() {
        this.rawBytes.rewind();
        return this.rawBytes.slice();
    }

    private int getUTF16StringLength(byte[] source, int offset, int maxLength) {
        int numBytes = maxLength;
        int clampedMaxLength = Math.min(maxLength, source.length - offset);
        for (int i = offset; i < offset + clampedMaxLength - 1; i += 2) {
            if (source[i] != 0 || source[i + 1] != 0) continue;
            numBytes = i - offset;
            break;
        }
        return numBytes;
    }

    @API(status=API.Status.STABLE)
    public MediaDetails(SlotReference slotReference, CdjStatus.TrackType mediaType, String name, int trackCount, int playlistCount, long lastModified) {
        if (!OpusProvider.getInstance().isRunning()) {
            throw new IllegalStateException("OpusProvider must be started up to use this Constructor");
        }
        this.slotReference = slotReference;
        this.mediaType = mediaType;
        this.name = name;
        this.creationDate = Long.toString(lastModified);
        this.trackCount = trackCount;
        this.totalSize = 0L;
        this.playlistCount = playlistCount;
        this.rawBytes = ByteBuffer.wrap(new byte[0]);
        this.color = new Color(0);
        this.freeSpace = 0L;
        this.hasMySettings = false;
    }

    MediaDetails(DatagramPacket packet) {
        this(packet.getData(), packet.getLength());
    }

    @API(status=API.Status.STABLE)
    public MediaDetails(byte[] packet, int packetLength) {
        byte[] packetCopy = new byte[packetLength];
        System.arraycopy(packet, 0, packetCopy, 0, packetLength);
        this.rawBytes = ByteBuffer.wrap(packetCopy).asReadOnlyBuffer();
        if (packetCopy.length < 192) {
            throw new IllegalArgumentException("Unable to create a MediaDetails object, packet too short: we need 192 bytes and were given only " + packetCopy.length);
        }
        int payloadLength = (int)Util.bytesToNumber(packetCopy, 34, 2);
        if (packetCopy.length != payloadLength + 36) {
            logger.warn("Received Media response packet with reported payload length of {} and actual payload length of {}", (Object)payloadLength, (Object)(packetCopy.length - 36));
        }
        if (!expectedMediaPacketSizes.contains(packetCopy.length)) {
            logger.warn("Processing Media response packets with unexpected lengths {}.", (Object)packetCopy.length);
            expectedMediaPacketSizes.add(packetCopy.length);
        }
        byte hostPlayer = packetCopy[39];
        CdjStatus.TrackSourceSlot hostSLot = CdjStatus.TRACK_SOURCE_SLOT_MAP.get(packetCopy[43]);
        if (hostSLot == null) {
            throw new IllegalArgumentException("Unrecognized slot for media response:" + packetCopy[43]);
        }
        this.slotReference = SlotReference.getSlotReference(hostPlayer, hostSLot);
        CdjStatus.TrackType type = CdjStatus.TRACK_TYPE_MAP.get(packetCopy[170]);
        if (type == null) {
            throw new IllegalArgumentException("Unrecognized media type for media response:" + packetCopy[170]);
        }
        this.mediaType = type;
        if (hostPlayer >= 40) {
            this.name = "rekordbox mobile";
            this.creationDate = "";
        } else {
            int mediaNameLength = this.getUTF16StringLength(packetCopy, 44, 64);
            int creationDateLength = this.getUTF16StringLength(packetCopy, 108, 24);
            this.name = new String(packetCopy, 44, mediaNameLength, StandardCharsets.UTF_16BE).trim();
            this.creationDate = new String(packetCopy, 108, creationDateLength, StandardCharsets.UTF_16BE).trim();
        }
        this.trackCount = (int)Util.bytesToNumber(packetCopy, 166, 2);
        this.color = ColorItem.colorForId(packetCopy[168]);
        this.playlistCount = (int)Util.bytesToNumber(packetCopy, 174, 2);
        this.hasMySettings = packetCopy[171] != 0;
        this.totalSize = Util.bytesToNumber(packetCopy, 176, 8);
        this.freeSpace = Util.bytesToNumber(packetCopy, 184, 8);
    }

    public String toString() {
        return "MediaDetails[slotReference:" + this.slotReference + ", name:" + this.name + ", creationDate:" + this.creationDate + ", mediaType:" + this.mediaType + ", trackCount:" + this.trackCount + ", playlistCount:" + this.playlistCount + ", totalSize:" + this.totalSize + ", freeSpace:" + this.freeSpace + "]";
    }

    @API(status=API.Status.STABLE)
    public String hashKey() {
        return this.creationDate + ":" + this.mediaType + ":" + this.totalSize + ":" + this.name;
    }

    @API(status=API.Status.STABLE)
    public boolean hasChanged(MediaDetails originalMedia) {
        if (!this.hashKey().equals(originalMedia.hashKey())) {
            throw new IllegalArgumentException("Can't compare media details with different hashKey values");
        }
        return this.playlistCount != originalMedia.playlistCount || this.trackCount != originalMedia.trackCount;
    }
}

