/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink;

import java.awt.Color;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.IntStream;
import org.apiguardian.api.API;
import org.deepsymmetry.beatlink.DeviceAnnouncement;
import org.deepsymmetry.cratedigger.pdb.RekordboxAnlz;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.STABLE)
public class Util {
    private static final Logger logger = LoggerFactory.getLogger(Util.class);
    private static final byte[] MAGIC_HEADER = new byte[]{81, 115, 112, 116, 49, 87, 109, 74, 79, 76};
    @API(status=API.Status.STABLE)
    public static final int PACKET_TYPE_OFFSET = 10;
    @API(status=API.Status.STABLE)
    public static final Map<Integer, Map<Byte, PacketType>> PACKET_TYPE_MAP;
    private static final Set<Integer> unknownPortsReported;
    private static final Map<Integer, Set<Byte>> unknownPortTypesReported;
    @API(status=API.Status.STABLE)
    public static final long NEUTRAL_PITCH = 0x100000L;
    private static final Map<String, Object> namedLocks;
    private static final Map<String, Integer> namedLockUseCounts;
    @API(status=API.Status.STABLE)
    public static final Color LOW_INTRO_COLOR;
    @API(status=API.Status.STABLE)
    public static final Color LOW_VERSE_1_COLOR;
    @API(status=API.Status.STABLE)
    public static final Color LOW_VERSE_2_COLOR;
    @API(status=API.Status.STABLE)
    public static final Color LOW_BRIDGE_COLOR;
    @API(status=API.Status.STABLE)
    public static final Color LOW_CHORUS_COLOR;
    @API(status=API.Status.STABLE)
    public static final Color LOW_OUTRO_COLOR;
    @API(status=API.Status.STABLE)
    public static final Color MID_INTRO_COLOR;
    @API(status=API.Status.STABLE)
    public static final Color MID_VERSE_1_COLOR;
    @API(status=API.Status.STABLE)
    public static final Color MID_VERSE_2_COLOR;
    @API(status=API.Status.STABLE)
    public static final Color MID_VERSE_3_COLOR;
    @API(status=API.Status.STABLE)
    public static final Color MID_VERSE_4_COLOR;
    @API(status=API.Status.STABLE)
    public static final Color MID_VERSE_5_COLOR;
    @API(status=API.Status.STABLE)
    public static final Color MID_VERSE_6_COLOR;
    @API(status=API.Status.STABLE)
    public static final Color MID_BRIDGE_COLOR;
    @API(status=API.Status.STABLE)
    public static final Color MID_CHORUS_COLOR;
    @API(status=API.Status.STABLE)
    public static final Color MID_OUTRO_COLOR;
    @API(status=API.Status.STABLE)
    public static final Color HIGH_INTRO_1_COLOR;
    @API(status=API.Status.STABLE)
    public static final Color HIGH_INTRO_2_COLOR;
    @API(status=API.Status.STABLE)
    public static final Color HIGH_UP_1_COLOR;
    @API(status=API.Status.STABLE)
    public static final Color HIGH_UP_2_COLOR;
    @API(status=API.Status.STABLE)
    public static final Color HIGH_UP_3_COLOR;
    @API(status=API.Status.STABLE)
    public static final Color HIGH_DOWN_COLOR;
    @API(status=API.Status.STABLE)
    public static final Color HIGH_CHORUS_1_COLOR;
    @API(status=API.Status.STABLE)
    public static final Color HIGH_CHORUS_2_COLOR;
    @API(status=API.Status.STABLE)
    public static final Color HIGH_OUTRO_1_COLOR;
    @API(status=API.Status.STABLE)
    public static final Color HIGH_OUTRO_2_COLOR;

    @API(status=API.Status.STABLE)
    public static ByteBuffer getMagicHeader() {
        return ByteBuffer.wrap(MAGIC_HEADER).asReadOnlyBuffer();
    }

    @API(status=API.Status.STABLE)
    public static DatagramPacket buildPacket(PacketType type, ByteBuffer deviceName, ByteBuffer payload) {
        ByteBuffer content = ByteBuffer.allocate(31 + payload.remaining());
        content.put(Util.getMagicHeader());
        content.put(type.protocolValue);
        content.put(deviceName);
        content.put(payload);
        return new DatagramPacket(content.array(), content.capacity());
    }

    @API(status=API.Status.STABLE)
    public static void setPayloadByte(byte[] payload, int address, byte value) {
        payload[address - 31] = value;
    }

    @API(status=API.Status.STABLE)
    public static PacketType validateHeader(DatagramPacket packet, int port) {
        Set typesReportedForPort;
        byte[] data = packet.getData();
        if (data.length < 10) {
            logger.warn("Packet is too short to be a Pro DJ Link packet; must be at least 10 bytes long, was only {}.", (Object)data.length);
            return null;
        }
        if (!Util.getMagicHeader().equals(ByteBuffer.wrap(data, 0, MAGIC_HEADER.length))) {
            logger.warn("Packet did not have correct ten-byte header for the Pro DJ Link protocol.");
            return null;
        }
        Map<Byte, PacketType> portMap = PACKET_TYPE_MAP.get(port);
        if (portMap == null) {
            if (!unknownPortsReported.contains(port)) {
                logger.warn("Do not know any Pro DJ Link packets that are received on port {} (this will be reported only once).", (Object)port);
                unknownPortsReported.add(port);
            }
            return null;
        }
        PacketType result = portMap.get(data[10]);
        if (result == null && !(typesReportedForPort = unknownPortTypesReported.computeIfAbsent(port, k -> Collections.newSetFromMap(new ConcurrentHashMap()))).contains(data[10])) {
            logger.warn("Do not know any Pro DJ Link packets received on port {} with type {} (this will be reported only once).", (Object)port, (Object)String.format("0x%02x", data[10]));
            typesReportedForPort.add(data[10]);
        }
        return result;
    }

    @API(status=API.Status.STABLE)
    public static int unsign(byte b) {
        return b & 0xFF;
    }

    @API(status=API.Status.STABLE)
    public static long bytesToNumber(byte[] buffer, int start, int length) {
        long result = 0L;
        for (int index = start; index < start + length; ++index) {
            result = (result << 8) + (long)Util.unsign(buffer[index]);
        }
        return result;
    }

    @API(status=API.Status.STABLE)
    public static int indexOfByteBuffer(ByteBuffer buf, byte[] bytes) {
        if (bytes.length == 0) {
            return -1;
        }
        OptionalInt optionalInt = IntStream.rangeClosed(buf.position(), buf.limit() - bytes.length).filter(i -> IntStream.range(0, bytes.length).allMatch(j -> buf.get(i + j) == bytes[j])).findFirst();
        if (optionalInt.isPresent()) {
            return optionalInt.getAsInt();
        }
        return -1;
    }

    @API(status=API.Status.STABLE)
    public static long bytesToNumberLittleEndian(byte[] buffer, int start, int length) {
        long result = 0L;
        for (int index = start + length - 1; index >= start; --index) {
            result = (result << 8) + (long)Util.unsign(buffer[index]);
        }
        return result;
    }

    @API(status=API.Status.STABLE)
    public static void numberToBytes(int number, byte[] buffer, int start, int length) {
        for (int index = start + length - 1; index >= start; --index) {
            buffer[index] = (byte)(number & 0xFF);
            number >>= 8;
        }
    }

    @API(status=API.Status.STABLE)
    public static long addressToLong(InetAddress address) {
        long result = 0L;
        for (byte element : address.getAddress()) {
            result = (result << 8) + (long)Util.unsign(element);
        }
        return result;
    }

    @API(status=API.Status.STABLE)
    public static boolean sameNetwork(int prefixLength, InetAddress address1, InetAddress address2) {
        if (logger.isDebugEnabled()) {
            logger.debug("Comparing address {} with {}, prefixLength={}", new Object[]{address1.getHostAddress(), address2.getHostAddress(), prefixLength});
        }
        long prefixMask = 0xFFFFFFFFL & -1L << 32 - prefixLength;
        return (Util.addressToLong(address1) & prefixMask) == (Util.addressToLong(address2) & prefixMask);
    }

    @API(status=API.Status.STABLE)
    public static double pitchToPercentage(long pitch) {
        return (double)(pitch - 0x100000L) / 10485.76;
    }

    @API(status=API.Status.STABLE)
    public static long percentageToPitch(double percentage) {
        return Math.round(percentage * 1048576.0 / 100.0) + 0x100000L;
    }

    @API(status=API.Status.STABLE)
    public static double pitchToMultiplier(long pitch) {
        return (double)pitch / 1048576.0;
    }

    @API(status=API.Status.STABLE)
    public static void writeFully(ByteBuffer buffer, WritableByteChannel channel) throws IOException {
        while (buffer.hasRemaining()) {
            channel.write(buffer);
        }
    }

    @API(status=API.Status.STABLE)
    public static long halfFrameToTime(long halfFrame) {
        return halfFrame * 100L / 15L;
    }

    @API(status=API.Status.STABLE)
    public static int timeToHalfFrame(long milliseconds) {
        return (int)(milliseconds * 15L / 100L);
    }

    @API(status=API.Status.STABLE)
    public static int timeToHalfFrameRounded(long milliseconds) {
        return Math.round((float)milliseconds * 0.15f);
    }

    @API(status=API.Status.STABLE)
    public static synchronized Object allocateNamedLock(String name) {
        Object result = namedLocks.get(name);
        if (result != null) {
            namedLockUseCounts.put(name, namedLockUseCounts.get(name) + 1);
            return result;
        }
        namedLockUseCounts.put(name, 1);
        result = new Object();
        namedLocks.put(name, result);
        return result;
    }

    @API(status=API.Status.STABLE)
    public static synchronized void freeNamedLock(String name) {
        int count = namedLockUseCounts.get(name);
        if (count > 1) {
            namedLockUseCounts.put(name, count - 1);
        } else {
            namedLocks.remove(name);
            namedLockUseCounts.remove(name);
        }
    }

    @API(status=API.Status.STABLE)
    public static Color buildColor(Color hueColor, Color alphaColor) {
        return new Color(hueColor.getRed(), hueColor.getGreen(), hueColor.getBlue(), alphaColor.getAlpha());
    }

    @API(status=API.Status.STABLE)
    public static Color phraseColor(RekordboxAnlz.SongStructureEntry phrase) {
        switch (phrase._parent().mood()) {
            case LOW: {
                RekordboxAnlz.PhraseLow phraseLow = (RekordboxAnlz.PhraseLow)phrase.kind();
                if (phraseLow == null) {
                    return Color.white;
                }
                switch (phraseLow.id()) {
                    case INTRO: {
                        return LOW_INTRO_COLOR;
                    }
                    case VERSE_1: 
                    case VERSE_1B: 
                    case VERSE_1C: {
                        return LOW_VERSE_1_COLOR;
                    }
                    case VERSE_2: 
                    case VERSE_2B: 
                    case VERSE_2C: {
                        return LOW_VERSE_2_COLOR;
                    }
                    case BRIDGE: {
                        return LOW_BRIDGE_COLOR;
                    }
                    case CHORUS: {
                        return LOW_CHORUS_COLOR;
                    }
                    case OUTRO: {
                        return LOW_OUTRO_COLOR;
                    }
                }
            }
            case MID: {
                RekordboxAnlz.PhraseMid phraseMid = (RekordboxAnlz.PhraseMid)phrase.kind();
                if (phraseMid == null) {
                    return Color.white;
                }
                switch (phraseMid.id()) {
                    case INTRO: {
                        return MID_INTRO_COLOR;
                    }
                    case VERSE_1: {
                        return MID_VERSE_1_COLOR;
                    }
                    case VERSE_2: {
                        return MID_VERSE_2_COLOR;
                    }
                    case VERSE_3: {
                        return MID_VERSE_3_COLOR;
                    }
                    case VERSE_4: {
                        return MID_VERSE_4_COLOR;
                    }
                    case VERSE_5: {
                        return MID_VERSE_5_COLOR;
                    }
                    case VERSE_6: {
                        return MID_VERSE_6_COLOR;
                    }
                    case BRIDGE: {
                        return MID_BRIDGE_COLOR;
                    }
                    case CHORUS: {
                        return MID_CHORUS_COLOR;
                    }
                    case OUTRO: {
                        return MID_OUTRO_COLOR;
                    }
                }
            }
            case HIGH: {
                RekordboxAnlz.PhraseHigh phraseHigh = (RekordboxAnlz.PhraseHigh)phrase.kind();
                if (phraseHigh == null) {
                    return Color.white;
                }
                switch (phraseHigh.id()) {
                    case INTRO: {
                        if (phrase.k1() == 1) {
                            return HIGH_INTRO_1_COLOR;
                        }
                        return HIGH_INTRO_2_COLOR;
                    }
                    case UP: {
                        if (phrase.k2() == 0) {
                            if (phrase.k3() == 0) {
                                return HIGH_UP_1_COLOR;
                            }
                            return HIGH_UP_2_COLOR;
                        }
                        return HIGH_UP_3_COLOR;
                    }
                    case DOWN: {
                        return HIGH_DOWN_COLOR;
                    }
                    case CHORUS: {
                        if (phrase.k1() == 1) {
                            return HIGH_CHORUS_1_COLOR;
                        }
                        return HIGH_CHORUS_2_COLOR;
                    }
                    case OUTRO: {
                        if (phrase.k1() == 1) {
                            return HIGH_OUTRO_1_COLOR;
                        }
                        return HIGH_OUTRO_2_COLOR;
                    }
                }
            }
        }
        return Color.WHITE;
    }

    @API(status=API.Status.STABLE)
    public static Color phraseTextColor(RekordboxAnlz.SongStructureEntry phrase) {
        if (phrase._parent().mood() == RekordboxAnlz.TrackMood.HIGH) {
            return Color.white;
        }
        return Color.black;
    }

    @API(status=API.Status.STABLE)
    public static String phraseLabel(RekordboxAnlz.SongStructureEntry phrase) {
        switch (phrase._parent().mood()) {
            case LOW: {
                RekordboxAnlz.PhraseLow phraseLow = (RekordboxAnlz.PhraseLow)phrase.kind();
                if (phraseLow == null) {
                    return "Unknown Low";
                }
                switch (phraseLow.id()) {
                    case INTRO: {
                        return "Intro";
                    }
                    case VERSE_1: 
                    case VERSE_1B: 
                    case VERSE_1C: {
                        return "Verse 1";
                    }
                    case VERSE_2: 
                    case VERSE_2B: 
                    case VERSE_2C: {
                        return "Verse 2";
                    }
                    case BRIDGE: {
                        return "Bridge";
                    }
                    case CHORUS: {
                        return "Chorus";
                    }
                    case OUTRO: {
                        return "Outro";
                    }
                }
            }
            case MID: {
                RekordboxAnlz.PhraseMid phraseMid = (RekordboxAnlz.PhraseMid)phrase.kind();
                if (phraseMid == null) {
                    return "Unknown Mid";
                }
                switch (phraseMid.id()) {
                    case INTRO: {
                        return "Intro";
                    }
                    case VERSE_1: {
                        return "Verse 1";
                    }
                    case VERSE_2: {
                        return "Verse 2";
                    }
                    case VERSE_3: {
                        return "Verse 3";
                    }
                    case VERSE_4: {
                        return "Verse 4";
                    }
                    case VERSE_5: {
                        return "Verse 5";
                    }
                    case VERSE_6: {
                        return "Verse 6";
                    }
                    case BRIDGE: {
                        return "Bridge";
                    }
                    case CHORUS: {
                        return "Chorus";
                    }
                    case OUTRO: {
                        return "Outro";
                    }
                }
            }
            case HIGH: {
                RekordboxAnlz.PhraseHigh phraseHigh = (RekordboxAnlz.PhraseHigh)phrase.kind();
                if (phraseHigh == null) {
                    return "Unknown High";
                }
                switch (phraseHigh.id()) {
                    case INTRO: {
                        if (phrase.k1() == 1) {
                            return "Intro 1";
                        }
                        return "Intro 2";
                    }
                    case UP: {
                        if (phrase.k2() == 0) {
                            if (phrase.k3() == 0) {
                                return "Up 1";
                            }
                            return "Up 2";
                        }
                        return "Up 3";
                    }
                    case DOWN: {
                        return "Down";
                    }
                    case CHORUS: {
                        if (phrase.k1() == 1) {
                            return "Chorus 1";
                        }
                        return "Chorus 2";
                    }
                    case OUTRO: {
                        if (phrase.k1() == 1) {
                            return "Outro 1";
                        }
                        return "Outro 2";
                    }
                }
            }
        }
        return "Unknown Mood";
    }

    @API(status=API.Status.STABLE)
    public static InterfaceAddress findMatchingAddress(DeviceAnnouncement announcement, NetworkInterface networkInterface) {
        for (InterfaceAddress address : networkInterface.getInterfaceAddresses()) {
            if (address == null) {
                logger.warn("Received a null InterfaceAddress from networkInterface.getInterfaceAddresses(), is this Windows? Do you have a VPN installed? Trying to recover by ignoring it.");
                continue;
            }
            if (address.getBroadcast() == null || !Util.sameNetwork(address.getNetworkPrefixLength(), announcement.getAddress(), address.getAddress())) continue;
            return address;
        }
        return null;
    }

    @API(status=API.Status.STABLE)
    public static String highResolutionPath(String artPath) {
        return artPath.replaceFirst("(\\.\\w+$)", "_m$1");
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static int translateOpusPlayerNumbers(int reportedPlayerNumber) {
        return reportedPlayerNumber & 7;
    }

    private Util() {
    }

    static {
        HashMap<Integer, Map> scratch = new HashMap<Integer, Map>();
        for (PacketType packetType : PacketType.values()) {
            Map portMap = scratch.computeIfAbsent(packetType.port, k -> new HashMap());
            portMap.put(packetType.protocolValue, packetType);
        }
        scratch.replaceAll((k, v) -> Collections.unmodifiableMap(v));
        PACKET_TYPE_MAP = Collections.unmodifiableMap(scratch);
        unknownPortsReported = Collections.newSetFromMap(new ConcurrentHashMap());
        unknownPortTypesReported = new ConcurrentHashMap<Integer, Set<Byte>>();
        namedLocks = new HashMap<String, Object>();
        namedLockUseCounts = new HashMap<String, Integer>();
        LOW_INTRO_COLOR = new Color(255, 170, 180);
        LOW_VERSE_1_COLOR = new Color(165, 160, 255);
        LOW_VERSE_2_COLOR = new Color(190, 160, 255);
        LOW_BRIDGE_COLOR = new Color(255, 250, 165);
        LOW_CHORUS_COLOR = new Color(185, 225, 185);
        LOW_OUTRO_COLOR = new Color(145, 160, 180);
        MID_INTRO_COLOR = new Color(225, 70, 70);
        MID_VERSE_1_COLOR = new Color(80, 110, 255);
        MID_VERSE_2_COLOR = new Color(80, 85, 255);
        MID_VERSE_3_COLOR = new Color(100, 80, 255);
        MID_VERSE_4_COLOR = new Color(120, 80, 255);
        MID_VERSE_5_COLOR = new Color(140, 80, 255);
        MID_VERSE_6_COLOR = new Color(160, 80, 255);
        MID_BRIDGE_COLOR = new Color(225, 215, 65);
        MID_CHORUS_COLOR = new Color(120, 195, 125);
        MID_OUTRO_COLOR = new Color(115, 130, 150);
        HIGH_INTRO_1_COLOR = new Color(200, 0, 0);
        HIGH_INTRO_2_COLOR = new Color(200, 50, 0);
        HIGH_UP_1_COLOR = new Color(140, 50, 255);
        HIGH_UP_2_COLOR = new Color(105, 50, 255);
        HIGH_UP_3_COLOR = new Color(90, 50, 255);
        HIGH_DOWN_COLOR = new Color(155, 115, 45);
        HIGH_CHORUS_1_COLOR = new Color(15, 170, 0);
        HIGH_CHORUS_2_COLOR = new Color(15, 170, 0);
        HIGH_OUTRO_1_COLOR = new Color(80, 135, 195);
        HIGH_OUTRO_2_COLOR = new Color(95, 135, 175);
    }

    @API(status=API.Status.STABLE)
    public static enum PacketType {
        FADER_START_COMMAND(2, "Fader Start", 50001),
        CHANNELS_ON_AIR(3, "Channels On Air", 50001),
        MEDIA_QUERY(5, "Media Query", 50002),
        MEDIA_RESPONSE(6, "Media Response", 50002),
        DEVICE_HELLO(10, "Device Hello", 50000),
        DEVICE_REKORDBOX_LIGHTING_HELLO_BYTES(16, "Rekordbox Lighting Hello Bytes", 50002),
        DEVICE_NUMBER_STAGE_1(0, "Device Number Claim Stage 1", 50000),
        DEVICE_NUMBER_WILL_ASSIGN(1, "Device Number Will Be Assigned", 50000),
        DEVICE_NUMBER_STAGE_2(2, "Device Number Claim Stage 2", 50000),
        DEVICE_NUMBER_ASSIGN(3, "Device Number Assignment", 50000),
        DEVICE_NUMBER_STAGE_3(4, "Device Number Claim Stage 3", 50000),
        DEVICE_NUMBER_ASSIGNMENT_FINISHED(5, "Device Number Assignment Finished", 50000),
        DEVICE_KEEP_ALIVE(6, "Device Keep-Alive", 50000),
        DEVICE_NUMBER_IN_USE(8, "Device Number In Use", 50000),
        CDJ_STATUS(10, "CDJ Status", 50002),
        OPUS_METADATA(86, "OPUS Metadata", 50002),
        LOAD_TRACK_COMMAND(25, "Load Track Command", 50002),
        LOAD_TRACK_ACK(26, "Load Track Acknowledgment", 50002),
        MASTER_HANDOFF_REQUEST(38, "Master Handoff Request", 50001),
        MASTER_HANDOFF_RESPONSE(39, "Master Handoff Response", 50001),
        BEAT(40, "Beat", 50001),
        PRECISE_POSITION(11, "Precise Position", 50001),
        MIXER_STATUS(41, "Mixer Status", 50002),
        SYNC_CONTROL(42, "Sync Control", 50001),
        LOAD_SETTINGS_COMMAND(52, "Load Settings Command", 50002);

        @API(status=API.Status.STABLE)
        public final byte protocolValue;
        @API(status=API.Status.STABLE)
        public final String name;
        @API(status=API.Status.STABLE)
        public final int port;

        private PacketType(int value, String name, int port) {
            this.protocolValue = (byte)value;
            this.name = name;
            this.port = port;
        }
    }
}

