/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apiguardian.api.API;
import org.deepsymmetry.beatlink.CdjStatus;
import org.deepsymmetry.beatlink.DeviceAnnouncement;
import org.deepsymmetry.beatlink.DeviceFinder;
import org.deepsymmetry.beatlink.DeviceReference;
import org.deepsymmetry.beatlink.DeviceUpdate;
import org.deepsymmetry.beatlink.DeviceUpdateListener;
import org.deepsymmetry.beatlink.LifecycleListener;
import org.deepsymmetry.beatlink.LifecycleParticipant;
import org.deepsymmetry.beatlink.MixerStatus;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.VirtualCdj;
import org.deepsymmetry.beatlink.data.OpusProvider;
import org.deepsymmetry.beatlink.data.SlotReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.EXPERIMENTAL)
public class VirtualRekordbox
extends LifecycleParticipant {
    private static final Logger logger = LoggerFactory.getLogger(VirtualRekordbox.class);
    @API(status=API.Status.EXPERIMENTAL)
    public static final int UPDATE_PORT = 50002;
    @API(status=API.Status.EXPERIMENTAL)
    public static final int MAC_ADDRESS_OFFSET = 38;
    private final AtomicReference<DatagramSocket> socket = new AtomicReference();
    private final AtomicReference<InetAddress> broadcastAddress = new AtomicReference();
    private final Map<DeviceReference, DeviceUpdate> updates = new ConcurrentHashMap<DeviceReference, DeviceUpdate>();
    private final AtomicInteger announceInterval = new AtomicInteger(1500);
    private static final int METADATA_TYPE_IDENTIFIER_PSSI = 10;
    private static final int METADATA_TYPE_IDENTIFIER_SONG_CHANGE = 1;
    private static final byte[] rekordboxKeepAliveBytes = new byte[]{81, 115, 112, 116, 49, 87, 109, 74, 79, 76, 6, 0, 114, 101, 107, 111, 114, 100, 98, 111, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3, 0, 54, 23, 1, 24, 62, -17, -38, 91, -54, -64, -88, 2, 11, 4, 1, 0, 0, 4, 8};
    private static final byte[] rekordboxLightingRequestStatusBytes = new byte[]{81, 115, 112, 116, 49, 87, 109, 74, 79, 76, 17, 114, 101, 107, 111, 114, 100, 98, 111, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 23, 1, 4, 23, 1, 0, 0, 0, 109, 0, 97, 0, 99, 0, 98, 0, 111, 0, 111, 0, 107, 0, 32, 0, 112, 0, 114, 0, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    @API(status=API.Status.EXPERIMENTAL)
    public static final int DEVICE_NAME_OFFSET = 12;
    @API(status=API.Status.EXPERIMENTAL)
    public static final int DEVICE_NAME_LENGTH = 20;
    @API(status=API.Status.EXPERIMENTAL)
    public static final int DEVICE_NUMBER_OFFSET = 36;
    private static final byte[] requestPSSIBytes = new byte[]{81, 115, 112, 116, 49, 87, 109, 74, 79, 76, 85, 114, 101, 107, 111, 114, 100, 98, 111, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 23, 0, 8, 54, 0, 0, 0, 10, 2, 3, 1};
    private final Map<Integer, SlotReference> playerTrackSourceSlots = new ConcurrentHashMap<Integer, SlotReference>();
    private final Map<Integer, Integer> playerToDeviceSqlRekordboxId = new ConcurrentHashMap<Integer, Integer>();
    private final Map<Integer, Byte> lastValidStatusFlagBytes = new ConcurrentHashMap<Integer, Byte>();
    private final Map<Integer, Integer> previousRawRekordboxIds = new ConcurrentHashMap<Integer, Integer>();
    private final Map<Integer, PacketTracker> playerPacketTrackers = new ConcurrentHashMap<Integer, PacketTracker>();
    @API(status=API.Status.EXPERIMENTAL)
    private static final long SELF_ASSIGNMENT_WATCH_PERIOD = 4000L;
    private List<NetworkInterface> matchingInterfaces = null;
    private InterfaceAddress matchedAddress = null;
    private final LifecycleListener deviceFinderLifecycleListener = new LifecycleListener(){

        @Override
        public void started(LifecycleParticipant sender) {
            logger.debug("VirtualRekordbox doesn't have anything to do when the DeviceFinder starts");
        }

        @Override
        public void stopped(LifecycleParticipant sender) {
            if (VirtualRekordbox.this.isRunning()) {
                logger.info("VirtualRekordbox stopping because DeviceFinder has stopped.");
                VirtualRekordbox.this.stop();
            }
        }
    };
    private final Set<DeviceUpdateListener> updateListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final VirtualRekordbox ourInstance = new VirtualRekordbox();

    @Override
    @API(status=API.Status.EXPERIMENTAL)
    public boolean isRunning() {
        return this.socket.get() != null;
    }

    @API(status=API.Status.EXPERIMENTAL)
    public InetAddress getLocalAddress() {
        this.ensureRunning();
        return this.socket.get().getLocalAddress();
    }

    @API(status=API.Status.EXPERIMENTAL)
    public InetAddress getBroadcastAddress() {
        this.ensureRunning();
        return this.broadcastAddress.get();
    }

    @API(status=API.Status.EXPERIMENTAL)
    public synchronized byte getDeviceNumber() {
        return rekordboxKeepAliveBytes[36];
    }

    @API(status=API.Status.EXPERIMENTAL)
    public synchronized void setDeviceNumber(byte number) {
        if (this.isRunning()) {
            throw new IllegalStateException("Can't change device number once started.");
        }
        VirtualRekordbox.rekordboxKeepAliveBytes[36] = number;
    }

    @API(status=API.Status.EXPERIMENTAL)
    public int getAnnounceInterval() {
        return this.announceInterval.get();
    }

    @API(status=API.Status.EXPERIMENTAL)
    public void setAnnounceInterval(int interval) {
        if (interval < 200 || interval > 2000) {
            throw new IllegalArgumentException("Interval must be between 200 and 2000");
        }
        this.announceInterval.set(interval);
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static String getDeviceName() {
        return new String(rekordboxKeepAliveBytes, 12, 20).trim();
    }

    @API(status=API.Status.EXPERIMENTAL)
    public void requestPSSI() throws IOException {
        if (DeviceFinder.getInstance().isRunning() && !DeviceFinder.getInstance().getCurrentDevices().isEmpty()) {
            InetAddress address = DeviceFinder.getInstance().getCurrentDevices().iterator().next().getAddress();
            DatagramPacket packet = new DatagramPacket(requestPSSIBytes, requestPSSIBytes.length, address, 50002);
            this.socket.get().send(packet);
        }
    }

    @API(status=API.Status.EXPERIMENTAL)
    public void clearPlayerCaches(int usbSlotNumber) {
        this.playerTrackSourceSlots.remove(usbSlotNumber);
    }

    SlotReference findMatchedTrackSourceSlotForPlayer(int player) {
        return this.playerTrackSourceSlots.get(player);
    }

    int findDeviceSqlRekordboxIdForPlayer(int player) {
        return this.playerToDeviceSqlRekordboxId.getOrDefault(player, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DeviceUpdate buildUpdate(DatagramPacket packet) {
        int length = packet.getLength();
        Util.PacketType kind = Util.validateHeader(packet, 50002);
        if (kind == null) {
            logger.debug("Ignoring unrecognized packet sent to update port.");
            return null;
        }
        switch (kind) {
            case MIXER_STATUS: {
                if (length != 56) {
                    logger.warn("Processing a Mixer Status packet with unexpected length {}, expected 56 bytes.", (Object)length);
                }
                if (length >= 56) {
                    return new MixerStatus(packet);
                }
                logger.warn("Ignoring too-short Mixer Status packet.");
                return null;
            }
            case CDJ_STATUS: {
                if (length < 204) {
                    logger.warn("Ignoring too-short CDJ Status packet with length {} (we need 204 bytes).", (Object)length);
                    return null;
                }
                byte reportedStatusFlags = packet.getData()[137];
                boolean hadToRecoverStatusFlags = reportedStatusFlags == 0;
                byte rawDeviceNumber = packet.getData()[33];
                if (hadToRecoverStatusFlags) {
                    Byte recoveredStatusFlags = this.lastValidStatusFlagBytes.get(rawDeviceNumber);
                    if (recoveredStatusFlags == null) {
                        logger.warn("Unable to recover from malformed Opus Quad status packet because we have not yet received a valid packet from device {}.", (Object)rawDeviceNumber);
                        return null;
                    }
                    packet.getData()[137] = recoveredStatusFlags;
                } else {
                    this.lastValidStatusFlagBytes.put(Integer.valueOf(rawDeviceNumber), reportedStatusFlags);
                }
                int rawRekordboxId = (int)Util.bytesToNumber(packet.getData(), 44, 4);
                CdjStatus status = new CdjStatus(packet, hadToRecoverStatusFlags);
                int deviceNumber = status.getDeviceNumber();
                Integer previousId = this.previousRawRekordboxIds.put(deviceNumber, rawRekordboxId);
                if (previousId == null) {
                    previousId = 0;
                }
                boolean trackChanged = previousId != rawRekordboxId;
                if (!trackChanged) return status;
                this.playerTrackSourceSlots.remove(deviceNumber);
                this.playerToDeviceSqlRekordboxId.remove(deviceNumber);
                if (rawRekordboxId == 0) return status;
                try {
                    this.requestPSSI();
                    return status;
                }
                catch (IOException e) {
                    logger.warn("Cannot send PSSI request");
                }
                return status;
            }
            case DEVICE_REKORDBOX_LIGHTING_HELLO_BYTES: {
                if (length >= 204) {
                    return new CdjStatus(packet);
                }
                logger.debug("Opus Hello bytes packet.");
                return null;
            }
            case OPUS_METADATA: {
                byte[] data = packet.getData();
                int packetLength = packet.getLength();
                byte[] binaryData = Arrays.copyOfRange(data, 52, packetLength);
                int playerNumber = Util.translateOpusPlayerNumbers(data[33]);
                int rekordboxIdFromOpus = (int)Util.bytesToNumber(data, 40, 4);
                PacketTracker tracker = this.playerPacketTrackers.computeIfAbsent(playerNumber, k -> new PacketTracker());
                if (data[37] != 10) return null;
                byte packetNumber = data[49];
                int totalPackets = data[51] - 1;
                boolean dataComplete = tracker.receivePacket(binaryData, packetNumber, totalPackets);
                if (!dataComplete) return null;
                byte[] pssiFromOpus = tracker.getDataAsBytesAndTrimTrailingZeros();
                tracker.resetForNewPacketStream();
                OpusProvider.DeviceSqlRekordboxIdAndSlot match = OpusProvider.getInstance().getDeviceSqlRekordboxIdAndSlotNumberFromPssi(pssiFromOpus, rekordboxIdFromOpus);
                if (match == null) return null;
                this.playerToDeviceSqlRekordboxId.put(playerNumber, match.rekordboxId);
                this.playerTrackSourceSlots.put(playerNumber, SlotReference.getSlotReference(match.usbSlot, CdjStatus.TrackSourceSlot.USB_SLOT));
                return null;
            }
        }
        logger.warn("Ignoring {} packet sent to update port.", (Object)kind.name);
        return null;
    }

    @API(status=API.Status.EXPERIMENTAL)
    public void sendRekordboxLightingPacket() {
        DatagramPacket updatesAnnouncement = new DatagramPacket(rekordboxLightingRequestStatusBytes, rekordboxLightingRequestStatusBytes.length, this.broadcastAddress.get(), 50002);
        try {
            this.socket.get().send(updatesAnnouncement);
        }
        catch (IOException e) {
            logger.warn("Unable to send Rekordbox lighting hello packet. Will try again when next device announces itself.");
        }
    }

    private void processUpdate(DeviceUpdate update) {
        this.updates.put(DeviceReference.getDeviceReference(update), update);
        this.deliverDeviceUpdate(update);
    }

    private boolean selfAssignDeviceNumber() {
        long started;
        long now = System.currentTimeMillis();
        if (now - (started = DeviceFinder.getInstance().getFirstDeviceTime()) < 4000L) {
            try {
                Thread.sleep(4000L - (now - started));
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted waiting to self-assign device number, giving up.");
                return false;
            }
        }
        HashSet<Integer> numbersUsed = new HashSet<Integer>();
        for (DeviceAnnouncement device : DeviceFinder.getInstance().getCurrentDevices()) {
            numbersUsed.add(device.getDeviceNumber());
        }
        if (!numbersUsed.contains(this.getDeviceNumber())) {
            return true;
        }
        for (int result = 19; result < 40; ++result) {
            if (numbersUsed.contains(result)) continue;
            this.setDeviceNumber((byte)result);
            return true;
        }
        logger.warn("Found no unused device numbers between 0x13 and 0x27, giving up.");
        return false;
    }

    @API(status=API.Status.EXPERIMENTAL)
    public InterfaceAddress getMatchedAddress() {
        return this.matchedAddress;
    }

    @API(status=API.Status.EXPERIMENTAL)
    public List<NetworkInterface> getMatchingInterfaces() {
        this.ensureRunning();
        return Collections.unmodifiableList(this.matchingInterfaces);
    }

    @API(status=API.Status.EXPERIMENTAL)
    public void sendRekordboxAnnouncement() {
        if (this.isRunning()) {
            DatagramPacket announcement = new DatagramPacket(rekordboxKeepAliveBytes, rekordboxKeepAliveBytes.length, this.broadcastAddress.get(), 50000);
            try {
                this.socket.get().send(announcement);
            }
            catch (IOException e) {
                logger.error("Exception sending announce, trying again.", (Throwable)e);
            }
        }
    }

    private boolean createVirtualRekordbox() throws Exception {
        OpusProvider.getInstance().start();
        this.addUpdateListener(VirtualCdj.getInstance().getUpdateListener());
        this.matchingInterfaces = new ArrayList<NetworkInterface>();
        this.matchedAddress = null;
        DeviceAnnouncement announcement = DeviceFinder.getInstance().getCurrentDevices().iterator().next();
        for (NetworkInterface networkInterface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
            InterfaceAddress candidate = Util.findMatchingAddress(announcement, networkInterface);
            if (candidate == null) continue;
            if (this.matchedAddress == null) {
                this.matchedAddress = candidate;
            }
            this.matchingInterfaces.add(networkInterface);
        }
        if (this.matchedAddress == null) {
            logger.warn("Unable to find network interface to communicate with {}, giving up.", (Object)announcement);
            return false;
        }
        logger.info("Found matching network interface {} ({}), will use address {}", new Object[]{this.matchingInterfaces.get(0).getDisplayName(), this.matchingInterfaces.get(0).getName(), this.matchedAddress});
        if (this.matchingInterfaces.size() > 1) {
            ListIterator<NetworkInterface> it = this.matchingInterfaces.listIterator(1);
            while (it.hasNext()) {
                NetworkInterface extra = it.next();
                logger.warn("Network interface {} ({}) sees same network: we will likely get duplicate DJ Link packets, causing severe problems.", (Object)extra.getDisplayName(), (Object)extra.getName());
            }
        }
        this.socket.set(new DatagramSocket(50002, this.matchedAddress.getAddress()));
        System.arraycopy(this.getMatchingInterfaces().get(0).getHardwareAddress(), 0, rekordboxKeepAliveBytes, 38, 6);
        System.arraycopy(this.matchedAddress.getAddress().getAddress(), 0, rekordboxKeepAliveBytes, 44, 4);
        System.arraycopy(this.getMatchingInterfaces().get(0).getHardwareAddress(), 0, rekordboxLightingRequestStatusBytes, 38, 6);
        System.arraycopy(this.matchedAddress.getAddress().getAddress(), 0, rekordboxLightingRequestStatusBytes, 44, 4);
        this.broadcastAddress.set(this.matchedAddress.getBroadcast());
        DeviceFinder.getInstance().addIgnoredAddress(this.matchedAddress.getBroadcast());
        DeviceFinder.getInstance().addIgnoredAddress(this.socket.get().getLocalAddress());
        if (!this.selfAssignDeviceNumber()) {
            logger.warn("Unable to find an unused a device number for the Virtual recordbox, giving up.");
            DeviceFinder.getInstance().removeIgnoredAddress(this.socket.get().getLocalAddress());
            this.socket.get().close();
            this.socket.set(null);
            return false;
        }
        this.createStatusReceiver().start();
        Thread announcer = new Thread(null, () -> {
            while (this.isRunning()) {
                this.sendAnnouncements();
            }
        }, "beat-link VirtualRekordbox announcement/updates sender");
        announcer.setDaemon(true);
        announcer.start();
        DeviceFinder.getInstance().addIgnoredAddress(this.matchedAddress.getBroadcast());
        this.deliverLifecycleAnnouncement(logger, true);
        return true;
    }

    private Thread createStatusReceiver() {
        byte[] buffer = new byte[1420];
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
        Thread receiver = new Thread(null, () -> {
            while (this.isRunning()) {
                boolean received;
                try {
                    this.socket.get().receive(packet);
                    received = true;
                }
                catch (IOException e) {
                    if (this.isRunning()) {
                        logger.warn("Problem reading from DeviceStatus socket, flushing DeviceFinder due to likely network change and shutting down.", (Throwable)e);
                        DeviceFinder.getInstance().flush();
                        this.stop();
                    }
                    received = false;
                }
                try {
                    DeviceUpdate update;
                    if (!received || packet.getAddress() == this.socket.get().getLocalAddress() || (update = this.buildUpdate(packet)) == null) continue;
                    this.processUpdate(update);
                }
                catch (Throwable t) {
                    logger.warn("Problem processing device update packet", t);
                }
            }
        }, "beat-link VirtualRekordbox status receiver");
        receiver.setDaemon(true);
        receiver.setPriority(10);
        return receiver;
    }

    private void sendAnnouncements() {
        try {
            this.sendRekordboxAnnouncement();
            this.sendRekordboxLightingPacket();
            Thread.sleep(this.getAnnounceInterval());
        }
        catch (Throwable t) {
            logger.warn("Unable to send announcement packets, flushing DeviceFinder due to likely network change and shutting down.", t);
            DeviceFinder.getInstance().flush();
            this.stop();
        }
    }

    @API(status=API.Status.EXPERIMENTAL)
    synchronized boolean start() throws Exception {
        if (!this.isRunning()) {
            DeviceFinder.getInstance().addLifecycleListener(this.deviceFinderLifecycleListener);
            DeviceFinder.getInstance().start();
            for (int i = 0; DeviceFinder.getInstance().getCurrentDevices().isEmpty() && i < 20; ++i) {
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException e) {
                    logger.warn("Interrupted waiting for devices, giving up", (Throwable)e);
                    return false;
                }
            }
            if (DeviceFinder.getInstance().getCurrentDevices().isEmpty()) {
                logger.warn("No DJ Link devices found, giving up");
                return false;
            }
            return this.createVirtualRekordbox();
        }
        return true;
    }

    @API(status=API.Status.EXPERIMENTAL)
    synchronized void stop() {
        if (this.isRunning()) {
            DeviceFinder.getInstance().removeIgnoredAddress(this.socket.get().getLocalAddress());
            this.socket.get().close();
            this.socket.set(null);
            this.broadcastAddress.set(null);
            this.updates.clear();
            this.lastValidStatusFlagBytes.clear();
            this.setDeviceNumber((byte)0);
            this.deliverLifecycleAnnouncement(logger, false);
        }
    }

    @API(status=API.Status.EXPERIMENTAL)
    public DeviceUpdate getLatestStatusFor(int deviceNumber) {
        this.ensureRunning();
        for (DeviceUpdate update : this.updates.values()) {
            if (update.getDeviceNumber() != deviceNumber) continue;
            return update;
        }
        return null;
    }

    @API(status=API.Status.EXPERIMENTAL)
    public void addUpdateListener(DeviceUpdateListener listener) {
        if (listener != null) {
            this.updateListeners.add(listener);
        }
    }

    @API(status=API.Status.EXPERIMENTAL)
    public void removeUpdateListener(DeviceUpdateListener listener) {
        if (listener != null) {
            this.updateListeners.remove(listener);
        }
    }

    @API(status=API.Status.EXPERIMENTAL)
    public Set<DeviceUpdateListener> getUpdateListeners() {
        return Set.copyOf(this.updateListeners);
    }

    private void deliverDeviceUpdate(DeviceUpdate update) {
        for (DeviceUpdateListener listener : this.getUpdateListeners()) {
            try {
                listener.received(update);
            }
            catch (Throwable t) {
                logger.warn("Problem delivering device update to listener", t);
            }
        }
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static VirtualRekordbox getInstance() {
        return ourInstance;
    }

    private VirtualRekordbox() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("VirtualRekordbox[number:").append(this.getDeviceNumber()).append(", name:").append(VirtualRekordbox.getDeviceName());
        sb.append(", announceInterval:").append(this.getAnnounceInterval());
        sb.append(", active:").append(this.isRunning());
        if (this.isRunning()) {
            sb.append(", localAddress:").append(this.getLocalAddress().getHostAddress());
            sb.append(", broadcastAddress:").append(this.getBroadcastAddress().getHostAddress());
        }
        return sb.append("]").toString();
    }

    private static class PacketTracker {
        private final List<Byte> data = new ArrayList<Byte>();

        PacketTracker() {
        }

        boolean receivePacket(byte[] packetData, int packetNumber, int totalPackets) {
            for (byte b : packetData) {
                this.data.add(b);
            }
            return packetNumber == totalPackets;
        }

        void resetForNewPacketStream() {
            this.data.clear();
        }

        byte[] getDataAsBytesAndTrimTrailingZeros() {
            while (!this.data.isEmpty() && this.data.get(this.data.size() - 1) == 0) {
                this.data.remove(this.data.size() - 1);
            }
            byte[] result = new byte[this.data.size()];
            for (int i = 0; i < this.data.size(); ++i) {
                result[i] = this.data.get(i);
            }
            return result;
        }
    }
}

