/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import org.apiguardian.api.API;
import org.deepsymmetry.beatlink.data.DataReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.STABLE)
public class AlbumArt {
    private static final Logger logger = LoggerFactory.getLogger(AlbumArt.class);
    public final DataReference artReference;
    private final ByteBuffer rawBytes;

    @API(status=API.Status.STABLE)
    public ByteBuffer getRawBytes() {
        this.rawBytes.rewind();
        return this.rawBytes.slice();
    }

    @API(status=API.Status.STABLE)
    public BufferedImage getImage() {
        ByteBuffer artwork = this.getRawBytes();
        artwork.rewind();
        byte[] imageBytes = new byte[artwork.remaining()];
        artwork.get(imageBytes);
        try {
            return ImageIO.read(new ByteArrayInputStream(imageBytes));
        }
        catch (IOException e) {
            logger.error("Weird! Caught exception creating image from artwork bytes", (Throwable)e);
            return null;
        }
    }

    @API(status=API.Status.STABLE)
    public AlbumArt(DataReference artReference, File file) throws IOException {
        this.artReference = artReference;
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            byte[] bytes = new byte[(int)raf.length()];
            raf.readFully(bytes);
            this.rawBytes = ByteBuffer.wrap(bytes);
        }
    }

    @API(status=API.Status.STABLE)
    public AlbumArt(DataReference artReference, ByteBuffer rawBytes) {
        this.artReference = artReference;
        byte[] bytes = new byte[rawBytes.remaining()];
        rawBytes.get(bytes);
        this.rawBytes = ByteBuffer.wrap(bytes).asReadOnlyBuffer();
    }

    public String toString() {
        return "AlbumArt[artReference=" + this.artReference + ", size=" + this.getRawBytes().remaining() + " bytes]";
    }
}

