/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.apiguardian.api.API;
import org.deepsymmetry.beatlink.CdjStatus;
import org.deepsymmetry.beatlink.DeviceAnnouncement;
import org.deepsymmetry.beatlink.DeviceAnnouncementListener;
import org.deepsymmetry.beatlink.DeviceFinder;
import org.deepsymmetry.beatlink.DeviceUpdate;
import org.deepsymmetry.beatlink.LifecycleListener;
import org.deepsymmetry.beatlink.LifecycleParticipant;
import org.deepsymmetry.beatlink.MediaDetails;
import org.deepsymmetry.beatlink.data.BeatGrid;
import org.deepsymmetry.beatlink.data.BeatGridListener;
import org.deepsymmetry.beatlink.data.BeatGridUpdate;
import org.deepsymmetry.beatlink.data.CueList;
import org.deepsymmetry.beatlink.data.DataReference;
import org.deepsymmetry.beatlink.data.DeckReference;
import org.deepsymmetry.beatlink.data.MetadataFinder;
import org.deepsymmetry.beatlink.data.MountListener;
import org.deepsymmetry.beatlink.data.SlotReference;
import org.deepsymmetry.beatlink.data.TrackMetadata;
import org.deepsymmetry.beatlink.data.TrackMetadataListener;
import org.deepsymmetry.beatlink.data.TrackMetadataUpdate;
import org.deepsymmetry.beatlink.data.WaveformFinder;
import org.deepsymmetry.beatlink.dbserver.Client;
import org.deepsymmetry.beatlink.dbserver.ConnectionManager;
import org.deepsymmetry.beatlink.dbserver.Message;
import org.deepsymmetry.beatlink.dbserver.NumberField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.STABLE)
public class BeatGridFinder
extends LifecycleParticipant {
    private static final Logger logger = LoggerFactory.getLogger(BeatGridFinder.class);
    private final Map<DeckReference, BeatGrid> hotCache = new ConcurrentHashMap<DeckReference, BeatGrid>();
    private final LinkedBlockingDeque<TrackMetadataUpdate> pendingUpdates = new LinkedBlockingDeque(100);
    private final TrackMetadataListener metadataListener = update -> {
        logger.debug("Received metadata update {}", (Object)update);
        if (!this.pendingUpdates.offerLast(update)) {
            logger.warn("Discarding metadata update because our queue is backed up.");
        }
    };
    private final MountListener mountListener = new MountListener(){

        @Override
        public void mediaMounted(SlotReference slot) {
            logger.debug("BeatGridFinder doesn't yet need to do anything in response to a media mount.");
        }

        @Override
        public void mediaUnmounted(SlotReference slot) {
            for (Map.Entry<DeckReference, BeatGrid> entry : new HashMap<DeckReference, BeatGrid>(BeatGridFinder.this.hotCache).entrySet()) {
                if (slot != SlotReference.getSlotReference(entry.getValue().dataReference)) continue;
                logger.debug("Evicting cached beat grid in response to unmount report {}", (Object)entry.getValue());
                BeatGridFinder.this.hotCache.remove(entry.getKey());
            }
        }
    };
    private final DeviceAnnouncementListener announcementListener = new DeviceAnnouncementListener(){

        @Override
        public void deviceFound(DeviceAnnouncement announcement) {
            logger.debug("Currently nothing for BeatGridFinder to do when devices appear.");
        }

        @Override
        public void deviceLost(DeviceAnnouncement announcement) {
            if (announcement.getDeviceNumber() == 25 && announcement.getDeviceName().equals("NXS-GW")) {
                logger.debug("Ignoring noise from Kuvo gateways, especially in CDJ-3000s, which fight each other and come and go constantly.");
                return;
            }
            logger.info("Clearing beat grids in response to the loss of a device, {}", (Object)announcement);
            BeatGridFinder.this.clearBeatGrids(announcement);
        }
    };
    private final AtomicBoolean running = new AtomicBoolean(false);
    private Thread queueHandler;
    private final AtomicBoolean retrying = new AtomicBoolean(false);
    private final Set<Integer> activeRequests = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<BeatGridListener> beatGridListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final LifecycleListener lifecycleListener = new LifecycleListener(){

        @Override
        public void started(LifecycleParticipant sender) {
            logger.debug("The BeatGridFinder does not auto-start when {} does.", (Object)sender);
        }

        @Override
        public void stopped(LifecycleParticipant sender) {
            if (BeatGridFinder.this.isRunning()) {
                logger.info("BeatGridFinder stopping because {} has.", (Object)sender);
                BeatGridFinder.this.stop();
            }
        }
    };
    private static final BeatGridFinder ourInstance = new BeatGridFinder();

    @Override
    @API(status=API.Status.STABLE)
    public boolean isRunning() {
        return this.running.get();
    }

    private void clearDeck(TrackMetadataUpdate update) {
        if (this.hotCache.remove(DeckReference.getDeckReference(update.player, 0)) != null) {
            this.deliverBeatGridUpdate(update.player, null);
        }
    }

    private void clearBeatGrids(DeviceAnnouncement announcement) {
        int player = announcement.getDeviceNumber();
        for (DeckReference deck : new HashSet<DeckReference>(this.hotCache.keySet())) {
            if (deck.player != player) continue;
            this.hotCache.remove(deck);
            if (deck.hotCue != 0) continue;
            this.deliverBeatGridUpdate(player, null);
        }
    }

    private void updateBeatGrid(TrackMetadataUpdate update, BeatGrid beatGrid) {
        this.hotCache.put(DeckReference.getDeckReference(update.player, 0), beatGrid);
        if (update.metadata.getCueList() != null) {
            for (CueList.Entry entry : update.metadata.getCueList().entries) {
                if (entry.hotCueNumber == 0) continue;
                this.hotCache.put(DeckReference.getDeckReference(update.player, entry.hotCueNumber), beatGrid);
            }
        }
        this.deliverBeatGridUpdate(update.player, beatGrid);
    }

    @API(status=API.Status.STABLE)
    public Map<DeckReference, BeatGrid> getLoadedBeatGrids() {
        this.ensureRunning();
        return Map.copyOf(this.hotCache);
    }

    @API(status=API.Status.STABLE)
    public BeatGrid getLatestBeatGridFor(int player) {
        this.ensureRunning();
        return this.hotCache.get(DeckReference.getDeckReference(player, 0));
    }

    @API(status=API.Status.STABLE)
    public BeatGrid getLatestBeatGridFor(DeviceUpdate update) {
        BeatGrid result = this.getLatestBeatGridFor(update.getDeviceNumber());
        if (result != null && update instanceof CdjStatus && result.dataReference.rekordboxId != ((CdjStatus)update).getRekordboxId()) {
            return null;
        }
        return result;
    }

    private BeatGrid requestBeatGridInternal(DataReference trackReference, TrackMetadataUpdate fromUpdate) {
        BeatGrid provided;
        MediaDetails sourceDetails = MetadataFinder.getInstance().getMediaDetailsFor(trackReference.getSlotReference());
        if (sourceDetails != null && (provided = MetadataFinder.getInstance().allMetadataProviders.getBeatGrid(sourceDetails, trackReference)) != null) {
            return provided;
        }
        if (MetadataFinder.getInstance().isPassive() && fromUpdate != null && trackReference.slot != CdjStatus.TrackSourceSlot.COLLECTION) {
            return null;
        }
        ConnectionManager.ClientTask<BeatGrid> task = client -> this.getBeatGrid(trackReference.rekordboxId, SlotReference.getSlotReference(trackReference), trackReference.trackType, fromUpdate, client);
        try {
            return ConnectionManager.getInstance().invokeWithClientSession(trackReference.player, task, "requesting beat grid");
        }
        catch (Exception e) {
            logger.error("Problem requesting beat grid, returning null", (Throwable)e);
            return null;
        }
    }

    @API(status=API.Status.STABLE)
    public BeatGrid requestBeatGridFrom(DataReference track) {
        for (BeatGrid cached : this.hotCache.values()) {
            if (!cached.dataReference.equals(track)) continue;
            return cached;
        }
        return this.requestBeatGridInternal(track, null);
    }

    BeatGrid getBeatGrid(int rekordboxId, SlotReference slot, CdjStatus.TrackType trackType, TrackMetadataUpdate fromUpdate, Client client) throws IOException {
        Message response = client.simpleRequest(Message.KnownType.BEAT_GRID_REQ, null, client.buildRMST(Message.MenuIdentifier.DATA, slot.slot, trackType), new NumberField(rekordboxId));
        if (response.knownType == Message.KnownType.BEAT_GRID) {
            return new BeatGrid(new DataReference(slot, rekordboxId, trackType), response);
        }
        if (WaveformFinder.retryUnanalyzedTrack(fromUpdate, this.retrying, this.metadataListener, "beat grid")) {
            return null;
        }
        logger.error("Unexpected response type when requesting beat grid: {}", (Object)response);
        return null;
    }

    @API(status=API.Status.STABLE)
    public void addBeatGridListener(BeatGridListener listener) {
        if (listener != null) {
            this.beatGridListeners.add(listener);
        }
    }

    @API(status=API.Status.STABLE)
    public void removeBeatGridListener(BeatGridListener listener) {
        if (listener != null) {
            this.beatGridListeners.remove(listener);
        }
    }

    @API(status=API.Status.STABLE)
    public Set<BeatGridListener> getBeatGridListeners() {
        return Set.copyOf(this.beatGridListeners);
    }

    private void deliverBeatGridUpdate(int player, BeatGrid beatGrid) {
        if (!this.getBeatGridListeners().isEmpty()) {
            BeatGridUpdate update = new BeatGridUpdate(player, beatGrid);
            for (BeatGridListener listener : this.getBeatGridListeners()) {
                try {
                    listener.beatGridChanged(update);
                }
                catch (Throwable t) {
                    logger.warn("Problem delivering beat grid update to listener", t);
                }
            }
        }
    }

    private void handleUpdate(TrackMetadataUpdate update) {
        if (update.metadata == null) {
            this.clearDeck(update);
        } else {
            BeatGrid lastBeatGrid = this.hotCache.get(DeckReference.getDeckReference(update.player, 0));
            if (lastBeatGrid == null || !lastBeatGrid.dataReference.equals(update.metadata.trackReference)) {
                for (BeatGrid cached : this.hotCache.values()) {
                    if (!cached.dataReference.equals(update.metadata.trackReference)) continue;
                    this.updateBeatGrid(update, cached);
                    return;
                }
                if (this.activeRequests.add(update.player)) {
                    this.clearDeck(update);
                    new Thread(() -> {
                        try {
                            BeatGrid grid = this.requestBeatGridInternal(update.metadata.trackReference, update);
                            if (grid != null && grid.beatCount > 0) {
                                this.updateBeatGrid(update, grid);
                            } else {
                                WaveformFinder.retryUnanalyzedTrack(update, this.retrying, this.metadataListener, "beat grid");
                            }
                        }
                        catch (Exception e) {
                            logger.warn("Problem requesting beat grid from update {}", (Object)update, (Object)e);
                            WaveformFinder.retryUnanalyzedTrack(update, this.retrying, this.metadataListener, "beat grid");
                        }
                        finally {
                            this.activeRequests.remove(update.player);
                        }
                    }, "Beat Grid request").start();
                }
            }
        }
    }

    @API(status=API.Status.STABLE)
    public synchronized void start() throws Exception {
        if (!this.isRunning()) {
            ConnectionManager.getInstance().addLifecycleListener(this.lifecycleListener);
            ConnectionManager.getInstance().start();
            DeviceFinder.getInstance().addDeviceAnnouncementListener(this.announcementListener);
            MetadataFinder.getInstance().addLifecycleListener(this.lifecycleListener);
            MetadataFinder.getInstance().start();
            MetadataFinder.getInstance().addTrackMetadataListener(this.metadataListener);
            MetadataFinder.getInstance().addMountListener(this.mountListener);
            this.queueHandler = new Thread(() -> {
                while (this.isRunning()) {
                    try {
                        this.handleUpdate(this.pendingUpdates.take());
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Throwable t) {
                        logger.error("Problem processing metadata update", t);
                    }
                }
            });
            this.running.set(true);
            this.queueHandler.start();
            this.deliverLifecycleAnnouncement(logger, true);
            SwingUtilities.invokeLater(() -> {
                for (Map.Entry<DeckReference, TrackMetadata> entry : MetadataFinder.getInstance().getLoadedTracks().entrySet()) {
                    if (entry.getKey().hotCue != 0) continue;
                    this.handleUpdate(new TrackMetadataUpdate(entry.getKey().player, entry.getValue()));
                }
            });
        }
    }

    @API(status=API.Status.STABLE)
    public synchronized void stop() {
        if (this.isRunning()) {
            MetadataFinder.getInstance().removeTrackMetadataListener(this.metadataListener);
            this.running.set(false);
            this.pendingUpdates.clear();
            this.queueHandler.interrupt();
            this.queueHandler = null;
            HashSet<DeckReference> dyingCache = new HashSet<DeckReference>(this.hotCache.keySet());
            SwingUtilities.invokeLater(() -> {
                for (DeckReference deck : dyingCache) {
                    if (deck.hotCue != 0) continue;
                    this.deliverBeatGridUpdate(deck.player, null);
                }
            });
            this.hotCache.clear();
            this.deliverLifecycleAnnouncement(logger, false);
        }
    }

    @API(status=API.Status.STABLE)
    public static BeatGridFinder getInstance() {
        return ourInstance;
    }

    private BeatGridFinder() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BeatGridFinder[running:").append(this.isRunning()).append(", passive:");
        sb.append(MetadataFinder.getInstance().isPassive());
        if (this.isRunning()) {
            sb.append(", loadedBeatGrids:").append(this.getLoadedBeatGrids());
        }
        return sb.append("]").toString();
    }
}

