/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apiguardian.api.API;
import org.deepsymmetry.beatlink.CdjStatus;
import org.deepsymmetry.beatlink.DeviceAnnouncement;
import org.deepsymmetry.beatlink.DeviceAnnouncementAdapter;
import org.deepsymmetry.beatlink.DeviceFinder;
import org.deepsymmetry.beatlink.LifecycleListener;
import org.deepsymmetry.beatlink.LifecycleParticipant;
import org.deepsymmetry.beatlink.MediaDetails;
import org.deepsymmetry.beatlink.MediaDetailsListener;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.VirtualCdj;
import org.deepsymmetry.beatlink.VirtualRekordbox;
import org.deepsymmetry.beatlink.data.AlbumArt;
import org.deepsymmetry.beatlink.data.ArtFinder;
import org.deepsymmetry.beatlink.data.BeatGrid;
import org.deepsymmetry.beatlink.data.CueList;
import org.deepsymmetry.beatlink.data.DataReference;
import org.deepsymmetry.beatlink.data.DatabaseListener;
import org.deepsymmetry.beatlink.data.MetadataFinder;
import org.deepsymmetry.beatlink.data.MetadataProvider;
import org.deepsymmetry.beatlink.data.MountListener;
import org.deepsymmetry.beatlink.data.SlotReference;
import org.deepsymmetry.beatlink.data.TrackMetadata;
import org.deepsymmetry.beatlink.data.WaveformDetail;
import org.deepsymmetry.beatlink.data.WaveformFinder;
import org.deepsymmetry.beatlink.data.WaveformPreview;
import org.deepsymmetry.cratedigger.Database;
import org.deepsymmetry.cratedigger.FileFetcher;
import org.deepsymmetry.cratedigger.pdb.RekordboxAnlz;
import org.deepsymmetry.cratedigger.pdb.RekordboxPdb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.STABLE)
public class CrateDigger {
    private final Logger logger = LoggerFactory.getLogger(CrateDigger.class);
    private final AtomicInteger retryLimit = new AtomicInteger(3);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final Set<SlotReference> mediaWithHiddenPioneerFolder = new HashSet<SlotReference>();
    private final Map<Integer, DeviceAnnouncement> addressBackup = new ConcurrentHashMap<Integer, DeviceAnnouncement>();
    private final Set<SlotReference> activeRequests = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<SlotReference, Database> databases = new ConcurrentHashMap<SlotReference, Database>();
    private static final long RETRY_BACKOFF = 2000L;
    private static final long MAX_RETRY_INTERVAL = 6000L;
    private final MediaDetailsListener mediaDetailsListener = new MediaDetailsListener(){

        @Override
        public void detailsAvailable(MediaDetails details) {
            if (CrateDigger.this.isRunning() && details.mediaType == CdjStatus.TrackType.REKORDBOX && !VirtualRekordbox.getInstance().isRunning() && details.slotReference.slot != CdjStatus.TrackSourceSlot.COLLECTION && !CrateDigger.this.databases.containsKey(details.slotReference) && CrateDigger.this.activeRequests.add(details.slotReference)) {
                new Thread(() -> {
                    File file = null;
                    try {
                        file = new File(CrateDigger.this.downloadDirectory, CrateDigger.this.slotPrefix(details.slotReference) + "export.pdb");
                        CrateDigger.this.logger.info("Fetching rekordbox export.pdb from player {}, slot {}", (Object)details.slotReference.player, (Object)details.slotReference.slot);
                        long started = System.nanoTime();
                        CrateDigger.this.fetchFile(details.slotReference, "PIONEER/rekordbox/export.pdb", file);
                        long duration = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - started);
                        CrateDigger.this.logger.info("Finished fetching export.pdb from player {}, slot {}; received {} in {}ms, {}/s.", new Object[]{details.slotReference.player, details.slotReference.slot, CrateDigger.humanReadableByteCount(file.length(), true), duration, CrateDigger.humanReadableByteCount(file.length() * 1000L / duration, true)});
                        started = System.nanoTime();
                        Database database = new Database(file);
                        duration = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - started);
                        CrateDigger.this.logger.info("Parsing database took {}ms, {} tracks/s", (Object)duration, (Object)((long)database.trackIndex.size() * 1000L / duration));
                        CrateDigger.this.databases.put(details.slotReference, database);
                        CrateDigger.this.deliverDatabaseUpdate(details.slotReference, database, true);
                    }
                    catch (Throwable t) {
                        CrateDigger.this.logger.error("Problem fetching rekordbox database for media {}, will not offer metadata for it.", (Object)details, (Object)t);
                        if (file != null) {
                            file.delete();
                        }
                    }
                    finally {
                        CrateDigger.this.activeRequests.remove(details.slotReference);
                    }
                }).start();
            }
        }
    };
    private final MetadataProvider metadataProvider = new MetadataProvider(){

        @Override
        public List<MediaDetails> supportedMedia() {
            return null;
        }

        @Override
        public TrackMetadata getTrackMetadata(MediaDetails sourceMedia, DataReference track) {
            Database database = CrateDigger.this.findDatabase(track);
            if (database != null) {
                try {
                    return new TrackMetadata(track, database, this.getCueList(sourceMedia, track));
                }
                catch (Exception e) {
                    CrateDigger.this.logger.error("Problem fetching metadata for track {} from database {}", new Object[]{track, database, e});
                }
            }
            return null;
        }

        @Override
        public AlbumArt getAlbumArt(MediaDetails sourceMedia, DataReference art) {
            block10: {
                File file = null;
                Database database = CrateDigger.this.findDatabase(art);
                if (database != null) {
                    try {
                        RekordboxPdb.ArtworkRow artworkRow = (RekordboxPdb.ArtworkRow)database.artworkIndex.get(art.rekordboxId);
                        if (artworkRow != null) {
                            file = new File(CrateDigger.this.downloadDirectory, CrateDigger.this.slotPrefix(art.getSlotReference()) + "art-" + art.rekordboxId + ".jpg");
                            if (file.canRead()) {
                                return new AlbumArt(art, file);
                            }
                            file.deleteOnExit();
                            if (ArtFinder.getInstance().getRequestHighResolutionArt()) {
                                try {
                                    CrateDigger.this.fetchFile(art.getSlotReference(), Util.highResolutionPath(Database.getText((RekordboxPdb.DeviceSqlString)artworkRow.path())), file, 1);
                                }
                                catch (IOException e) {
                                    if (!(e instanceof FileNotFoundException)) {
                                        CrateDigger.this.logger.error("Unexpected exception type trying to load high resolution album art", (Throwable)e);
                                    }
                                    CrateDigger.this.fetchFile(art.getSlotReference(), Database.getText((RekordboxPdb.DeviceSqlString)artworkRow.path()), file);
                                }
                            } else {
                                CrateDigger.this.fetchFile(art.getSlotReference(), Database.getText((RekordboxPdb.DeviceSqlString)artworkRow.path()), file);
                            }
                            return new AlbumArt(art, file);
                        }
                        CrateDigger.this.logger.warn("Unable to find artwork {} in database {}", (Object)art, (Object)database);
                    }
                    catch (Exception e) {
                        CrateDigger.this.logger.warn("Problem fetching artwork {} from database {}", new Object[]{art, database, e});
                        if (file == null) break block10;
                        file.delete();
                    }
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BeatGrid getBeatGrid(MediaDetails sourceMedia, DataReference track) {
            block6: {
                Database database = CrateDigger.this.findDatabase(track);
                if (database != null) {
                    BeatGrid beatGrid;
                    RekordboxAnlz file = CrateDigger.this.findTrackAnalysis(track, database);
                    if (file == null) break block6;
                    try {
                        beatGrid = new BeatGrid(track, file);
                    }
                    catch (Throwable throwable) {
                        try {
                            file._io().close();
                            throw throwable;
                        }
                        catch (Exception e) {
                            CrateDigger.this.logger.error("Problem fetching beat grid for track {} from database {}", new Object[]{track, database, e});
                        }
                    }
                    file._io().close();
                    return beatGrid;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CueList getCueList(MediaDetails sourceMedia, DataReference track) {
            block7: {
                Database database = CrateDigger.this.findDatabase(track);
                if (database != null) {
                    CueList cueList;
                    RekordboxAnlz file = CrateDigger.this.findExtendedAnalysis(track, database);
                    if (file == null) {
                        file = CrateDigger.this.findTrackAnalysis(track, database);
                    }
                    if (file == null) break block7;
                    try {
                        cueList = new CueList(file);
                    }
                    catch (Throwable throwable) {
                        try {
                            file._io().close();
                            throw throwable;
                        }
                        catch (Exception e) {
                            CrateDigger.this.logger.error("Problem fetching cue list for track {} from database {}", new Object[]{track, database, e});
                        }
                    }
                    file._io().close();
                    return cueList;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public WaveformPreview getWaveformPreview(MediaDetails sourceMedia, DataReference track) {
            block22: {
                Database database = CrateDigger.this.findDatabase(track);
                if (database != null) {
                    WaveformPreview waveformPreview;
                    RekordboxAnlz file;
                    block21: {
                        block20: {
                            if (WaveformFinder.getInstance().getPreferredStyle() == WaveformFinder.WaveformStyle.THREE_BAND) {
                                WaveformPreview waveformPreview2;
                                file = CrateDigger.this.findTrackAnalysis(track, database, ".2EX");
                                if (file == null) break block20;
                                try {
                                    waveformPreview2 = new WaveformPreview(track, file, WaveformFinder.WaveformStyle.THREE_BAND);
                                }
                                catch (Throwable throwable) {
                                    try {
                                        file._io().close();
                                        throw throwable;
                                    }
                                    catch (IllegalStateException e) {
                                        CrateDigger.this.logger.info("No 3-band preview waveform found, falling back to color or blue version.");
                                        break block20;
                                    }
                                    catch (Exception e) {
                                        CrateDigger.this.logger.error("Problem fetching 3-band waveform preview for track {} from database {}", new Object[]{track, database, e});
                                    }
                                }
                                file._io().close();
                                return waveformPreview2;
                            }
                        }
                        if (WaveformFinder.getInstance().getPreferredStyle() == WaveformFinder.WaveformStyle.RGB) {
                            WaveformPreview waveformPreview3;
                            file = CrateDigger.this.findExtendedAnalysis(track, database);
                            if (file == null) break block21;
                            try {
                                waveformPreview3 = new WaveformPreview(track, file, WaveformFinder.WaveformStyle.RGB);
                            }
                            catch (Throwable throwable) {
                                try {
                                    file._io().close();
                                    throw throwable;
                                }
                                catch (IllegalStateException e) {
                                    CrateDigger.this.logger.info("No color preview waveform found, checking for blue version.");
                                    break block21;
                                }
                                catch (Exception e) {
                                    CrateDigger.this.logger.error("Problem fetching color waveform preview for track {} from database {}", new Object[]{track, database, e});
                                }
                            }
                            file._io().close();
                            return waveformPreview3;
                        }
                    }
                    file = CrateDigger.this.findTrackAnalysis(track, database);
                    if (file == null) break block22;
                    try {
                        waveformPreview = new WaveformPreview(track, file, WaveformFinder.WaveformStyle.BLUE);
                    }
                    catch (Throwable throwable) {
                        try {
                            file._io().close();
                            throw throwable;
                        }
                        catch (Exception e) {
                            CrateDigger.this.logger.error("Problem fetching waveform preview for track {} from database {}", new Object[]{track, database, e});
                        }
                    }
                    file._io().close();
                    return waveformPreview;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public WaveformDetail getWaveformDetail(MediaDetails sourceMedia, DataReference track) {
            block14: {
                Database database = CrateDigger.this.findDatabase(track);
                if (database != null) {
                    WaveformDetail waveformDetail;
                    RekordboxAnlz file;
                    block13: {
                        if (WaveformFinder.getInstance().getPreferredStyle() == WaveformFinder.WaveformStyle.THREE_BAND) {
                            WaveformDetail waveformDetail2;
                            file = CrateDigger.this.findTrackAnalysis(track, database, ".2EX");
                            if (file == null) break block13;
                            try {
                                waveformDetail2 = new WaveformDetail(track, file, WaveformFinder.WaveformStyle.THREE_BAND);
                            }
                            catch (Throwable throwable) {
                                try {
                                    file._io().close();
                                    throw throwable;
                                }
                                catch (IllegalStateException e) {
                                    CrateDigger.this.logger.info("No 3-band detail waveform found, falling back to color or blue version.");
                                    break block13;
                                }
                                catch (Exception e) {
                                    CrateDigger.this.logger.error("Problem fetching waveform detail for track {} from database {}", new Object[]{track, database, e});
                                }
                            }
                            file._io().close();
                            return waveformDetail2;
                        }
                    }
                    file = CrateDigger.this.findExtendedAnalysis(track, database);
                    if (file == null) break block14;
                    try {
                        waveformDetail = new WaveformDetail(track, file, WaveformFinder.WaveformStyle.RGB);
                    }
                    catch (Throwable throwable) {
                        try {
                            file._io().close();
                            throw throwable;
                        }
                        catch (Exception e) {
                            CrateDigger.this.logger.error("Problem fetching waveform preview for track {} from database {}", new Object[]{track, database, e});
                        }
                    }
                    file._io().close();
                    return waveformDetail;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public RekordboxAnlz.TaggedSection getAnalysisSection(MediaDetails sourceMedia, DataReference track, String fileExtension, String typeTag) {
            Database database = CrateDigger.this.findDatabase(track);
            if (database == null) return null;
            try {
                if (typeTag.length() > 4) {
                    throw new IllegalArgumentException("typeTag cannot be longer than four characters");
                }
                int fourcc = 0;
                for (int i = 0; i < 4; ++i) {
                    fourcc *= 256;
                    if (i >= typeTag.length()) continue;
                    fourcc += typeTag.charAt(i);
                }
                RekordboxAnlz file = CrateDigger.this.findTrackAnalysis(track, database, fileExtension);
                if (file == null) return null;
                try {
                    RekordboxAnlz.TaggedSection section;
                    Iterator iterator = file.sections().iterator();
                    do {
                        if (!iterator.hasNext()) return null;
                    } while ((section = (RekordboxAnlz.TaggedSection)iterator.next()).fourcc() != RekordboxAnlz.SectionTags.byId((long)fourcc));
                    RekordboxAnlz.TaggedSection taggedSection = section;
                    return taggedSection;
                }
                finally {
                    file._io().close();
                }
            }
            catch (Exception e) {
                CrateDigger.this.logger.error("Problem fetching analysis file {} section {} for track {} from database {}", new Object[]{fileExtension, typeTag, track, database, e});
            }
            return null;
        }
    };
    private static final CrateDigger instance = new CrateDigger();
    @API(status=API.Status.STABLE)
    public final File downloadDirectory;
    private static final int TEMP_DIR_ATTEMPTS = 1000;
    private final Set<DatabaseListener> dbListeners = Collections.newSetFromMap(new ConcurrentHashMap());

    @API(status=API.Status.STABLE)
    public int getRetryLimit() {
        return this.retryLimit.get();
    }

    @API(status=API.Status.STABLE)
    public void setRetryLimit(int limit) {
        if (limit < 1 || limit > 10) {
            throw new IllegalArgumentException("limit must be between 1 and 10");
        }
        this.retryLimit.set(limit);
    }

    @API(status=API.Status.STABLE)
    public boolean isRunning() {
        return this.running.get();
    }

    private String mountPath(CdjStatus.TrackSourceSlot slot) {
        switch (slot) {
            case SD_SLOT: {
                return "/B/";
            }
            case USB_SLOT: {
                return "/C/";
            }
        }
        throw new IllegalArgumentException("Don't know how to NFS mount filesystem for slot " + slot);
    }

    private void fetchFile(SlotReference slot, String path, File destination) throws IOException {
        this.fetchFile(slot, path, destination, this.getRetryLimit());
    }

    private void fetchFile(SlotReference slot, String path, File destination, int retryLimit) throws IOException {
        DeviceAnnouncement player = DeviceFinder.getInstance().getLatestAnnouncementFrom(slot.player);
        if (player == null) {
            throw new IOException("Cannot fetch file from player that is not found on the network; slot: " + slot);
        }
        int triesMade = 0;
        if (((String)path).startsWith("PIONEER/") && this.mediaWithHiddenPioneerFolder.contains(slot)) {
            path = "." + (String)path;
        }
        while (triesMade < retryLimit) {
            try {
                FileFetcher.getInstance().fetch(player.getAddress(), this.mountPath(slot.slot), (String)path, destination);
                destination.deleteOnExit();
                return;
            }
            catch (IOException e) {
                if (((String)path).startsWith("PIONEER/") && e.getMessage().contains("lookup of element \"PIONEER\" returned status")) {
                    this.mediaWithHiddenPioneerFolder.add(slot);
                    this.fetchFile(slot, "." + (String)path, destination);
                    return;
                }
                if (++triesMade < retryLimit) {
                    this.logger.warn("Attempt to fetch file {} from {} to {} failed, tries left: {}", new Object[]{path, slot, destination, retryLimit - triesMade, e});
                    try {
                        Thread.sleep(Math.min(6000L, (long)triesMade * 2000L));
                    }
                    catch (InterruptedException ie) {
                        this.logger.warn("Interrupted while sleeping between file fetch attempts. Retrying immediately.");
                    }
                    continue;
                }
                throw e;
            }
        }
    }

    private String slotPrefix(SlotReference slotReference) {
        return "player-" + slotReference.player + "-slot-" + slotReference.slot.protocolValue + "-";
    }

    @API(status=API.Status.STABLE)
    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    @API(status=API.Status.STABLE)
    public Database findDatabase(DataReference reference) {
        if (reference.trackType == CdjStatus.TrackType.REKORDBOX) {
            return this.databases.get(reference.getSlotReference());
        }
        return null;
    }

    @API(status=API.Status.STABLE)
    public Database findDatabase(SlotReference slot) {
        return this.databases.get(slot);
    }

    private RekordboxAnlz findTrackAnalysis(DataReference track, Database database) {
        return this.findTrackAnalysis(track, database, ".DAT");
    }

    private RekordboxAnlz findExtendedAnalysis(DataReference track, Database database) {
        return this.findTrackAnalysis(track, database, ".EXT");
    }

    private File trackAnalyisFile(DataReference track, Database database, String extension) {
        RekordboxPdb.TrackRow trackRow = (RekordboxPdb.TrackRow)database.trackIndex.get(track.rekordboxId);
        if (trackRow != null) {
            return new File(this.downloadDirectory, this.slotPrefix(track.getSlotReference()) + "track-" + track.rekordboxId + "-anlz" + extension.toLowerCase());
        }
        this.logger.warn("Unable to find track {} in database {}", (Object)track, (Object)database);
        return null;
    }

    /*
     * Exception decompiling
     */
    private RekordboxAnlz findTrackAnalysis(DataReference track, Database database, String extension) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @API(status=API.Status.EXPERIMENTAL)
    public void logTrackAnalysis(DataReference track, String extension, String reason, File logDir) throws IOException {
        Database database = this.findDatabase(track);
        if (database == null) {
            throw new IllegalArgumentException("No parsed database found for track " + track);
        }
        File analysis = this.trackAnalyisFile(track, database, extension);
        if (analysis == null || !analysis.canRead()) {
            throw new IllegalArgumentException("No analysis file exists for track " + track);
        }
        this.logger.info("Copying {} to analysis problem log directory because {}.", (Object)analysis.getName(), (Object)reason);
        Files.copy(analysis.toPath(), logDir.toPath().resolve(analysis.getName()), StandardCopyOption.REPLACE_EXISTING);
    }

    @API(status=API.Status.STABLE)
    public synchronized void start() throws Exception {
        if (!this.isRunning()) {
            MetadataFinder.getInstance().start();
            this.running.set(true);
            for (MediaDetails details : MetadataFinder.getInstance().getMountedMediaDetails()) {
                this.mediaDetailsListener.detailsAvailable(details);
            }
            MetadataFinder.getInstance().addMetadataProvider(this.metadataProvider);
        }
    }

    @API(status=API.Status.STABLE)
    public synchronized void stop() {
        if (this.isRunning()) {
            this.running.set(false);
            MetadataFinder.getInstance().removeMetadataProvider(this.metadataProvider);
            for (Database database : this.databases.values()) {
                database.sourceFile.delete();
            }
            this.databases.clear();
        }
    }

    @API(status=API.Status.STABLE)
    public static CrateDigger getInstance() {
        return instance;
    }

    static File createDownloadDirectory() {
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        String baseName = "bl-" + System.currentTimeMillis() + "-";
        for (int counter = 0; counter < 1000; ++counter) {
            File tempDir = new File(baseDir, baseName + counter);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IllegalStateException("Failed to create download directory within 1000 attempts.");
    }

    @API(status=API.Status.STABLE)
    public void addDatabaseListener(DatabaseListener listener) {
        if (listener != null) {
            this.dbListeners.add(listener);
        }
    }

    @API(status=API.Status.STABLE)
    public void removeDatabaseListener(DatabaseListener listener) {
        if (listener != null) {
            this.dbListeners.remove(listener);
        }
    }

    @API(status=API.Status.STABLE)
    public Set<DatabaseListener> getDatabaseListeners() {
        return Set.copyOf(this.dbListeners);
    }

    private void deliverDatabaseUpdate(SlotReference slot, Database database, boolean available) {
        for (DatabaseListener listener : this.getDatabaseListeners()) {
            try {
                if (available) {
                    listener.databaseMounted(slot, database);
                    continue;
                }
                listener.databaseUnmounted(slot, database);
            }
            catch (Throwable t) {
                this.logger.warn("Problem delivering rekordbox database availability update to listener", t);
            }
        }
    }

    private CrateDigger() {
        LifecycleListener lifecycleListener = new LifecycleListener(){

            @Override
            public void started(LifecycleParticipant sender) {
                new Thread(() -> {
                    try {
                        CrateDigger.this.logger.info("CrateDigger starting because {} has.", (Object)sender);
                        CrateDigger.this.start();
                    }
                    catch (Throwable t) {
                        CrateDigger.this.logger.error("Problem starting the CrateDigger in response to a lifecycle event.", t);
                    }
                }).start();
            }

            @Override
            public void stopped(LifecycleParticipant sender) {
                if (CrateDigger.this.isRunning()) {
                    CrateDigger.this.logger.info("CrateDigger stopping because {} has.", (Object)sender);
                    CrateDigger.this.stop();
                }
            }
        };
        MetadataFinder.getInstance().addLifecycleListener(lifecycleListener);
        MountListener mountListener = new MountListener(){

            @Override
            public void mediaMounted(SlotReference slot) {
                DeviceAnnouncement player = DeviceFinder.getInstance().getLatestAnnouncementFrom(slot.player);
                CrateDigger.this.addressBackup.put(slot.player, player);
                CrateDigger.this.logger.debug("Media mounted, waiting for details.");
            }

            @Override
            public void mediaUnmounted(SlotReference slot) {
                CrateDigger.this.mediaWithHiddenPioneerFolder.remove(slot);
                DeviceAnnouncement player = DeviceFinder.getInstance().getLatestAnnouncementFrom(slot.player);
                if (player == null) {
                    CrateDigger.this.logger.info("Received an unmount for a player we can't find, it must have left network.");
                    player = CrateDigger.this.addressBackup.get(slot.player);
                }
                if (player != null) {
                    FileFetcher.getInstance().removePlayer(player.getAddress());
                } else {
                    CrateDigger.this.logger.warn("Unable to clear FileFetcher connections for player that we can't find backup address for!");
                }
                Database database = CrateDigger.this.databases.remove(slot);
                if (database != null) {
                    CrateDigger.this.deliverDatabaseUpdate(slot, database, false);
                    try {
                        database.close();
                    }
                    catch (IOException e) {
                        CrateDigger.this.logger.error("Problem closing parsed rekordbox database export.", (Throwable)e);
                    }
                    database.sourceFile.delete();
                }
                String prefix = CrateDigger.this.slotPrefix(slot);
                File[] files = CrateDigger.this.downloadDirectory.listFiles();
                if (files != null) {
                    for (File file : files) {
                        if (!file.getName().startsWith(prefix)) continue;
                        file.delete();
                    }
                }
            }
        };
        MetadataFinder.getInstance().addMountListener(mountListener);
        DeviceAnnouncementAdapter deviceListener = new DeviceAnnouncementAdapter(){

            @Override
            public void deviceLost(DeviceAnnouncement announcement) {
                FileFetcher.getInstance().removePlayer(announcement.getAddress());
            }
        };
        DeviceFinder.getInstance().addDeviceAnnouncementListener(deviceListener);
        VirtualCdj.getInstance().addMediaDetailsListener(this.mediaDetailsListener);
        this.downloadDirectory = CrateDigger.createDownloadDirectory();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CrateDigger[").append("running: ").append(this.isRunning());
        if (this.isRunning()) {
            sb.append(", databases mounted: ").append(this.databases.size());
            sb.append(", download directory: ").append(this.downloadDirectory.getAbsolutePath());
            sb.append(", media using hidden PIONEER folder: ").append(this.mediaWithHiddenPioneerFolder);
        }
        return sb.append("]").toString();
    }
}

