/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import org.apiguardian.api.API;
import org.deepsymmetry.beatlink.CdjStatus;
import org.deepsymmetry.beatlink.data.SlotReference;

@API(status=API.Status.STABLE)
public class DataReference {
    @API(status=API.Status.STABLE)
    public final int player;
    @API(status=API.Status.STABLE)
    public final CdjStatus.TrackSourceSlot slot;
    @API(status=API.Status.STABLE)
    public final int rekordboxId;
    public final CdjStatus.TrackType trackType;
    @API(status=API.Status.STABLE)
    private final int hash;

    @API(status=API.Status.DEPRECATED)
    public DataReference(int player, CdjStatus.TrackSourceSlot slot, int rekordboxId) {
        this(player, slot, rekordboxId, CdjStatus.TrackType.REKORDBOX);
    }

    @API(status=API.Status.STABLE)
    public DataReference(int player, CdjStatus.TrackSourceSlot slot, int rekordboxId, CdjStatus.TrackType trackType) {
        this.player = player;
        this.slot = slot;
        this.rekordboxId = rekordboxId;
        this.trackType = trackType;
        int scratch = 7;
        scratch = scratch * 31 + player;
        scratch = scratch * 31 + slot.hashCode();
        scratch = scratch * 31 + rekordboxId;
        this.hash = scratch * 31 + trackType.hashCode();
    }

    @API(status=API.Status.DEPRECATED)
    public DataReference(SlotReference slot, int rekordboxId) {
        this(slot.player, slot.slot, rekordboxId, CdjStatus.TrackType.REKORDBOX);
    }

    @API(status=API.Status.STABLE)
    public DataReference(SlotReference slot, int rekordboxId, CdjStatus.TrackType trackType) {
        this(slot.player, slot.slot, rekordboxId, trackType);
    }

    @API(status=API.Status.STABLE)
    public SlotReference getSlotReference() {
        return SlotReference.getSlotReference(this);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DataReference) {
            DataReference other = (DataReference)obj;
            return other.player == this.player && other.slot == this.slot && other.rekordboxId == this.rekordboxId && other.trackType == this.trackType;
        }
        return false;
    }

    public String toString() {
        return "DataReference[player:" + this.player + ", slot:" + this.slot + ", rekordboxId:" + this.rekordboxId + ", trackType:" + this.trackType + "]";
    }
}

