/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apiguardian.api.API;
import org.deepsymmetry.beatlink.CdjStatus;
import org.deepsymmetry.beatlink.MediaDetails;
import org.deepsymmetry.beatlink.data.MetadataFinder;
import org.deepsymmetry.beatlink.data.SlotReference;
import org.deepsymmetry.beatlink.dbserver.Client;
import org.deepsymmetry.beatlink.dbserver.ConnectionManager;
import org.deepsymmetry.beatlink.dbserver.Message;
import org.deepsymmetry.beatlink.dbserver.NumberField;
import org.deepsymmetry.beatlink.dbserver.StringField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.STABLE)
public class MenuLoader {
    private static final Logger logger = LoggerFactory.getLogger(MenuLoader.class);
    private static final MenuLoader ourInstance = new MenuLoader();

    @API(status=API.Status.STABLE)
    public List<Message> requestRootMenuFrom(SlotReference slotReference, int sortOrder) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    MediaDetails details = MetadataFinder.getInstance().getMediaDetailsFor(slotReference);
                    CdjStatus.TrackType mediaType = details == null ? CdjStatus.TrackType.REKORDBOX : details.mediaType;
                    Message response = client.menuRequestTyped(Message.KnownType.ROOT_MENU_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, mediaType, new NumberField(sortOrder), new NumberField(0xFFFFFFL));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, mediaType, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting root menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestPlaylistMenuFrom(SlotReference slotReference, int sortOrder) throws Exception {
        return MetadataFinder.getInstance().requestPlaylistItemsFrom(slotReference.player, slotReference.slot, sortOrder, 0, true);
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestHistoryMenuFrom(SlotReference slotReference, int sortOrder) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting History menu.");
                    Message response = client.menuRequest(Message.KnownType.HISTORY_MENU_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting history menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestHistoryPlaylistFrom(SlotReference slotReference, int sortOrder, int historyId) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting History playlist.");
                    Message response = client.menuRequest(Message.KnownType.TRACK_MENU_FOR_HISTORY_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(historyId));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting history playlist");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestTrackMenuFrom(SlotReference slotReference, int sortOrder) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> MetadataFinder.getInstance().getFullTrackList(slotReference.slot, client, sortOrder);
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting track menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestArtistMenuFrom(SlotReference slotReference, int sortOrder) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting Artist menu.");
                    Message response = client.menuRequest(Message.KnownType.ARTIST_MENU_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting artist menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestArtistAlbumMenuFrom(SlotReference slotReference, int sortOrder, int artistId) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting Artist Album menu.");
                    Message response = client.menuRequest(Message.KnownType.ALBUM_MENU_FOR_ARTIST_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(artistId));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting artist album menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestArtistAlbumTrackMenuFrom(SlotReference slotReference, int sortOrder, int artistId, int albumId) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting Artist Album Track menu.");
                    Message response = client.menuRequest(Message.KnownType.TRACK_MENU_FOR_ARTIST_AND_ALBUM, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(artistId), new NumberField(albumId));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting artist album tracks menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestOriginalArtistMenuFrom(SlotReference slotReference, int sortOrder) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting Original Artist menu.");
                    Message response = client.menuRequest(Message.KnownType.ORIGINAL_ARTIST_MENU_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting artist menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestOriginalArtistAlbumMenuFrom(SlotReference slotReference, int sortOrder, int artistId) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting Original Artist Album menu.");
                    Message response = client.menuRequest(Message.KnownType.ALBUM_MENU_FOR_ORIGINAL_ARTIST_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(artistId));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting artist album menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestOriginalArtistAlbumTrackMenuFrom(SlotReference slotReference, int sortOrder, int artistId, int albumId) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting Original Artist Album Track menu.");
                    Message response = client.menuRequest(Message.KnownType.TRACK_MENU_FOR_ORIGINAL_ARTIST_AND_ALBUM, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(artistId), new NumberField(albumId));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting artist album tracks menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestRemixerMenuFrom(SlotReference slotReference, int sortOrder) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting Remixer menu.");
                    Message response = client.menuRequest(Message.KnownType.REMIXER_MENU_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting artist menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestRemixerAlbumMenuFrom(SlotReference slotReference, int sortOrder, int artistId) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting Remixer Album menu.");
                    Message response = client.menuRequest(Message.KnownType.ALBUM_MENU_FOR_REMIXER_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(artistId));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting artist album menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestRemixerAlbumTrackMenuFrom(SlotReference slotReference, int sortOrder, int artistId, int albumId) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting Remixer Album Track menu.");
                    Message response = client.menuRequest(Message.KnownType.TRACK_MENU_FOR_REMIXER_AND_ALBUM, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(artistId), new NumberField(albumId));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting artist album tracks menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestAlbumTrackMenuFrom(SlotReference slotReference, int sortOrder, int albumId) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting Album Track menu.");
                    Message response = client.menuRequest(Message.KnownType.TRACK_MENU_FOR_ALBUM_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(albumId));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting album tracks menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestGenreMenuFrom(SlotReference slotReference, int sortOrder) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting Genre menu.");
                    Message response = client.menuRequest(Message.KnownType.GENRE_MENU_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting genre menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestGenreArtistMenuFrom(SlotReference slotReference, int sortOrder, int genreId) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting Genre Artist menu.");
                    Message response = client.menuRequest(Message.KnownType.ARTIST_MENU_FOR_GENRE_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(genreId));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting genre artists menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestGenreArtistAlbumMenuFrom(SlotReference slotReference, int sortOrder, int genreId, int artistId) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting Genre Artist Album menu.");
                    Message response = client.menuRequest(Message.KnownType.ALBUM_MENU_FOR_GENRE_AND_ARTIST, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(genreId), new NumberField(artistId));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting genre artist albums menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestGenreArtistAlbumTrackMenuFrom(SlotReference slotReference, int sortOrder, int genreId, int artistId, int albumId) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting Genre Artist Album Track menu.");
                    Message response = client.menuRequest(Message.KnownType.TRACK_MENU_FOR_GENRE_ARTIST_AND_ALBUM, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(genreId), new NumberField(artistId), new NumberField(albumId));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting genre artist album tracks menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestLabelMenuFrom(SlotReference slotReference, int sortOrder) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting Label menu.");
                    Message response = client.menuRequest(Message.KnownType.LABEL_MENU_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting genre menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestLabelArtistMenuFrom(SlotReference slotReference, int sortOrder, int labelId) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting Label Artist menu.");
                    Message response = client.menuRequest(Message.KnownType.ARTIST_MENU_FOR_LABEL_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(labelId));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting genre artists menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestLabelArtistAlbumMenuFrom(SlotReference slotReference, int sortOrder, int labelId, int artistId) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting Label Artist Album menu.");
                    Message response = client.menuRequest(Message.KnownType.ALBUM_MENU_FOR_LABEL_AND_ARTIST, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(labelId), new NumberField(artistId));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting genre artist albums menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestLabelArtistAlbumTrackMenuFrom(SlotReference slotReference, int sortOrder, int labelId, int artistId, int albumId) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting Label Artist Album Track menu.");
                    Message response = client.menuRequest(Message.KnownType.TRACK_MENU_FOR_LABEL_ARTIST_AND_ALBUM, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(labelId), new NumberField(artistId), new NumberField(albumId));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting genre artist album tracks menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestAlbumMenuFrom(SlotReference slotReference, int sortOrder) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting Album menu.");
                    Message response = client.menuRequest(Message.KnownType.ALBUM_MENU_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting album menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestKeyMenuFrom(SlotReference slotReference, int sortOrder) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting Key menu.");
                    Message response = client.menuRequest(Message.KnownType.KEY_MENU_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting key menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestKeyNeighborMenuFrom(SlotReference slotReference, int sortOrder, int keyId) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting key neighbor menu.");
                    Message response = client.menuRequest(Message.KnownType.NEIGHBOR_MENU_FOR_KEY, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(keyId));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting key neighbor menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestTracksByKeyAndDistanceFrom(SlotReference slotReference, int sortOrder, int keyId, int distance) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting tracks by key and distance menu.");
                    Message response = client.menuRequest(Message.KnownType.TRACK_MENU_FOR_KEY_AND_DISTANCE, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(keyId), new NumberField(distance));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting tracks by key and distance menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestBpmMenuFrom(SlotReference slotReference, int sortOrder) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting BPM menu.");
                    Message response = client.menuRequest(Message.KnownType.BPM_MENU_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting BPM menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestBpmRangeMenuFrom(SlotReference slotReference, int sortOrder, int bpm) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting tempo neighbor menu.");
                    Message response = client.menuRequest(Message.KnownType.BPM_RANGE_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(bpm));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting tempo range menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestTracksByBpmRangeFrom(SlotReference slotReference, int sortOrder, int bpm, int range) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting tracks by bpm range menu.");
                    Message response = client.menuRequest(Message.KnownType.TRACK_MENU_FOR_BPM_AND_DISTANCE, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(bpm), new NumberField(range));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting tracks within tempo range menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestRatingMenuFrom(SlotReference slotReference, int sortOrder) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting Rating menu.");
                    Message response = client.menuRequest(Message.KnownType.RATING_MENU_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting rating menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestTracksByRatingFrom(SlotReference slotReference, int sortOrder, int rating) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting tracks by rating menu.");
                    Message response = client.menuRequest(Message.KnownType.TRACK_MENU_FOR_RATING_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(rating));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting tracks by rating menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestColorMenuFrom(SlotReference slotReference, int sortOrder) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting Color menu.");
                    Message response = client.menuRequest(Message.KnownType.COLOR_MENU_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting color menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestTracksByColorFrom(SlotReference slotReference, int sortOrder, int color) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting tracks by color menu.");
                    Message response = client.menuRequest(Message.KnownType.TRACK_MENU_FOR_COLOR_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(color));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting tracks by color menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestTimeMenuFrom(SlotReference slotReference, int sortOrder) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting Time menu.");
                    Message response = client.menuRequest(Message.KnownType.TIME_MENU_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting time menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestTracksByTimeFrom(SlotReference slotReference, int sortOrder, int time) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting tracks by time menu.");
                    Message response = client.menuRequest(Message.KnownType.TRACK_MENU_FOR_TIME_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(time));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting tracks by time menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestBitRateMenuFrom(SlotReference slotReference, int sortOrder) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting Bit Rate menu.");
                    Message response = client.menuRequest(Message.KnownType.BIT_RATE_MENU_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting genre menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestTracksByBitRateFrom(SlotReference slotReference, int sortOrder, int bitRate) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting tracks by bit rate menu.");
                    Message response = client.menuRequest(Message.KnownType.TRACK_MENU_FOR_BIT_RATE_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(bitRate));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting tracks by time menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestYearMenuFrom(SlotReference slotReference, int sortOrder) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting Year menu.");
                    Message response = client.menuRequest(Message.KnownType.YEAR_MENU_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting year menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestYearsByDecadeFrom(SlotReference slotReference, int sortOrder, int decade) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting years by decade menu.");
                    Message response = client.menuRequest(Message.KnownType.YEAR_MENU_FOR_DECADE_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(decade));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting years by decade menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestTracksByDecadeAndYear(SlotReference slotReference, int sortOrder, int decade, int year) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting tracks by decade and year menu.");
                    Message response = client.menuRequest(Message.KnownType.TRACK_MENU_FOR_DECADE_YEAR_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(decade), new NumberField(year));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting tracks by decade and year menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestFilenameMenuFrom(SlotReference slotReference, int sortOrder) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting Filename menu.");
                    Message response = client.menuRequest(Message.KnownType.FILENAME_MENU_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting filename menu");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestFolderMenuFrom(SlotReference slotReference, int sortOrder, int folderId) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> {
            if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                try {
                    logger.debug("Requesting Folder menu.");
                    Message response = client.menuRequestTyped(Message.KnownType.FOLDER_MENU_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.UNANALYZED, new NumberField(sortOrder), new NumberField(folderId), new NumberField(0xFFFFFFL));
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.UNANALYZED, response);
                    return list;
                }
                finally {
                    client.unlockForMenuOperations();
                }
            }
            throw new TimeoutException("Unable to lock player for menu operations.");
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting folder menu");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @API(status=API.Status.STABLE)
    private List<Message> getSearchItems(CdjStatus.TrackSourceSlot slot, int sortOrder, String text, AtomicInteger count, Client client) throws IOException, InterruptedException, TimeoutException {
        if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
            try {
                StringField textField = new StringField(text);
                Message response = client.menuRequest(Message.KnownType.SEARCH_MENU, Message.MenuIdentifier.MAIN_MENU, slot, new NumberField(sortOrder), new NumberField(textField.getSize()), textField, NumberField.WORD_0);
                int actualCount = (int)response.getMenuResultsCount();
                if (actualCount == 0) {
                    if (count != null) {
                        count.set(0);
                    }
                    List<Message> list = Collections.emptyList();
                    return list;
                }
                if (count == null) {
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                int desiredCount = Math.min(count.get(), actualCount);
                count.set(actualCount);
                if (desiredCount < 1) {
                    List<Message> list = Collections.emptyList();
                    return list;
                }
                List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slot, CdjStatus.TrackType.REKORDBOX, 0, desiredCount);
                return list;
            }
            finally {
                client.unlockForMenuOperations();
            }
        }
        throw new TimeoutException("Unable to lock player for menu operations.");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestSearchResultsFrom(int player, CdjStatus.TrackSourceSlot slot, int sortOrder, String text, AtomicInteger count) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> this.getSearchItems(slot, sortOrder, text.toUpperCase(), count, client);
        return ConnectionManager.getInstance().invokeWithClientSession(player, task, "performing search");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Message> getMoreSearchItems(CdjStatus.TrackSourceSlot slot, int sortOrder, String text, int offset, int count, Client client) throws IOException, InterruptedException, TimeoutException {
        if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
            try {
                StringField textField = new StringField(text);
                Message response = client.menuRequest(Message.KnownType.SEARCH_MENU, Message.MenuIdentifier.MAIN_MENU, slot, new NumberField(sortOrder), new NumberField(textField.getSize()), textField, NumberField.WORD_0);
                int actualCount = (int)response.getMenuResultsCount();
                if (offset + count > actualCount) {
                    throw new IllegalArgumentException("Cannot request items past the end of the menu.");
                }
                List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slot, CdjStatus.TrackType.REKORDBOX, offset, count);
                return list;
            }
            finally {
                client.unlockForMenuOperations();
            }
        }
        throw new TimeoutException("Unable to lock player for menu operations.");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestMoreSearchResultsFrom(int player, CdjStatus.TrackSourceSlot slot, int sortOrder, String text, int offset, int count) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> this.getMoreSearchItems(slot, sortOrder, text.toUpperCase(), offset, count, client);
        return ConnectionManager.getInstance().invokeWithClientSession(player, task, "performing search");
    }

    @API(status=API.Status.STABLE)
    public static MenuLoader getInstance() {
        return ourInstance;
    }

    private MenuLoader() {
    }
}

