/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.apiguardian.api.API;
import org.deepsymmetry.beatlink.CdjStatus;
import org.deepsymmetry.beatlink.DeviceAnnouncement;
import org.deepsymmetry.beatlink.DeviceAnnouncementListener;
import org.deepsymmetry.beatlink.DeviceFinder;
import org.deepsymmetry.beatlink.DeviceUpdate;
import org.deepsymmetry.beatlink.DeviceUpdateListener;
import org.deepsymmetry.beatlink.LifecycleListener;
import org.deepsymmetry.beatlink.LifecycleParticipant;
import org.deepsymmetry.beatlink.MediaDetails;
import org.deepsymmetry.beatlink.MediaDetailsListener;
import org.deepsymmetry.beatlink.VirtualCdj;
import org.deepsymmetry.beatlink.VirtualRekordbox;
import org.deepsymmetry.beatlink.data.AlbumArt;
import org.deepsymmetry.beatlink.data.BeatGrid;
import org.deepsymmetry.beatlink.data.CueList;
import org.deepsymmetry.beatlink.data.DataReference;
import org.deepsymmetry.beatlink.data.DeckReference;
import org.deepsymmetry.beatlink.data.MetadataProvider;
import org.deepsymmetry.beatlink.data.MountListener;
import org.deepsymmetry.beatlink.data.OpusProvider;
import org.deepsymmetry.beatlink.data.SlotReference;
import org.deepsymmetry.beatlink.data.TrackMetadata;
import org.deepsymmetry.beatlink.data.TrackMetadataListener;
import org.deepsymmetry.beatlink.data.TrackMetadataUpdate;
import org.deepsymmetry.beatlink.data.WaveformDetail;
import org.deepsymmetry.beatlink.data.WaveformPreview;
import org.deepsymmetry.beatlink.dbserver.Client;
import org.deepsymmetry.beatlink.dbserver.ConnectionManager;
import org.deepsymmetry.beatlink.dbserver.Message;
import org.deepsymmetry.beatlink.dbserver.NumberField;
import org.deepsymmetry.cratedigger.pdb.RekordboxAnlz;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.STABLE)
public class MetadataFinder
extends LifecycleParticipant {
    private static final Logger logger = LoggerFactory.getLogger(MetadataFinder.class);
    @API(status=API.Status.STABLE)
    public static final int MENU_TIMEOUT = 20;
    private final Map<DeckReference, TrackMetadata> hotCache = new ConcurrentHashMap<DeckReference, TrackMetadata>();
    private final LinkedBlockingDeque<CdjStatus> pendingUpdates = new LinkedBlockingDeque(100);
    private final DeviceUpdateListener updateListener = update -> {
        logger.debug("Received device update {}", (Object)update);
        if (update instanceof CdjStatus && !this.pendingUpdates.offerLast((CdjStatus)update)) {
            logger.warn("Discarding CDJ update because our queue is backed up.");
        }
    };
    private final DeviceAnnouncementListener announcementListener = new DeviceAnnouncementListener(){

        @Override
        public void deviceFound(DeviceAnnouncement announcement) {
            if (announcement.getDeviceNumber() == 25 && announcement.getDeviceName().equals("NXS-GW")) {
                logger.debug("Ignoring arrival of Kuvo gateway, which fight each other and come and go constantly, especially in CDJ-3000s.");
                return;
            }
            logger.info("Processing device found, number:{}, name:\"{}\".", (Object)announcement.getDeviceNumber(), (Object)announcement.getDeviceName());
            if ((announcement.getDeviceNumber() > 15 && announcement.getDeviceNumber() < 32 || announcement.getDeviceNumber() > 40) && announcement.getDeviceName().startsWith("rekordbox")) {
                logger.info("Recording rekordbox collection mount.");
                MetadataFinder.this.recordMount(SlotReference.getSlotReference(announcement.getDeviceNumber(), CdjStatus.TrackSourceSlot.COLLECTION));
            }
        }

        @Override
        public void deviceLost(DeviceAnnouncement announcement) {
            if (announcement.getDeviceNumber() == 25 && announcement.getDeviceName().equals("NXS-GW")) {
                logger.debug("Ignoring departure of Kuvo gateway, which fight each other and come and go constantly, especially in CDJ-3000s.");
                return;
            }
            MetadataFinder.this.clearMetadata(announcement);
            if (announcement.getDeviceNumber() < 16) {
                MetadataFinder.this.removeMount(SlotReference.getSlotReference(announcement.getDeviceNumber(), CdjStatus.TrackSourceSlot.CD_SLOT));
                MetadataFinder.this.removeMount(SlotReference.getSlotReference(announcement.getDeviceNumber(), CdjStatus.TrackSourceSlot.USB_SLOT));
                MetadataFinder.this.removeMount(SlotReference.getSlotReference(announcement.getDeviceNumber(), CdjStatus.TrackSourceSlot.SD_SLOT));
            } else if ((announcement.getDeviceNumber() > 15 && announcement.getDeviceNumber() < 32 || announcement.getDeviceNumber() > 40) && announcement.getDeviceName().startsWith("rekordbox")) {
                MetadataFinder.this.removeMount(SlotReference.getSlotReference(announcement.getDeviceNumber(), CdjStatus.TrackSourceSlot.COLLECTION));
            }
        }
    };
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final AtomicBoolean passive = new AtomicBoolean(false);
    private Thread queueHandler;
    private final Set<Integer> activeRequests = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<SlotReference> mediaMounts = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<SlotReference, MediaDetails> mediaDetails = new ConcurrentHashMap<SlotReference, MediaDetails>();
    private final Set<MountListener> mountListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<TrackMetadataListener> trackListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<String, Set<MetadataProvider>> metadataProviders = new ConcurrentHashMap<String, Set<MetadataProvider>>();
    final MetadataProvider allMetadataProviders = new MetadataProvider(){

        @Override
        public List<MediaDetails> supportedMedia() {
            return Collections.emptyList();
        }

        @Override
        public TrackMetadata getTrackMetadata(MediaDetails sourceMedia, DataReference track) {
            TrackMetadata result;
            for (MetadataProvider provider : MetadataFinder.this.getMetadataProviders(sourceMedia)) {
                result = provider.getTrackMetadata(sourceMedia, track);
                if (result == null) continue;
                return result;
            }
            for (MetadataProvider provider : MetadataFinder.this.getMetadataProviders(null)) {
                result = provider.getTrackMetadata(sourceMedia, track);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        @Override
        public AlbumArt getAlbumArt(MediaDetails sourceMedia, DataReference art) {
            AlbumArt result;
            for (MetadataProvider provider : MetadataFinder.this.getMetadataProviders(sourceMedia)) {
                result = provider.getAlbumArt(sourceMedia, art);
                if (result == null) continue;
                return result;
            }
            for (MetadataProvider provider : MetadataFinder.this.getMetadataProviders(null)) {
                result = provider.getAlbumArt(sourceMedia, art);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        @Override
        public BeatGrid getBeatGrid(MediaDetails sourceMedia, DataReference track) {
            BeatGrid result;
            for (MetadataProvider provider : MetadataFinder.this.getMetadataProviders(sourceMedia)) {
                result = provider.getBeatGrid(sourceMedia, track);
                if (result == null) continue;
                return result;
            }
            for (MetadataProvider provider : MetadataFinder.this.getMetadataProviders(null)) {
                result = provider.getBeatGrid(sourceMedia, track);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        @Override
        public CueList getCueList(MediaDetails sourceMedia, DataReference track) {
            CueList result;
            for (MetadataProvider provider : MetadataFinder.this.getMetadataProviders(sourceMedia)) {
                result = provider.getCueList(sourceMedia, track);
                if (result == null) continue;
                return result;
            }
            for (MetadataProvider provider : MetadataFinder.this.getMetadataProviders(null)) {
                result = provider.getCueList(sourceMedia, track);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        @Override
        public WaveformPreview getWaveformPreview(MediaDetails sourceMedia, DataReference track) {
            WaveformPreview result;
            for (MetadataProvider provider : MetadataFinder.this.getMetadataProviders(sourceMedia)) {
                result = provider.getWaveformPreview(sourceMedia, track);
                if (result == null) continue;
                return result;
            }
            for (MetadataProvider provider : MetadataFinder.this.getMetadataProviders(null)) {
                result = provider.getWaveformPreview(sourceMedia, track);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        @Override
        public WaveformDetail getWaveformDetail(MediaDetails sourceMedia, DataReference track) {
            WaveformDetail result;
            for (MetadataProvider provider : MetadataFinder.this.getMetadataProviders(sourceMedia)) {
                result = provider.getWaveformDetail(sourceMedia, track);
                if (result == null) continue;
                return result;
            }
            for (MetadataProvider provider : MetadataFinder.this.getMetadataProviders(null)) {
                result = provider.getWaveformDetail(sourceMedia, track);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        @Override
        public RekordboxAnlz.TaggedSection getAnalysisSection(MediaDetails sourceMedia, DataReference track, String fileExtension, String typeTag) {
            RekordboxAnlz.TaggedSection result;
            for (MetadataProvider provider : MetadataFinder.this.getMetadataProviders(sourceMedia)) {
                result = provider.getAnalysisSection(sourceMedia, track, fileExtension, typeTag);
                if (result == null) continue;
                return result;
            }
            for (MetadataProvider provider : MetadataFinder.this.getMetadataProviders(null)) {
                result = provider.getAnalysisSection(sourceMedia, track, fileExtension, typeTag);
                if (result == null) continue;
                return result;
            }
            return null;
        }
    };
    private final LifecycleListener lifecycleListener = new LifecycleListener(){

        @Override
        public void started(LifecycleParticipant sender) {
            logger.debug("MetadataFinder won't automatically start just because {} has.", (Object)sender);
        }

        @Override
        public void stopped(LifecycleParticipant sender) {
            if (MetadataFinder.this.isRunning()) {
                logger.info("MetadataFinder stopping because {} has.", (Object)sender);
                MetadataFinder.this.stop();
            }
        }
    };
    private static final MetadataFinder ourInstance = new MetadataFinder();

    @API(status=API.Status.STABLE)
    public TrackMetadata requestMetadataFrom(CdjStatus status) {
        if (status.getTrackSourceSlot() == CdjStatus.TrackSourceSlot.NO_TRACK || status.getRekordboxId() == 0) {
            return null;
        }
        DataReference track = new DataReference(status.getTrackSourcePlayer(), status.getTrackSourceSlot(), status.getRekordboxId(), status.getTrackType());
        return this.requestMetadataFrom(track);
    }

    @API(status=API.Status.DEPRECATED)
    public TrackMetadata requestMetadataFrom(DataReference track, CdjStatus.TrackType trackType) {
        return this.requestMetadataInternal(track, false);
    }

    @API(status=API.Status.STABLE)
    public TrackMetadata requestMetadataFrom(DataReference track) {
        return this.requestMetadataInternal(track, false);
    }

    private TrackMetadata requestMetadataInternal(DataReference track, boolean failIfPassive) {
        TrackMetadata provided;
        MediaDetails sourceDetails = this.getMediaDetailsFor(track.getSlotReference());
        if (sourceDetails != null && (provided = this.allMetadataProviders.getTrackMetadata(sourceDetails, track)) != null) {
            return provided;
        }
        if (this.passive.get() && failIfPassive && track.slot != CdjStatus.TrackSourceSlot.COLLECTION) {
            return null;
        }
        ConnectionManager.ClientTask<TrackMetadata> task = client -> this.queryMetadata(track, client);
        try {
            return ConnectionManager.getInstance().invokeWithClientSession(track.player, task, "requesting metadata");
        }
        catch (Exception e) {
            logger.error("Problem requesting metadata, returning null", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TrackMetadata queryMetadata(DataReference track, Client client) throws IOException, InterruptedException, TimeoutException {
        if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
            try {
                Message.KnownType requestType = track.trackType == CdjStatus.TrackType.REKORDBOX ? Message.KnownType.REKORDBOX_METADATA_REQ : Message.KnownType.UNANALYZED_METADATA_REQ;
                Message response = client.menuRequestTyped(requestType, Message.MenuIdentifier.MAIN_MENU, track.slot, track.trackType, new NumberField(track.rekordboxId));
                long count = response.getMenuResultsCount();
                if (count == 0xFFFFFFFFL) {
                    TrackMetadata trackMetadata = null;
                    return trackMetadata;
                }
                List<Message> items = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, track.slot, track.trackType, response);
                CueList cueList = track.trackType == CdjStatus.TrackType.REKORDBOX ? this.getCueList(track.rekordboxId, track.slot, client) : null;
                TrackMetadata trackMetadata = new TrackMetadata(track, track.trackType, items, cueList);
                return trackMetadata;
            }
            finally {
                client.unlockForMenuOperations();
            }
        }
        throw new TimeoutException("Unable to lock the player for menu operations");
    }

    CueList getCueList(int rekordboxId, CdjStatus.TrackSourceSlot slot, Client client) throws IOException {
        Message response = client.simpleRequest(Message.KnownType.CUE_LIST_EXT_REQ, null, client.buildRMST(Message.MenuIdentifier.DATA, slot), new NumberField(rekordboxId), NumberField.WORD_0);
        if (response.knownType == Message.KnownType.CUE_LIST_EXT) {
            return new CueList(response);
        }
        response = client.simpleRequest(Message.KnownType.CUE_LIST_REQ, null, client.buildRMST(Message.MenuIdentifier.DATA, slot), new NumberField(rekordboxId));
        if (response.knownType == Message.KnownType.CUE_LIST) {
            return new CueList(response);
        }
        logger.error("Unexpected response type when requesting cue list: {}", (Object)response);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Message> getFullTrackList(CdjStatus.TrackSourceSlot slot, Client client, int sortOrder) throws IOException, InterruptedException, TimeoutException {
        if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
            try {
                Message response = client.menuRequest(Message.KnownType.TRACK_MENU_REQ, Message.MenuIdentifier.MAIN_MENU, slot, new NumberField(sortOrder));
                long count = response.getMenuResultsCount();
                if (count == 0xFFFFFFFFL || count == 0L) {
                    List<Message> list = Collections.emptyList();
                    return list;
                }
                List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slot, CdjStatus.TrackType.REKORDBOX, response);
                return list;
            }
            finally {
                client.unlockForMenuOperations();
            }
        }
        throw new TimeoutException("Unable to lock the player for menu operations");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Message> getPlaylistItems(CdjStatus.TrackSourceSlot slot, int sortOrder, int playlistOrFolderId, boolean folder, Client client) throws IOException, InterruptedException, TimeoutException {
        if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
            try {
                Message response = client.menuRequest(Message.KnownType.PLAYLIST_REQ, Message.MenuIdentifier.MAIN_MENU, slot, new NumberField(sortOrder), new NumberField(playlistOrFolderId), new NumberField(folder ? 1L : 0L));
                long count = response.getMenuResultsCount();
                if (count == 0xFFFFFFFFL || count == 0L) {
                    List<Message> list = Collections.emptyList();
                    return list;
                }
                List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slot, CdjStatus.TrackType.REKORDBOX, response);
                return list;
            }
            finally {
                client.unlockForMenuOperations();
            }
        }
        throw new TimeoutException("Unable to lock player for menu operations.");
    }

    @API(status=API.Status.STABLE)
    public List<Message> requestPlaylistItemsFrom(int player, CdjStatus.TrackSourceSlot slot, int sortOrder, int playlistOrFolderId, boolean folder) throws Exception {
        ConnectionManager.ClientTask<List> task = client -> this.getPlaylistItems(slot, sortOrder, playlistOrFolderId, folder, client);
        return ConnectionManager.getInstance().invokeWithClientSession(player, task, "requesting playlist information");
    }

    @Override
    @API(status=API.Status.STABLE)
    public boolean isRunning() {
        return this.running.get();
    }

    @API(status=API.Status.STABLE)
    public boolean isPassive() {
        return this.passive.get();
    }

    @API(status=API.Status.STABLE)
    public void setPassive(boolean passive) {
        this.passive.set(passive);
    }

    private void clearDeck(CdjStatus update) {
        if (this.hotCache.remove(DeckReference.getDeckReference(update.getDeviceNumber(), 0)) != null) {
            this.deliverTrackMetadataUpdate(update.getDeviceNumber(), null);
        }
    }

    private void clearMetadata(DeviceAnnouncement announcement) {
        int player = announcement.getDeviceNumber();
        for (DeckReference deck : new HashSet<DeckReference>(this.hotCache.keySet())) {
            if (deck.player != player) continue;
            this.hotCache.remove(deck);
            if (deck.hotCue != 0) continue;
            this.deliverTrackMetadataUpdate(player, null);
        }
    }

    private void updateMetadata(CdjStatus update, TrackMetadata data) {
        this.hotCache.put(DeckReference.getDeckReference(update.getDeviceNumber(), 0), data);
        if (data.getCueList() != null) {
            for (CueList.Entry entry : data.getCueList().entries) {
                if (entry.hotCueNumber == 0) continue;
                this.hotCache.put(DeckReference.getDeckReference(update.getDeviceNumber(), entry.hotCueNumber), data);
            }
        }
        this.deliverTrackMetadataUpdate(update.getDeviceNumber(), data);
    }

    @API(status=API.Status.STABLE)
    public Map<DeckReference, TrackMetadata> getLoadedTracks() {
        this.ensureRunning();
        return Map.copyOf(this.hotCache);
    }

    @API(status=API.Status.STABLE)
    public TrackMetadata getLatestMetadataFor(int player) {
        this.ensureRunning();
        return this.hotCache.get(DeckReference.getDeckReference(player, 0));
    }

    @API(status=API.Status.STABLE)
    public TrackMetadata getLatestMetadataFor(DeviceUpdate update) {
        return this.getLatestMetadataFor(update.getDeviceNumber());
    }

    private void flushHotCacheSlot(SlotReference slot) {
        for (Map.Entry<DeckReference, TrackMetadata> entry : new HashMap<DeckReference, TrackMetadata>(this.hotCache).entrySet()) {
            if (slot != SlotReference.getSlotReference(entry.getValue().trackReference)) continue;
            logger.debug("Evicting cached metadata in response to unmount report {}", (Object)entry.getValue());
            this.hotCache.remove(entry.getKey());
        }
    }

    private void recordMount(SlotReference slot) {
        if (this.mediaMounts.add(slot)) {
            this.deliverMountUpdate(slot, true);
        }
        if (!this.mediaDetails.containsKey(slot) && !VirtualCdj.getInstance().inOpusQuadCompatibilityMode()) {
            try {
                VirtualCdj.getInstance().sendMediaQuery(slot);
            }
            catch (Exception e) {
                logger.warn("Problem trying to request media details for {}", (Object)slot, (Object)e);
            }
        }
        if (OpusProvider.getInstance().isRunning()) {
            OpusProvider.getInstance().pollAndSendMediaDetails(slot.player);
        }
    }

    private void removeMount(SlotReference slot) {
        this.mediaDetails.remove(slot);
        if (this.mediaMounts.remove(slot)) {
            this.deliverMountUpdate(slot, false);
        }
    }

    @API(status=API.Status.STABLE)
    public Set<SlotReference> getMountedMediaSlots() {
        return Set.copyOf(this.mediaMounts);
    }

    @API(status=API.Status.STABLE)
    public Collection<MediaDetails> getMountedMediaDetails() {
        return Collections.unmodifiableCollection(this.mediaDetails.values());
    }

    @API(status=API.Status.STABLE)
    public MediaDetails getMediaDetailsFor(SlotReference slot) {
        return this.mediaDetails.get(slot);
    }

    @API(status=API.Status.STABLE)
    public void addMountListener(MountListener listener) {
        if (listener != null) {
            this.mountListeners.add(listener);
        }
    }

    @API(status=API.Status.STABLE)
    public void removeMountListener(MountListener listener) {
        if (listener != null) {
            this.mountListeners.remove(listener);
        }
    }

    @API(status=API.Status.STABLE)
    public Set<MountListener> getMountListeners() {
        return Set.copyOf(this.mountListeners);
    }

    private void deliverMountUpdate(SlotReference slot, boolean mounted) {
        if (mounted) {
            logger.info("Reporting media mounted in {}", (Object)slot);
        } else {
            logger.info("Reporting media removed from {}", (Object)slot);
        }
        for (MountListener listener : this.getMountListeners()) {
            try {
                if (mounted) {
                    listener.mediaMounted(slot);
                    continue;
                }
                listener.mediaUnmounted(slot);
            }
            catch (Throwable t) {
                logger.warn("Problem delivering mount update to listener", t);
            }
        }
    }

    @API(status=API.Status.STABLE)
    public void addTrackMetadataListener(TrackMetadataListener listener) {
        if (listener != null) {
            this.trackListeners.add(listener);
        }
    }

    @API(status=API.Status.STABLE)
    public void removeTrackMetadataListener(TrackMetadataListener listener) {
        if (listener != null) {
            this.trackListeners.remove(listener);
        }
    }

    @API(status=API.Status.STABLE)
    public Set<TrackMetadataListener> getTrackMetadataListeners() {
        return Set.copyOf(this.trackListeners);
    }

    private void deliverTrackMetadataUpdate(int player, TrackMetadata metadata) {
        if (!this.getTrackMetadataListeners().isEmpty()) {
            TrackMetadataUpdate update = new TrackMetadataUpdate(player, metadata);
            for (TrackMetadataListener listener : this.getTrackMetadataListeners()) {
                try {
                    listener.metadataChanged(update);
                }
                catch (Throwable t) {
                    logger.warn("Problem delivering track metadata update to listener", t);
                }
            }
        }
    }

    @API(status=API.Status.STABLE)
    public void addMetadataProvider(MetadataProvider provider) {
        List<MediaDetails> supportedMedia = provider.supportedMedia();
        if (supportedMedia == null || supportedMedia.isEmpty()) {
            this.addMetadataProviderForMedia("", provider);
        } else {
            for (MediaDetails details : supportedMedia) {
                this.addMetadataProviderForMedia(details.hashKey(), provider);
            }
        }
    }

    private void addMetadataProviderForMedia(String key, MetadataProvider provider) {
        if (!this.metadataProviders.containsKey(key)) {
            this.metadataProviders.put(key, Collections.newSetFromMap(new ConcurrentHashMap()));
        }
        Set<MetadataProvider> providers = this.metadataProviders.get(key);
        providers.add(provider);
    }

    @API(status=API.Status.STABLE)
    public void removeMetadataProvider(MetadataProvider provider) {
        for (Set<MetadataProvider> providers : this.metadataProviders.values()) {
            providers.remove(provider);
        }
    }

    @API(status=API.Status.STABLE)
    public Set<MetadataProvider> getMetadataProviders(MediaDetails sourceMedia) {
        String key = sourceMedia == null ? "" : sourceMedia.hashKey();
        Set<MetadataProvider> result = this.metadataProviders.get(key);
        if (result == null) {
            return Collections.emptySet();
        }
        return Set.copyOf(result);
    }

    private void handleUpdate(CdjStatus update) {
        SlotReference slot;
        if (update.isLocalUsbEmpty()) {
            slot = SlotReference.getSlotReference(update.getDeviceNumber(), CdjStatus.TrackSourceSlot.USB_SLOT);
            this.flushHotCacheSlot(slot);
            this.removeMount(slot);
        } else if (update.isLocalUsbLoaded()) {
            this.recordMount(SlotReference.getSlotReference(update.getDeviceNumber(), CdjStatus.TrackSourceSlot.USB_SLOT));
        }
        if (update.isLocalSdEmpty()) {
            slot = SlotReference.getSlotReference(update.getDeviceNumber(), CdjStatus.TrackSourceSlot.SD_SLOT);
            this.flushHotCacheSlot(slot);
            this.removeMount(slot);
        } else if (update.isLocalSdLoaded()) {
            this.recordMount(SlotReference.getSlotReference(update.getDeviceNumber(), CdjStatus.TrackSourceSlot.SD_SLOT));
        }
        if (update.isDiscSlotEmpty()) {
            this.removeMount(SlotReference.getSlotReference(update.getDeviceNumber(), CdjStatus.TrackSourceSlot.CD_SLOT));
        } else {
            this.recordMount(SlotReference.getSlotReference(update.getDeviceNumber(), CdjStatus.TrackSourceSlot.CD_SLOT));
        }
        if (update.getTrackType() == CdjStatus.TrackType.UNKNOWN || update.getTrackType() == CdjStatus.TrackType.NO_TRACK || update.getTrackSourceSlot() == CdjStatus.TrackSourceSlot.NO_TRACK || update.getTrackSourceSlot() == CdjStatus.TrackSourceSlot.UNKNOWN || update.getRekordboxId() == 0) {
            this.clearDeck(update);
        } else {
            TrackMetadata lastMetadata = this.hotCache.get(DeckReference.getDeckReference(update.getDeviceNumber(), 0));
            DataReference trackReference = new DataReference(update.getTrackSourcePlayer(), update.getTrackSourceSlot(), update.getRekordboxId(), update.getTrackType());
            if (lastMetadata == null || !lastMetadata.trackReference.equals(trackReference)) {
                for (TrackMetadata cached : this.hotCache.values()) {
                    if (!cached.trackReference.equals(trackReference)) continue;
                    this.updateMetadata(update, cached);
                    return;
                }
                if ((ConnectionManager.getInstance().getPlayerDBServerPort(update.getTrackSourcePlayer()) > 0 || VirtualRekordbox.getInstance().isRunning()) && this.activeRequests.add(update.getTrackSourcePlayer())) {
                    this.clearDeck(update);
                    new Thread(() -> {
                        try {
                            TrackMetadata data = this.requestMetadataInternal(trackReference, true);
                            if (data != null) {
                                this.updateMetadata(update, data);
                            }
                        }
                        catch (Exception e) {
                            logger.warn("Problem requesting track metadata from update {}", (Object)update, (Object)e);
                        }
                        finally {
                            this.activeRequests.remove(update.getTrackSourcePlayer());
                        }
                    }, "MetadataFinder metadata request").start();
                }
            }
        }
    }

    @API(status=API.Status.STABLE)
    public synchronized void start() throws Exception {
        if (!this.isRunning()) {
            ConnectionManager.getInstance().addLifecycleListener(this.lifecycleListener);
            ConnectionManager.getInstance().start();
            DeviceFinder.getInstance().start();
            DeviceFinder.getInstance().addDeviceAnnouncementListener(this.announcementListener);
            VirtualCdj.getInstance().addLifecycleListener(this.lifecycleListener);
            VirtualCdj.getInstance().start();
            VirtualCdj.getInstance().addUpdateListener(this.updateListener);
            this.queueHandler = new Thread(() -> {
                while (this.isRunning()) {
                    try {
                        this.handleUpdate(this.pendingUpdates.take());
                    }
                    catch (InterruptedException e) {
                        logger.debug("Interrupted, presumably due to MetadataFinder shutdown.", (Throwable)e);
                    }
                    catch (Exception e) {
                        logger.error("Problem handling CDJ status update.", (Throwable)e);
                    }
                }
            });
            this.running.set(true);
            this.queueHandler.start();
            this.deliverLifecycleAnnouncement(logger, true);
            for (DeviceAnnouncement existingDevice : DeviceFinder.getInstance().getCurrentDevices()) {
                this.announcementListener.deviceFound(existingDevice);
            }
        }
    }

    @API(status=API.Status.STABLE)
    public synchronized void stop() {
        if (this.isRunning()) {
            VirtualCdj.getInstance().removeUpdateListener(this.updateListener);
            this.running.set(false);
            this.pendingUpdates.clear();
            this.queueHandler.interrupt();
            this.queueHandler = null;
            HashSet<DeckReference> dyingCache = new HashSet<DeckReference>(this.hotCache.keySet());
            SwingUtilities.invokeLater(() -> {
                for (DeckReference deck : dyingCache) {
                    if (deck.hotCue != 0) continue;
                    this.deliverTrackMetadataUpdate(deck.player, null);
                }
            });
            this.hotCache.clear();
            this.deliverLifecycleAnnouncement(logger, false);
        }
    }

    @API(status=API.Status.STABLE)
    public static MetadataFinder getInstance() {
        return ourInstance;
    }

    private MetadataFinder() {
        VirtualCdj.getInstance().addMediaDetailsListener(details -> {
            this.mediaDetails.put(details.slotReference, details);
            if (!this.mediaMounts.contains(details.slotReference)) {
                logger.warn("Discarding media details reported for an unmounted media slot: {}", (Object)details);
                this.mediaDetails.remove(details.slotReference);
            } else {
                for (MountListener listener : this.getMountListeners()) {
                    try {
                        if (!(listener instanceof MediaDetailsListener)) continue;
                        ((MediaDetailsListener)((Object)listener)).detailsAvailable(details);
                    }
                    catch (Throwable t) {
                        logger.warn("Problem delivering media details update to mount listener", t);
                    }
                }
            }
        });
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MetadataFinder[").append("running:").append(this.isRunning()).append(", passive:").append(this.isPassive());
        if (this.isRunning()) {
            sb.append(", loadedTracks:").append(this.getLoadedTracks()).append(", mountedMediaSlots:").append(this.getMountedMediaSlots());
            sb.append(", mountedMediaDetails:").append(this.getMountedMediaDetails());
        }
        return sb.append("]").toString();
    }
}

