/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.prefs.Preferences;
import org.apiguardian.api.API;
import org.deepsymmetry.beatlink.CdjStatus;
import org.deepsymmetry.beatlink.MediaDetails;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.VirtualCdj;
import org.deepsymmetry.beatlink.VirtualRekordbox;
import org.deepsymmetry.beatlink.data.AlbumArt;
import org.deepsymmetry.beatlink.data.ArtFinder;
import org.deepsymmetry.beatlink.data.BeatGrid;
import org.deepsymmetry.beatlink.data.CrateDigger;
import org.deepsymmetry.beatlink.data.CueList;
import org.deepsymmetry.beatlink.data.DataReference;
import org.deepsymmetry.beatlink.data.MetadataFinder;
import org.deepsymmetry.beatlink.data.MetadataProvider;
import org.deepsymmetry.beatlink.data.SlotReference;
import org.deepsymmetry.beatlink.data.TrackMetadata;
import org.deepsymmetry.beatlink.data.WaveformDetail;
import org.deepsymmetry.beatlink.data.WaveformFinder;
import org.deepsymmetry.beatlink.data.WaveformPreview;
import org.deepsymmetry.cratedigger.Database;
import org.deepsymmetry.cratedigger.pdb.RekordboxAnlz;
import org.deepsymmetry.cratedigger.pdb.RekordboxPdb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlite.mc.SQLiteMCSqlCipherConfig;

@API(status=API.Status.EXPERIMENTAL)
public class OpusProvider {
    private static final Logger logger = LoggerFactory.getLogger(OpusProvider.class);
    public static final String OPUS_NAME = "OPUS-QUAD";
    private static final AtomicBoolean running = new AtomicBoolean(false);
    private static final Preferences prefs = Preferences.userRoot().node(OpusProvider.class.getName());
    private static final String databasePrefsKey = "databaseKey";
    private final AtomicReference<String> databaseKey = new AtomicReference<String>(prefs.get("databaseKey", null));
    private final Map<Integer, RekordboxUsbArchive> usbArchiveMap = new ConcurrentHashMap<Integer, RekordboxUsbArchive>();
    private final Map<Integer, LinkedBlockingQueue<MediaDetails>> archiveAttachQueueMap = new ConcurrentHashMap<Integer, LinkedBlockingQueue<MediaDetails>>();
    private final Map<String, Set<DeviceSqlRekordboxIdAndSlot>> pssiToDeviceSqlRekordboxIds = new ConcurrentHashMap<String, Set<DeviceSqlRekordboxIdAndSlot>>();
    @API(status=API.Status.EXPERIMENTAL)
    public final MetadataProvider metadataProvider = new MetadataProvider(){

        @Override
        public List<MediaDetails> supportedMedia() {
            return Collections.emptyList();
        }

        @Override
        public TrackMetadata getTrackMetadata(MediaDetails sourceMedia, DataReference track) {
            RekordboxUsbArchive archive = OpusProvider.this.findArchive(track.player);
            if (archive != null && track.trackType == CdjStatus.TrackType.REKORDBOX) {
                Connection connection = archive.getConnection();
                if (connection != null) {
                    try {
                        return new TrackMetadata(track, connection, this.getCueList(sourceMedia, track));
                    }
                    catch (Exception e) {
                        logger.error("Problem fetching metadata for track {} from JDBC SQLite connection", (Object)track, (Object)e);
                    }
                } else {
                    Database database = archive.getDatabase();
                    try {
                        return new TrackMetadata(track, database, this.getCueList(sourceMedia, track));
                    }
                    catch (Exception e) {
                        logger.error("Problem fetching metadata for track {} from DeviceSQL database {}", new Object[]{track, database, e});
                    }
                }
            }
            return null;
        }

        @Override
        public AlbumArt getAlbumArt(MediaDetails sourceMedia, DataReference art) {
            block29: {
                File file = null;
                RekordboxUsbArchive archive = OpusProvider.this.findArchive(art.player);
                if (archive != null && art.trackType == CdjStatus.TrackType.REKORDBOX) {
                    FileSystem fileSystem = archive.getFileSystem();
                    Connection connection = archive.getConnection();
                    Database database = archive.getDatabase();
                    try {
                        String artPath = null;
                        if (connection != null) {
                            try (Statement statement = connection.createStatement();
                                 ResultSet resultSet = statement.executeQuery("select * from image where image_id = " + art.rekordboxId);){
                                if (resultSet.next()) {
                                    artPath = resultSet.getString("path");
                                }
                            }
                            catch (SQLException e) {
                                logger.error("Problem retrieving artwork path from SQLite database", (Throwable)e);
                            }
                        } else {
                            RekordboxPdb.ArtworkRow artworkRow = (RekordboxPdb.ArtworkRow)database.artworkIndex.get(art.rekordboxId);
                            if (artworkRow != null) {
                                artPath = Database.getText((RekordboxPdb.DeviceSqlString)artworkRow.path());
                            }
                        }
                        if (artPath != null) {
                            file = new File(OpusProvider.this.extractDirectory, OpusProvider.this.slotPrefix(archive.getUsbSlot()) + "art-" + art.rekordboxId + ".jpg");
                            if (file.canRead()) {
                                return new AlbumArt(art, file);
                            }
                            if (ArtFinder.getInstance().getRequestHighResolutionArt()) {
                                try {
                                    OpusProvider.this.extractFile(fileSystem, Util.highResolutionPath(artPath), file);
                                }
                                catch (IOException e) {
                                    if (!(e instanceof NoSuchFileException)) {
                                        logger.error("Unexpected exception type trying to load high resolution album art", (Throwable)e);
                                    }
                                    OpusProvider.this.extractFile(fileSystem, artPath, file);
                                }
                            } else {
                                OpusProvider.this.extractFile(fileSystem, artPath, file);
                            }
                            return new AlbumArt(art, file);
                        }
                        logger.warn("Unable to find artwork {} in database {}", (Object)art, (Object)database);
                    }
                    catch (Exception e) {
                        logger.warn("Problem fetching artwork {} from database {}", new Object[]{art, database, e});
                        if (file == null) break block29;
                        file.delete();
                    }
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BeatGrid getBeatGrid(MediaDetails sourceMedia, DataReference track) {
            block6: {
                RekordboxUsbArchive archive = OpusProvider.this.findArchive(track.player);
                if (archive != null && track.trackType == CdjStatus.TrackType.REKORDBOX) {
                    BeatGrid beatGrid;
                    RekordboxAnlz file = OpusProvider.this.findTrackAnalysis(archive.getUsbSlot(), track, archive.getDatabase(), archive.getConnection(), archive.getFileSystem(), ".DAT");
                    if (file == null) break block6;
                    try {
                        beatGrid = new BeatGrid(track, file);
                    }
                    catch (Throwable throwable) {
                        try {
                            file._io().close();
                            throw throwable;
                        }
                        catch (Exception e) {
                            logger.error("Problem fetching beat grid for track {} from archive {}", new Object[]{track, archive, e});
                        }
                    }
                    file._io().close();
                    return beatGrid;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CueList getCueList(MediaDetails sourceMedia, DataReference track) {
            block7: {
                RekordboxUsbArchive archive = OpusProvider.this.findArchive(track.player);
                if (archive != null && track.trackType == CdjStatus.TrackType.REKORDBOX) {
                    CueList cueList;
                    RekordboxAnlz file = OpusProvider.this.findTrackAnalysis(archive.getUsbSlot(), track, archive.getDatabase(), archive.getConnection(), archive.getFileSystem(), ".EXT");
                    if (file == null) {
                        file = OpusProvider.this.findTrackAnalysis(archive.getUsbSlot(), track, archive.getDatabase(), archive.getConnection(), archive.getFileSystem(), ".DAT");
                    }
                    if (file == null) break block7;
                    try {
                        cueList = new CueList(file);
                    }
                    catch (Throwable throwable) {
                        try {
                            file._io().close();
                            throw throwable;
                        }
                        catch (Exception e) {
                            logger.error("Problem fetching cue list for track {} from archive {}", new Object[]{track, archive, e});
                        }
                    }
                    file._io().close();
                    return cueList;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private WaveformPreview findPreview(RekordboxUsbArchive archive, DataReference track, WaveformFinder.WaveformStyle style) {
            block6: {
                WaveformPreview waveformPreview;
                String fileExtension = style == WaveformFinder.WaveformStyle.BLUE ? ".DAT" : (style == WaveformFinder.WaveformStyle.RGB ? ".EXT" : ".2EX");
                RekordboxAnlz file = OpusProvider.this.findTrackAnalysis(archive.getUsbSlot(), track, archive.getDatabase(), archive.getConnection(), archive.getFileSystem(), fileExtension);
                if (file == null) break block6;
                try {
                    waveformPreview = new WaveformPreview(track, file, style);
                }
                catch (Throwable throwable) {
                    try {
                        file._io().close();
                        throw throwable;
                    }
                    catch (IllegalStateException e) {
                        logger.info("No {} waveform preview found.", (Object)style);
                        break block6;
                    }
                    catch (Exception e) {
                        logger.error("Problem fetching {} waveform preview for track {} from archive {}", new Object[]{style, track, archive, e});
                    }
                }
                file._io().close();
                return waveformPreview;
            }
            return null;
        }

        @Override
        public WaveformPreview getWaveformPreview(MediaDetails sourceMedia, DataReference track) {
            RekordboxUsbArchive archive = OpusProvider.this.findArchive(track.player);
            if (archive == null || track.trackType != CdjStatus.TrackType.REKORDBOX) {
                return null;
            }
            WaveformFinder.WaveformStyle style = WaveformFinder.getInstance().getPreferredStyle();
            WaveformPreview result = this.findPreview(archive, track, style);
            if (result != null) {
                return result;
            }
            switch (style) {
                case BLUE: {
                    result = this.findPreview(archive, track, WaveformFinder.WaveformStyle.RGB);
                    if (result == null) {
                        result = this.findPreview(archive, track, WaveformFinder.WaveformStyle.THREE_BAND);
                    }
                    return result;
                }
                case RGB: {
                    result = this.findPreview(archive, track, WaveformFinder.WaveformStyle.THREE_BAND);
                    if (result == null) {
                        result = this.findPreview(archive, track, WaveformFinder.WaveformStyle.BLUE);
                    }
                    return result;
                }
                case THREE_BAND: {
                    result = this.findPreview(archive, track, WaveformFinder.WaveformStyle.RGB);
                    if (result == null) {
                        result = this.findPreview(archive, track, WaveformFinder.WaveformStyle.BLUE);
                    }
                    return result;
                }
            }
            logger.error("Unrecognized waveform style: {}", (Object)style);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private WaveformDetail findDetail(RekordboxUsbArchive archive, DataReference track, WaveformFinder.WaveformStyle style) {
            block6: {
                WaveformDetail waveformDetail;
                String fileExtension = style == WaveformFinder.WaveformStyle.THREE_BAND ? ".2EX" : ".EXT";
                RekordboxAnlz file = OpusProvider.this.findTrackAnalysis(archive.getUsbSlot(), track, archive.getDatabase(), archive.getConnection(), archive.getFileSystem(), fileExtension);
                if (file == null) break block6;
                try {
                    waveformDetail = new WaveformDetail(track, file, style);
                }
                catch (Throwable throwable) {
                    try {
                        file._io().close();
                        throw throwable;
                    }
                    catch (IllegalStateException e) {
                        logger.info("No {} waveform detail found.", (Object)style);
                        break block6;
                    }
                    catch (Exception e) {
                        logger.error("Problem fetching {} waveform detail for track {} from archive {}", new Object[]{style, track, archive, e});
                    }
                }
                file._io().close();
                return waveformDetail;
            }
            return null;
        }

        @Override
        public WaveformDetail getWaveformDetail(MediaDetails sourceMedia, DataReference track) {
            RekordboxUsbArchive archive = OpusProvider.this.findArchive(track.player);
            if (archive == null || track.trackType != CdjStatus.TrackType.REKORDBOX) {
                return null;
            }
            WaveformFinder.WaveformStyle style = WaveformFinder.getInstance().getPreferredStyle();
            WaveformDetail result = this.findDetail(archive, track, style);
            if (result != null) {
                return result;
            }
            switch (style) {
                case BLUE: {
                    result = this.findDetail(archive, track, WaveformFinder.WaveformStyle.RGB);
                    if (result == null) {
                        result = this.findDetail(archive, track, WaveformFinder.WaveformStyle.THREE_BAND);
                    }
                    return result;
                }
                case RGB: {
                    result = this.findDetail(archive, track, WaveformFinder.WaveformStyle.THREE_BAND);
                    return result;
                }
                case THREE_BAND: {
                    result = this.findDetail(archive, track, WaveformFinder.WaveformStyle.RGB);
                    return result;
                }
            }
            logger.error("Unrecognized waveform style: {}", (Object)style);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public RekordboxAnlz.TaggedSection getAnalysisSection(MediaDetails sourceMedia, DataReference track, String fileExtension, String typeTag) {
            RekordboxUsbArchive archive = OpusProvider.this.findArchive(track.player);
            if (archive == null) return null;
            if (track.trackType != CdjStatus.TrackType.REKORDBOX) return null;
            try {
                if (typeTag.length() > 4) {
                    throw new IllegalArgumentException("typeTag cannot be longer than four characters");
                }
                int fourcc = 0;
                for (int i = 0; i < 4; ++i) {
                    fourcc *= 256;
                    if (i >= typeTag.length()) continue;
                    fourcc += typeTag.charAt(i);
                }
                RekordboxAnlz file = OpusProvider.this.findTrackAnalysis(archive.getUsbSlot(), track, archive.getDatabase(), archive.getConnection(), archive.getFileSystem(), fileExtension);
                if (file == null) return null;
                try {
                    RekordboxAnlz.TaggedSection section;
                    Iterator iterator = file.sections().iterator();
                    do {
                        if (!iterator.hasNext()) return null;
                    } while ((section = (RekordboxAnlz.TaggedSection)iterator.next()).fourcc() != RekordboxAnlz.SectionTags.byId((long)fourcc));
                    RekordboxAnlz.TaggedSection taggedSection = section;
                    return taggedSection;
                }
                finally {
                    file._io().close();
                }
            }
            catch (Exception e) {
                logger.error("Problem fetching analysis file {} section {} for track {} from archive {}", new Object[]{fileExtension, typeTag, track, archive, e});
            }
            return null;
        }
    };
    private static final OpusProvider instance = new OpusProvider();
    @API(status=API.Status.EXPERIMENTAL)
    public final File extractDirectory = CrateDigger.createDownloadDirectory();

    @API(status=API.Status.STABLE)
    public boolean isRunning() {
        return running.get();
    }

    @API(status=API.Status.EXPERIMENTAL)
    public void setDatabaseKey(String key) {
        throw new UnsupportedOperationException("This is not yet ready for use");
    }

    private String computeSha1(byte[] data) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA1");
            digest.update(data);
            byte[] result = digest.digest();
            StringBuilder hex = new StringBuilder(result.length * 2);
            for (byte b : result) {
                hex.append(String.format("%02x", b & 0xFF));
            }
            return hex.toString();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Unable to obtain SHA-1 MessageDigest instance", (Throwable)e);
            return null;
        }
    }

    @API(status=API.Status.EXPERIMENTAL)
    public synchronized void attachMetadataArchive(File archiveFile, int usbSlotNumber) throws IOException {
        if (usbSlotNumber < 1 || usbSlotNumber > 3) {
            throw new IllegalArgumentException("Unsupported usbSlotNumber, can only use 1, 2 or 3.");
        }
        RekordboxUsbArchive formerArchive = this.usbArchiveMap.remove(usbSlotNumber);
        SlotReference emptySlotReference = SlotReference.getSlotReference(usbSlotNumber, null);
        MediaDetails emptyDetails = new MediaDetails(emptySlotReference, CdjStatus.TrackType.REKORDBOX, "", 0, 0, 0L);
        this.archiveAttachQueueMap.get(usbSlotNumber).add(emptyDetails);
        if (formerArchive != null) {
            try {
                logger.info("Detached metadata archive {} from slot {}", (Object)formerArchive, (Object)formerArchive.usbSlot);
                if (formerArchive.getDatabase() != null) {
                    formerArchive.getDatabase().close();
                }
                if (formerArchive.getConnection() != null) {
                    try {
                        formerArchive.getConnection().close();
                    }
                    catch (Exception e) {
                        logger.error("Problem closing metadata archive JDBC connection for slot {}", (Object)usbSlotNumber, (Object)e);
                    }
                }
                formerArchive.getFileSystem().close();
            }
            catch (IOException e) {
                logger.error("Problem closing database or FileSystem for slot {}", (Object)usbSlotNumber, (Object)e);
            }
            VirtualRekordbox.getInstance().clearPlayerCaches(usbSlotNumber);
            for (Set<DeviceSqlRekordboxIdAndSlot> matches : this.pssiToDeviceSqlRekordboxIds.values()) {
                matches.removeIf(v -> v.usbSlot == usbSlotNumber);
            }
            this.pssiToDeviceSqlRekordboxIds.entrySet().removeIf(entry -> ((Set)entry.getValue()).isEmpty());
            logger.info("Removed PSSI mappings for slot {}, pssiToDeviceSqlRekordboxIds now has {} entries", (Object)usbSlotNumber, (Object)this.pssiToDeviceSqlRekordboxIds.size());
            String prefix = this.slotPrefix(usbSlotNumber);
            File[] files = this.extractDirectory.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!file.getName().startsWith(prefix)) continue;
                    file.delete();
                }
            }
        }
        if (archiveFile == null) {
            return;
        }
        FileSystem filesystem = FileSystems.newFileSystem(archiveFile.toPath(), Thread.currentThread().getContextClassLoader());
        SlotReference slotReference = SlotReference.getSlotReference(usbSlotNumber, CdjStatus.TrackSourceSlot.USB_SLOT);
        RekordboxUsbArchive openedArchive = null;
        MediaDetails newDetails = null;
        if (this.databaseKey.get() != null) {
            try {
                File databaseFile = new File(this.extractDirectory, this.slotPrefix(usbSlotNumber) + "exportLibrary.db");
                Files.copy(filesystem.getPath("/exportLibrary.db", new String[0]), databaseFile.toPath(), new CopyOption[0]);
                Connection connection = SQLiteMCSqlCipherConfig.getV4Defaults().withKey(this.databaseKey.get()).build().createConnection("jdbc:sqlite:file:" + databaseFile.getAbsolutePath());
                openedArchive = new RekordboxUsbArchive(usbSlotNumber, null, connection, filesystem);
                newDetails = new MediaDetails(slotReference, CdjStatus.TrackType.REKORDBOX, filesystem.toString(), OpusProvider.getRowCount(connection, "content"), OpusProvider.getRowCount(connection, "playlist"), databaseFile.lastModified());
                logger.info("Attached SQLite metadata archive {} for slot {}.", (Object)filesystem, (Object)usbSlotNumber);
            }
            catch (Exception e) {
                filesystem.close();
                logger.error("Problem reading exportLibrary.db from metadata archive {}, is database key correct?", (Object)archiveFile, (Object)e);
            }
        }
        if (openedArchive == null) {
            try {
                File databaseFile = new File(this.extractDirectory, this.slotPrefix(usbSlotNumber) + "export.pdb");
                Files.copy(filesystem.getPath("/export.pdb", new String[0]), databaseFile.toPath(), new CopyOption[0]);
                Database database = new Database(databaseFile);
                openedArchive = new RekordboxUsbArchive(usbSlotNumber, database, null, filesystem);
                newDetails = new MediaDetails(slotReference, CdjStatus.TrackType.REKORDBOX, filesystem.toString(), database.trackIndex.size(), database.playlistIndex.size(), database.sourceFile.lastModified());
                SlotReference slotRef = SlotReference.getSlotReference(1, CdjStatus.TrackSourceSlot.USB_SLOT);
                Iterator iterator = database.trackIndex.keySet().iterator();
                while (iterator.hasNext()) {
                    long key = (Long)iterator.next();
                    int trackId = Math.toIntExact(key);
                    DataReference dataRef = new DataReference(slotRef, trackId, CdjStatus.TrackType.REKORDBOX);
                    RekordboxAnlz anlz = this.findTrackAnalysis(usbSlotNumber, dataRef, database, openedArchive.getConnection(), filesystem, ".EXT");
                    if (anlz != null) {
                        byte[] songStructure = this.getSongStructureRawBody(anlz);
                        if (songStructure != null) {
                            String sha1 = this.computeSha1(songStructure);
                            if (sha1 == null) {
                                logger.warn("Could not calculate SHA-1 for track {}", (Object)trackId);
                                continue;
                            }
                            Set shaSet = this.pssiToDeviceSqlRekordboxIds.computeIfAbsent(sha1, k -> Collections.newSetFromMap(new ConcurrentHashMap()));
                            shaSet.add(new DeviceSqlRekordboxIdAndSlot(trackId, usbSlotNumber));
                            continue;
                        }
                        logger.warn("No SONG_STRUCTURE found for track {}", (Object)trackId);
                        continue;
                    }
                    logger.warn("No extended analysis found for track {}", (Object)trackId);
                }
                logger.info("pssiToDeviceSqlRekordboxIds now contains {} entries", (Object)this.pssiToDeviceSqlRekordboxIds.size());
                logger.info("Attached DeviceSQL metadata archive {} for slot {}.", (Object)filesystem, (Object)usbSlotNumber);
            }
            catch (Exception e) {
                filesystem.close();
                throw new IOException("Problem reading export.pdb from metadata archive " + archiveFile, e);
            }
        }
        this.usbArchiveMap.put(usbSlotNumber, openedArchive);
        VirtualRekordbox.getInstance().requestPSSI();
        try {
            this.archiveAttachQueueMap.get(usbSlotNumber).put(newDetails);
        }
        catch (InterruptedException e) {
            logger.error("Problem enqueuing media update for mounted metadata archive", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getRowCount(Connection connection, String table) {
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("select count (*) ");){
            if (!resultSet.next()) return 0;
            int n = resultSet.getInt(1);
            return n;
        }
        catch (Exception e) {
            logger.error("Problem counting rows in SQLite database from table {}", (Object)table, (Object)e);
        }
        return 0;
    }

    @API(status=API.Status.EXPERIMENTAL)
    public RekordboxUsbArchive findArchive(int usbSlotNumber) {
        return this.usbArchiveMap.get(usbSlotNumber);
    }

    void pollAndSendMediaDetails(int usbSlotNumber) {
        MediaDetails mediaDetails;
        if (usbSlotNumber > 0 && usbSlotNumber < 4 && (mediaDetails = this.archiveAttachQueueMap.get(usbSlotNumber).poll()) != null) {
            VirtualCdj.getInstance().deliverMediaDetailsUpdate(mediaDetails);
        }
    }

    private String slotPrefix(int slot) {
        return "slot-" + slot + "-";
    }

    private byte[] getSongStructureRawBody(RekordboxAnlz anlz) {
        for (RekordboxAnlz.TaggedSection section : anlz.sections()) {
            if (section.fourcc() != RekordboxAnlz.SectionTags.SONG_STRUCTURE) continue;
            return section._raw_body();
        }
        return null;
    }

    private void extractFile(FileSystem archive, String sourcePath, File destination) throws IOException {
        if (sourcePath.startsWith("PIONEER/") && !Files.isReadable(archive.getPath(sourcePath, new String[0]))) {
            this.extractFile(archive, "." + sourcePath, destination);
            return;
        }
        Files.copy(archive.getPath(sourcePath, new String[0]), destination.toPath(), new CopyOption[0]);
        destination.deleteOnExit();
    }

    /*
     * Exception decompiling
     */
    private RekordboxAnlz findTrackAnalysis(int usbSlotNumber, DataReference track, Database database, Connection connection, FileSystem filesystem, String extension) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public DeviceSqlRekordboxIdAndSlot getDeviceSqlRekordboxIdAndSlotNumberFromPssi(byte[] pssi, int idSentFromOpus) {
        byte[] pssiBody = Arrays.copyOfRange(pssi, 12, pssi.length);
        String pssiBodySha1 = this.computeSha1(pssiBody);
        if (pssiBodySha1 == null) {
            logger.warn("Could not calculate SHA-1 for PSSI");
            return null;
        }
        Set matches = this.pssiToDeviceSqlRekordboxIds.getOrDefault(pssiBodySha1, Collections.emptySet());
        if (matches.isEmpty()) {
            logger.warn("No PSSI matches found");
            return null;
        }
        if (matches.size() == 1) {
            return (DeviceSqlRekordboxIdAndSlot)matches.iterator().next();
        }
        for (DeviceSqlRekordboxIdAndSlot match : matches) {
            if (match.rekordboxId != idSentFromOpus) continue;
            logger.info("Multiple PSSI matches found, preferring ID sent from Opus: {}", (Object)idSentFromOpus);
            return match;
        }
        DeviceSqlRekordboxIdAndSlot firstMatch = (DeviceSqlRekordboxIdAndSlot)matches.iterator().next();
        logger.info("Multiple PSSI matches found, but none match ID sent from Opus: {}. Returning the first match: {}", (Object)idSentFromOpus, (Object)firstMatch);
        return firstMatch;
    }

    private boolean trackMatchesArchive(DataReference dataRef, ByteBuffer pssiFromOpus, RekordboxUsbArchive archive) {
        RekordboxAnlz anlz = this.findTrackAnalysis(archive.getUsbSlot(), dataRef, archive.getDatabase(), archive.getConnection(), archive.getFileSystem(), ".EXT");
        if (anlz != null) {
            for (RekordboxAnlz.TaggedSection taggedSection : anlz.sections()) {
                if (taggedSection.fourcc() != RekordboxAnlz.SectionTags.SONG_STRUCTURE) continue;
                return Util.indexOfByteBuffer(pssiFromOpus, taggedSection._raw_body()) > -1;
            }
        }
        return false;
    }

    @API(status=API.Status.EXPERIMENTAL)
    public int findMatchingUsbSlotForTrack(int rekordboxId, int player, ByteBuffer songStructureBytes) {
        SlotReference slotRef = SlotReference.getSlotReference(player, CdjStatus.TrackSourceSlot.USB_SLOT);
        DataReference dataRef = new DataReference(slotRef, rekordboxId, CdjStatus.TrackType.REKORDBOX);
        for (RekordboxUsbArchive archive : this.usbArchiveMap.values()) {
            if (!this.trackMatchesArchive(dataRef, songStructureBytes, archive)) continue;
            return archive.getUsbSlot();
        }
        return 0;
    }

    @API(status=API.Status.STABLE)
    public synchronized void start() {
        if (!this.isRunning()) {
            running.set(true);
            MetadataFinder.getInstance().addMetadataProvider(this.metadataProvider);
        }
    }

    @API(status=API.Status.STABLE)
    public synchronized void stop() {
        if (this.isRunning()) {
            running.set(false);
            MetadataFinder.getInstance().removeMetadataProvider(this.metadataProvider);
        }
    }

    @API(status=API.Status.STABLE)
    public static OpusProvider getInstance() {
        return instance;
    }

    private OpusProvider() {
        for (int i = 1; i <= 3; ++i) {
            this.archiveAttachQueueMap.put(i, new LinkedBlockingQueue());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OpusProvider[").append("running: ").append(this.isRunning());
        if (this.isRunning()) {
            for (RekordboxUsbArchive archive : this.usbArchiveMap.values()) {
                sb.append(", USB ").append(archive.getUsbSlot()).append(" media: ").append(archive.getFileSystem());
            }
        }
        return sb.append("]").toString();
    }

    public static class DeviceSqlRekordboxIdAndSlot {
        public final int rekordboxId;
        public final int usbSlot;
        private final int hashcode;

        private DeviceSqlRekordboxIdAndSlot(int rekordboxId, int usbSlot) {
            this.rekordboxId = rekordboxId;
            this.usbSlot = usbSlot;
            this.hashcode = Objects.hash(rekordboxId, usbSlot);
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean equals(Object obj) {
            return obj instanceof DeviceSqlRekordboxIdAndSlot && ((DeviceSqlRekordboxIdAndSlot)obj).rekordboxId == this.rekordboxId && ((DeviceSqlRekordboxIdAndSlot)obj).usbSlot == this.usbSlot;
        }

        public String toString() {
            return "DeviceSqlRekordboxIdAndSlot[rekordboxId=" + this.rekordboxId + ", usbSlot=" + this.usbSlot + "]";
        }
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static class RekordboxUsbArchive {
        private final int usbSlot;
        private final Database database;
        private final Connection connection;
        private final FileSystem fileSystem;

        private RekordboxUsbArchive(int usbSlot, Database database, Connection connection, FileSystem fileSystem) {
            this.usbSlot = usbSlot;
            this.database = database;
            this.connection = connection;
            this.fileSystem = fileSystem;
        }

        @API(status=API.Status.EXPERIMENTAL)
        public int getUsbSlot() {
            return this.usbSlot;
        }

        @API(status=API.Status.EXPERIMENTAL)
        public Database getDatabase() {
            return this.database;
        }

        @API(status=API.Status.EXPERIMENTAL)
        public Connection getConnection() {
            return this.connection;
        }

        @API(status=API.Status.EXPERIMENTAL)
        public FileSystem getFileSystem() {
            return this.fileSystem;
        }
    }
}

