/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.apiguardian.api.API;
import org.deepsymmetry.beatlink.CdjStatus;
import org.deepsymmetry.beatlink.DeviceUpdate;
import org.deepsymmetry.beatlink.LifecycleListener;
import org.deepsymmetry.beatlink.LifecycleParticipant;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.VirtualCdj;
import org.deepsymmetry.beatlink.data.AnalysisTagFinder;
import org.deepsymmetry.beatlink.data.AnalysisTagListener;
import org.deepsymmetry.beatlink.data.BeatGrid;
import org.deepsymmetry.beatlink.data.BeatGridFinder;
import org.deepsymmetry.beatlink.data.BeatGridListener;
import org.deepsymmetry.beatlink.data.DataReference;
import org.deepsymmetry.beatlink.data.DeckReference;
import org.deepsymmetry.beatlink.data.MetadataFinder;
import org.deepsymmetry.beatlink.data.SearchableItem;
import org.deepsymmetry.beatlink.data.SignatureListener;
import org.deepsymmetry.beatlink.data.SignatureUpdate;
import org.deepsymmetry.beatlink.data.TrackMetadata;
import org.deepsymmetry.beatlink.data.TrackMetadataListener;
import org.deepsymmetry.beatlink.data.WaveformDetail;
import org.deepsymmetry.beatlink.data.WaveformFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.STABLE)
public class SignatureFinder
extends LifecycleParticipant {
    private static final Logger logger = LoggerFactory.getLogger(SignatureFinder.class);
    private final LinkedBlockingDeque<Integer> pendingUpdates = new LinkedBlockingDeque(20);
    private final Map<Integer, String> signatures = new ConcurrentHashMap<Integer, String>();
    private final TrackMetadataListener metadataListener = update -> {
        if (update.metadata == null) {
            this.clearSignature(update.player);
        } else {
            this.checkIfSignatureReady(update.player);
        }
    };
    private final Map<Integer, WaveformDetail> rgbWaveforms = new ConcurrentHashMap<Integer, WaveformDetail>();
    private final AnalysisTagListener rgbWaveformListener = update -> {
        if (update.taggedSection == null) {
            this.rgbWaveforms.remove(update.player);
            this.clearSignature(update.player);
        } else {
            CdjStatus lastStatus = (CdjStatus)VirtualCdj.getInstance().getLatestStatusFor(update.player);
            DataReference reference = new DataReference(update.player, lastStatus.getTrackSourceSlot(), lastStatus.getRekordboxId(), lastStatus.getTrackType());
            WaveformDetail detail = new WaveformDetail(reference, update.taggedSection);
            this.rgbWaveforms.put(update.player, detail);
            this.checkIfSignatureReady(update.player);
        }
    };
    private final BeatGridListener beatGridListener = update -> {
        if (update.beatGrid == null) {
            this.clearSignature(update.player);
        } else {
            this.checkIfSignatureReady(update.player);
        }
    };
    private final AtomicBoolean running = new AtomicBoolean(false);
    private Thread queueHandler;
    private final Set<SignatureListener> signatureListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final LifecycleListener lifecycleListener = new LifecycleListener(){

        @Override
        public void started(LifecycleParticipant sender) {
            logger.debug("The SignatureFinder does not auto-start when {} does.", (Object)sender);
        }

        @Override
        public void stopped(LifecycleParticipant sender) {
            if (SignatureFinder.this.isRunning()) {
                logger.info("SignatureFinder stopping because {} has.", (Object)sender);
                SignatureFinder.this.stop();
            }
        }
    };
    private static final SignatureFinder ourInstance = new SignatureFinder();

    private void clearSignature(int player) {
        if (this.signatures.remove(player) != null) {
            this.deliverSignatureUpdate(player, null);
        }
    }

    private void checkIfSignatureReady(int player) {
        if (!this.pendingUpdates.offerLast(player)) {
            logger.warn("Discarding signature check for player {} because our queue is backed up.", (Object)player);
        }
    }

    @Override
    @API(status=API.Status.STABLE)
    public boolean isRunning() {
        return this.running.get();
    }

    @API(status=API.Status.STABLE)
    public Map<Integer, String> getSignatures() {
        this.ensureRunning();
        return Map.copyOf(this.signatures);
    }

    @API(status=API.Status.STABLE)
    public String getLatestSignatureFor(int player) {
        this.ensureRunning();
        return this.signatures.get(player);
    }

    @API(status=API.Status.STABLE)
    public String getLatestSignatureFor(DeviceUpdate update) {
        return this.getLatestSignatureFor(update.getDeviceNumber());
    }

    @API(status=API.Status.STABLE)
    public void addSignatureListener(SignatureListener listener) {
        if (listener != null) {
            this.signatureListeners.add(listener);
        }
    }

    @API(status=API.Status.STABLE)
    public void removeSignatureListener(SignatureListener listener) {
        if (listener != null) {
            this.signatureListeners.remove(listener);
        }
    }

    @API(status=API.Status.STABLE)
    public Set<SignatureListener> getSignatureListeners() {
        return Set.copyOf(this.signatureListeners);
    }

    private void deliverSignatureUpdate(int player, String signature) {
        Set<SignatureListener> listeners = this.getSignatureListeners();
        if (!listeners.isEmpty()) {
            SwingUtilities.invokeLater(() -> {
                SignatureUpdate update = new SignatureUpdate(player, signature);
                for (SignatureListener listener : listeners) {
                    try {
                        listener.signatureChanged(update);
                    }
                    catch (Throwable t) {
                        logger.warn("Problem delivering track signature update to listener", t);
                    }
                }
            });
        }
    }

    private void checkExistingTracks() {
        SwingUtilities.invokeLater(() -> {
            for (Map.Entry<DeckReference, TrackMetadata> entry : MetadataFinder.getInstance().getLoadedTracks().entrySet()) {
                if (entry.getKey().hotCue != 0) continue;
                this.checkIfSignatureReady(entry.getKey().player);
            }
        });
    }

    private void digestInteger(MessageDigest digest, int value) {
        byte[] valueBytes = new byte[4];
        Util.numberToBytes(value, valueBytes, 0, 4);
        digest.update(valueBytes);
    }

    @API(status=API.Status.STABLE)
    public String computeTrackSignature(String title, SearchableItem artist, int duration, WaveformDetail waveformDetail, BeatGrid beatGrid) {
        String safeTitle = title == null ? "" : title;
        String artistName = artist == null ? "[no artist]" : artist.label;
        try {
            if (waveformDetail.style != WaveformFinder.WaveformStyle.RGB) {
                throw new IllegalArgumentException("Signatures can only be computed from RGB waveform details.");
            }
            MessageDigest digest = MessageDigest.getInstance("SHA1");
            digest.update(safeTitle.getBytes(StandardCharsets.UTF_8));
            digest.update((byte)0);
            digest.update(artistName.getBytes(StandardCharsets.UTF_8));
            digest.update((byte)0);
            this.digestInteger(digest, duration);
            digest.update(waveformDetail.getData());
            for (int i = 1; i <= beatGrid.beatCount; ++i) {
                this.digestInteger(digest, beatGrid.getBeatWithinBar(i));
                this.digestInteger(digest, (int)beatGrid.getTimeWithinTrack(i));
            }
            byte[] result = digest.digest();
            StringBuilder hex = new StringBuilder(result.length * 2);
            for (byte aResult : result) {
                hex.append(String.format("%02x", aResult & 0xFF));
            }
            return hex.toString();
        }
        catch (NullPointerException e) {
            logger.info("Returning null track signature because an input element was null.", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Unable to obtain SHA-1 MessageDigest instance for computing track signatures.", (Throwable)e);
        }
        return null;
    }

    private void handleUpdate(int player) {
        String signature;
        TrackMetadata metadata = MetadataFinder.getInstance().getLatestMetadataFor(player);
        WaveformDetail waveformDetail = this.rgbWaveforms.get(player);
        BeatGrid beatGrid = BeatGridFinder.getInstance().getLatestBeatGridFor(player);
        if (metadata != null && waveformDetail != null && beatGrid != null && (signature = this.computeTrackSignature(metadata.getTitle(), metadata.getArtist(), metadata.getDuration(), waveformDetail, beatGrid)) != null) {
            this.signatures.put(player, signature);
            this.deliverSignatureUpdate(player, signature);
        }
    }

    @API(status=API.Status.STABLE)
    public synchronized void start() throws Exception {
        if (!this.isRunning()) {
            MetadataFinder.getInstance().addLifecycleListener(this.lifecycleListener);
            MetadataFinder.getInstance().start();
            MetadataFinder.getInstance().addTrackMetadataListener(this.metadataListener);
            AnalysisTagFinder.getInstance().addLifecycleListener(this.lifecycleListener);
            AnalysisTagFinder.getInstance().start();
            AnalysisTagFinder.getInstance().addAnalysisTagListener(this.rgbWaveformListener, ".EXT", "PWV5");
            BeatGridFinder.getInstance().addLifecycleListener(this.lifecycleListener);
            BeatGridFinder.getInstance().start();
            BeatGridFinder.getInstance().addBeatGridListener(this.beatGridListener);
            this.queueHandler = new Thread(() -> {
                while (this.isRunning()) {
                    try {
                        this.handleUpdate(this.pendingUpdates.take());
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Throwable t) {
                        logger.error("Problem processing track signature update", t);
                    }
                }
            });
            this.running.set(true);
            this.queueHandler.start();
            this.deliverLifecycleAnnouncement(logger, true);
            this.checkExistingTracks();
        }
    }

    @API(status=API.Status.STABLE)
    public synchronized void stop() {
        if (this.isRunning()) {
            MetadataFinder.getInstance().removeTrackMetadataListener(this.metadataListener);
            AnalysisTagFinder.getInstance().removeAnalysisTagListener(this.rgbWaveformListener, ".EXT", "PWV5");
            BeatGridFinder.getInstance().removeBeatGridListener(this.beatGridListener);
            this.running.set(false);
            this.pendingUpdates.clear();
            this.queueHandler.interrupt();
            this.queueHandler = null;
            HashSet<Integer> dyingSignatures = new HashSet<Integer>(this.signatures.keySet());
            this.signatures.clear();
            SwingUtilities.invokeLater(() -> {
                for (Integer player : dyingSignatures) {
                    this.deliverSignatureUpdate(player, null);
                }
            });
        }
        this.deliverLifecycleAnnouncement(logger, false);
    }

    @API(status=API.Status.STABLE)
    public static SignatureFinder getInstance() {
        return ourInstance;
    }

    private SignatureFinder() {
    }

    public String toString() {
        return "SignatureFinder[running:" + this.isRunning() + ", signatures:" + this.signatures + "]";
    }
}

