/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apiguardian.api.API;
import org.deepsymmetry.beatlink.CdjStatus;
import org.deepsymmetry.beatlink.data.DataReference;

@API(status=API.Status.STABLE)
public class SlotReference {
    @API(status=API.Status.STABLE)
    public final int player;
    @API(status=API.Status.STABLE)
    public final CdjStatus.TrackSourceSlot slot;
    private final int hashcode;
    private static final Map<Integer, Map<CdjStatus.TrackSourceSlot, SlotReference>> instances = new HashMap<Integer, Map<CdjStatus.TrackSourceSlot, SlotReference>>();

    private SlotReference(int player, CdjStatus.TrackSourceSlot slot) {
        this.player = player;
        this.slot = slot;
        this.hashcode = Objects.hash(new Object[]{player, slot});
    }

    @API(status=API.Status.STABLE)
    public static synchronized SlotReference getSlotReference(int player, CdjStatus.TrackSourceSlot slot) {
        Map playerMap = instances.computeIfAbsent(player, k -> new HashMap());
        return playerMap.computeIfAbsent(slot, s -> new SlotReference(player, (CdjStatus.TrackSourceSlot)((Object)s)));
    }

    @API(status=API.Status.STABLE)
    public static SlotReference getSlotReference(DataReference dataReference) {
        return SlotReference.getSlotReference(dataReference.player, dataReference.slot);
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        return obj instanceof SlotReference && ((SlotReference)obj).player == this.player && ((SlotReference)obj).slot == this.slot;
    }

    public String toString() {
        return "SlotReference[player:" + this.player + ", slot:" + this.slot + "]";
    }
}

