/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apiguardian.api.API;
import org.deepsymmetry.beatlink.CdjStatus;
import org.deepsymmetry.beatlink.data.ColorItem;
import org.deepsymmetry.beatlink.data.CueList;
import org.deepsymmetry.beatlink.data.DataReference;
import org.deepsymmetry.beatlink.data.SearchableItem;
import org.deepsymmetry.beatlink.dbserver.Message;
import org.deepsymmetry.beatlink.dbserver.NumberField;
import org.deepsymmetry.beatlink.dbserver.StringField;
import org.deepsymmetry.cratedigger.Database;
import org.deepsymmetry.cratedigger.pdb.RekordboxPdb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.STABLE)
public class TrackMetadata {
    private static final Logger logger = LoggerFactory.getLogger((String)TrackMetadata.class.getName());
    @API(status=API.Status.STABLE)
    public final DataReference trackReference;
    @API(status=API.Status.STABLE)
    public final CdjStatus.TrackType trackType;
    @API(status=API.Status.EXPERIMENTAL)
    public final long timestamp = System.nanoTime();
    @API(status=API.Status.DEPRECATED)
    public final List<Message> rawItems;
    @API(status=API.Status.DEPRECATED)
    public final RekordboxPdb.TrackRow rawRow;
    private SearchableItem album;
    private SearchableItem artist;
    private ColorItem color;
    private String comment;
    private String dateAdded;
    private int duration;
    private SearchableItem genre;
    private SearchableItem key;
    private SearchableItem label;
    private SearchableItem originalArtist;
    private int rating;
    private SearchableItem remixer;
    private int tempo;
    private int year;
    private int bitRate;
    private String title;
    private int artworkId;
    private final CueList cueList;

    private SearchableItem buildSearchableItem(Message menuItem) {
        return new SearchableItem((int)((NumberField)menuItem.arguments.get(1)).getValue(), ((StringField)menuItem.arguments.get(3)).getValue());
    }

    @API(status=API.Status.STABLE)
    public TrackMetadata(DataReference reference, Database database, CueList cueList) {
        RekordboxPdb.LabelRow labelRow;
        RekordboxPdb.AlbumRow albumRow;
        this.rawItems = null;
        this.rawRow = (RekordboxPdb.TrackRow)database.trackIndex.get(reference.rekordboxId);
        if (this.rawRow == null) {
            throw new NoSuchElementException("Track " + reference.rekordboxId + " not found in PDB file.");
        }
        this.trackReference = reference;
        this.trackType = CdjStatus.TrackType.REKORDBOX;
        this.cueList = cueList;
        this.title = Database.getText((RekordboxPdb.DeviceSqlString)this.rawRow.title());
        this.artworkId = (int)this.rawRow.artworkId();
        RekordboxPdb.ArtistRow artistRow = (RekordboxPdb.ArtistRow)database.artistIndex.get(this.rawRow.artistId());
        if (artistRow != null) {
            this.artist = new SearchableItem((int)artistRow.id(), Database.getText((RekordboxPdb.DeviceSqlString)artistRow.name()));
        }
        if ((artistRow = (RekordboxPdb.ArtistRow)database.artistIndex.get(this.rawRow.originalArtistId())) != null) {
            this.originalArtist = new SearchableItem((int)artistRow.id(), Database.getText((RekordboxPdb.DeviceSqlString)artistRow.name()));
        }
        if ((artistRow = (RekordboxPdb.ArtistRow)database.artistIndex.get(this.rawRow.originalArtistId())) != null) {
            this.remixer = new SearchableItem((int)artistRow.id(), Database.getText((RekordboxPdb.DeviceSqlString)artistRow.name()));
        }
        if ((albumRow = (RekordboxPdb.AlbumRow)database.albumIndex.get(this.rawRow.albumId())) != null) {
            this.album = new SearchableItem((int)albumRow.id(), Database.getText((RekordboxPdb.DeviceSqlString)albumRow.name()));
        }
        if ((labelRow = (RekordboxPdb.LabelRow)database.labelIndex.get(this.rawRow.labelId())) != null) {
            this.label = new SearchableItem((int)labelRow.id(), Database.getText((RekordboxPdb.DeviceSqlString)labelRow.name()));
        }
        this.duration = this.rawRow.duration();
        this.tempo = (int)this.rawRow.tempo();
        this.comment = Database.getText((RekordboxPdb.DeviceSqlString)this.rawRow.comment());
        RekordboxPdb.KeyRow keyRow = (RekordboxPdb.KeyRow)database.musicalKeyIndex.get(this.rawRow.keyId());
        if (keyRow != null) {
            this.key = new SearchableItem((int)keyRow.id(), Database.getText((RekordboxPdb.DeviceSqlString)keyRow.name()));
        }
        this.rating = this.rawRow.rating();
        RekordboxPdb.ColorRow colorRow = (RekordboxPdb.ColorRow)database.colorIndex.get(this.rawRow.colorId());
        this.color = colorRow != null ? new ColorItem(this.rawRow.colorId(), Database.getText((RekordboxPdb.DeviceSqlString)colorRow.name())) : new ColorItem(this.rawRow.colorId(), "");
        RekordboxPdb.GenreRow genreRow = (RekordboxPdb.GenreRow)database.genreIndex.get(this.rawRow.genreId());
        if (genreRow != null) {
            this.genre = new SearchableItem((int)genreRow.id(), Database.getText((RekordboxPdb.DeviceSqlString)genreRow.name()));
        }
        this.dateAdded = Database.getText((RekordboxPdb.DeviceSqlString)this.rawRow.dateAdded());
        this.bitRate = (int)this.rawRow.bitrate();
        this.year = this.rawRow.year();
    }

    @API(status=API.Status.EXPERIMENTAL)
    TrackMetadata(DataReference reference, Connection connection, CueList cueList) throws SQLException {
        this.rawRow = null;
        this.rawItems = null;
        this.trackReference = reference;
        this.trackType = CdjStatus.TrackType.REKORDBOX;
        this.cueList = cueList;
        try (Statement statement = connection.createStatement();
             ResultSet trackSet = statement.executeQuery("select * from content where content_id=" + this.trackReference.rekordboxId);){
            if (!trackSet.next()) {
                throw new SQLException("Track " + this.trackReference.rekordboxId + " not found in export database");
            }
            this.artworkId = trackSet.getInt("image_id");
            this.title = trackSet.getString("title");
            this.duration = trackSet.getInt("length");
            this.tempo = trackSet.getInt("bpmx100");
            this.comment = trackSet.getString("djComment");
            this.dateAdded = trackSet.getString("dateAdded");
            this.bitRate = trackSet.getInt("bitrate");
            this.year = trackSet.getInt("releaseYear");
            this.artist = this.extractRelatedName(connection, "artist", trackSet.getInt("artist_id_artist"));
            this.originalArtist = this.extractRelatedName(connection, "artist", trackSet.getInt("artist_id_originalArtist"));
            this.remixer = this.extractRelatedName(connection, "artist", trackSet.getInt("artist_id_remixer"));
            this.album = this.extractRelatedName(connection, "album", trackSet.getInt("album_id"));
            this.label = this.extractRelatedName(connection, "label", trackSet.getInt("label_id"));
            this.key = this.extractRelatedName(connection, "key", trackSet.getInt("key_id"));
            this.genre = this.extractRelatedName(connection, "genre", trackSet.getInt("genre_id"));
            SearchableItem colorTemp = this.extractRelatedName(connection, "color", trackSet.getInt("color_id"));
            if (colorTemp != null) {
                this.color = new ColorItem(colorTemp.id, colorTemp.label);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SearchableItem extractRelatedName(Connection connection, String table, int id) {
        if (id == 0) return null;
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("select * from " + table + " where " + table + "_id=" + id);){
            if (resultSet.next()) {
                SearchableItem searchableItem = new SearchableItem(id, resultSet.getString("name"));
                return searchableItem;
            }
            logger.warn("{} row with id {} not found when loading track", (Object)table, (Object)id);
            return null;
        }
        catch (SQLException e) {
            logger.warn("{} row with id {} not found when loading track", (Object)table, (Object)id);
        }
        return null;
    }

    TrackMetadata(DataReference reference, CdjStatus.TrackType trackType, List<Message> items, CueList cueList) {
        this.rawRow = null;
        this.trackReference = reference;
        this.trackType = trackType;
        this.cueList = cueList;
        this.rawItems = Collections.unmodifiableList(new LinkedList<Message>(items));
        for (Message item : items) {
            this.parseMetadataItem(item);
        }
        if (this.title == null) {
            this.title = "";
        }
        if (this.comment == null) {
            this.comment = "";
        }
        if (this.dateAdded == null) {
            this.dateAdded = "";
        }
    }

    private void parseMetadataItem(Message item) {
        switch (item.getMenuItemType()) {
            case TRACK_TITLE: {
                this.title = ((StringField)item.arguments.get(3)).getValue();
                this.artworkId = (int)((NumberField)item.arguments.get(8)).getValue();
                break;
            }
            case ARTIST: {
                this.artist = this.buildSearchableItem(item);
                break;
            }
            case ORIGINAL_ARTIST: {
                this.originalArtist = this.buildSearchableItem(item);
                break;
            }
            case REMIXER: {
                this.remixer = this.buildSearchableItem(item);
            }
            case ALBUM_TITLE: {
                this.album = this.buildSearchableItem(item);
                break;
            }
            case LABEL: {
                this.label = this.buildSearchableItem(item);
                break;
            }
            case DURATION: {
                this.duration = (int)((NumberField)item.arguments.get(1)).getValue();
                break;
            }
            case TEMPO: {
                this.tempo = (int)((NumberField)item.arguments.get(1)).getValue();
                break;
            }
            case COMMENT: {
                this.comment = ((StringField)item.arguments.get(3)).getValue();
                break;
            }
            case KEY: {
                this.key = this.buildSearchableItem(item);
                break;
            }
            case RATING: {
                this.rating = (int)((NumberField)item.arguments.get(1)).getValue();
                break;
            }
            case COLOR_NONE: 
            case COLOR_AQUA: 
            case COLOR_BLUE: 
            case COLOR_GREEN: 
            case COLOR_ORANGE: 
            case COLOR_PINK: 
            case COLOR_PURPLE: 
            case COLOR_RED: 
            case COLOR_YELLOW: {
                int colorId = (int)((NumberField)item.arguments.get(1)).getValue();
                String label = ((StringField)item.arguments.get(3)).getValue();
                this.color = new ColorItem(colorId, label);
                break;
            }
            case GENRE: {
                this.genre = this.buildSearchableItem(item);
                break;
            }
            case DATE_ADDED: {
                this.dateAdded = ((StringField)item.arguments.get(3)).getValue();
                break;
            }
            case YEAR: {
                this.year = (int)((NumberField)item.arguments.get(1)).getValue();
                break;
            }
            case BIT_RATE: {
                this.bitRate = (int)((NumberField)item.arguments.get(1)).getValue();
                break;
            }
            default: {
                logger.warn("Ignoring track metadata item with unknown type: {}", (Object)item);
            }
        }
    }

    @API(status=API.Status.STABLE)
    public SearchableItem getAlbum() {
        return this.album;
    }

    @API(status=API.Status.STABLE)
    public SearchableItem getArtist() {
        return this.artist;
    }

    @API(status=API.Status.STABLE)
    public int getArtworkId() {
        return this.artworkId;
    }

    @API(status=API.Status.STABLE)
    public ColorItem getColor() {
        return this.color;
    }

    @API(status=API.Status.STABLE)
    public String getComment() {
        return this.comment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrackMetadata metadata = (TrackMetadata)o;
        if (this.trackReference != metadata.trackReference) {
            return false;
        }
        if (this.trackType != metadata.trackType) {
            return false;
        }
        if (this.duration != metadata.duration) {
            return false;
        }
        if (this.rating != metadata.rating) {
            return false;
        }
        if (this.tempo != metadata.tempo) {
            return false;
        }
        if (this.artworkId != metadata.artworkId) {
            return false;
        }
        if (!Objects.equals(this.album, metadata.album)) {
            return false;
        }
        if (!Objects.equals(this.artist, metadata.artist)) {
            return false;
        }
        if (!Objects.equals(this.color, metadata.color)) {
            return false;
        }
        if (!Objects.equals(this.comment, metadata.comment)) {
            return false;
        }
        if (!Objects.equals(this.dateAdded, metadata.dateAdded)) {
            return false;
        }
        if (!Objects.equals(this.genre, metadata.genre)) {
            return false;
        }
        if (!Objects.equals(this.key, metadata.key)) {
            return false;
        }
        if (!Objects.equals(this.label, metadata.label)) {
            return false;
        }
        if (!Objects.equals(this.originalArtist, metadata.originalArtist)) {
            return false;
        }
        if (!Objects.equals(this.remixer, metadata.remixer)) {
            return false;
        }
        if (!Objects.equals(this.title, metadata.title)) {
            return false;
        }
        return Objects.equals(this.cueList, metadata.cueList);
    }

    public int hashCode() {
        int result = this.album != null ? this.album.hashCode() : 0;
        result = 31 * result + (this.artist != null ? this.artist.hashCode() : 0);
        result = 31 * result + this.bitRate;
        result = 31 * result + (this.color != null ? this.color.hashCode() : 0);
        result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
        result = 31 * result + (this.dateAdded != null ? this.dateAdded.hashCode() : 0);
        result = 31 * result + this.duration;
        result = 31 * result + (this.genre != null ? this.genre.hashCode() : 0);
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
        result = 31 * result + (this.originalArtist != null ? this.originalArtist.hashCode() : 0);
        result = 31 * result + this.rating;
        result = 31 * result + (this.remixer != null ? this.remixer.hashCode() : 0);
        result = 31 * result + this.tempo;
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + this.artworkId;
        result = 31 * result + (this.cueList != null ? this.cueList.hashCode() : 0);
        result = 31 * result + this.trackReference.hashCode();
        result = 31 * result + this.trackType.hashCode();
        result = 31 * result + this.year;
        return result;
    }

    @API(status=API.Status.STABLE)
    public int getBitRate() {
        return this.bitRate;
    }

    @API(status=API.Status.STABLE)
    public CueList getCueList() {
        return this.cueList;
    }

    @API(status=API.Status.STABLE)
    public String getDateAdded() {
        return this.dateAdded;
    }

    @API(status=API.Status.STABLE)
    public int getDuration() {
        return this.duration;
    }

    @API(status=API.Status.STABLE)
    public SearchableItem getGenre() {
        return this.genre;
    }

    @API(status=API.Status.STABLE)
    public SearchableItem getKey() {
        return this.key;
    }

    @API(status=API.Status.STABLE)
    public SearchableItem getLabel() {
        return this.label;
    }

    @API(status=API.Status.STABLE)
    public SearchableItem getOriginalArtist() {
        return this.originalArtist;
    }

    @API(status=API.Status.STABLE)
    public int getRating() {
        return this.rating;
    }

    @API(status=API.Status.STABLE)
    public SearchableItem getRemixer() {
        return this.remixer;
    }

    @API(status=API.Status.STABLE)
    public int getTempo() {
        return this.tempo;
    }

    @API(status=API.Status.STABLE)
    public String getTitle() {
        return this.title;
    }

    @API(status=API.Status.STABLE)
    public int getYear() {
        return this.year;
    }

    public String toString() {
        return "Track Metadata[trackReference: " + this.trackReference + ", TrackType: " + this.trackType + ", Title: " + this.title + ", Artist: " + this.artist + ", Album: " + this.album + ", Remixer: " + this.remixer + ", Label: " + this.label + ", Original Artist: " + this.originalArtist + ", Date Added: " + this.dateAdded + ", Duration: " + this.duration + ", Tempo: " + this.tempo + ", Comment: " + this.comment + ", Key: " + this.key + ", Rating: " + this.rating + ", Color: " + this.color + ", Genre: " + this.genre + ", Year: " + this.year + ", Bit Rate: " + this.bitRate + ", Artwork ID: " + this.artworkId + ", Cue List: " + this.cueList + "]";
    }
}

