/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import org.apiguardian.api.API;
import org.deepsymmetry.beatlink.data.BeatGrid;

@API(status=API.Status.STABLE)
public class TrackPositionUpdate {
    @API(status=API.Status.STABLE)
    public final long timestamp;
    @API(status=API.Status.STABLE)
    public final long milliseconds;
    @API(status=API.Status.STABLE)
    public final int beatNumber;
    @API(status=API.Status.STABLE)
    public final boolean definitive;
    @API(status=API.Status.STABLE)
    public final boolean precise;
    @API(status=API.Status.STABLE)
    public final boolean fromBeat;
    @API(status=API.Status.STABLE)
    public final boolean playing;
    @API(status=API.Status.STABLE)
    public final double pitch;
    @API(status=API.Status.STABLE)
    public final boolean reverse;
    @API(status=API.Status.STABLE)
    public final BeatGrid beatGrid;

    @API(status=API.Status.STABLE)
    public int getBeatWithinBar() {
        if (this.beatGrid != null) {
            return this.beatGrid.getBeatWithinBar(this.beatNumber);
        }
        return 0;
    }

    @API(status=API.Status.STABLE)
    public TrackPositionUpdate(long timestamp, long milliseconds, int beatNumber, boolean definitive, boolean playing, double pitch, boolean reverse, BeatGrid beatGrid) {
        this(timestamp, milliseconds, beatNumber, definitive, playing, pitch, reverse, beatGrid, false, false);
    }

    @API(status=API.Status.STABLE)
    public TrackPositionUpdate(long timestamp, long milliseconds, int beatNumber, boolean definitive, boolean playing, double pitch, boolean reverse, BeatGrid beatGrid, boolean precise, boolean fromBeat) {
        this.timestamp = timestamp;
        this.milliseconds = milliseconds;
        this.beatNumber = beatNumber;
        this.definitive = definitive;
        this.playing = playing;
        this.pitch = pitch;
        this.reverse = reverse;
        this.beatGrid = beatGrid;
        this.precise = precise;
        this.fromBeat = fromBeat;
    }

    public String toString() {
        return "TrackPositionUpdate[timestamp:" + this.timestamp + ", milliseconds:" + this.milliseconds + ", beatNumber:" + this.beatNumber + ", definitive:" + this.definitive + ", playing:" + this.playing + ", pitch:" + String.format("%.2f", this.pitch) + ", reverse:" + this.reverse + ", beatGrid:" + this.beatGrid + ", precise:" + this.precise + ", fromBeat:" + this.fromBeat + "]";
    }
}

