/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.awt.Color;
import java.nio.ByteBuffer;
import javax.swing.JComponent;
import org.apiguardian.api.API;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.data.BeatGrid;
import org.deepsymmetry.beatlink.data.DataReference;
import org.deepsymmetry.beatlink.data.TrackMetadata;
import org.deepsymmetry.beatlink.data.WaveformDetailComponent;
import org.deepsymmetry.beatlink.data.WaveformFinder;
import org.deepsymmetry.beatlink.dbserver.BinaryField;
import org.deepsymmetry.beatlink.dbserver.Message;
import org.deepsymmetry.cratedigger.pdb.RekordboxAnlz;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.STABLE)
public class WaveformDetail {
    private final Logger logger = LoggerFactory.getLogger(WaveformDetail.class);
    @API(status=API.Status.STABLE)
    public static final int LEADING_DBSERVER_JUNK_BYTES = 19;
    @API(status=API.Status.STABLE)
    public static final int LEADING_DBSERVER_COLOR_JUNK_BYTES = 28;
    @API(status=API.Status.STABLE)
    public final DataReference dataReference;
    @API(status=API.Status.STABLE)
    public final Message rawMessage;
    private final ByteBuffer detailBuffer;
    @API(status=API.Status.DEPRECATED)
    public final boolean isColor;
    @API(status=API.Status.EXPERIMENTAL)
    public final WaveformFinder.WaveformStyle style;
    @API(status=API.Status.STABLE)
    public static final Color[] COLOR_MAP = new Color[]{new Color(0, 104, 144), new Color(0, 136, 176), new Color(0, 168, 232), new Color(0, 184, 216), new Color(120, 184, 216), new Color(136, 192, 232), new Color(136, 192, 232), new Color(200, 224, 232)};

    @API(status=API.Status.STABLE)
    public ByteBuffer getData() {
        this.detailBuffer.rewind();
        return this.detailBuffer.slice();
    }

    @API(status=API.Status.STABLE)
    public int getFrameCount() {
        int bytes = this.getData().remaining();
        switch (this.style) {
            case THREE_BAND: {
                return bytes / 3;
            }
            case RGB: {
                return bytes / 2;
            }
            case BLUE: {
                return bytes;
            }
        }
        throw new IllegalStateException("Unrecognized waveform style: " + this.style);
    }

    @API(status=API.Status.STABLE)
    public long getTotalTime() {
        return Util.halfFrameToTime(this.getFrameCount());
    }

    @API(status=API.Status.STABLE)
    public JComponent createViewComponent(TrackMetadata metadata, BeatGrid beatGrid) {
        return new WaveformDetailComponent(this, metadata, beatGrid);
    }

    @API(status=API.Status.DEPRECATED)
    public WaveformDetail(DataReference reference, Message message) {
        this(reference, message, WaveformFinder.getInstance().getPreferredStyle());
    }

    @API(status=API.Status.STABLE)
    public WaveformDetail(DataReference reference, Message message, WaveformFinder.WaveformStyle style) {
        this.isColor = style != WaveformFinder.WaveformStyle.BLUE;
        this.style = style;
        this.dataReference = reference;
        this.rawMessage = message;
        ByteBuffer rawBuffer = ((BinaryField)this.rawMessage.arguments.get(3)).getValue();
        rawBuffer.position(this.isColor ? 28 : 19);
        this.detailBuffer = rawBuffer.slice();
    }

    public WaveformDetail(DataReference reference, RekordboxAnlz.TaggedSection section) {
        this.dataReference = reference;
        this.rawMessage = null;
        if (section.body() instanceof RekordboxAnlz.Wave3bandPreviewTag) {
            RekordboxAnlz.Wave3bandScrollTag tag = (RekordboxAnlz.Wave3bandScrollTag)section.body();
            this.detailBuffer = ByteBuffer.wrap(tag.entries()).asReadOnlyBuffer();
            this.isColor = false;
            this.style = WaveformFinder.WaveformStyle.THREE_BAND;
        } else if (section.body() instanceof RekordboxAnlz.WaveColorScrollTag) {
            RekordboxAnlz.WaveColorScrollTag tag = (RekordboxAnlz.WaveColorScrollTag)section.body();
            this.detailBuffer = ByteBuffer.wrap(tag.entries()).asReadOnlyBuffer();
            this.isColor = true;
            this.style = WaveformFinder.WaveformStyle.RGB;
        } else if (section.body() instanceof RekordboxAnlz.WaveScrollTag) {
            RekordboxAnlz.WaveScrollTag tag = (RekordboxAnlz.WaveScrollTag)section.body();
            this.detailBuffer = ByteBuffer.wrap(tag.entries()).asReadOnlyBuffer();
            this.isColor = false;
            this.style = WaveformFinder.WaveformStyle.BLUE;
        } else {
            throw new IllegalStateException("Cannot create WaveformDetail from section: " + section);
        }
    }

    @API(status=API.Status.STABLE)
    public WaveformDetail(DataReference reference, RekordboxAnlz anlzFile) {
        this(reference, anlzFile, WaveformFinder.getInstance().getPreferredStyle());
    }

    @API(status=API.Status.STABLE)
    public WaveformDetail(DataReference reference, RekordboxAnlz anlzFile, WaveformFinder.WaveformStyle style) {
        this.dataReference = reference;
        this.rawMessage = null;
        ByteBuffer found = null;
        boolean threeBandFound = false;
        boolean colorFound = false;
        for (RekordboxAnlz.TaggedSection section : anlzFile.sections()) {
            RekordboxAnlz.Wave3bandScrollTag tag;
            if (style == WaveformFinder.WaveformStyle.THREE_BAND && section.body() instanceof RekordboxAnlz.Wave3bandScrollTag) {
                tag = (RekordboxAnlz.Wave3bandScrollTag)section.body();
                found = ByteBuffer.wrap(tag.entries()).asReadOnlyBuffer();
                threeBandFound = true;
                break;
            }
            if (style == WaveformFinder.WaveformStyle.RGB && section.body() instanceof RekordboxAnlz.WaveColorScrollTag) {
                tag = (RekordboxAnlz.WaveColorScrollTag)section.body();
                found = ByteBuffer.wrap(tag.entries()).asReadOnlyBuffer();
                colorFound = true;
                break;
            }
            if (!(section.body() instanceof RekordboxAnlz.WaveScrollTag)) continue;
            tag = (RekordboxAnlz.WaveScrollTag)section.body();
            found = ByteBuffer.wrap(tag.entries()).asReadOnlyBuffer();
        }
        this.detailBuffer = found;
        this.style = threeBandFound ? WaveformFinder.WaveformStyle.THREE_BAND : (colorFound ? WaveformFinder.WaveformStyle.RGB : WaveformFinder.WaveformStyle.BLUE);
        this.isColor = colorFound;
        if (this.detailBuffer == null) {
            throw new IllegalStateException("Could not construct WaveformDetail of style " + style + ", missing from analysis file " + anlzFile);
        }
    }

    @API(status=API.Status.DEPRECATED)
    public WaveformDetail(DataReference reference, ByteBuffer data, boolean isColor) {
        this(reference, data, isColor ? WaveformFinder.WaveformStyle.RGB : WaveformFinder.WaveformStyle.BLUE);
    }

    @API(status=API.Status.EXPERIMENTAL)
    public WaveformDetail(DataReference reference, ByteBuffer data, WaveformFinder.WaveformStyle style) {
        this.dataReference = reference;
        this.rawMessage = null;
        byte[] bytes = new byte[data.remaining()];
        data.get(bytes);
        this.detailBuffer = ByteBuffer.wrap(bytes).asReadOnlyBuffer();
        this.isColor = style == WaveformFinder.WaveformStyle.RGB;
        this.style = style;
    }

    private int getColorWaveformBits(ByteBuffer waveBytes, int segment) {
        int base = segment * 2;
        int big = Util.unsign(waveBytes.get(base));
        int small = Util.unsign(waveBytes.get(base + 1));
        return big * 256 + small;
    }

    @API(status=API.Status.STABLE)
    public int segmentHeight(int segment, int scale) {
        ByteBuffer waveBytes = this.getData();
        int limit = this.getFrameCount();
        int sum = 0;
        block5: for (int i = segment; i < segment + scale && i < limit; ++i) {
            switch (this.style) {
                case THREE_BAND: {
                    throw new UnsupportedOperationException();
                }
                case RGB: {
                    sum += this.getColorWaveformBits(waveBytes, segment) >> 2 & 0x1F;
                    continue block5;
                }
                case BLUE: {
                    sum += waveBytes.get(i) & 0x1F;
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("Unrecognized waveform style: " + this.style);
                }
            }
        }
        return sum / scale;
    }

    public int segmentHeight(int segment, int scale, WaveformFinder.ThreeBandLayer band) {
        if (this.style != WaveformFinder.WaveformStyle.THREE_BAND) {
            throw new UnsupportedOperationException();
        }
        ByteBuffer bytes = this.getData();
        int limit = this.getFrameCount();
        int sum = 0;
        block5: for (int i = segment; i < segment + scale && i < limit; ++i) {
            int base = i * 3;
            switch (band) {
                case LOW: {
                    sum += Math.round((float)Util.unsign(bytes.get(base + 2)) * 0.4f);
                    continue block5;
                }
                case MID: {
                    sum += Math.round((float)Util.unsign(bytes.get(base)) * 0.3f);
                    continue block5;
                }
                case HIGH: {
                    sum += Math.round((float)Util.unsign(bytes.get(base + 1)) * 0.06f);
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("Unrecognized three-band waveform band: " + band);
                }
            }
        }
        return sum / scale;
    }

    @API(status=API.Status.STABLE)
    public Color segmentColor(int segment, int scale) {
        ByteBuffer waveBytes = this.getData();
        int limit = this.getFrameCount();
        switch (this.style) {
            case THREE_BAND: {
                throw new UnsupportedOperationException();
            }
            case RGB: {
                int red = 0;
                int green = 0;
                int blue = 0;
                for (int i = segment; i < segment + scale && i < limit; ++i) {
                    int bits = this.getColorWaveformBits(waveBytes, segment);
                    red += bits >> 13 & 7;
                    green += bits >> 10 & 7;
                    blue += bits >> 7 & 7;
                }
                return new Color(red * 255 / (scale * 7), blue * 255 / (scale * 7), green * 255 / (scale * 7));
            }
            case BLUE: {
                int sum = 0;
                for (int i = segment; i < segment + scale && i < limit; ++i) {
                    sum += (waveBytes.get(i) & 0xE0) >> 5;
                }
                return COLOR_MAP[sum / scale];
            }
        }
        throw new IllegalStateException("Unrecognized waveform style: " + this.style);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WaveformDetail)) {
            return false;
        }
        WaveformDetail other = (WaveformDetail)obj;
        return this.getData().equals(other.getData());
    }

    public String toString() {
        return "WaveformDetail[dataReference=" + this.dataReference + ", size:" + this.getData().remaining() + "]";
    }
}

