/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.awt.Color;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;
import org.apiguardian.api.API;
import org.deepsymmetry.beatlink.CdjStatus;
import org.deepsymmetry.beatlink.DeviceAnnouncement;
import org.deepsymmetry.beatlink.DeviceAnnouncementListener;
import org.deepsymmetry.beatlink.DeviceFinder;
import org.deepsymmetry.beatlink.DeviceUpdate;
import org.deepsymmetry.beatlink.LifecycleListener;
import org.deepsymmetry.beatlink.LifecycleParticipant;
import org.deepsymmetry.beatlink.MediaDetails;
import org.deepsymmetry.beatlink.data.CueList;
import org.deepsymmetry.beatlink.data.DataReference;
import org.deepsymmetry.beatlink.data.DeckReference;
import org.deepsymmetry.beatlink.data.MetadataFinder;
import org.deepsymmetry.beatlink.data.MountListener;
import org.deepsymmetry.beatlink.data.SlotReference;
import org.deepsymmetry.beatlink.data.TrackMetadata;
import org.deepsymmetry.beatlink.data.TrackMetadataListener;
import org.deepsymmetry.beatlink.data.TrackMetadataUpdate;
import org.deepsymmetry.beatlink.data.WaveformDetail;
import org.deepsymmetry.beatlink.data.WaveformDetailUpdate;
import org.deepsymmetry.beatlink.data.WaveformListener;
import org.deepsymmetry.beatlink.data.WaveformPreview;
import org.deepsymmetry.beatlink.data.WaveformPreviewUpdate;
import org.deepsymmetry.beatlink.dbserver.Client;
import org.deepsymmetry.beatlink.dbserver.ConnectionManager;
import org.deepsymmetry.beatlink.dbserver.Message;
import org.deepsymmetry.beatlink.dbserver.NumberField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.STABLE)
public class WaveformFinder
extends LifecycleParticipant {
    private static final Logger logger = LoggerFactory.getLogger(WaveformFinder.class);
    private final Map<DeckReference, WaveformPreview> previewHotCache = new ConcurrentHashMap<DeckReference, WaveformPreview>();
    private final Map<DeckReference, WaveformDetail> detailHotCache = new ConcurrentHashMap<DeckReference, WaveformDetail>();
    private final AtomicBoolean findDetails = new AtomicBoolean(true);
    private final AtomicReference<WaveformStyle> preferredStyle = new AtomicReference<WaveformStyle>(WaveformStyle.RGB);
    private final LinkedBlockingDeque<TrackMetadataUpdate> pendingUpdates = new LinkedBlockingDeque(100);
    private final TrackMetadataListener metadataListener = update -> {
        logger.debug("Received metadata update {}", (Object)update);
        if (!this.pendingUpdates.offerLast(update)) {
            logger.warn("Discarding metadata update because our queue is backed up.");
        }
    };
    private final MountListener mountListener = new MountListener(){

        @Override
        public void mediaMounted(SlotReference slot) {
            logger.debug("WaveformFinder doesn't yet need to do anything in response to a media mount.");
        }

        @Override
        public void mediaUnmounted(SlotReference slot) {
            for (Map.Entry<DeckReference, WaveformPreview> entry : new HashMap<DeckReference, WaveformPreview>(WaveformFinder.this.previewHotCache).entrySet()) {
                if (slot != SlotReference.getSlotReference(entry.getValue().dataReference)) continue;
                logger.debug("Evicting cached waveform preview in response to unmount report {}", (Object)entry.getValue());
                WaveformFinder.this.previewHotCache.remove(entry.getKey());
            }
            for (Map.Entry<DeckReference, Object> entry : new HashMap<DeckReference, WaveformDetail>(WaveformFinder.this.detailHotCache).entrySet()) {
                if (slot != SlotReference.getSlotReference(((WaveformDetail)entry.getValue()).dataReference)) continue;
                logger.debug("Evicting cached waveform detail in response to unmount report {}", entry.getValue());
                WaveformFinder.this.detailHotCache.remove(entry.getKey());
            }
        }
    };
    private final DeviceAnnouncementListener announcementListener = new DeviceAnnouncementListener(){

        @Override
        public void deviceFound(DeviceAnnouncement announcement) {
            logger.debug("Currently nothing for WaveformFinder to do when devices appear.");
        }

        @Override
        public void deviceLost(DeviceAnnouncement announcement) {
            if (announcement.getDeviceNumber() == 25 && announcement.getDeviceName().equals("NXS-GW")) {
                logger.debug("Ignoring departure of Kuvo gateway, which fight each other and come and go constantly, especially in CDJ-3000s.");
                return;
            }
            logger.info("Clearing waveforms in response to the loss of a device, {}", (Object)announcement);
            WaveformFinder.this.clearWaveforms(announcement);
        }
    };
    private final AtomicBoolean running = new AtomicBoolean(false);
    private Thread queueHandler;
    static final long MAXIMUM_ANALYSIS_WAIT = TimeUnit.SECONDS.toNanos(90L);
    static final long ANALYSIS_UPDATE_INTERVAL = TimeUnit.SECONDS.toMillis(10L);
    private final AtomicBoolean retrying = new AtomicBoolean(false);
    private final Set<Integer> activePreviewRequests = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Integer> activeDetailRequests = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<WaveformListener> waveformListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final LifecycleListener lifecycleListener = new LifecycleListener(){

        @Override
        public void started(LifecycleParticipant sender) {
            logger.debug("The WaveformFinder does not auto-start when {} does.", (Object)sender);
        }

        @Override
        public void stopped(LifecycleParticipant sender) {
            if (WaveformFinder.this.isRunning()) {
                logger.info("WaveformFinder stopping because {} has.", (Object)sender);
                WaveformFinder.this.stop();
            }
        }
    };
    private static final WaveformFinder ourInstance = new WaveformFinder();

    @API(status=API.Status.STABLE)
    public final void setFindDetails(boolean findDetails) {
        this.findDetails.set(findDetails);
        if (findDetails) {
            this.primeCache();
        } else {
            HashSet<DeckReference> dyingCache = new HashSet<DeckReference>(this.detailHotCache.keySet());
            this.detailHotCache.clear();
            SwingUtilities.invokeLater(() -> {
                for (DeckReference deck : dyingCache) {
                    this.deliverWaveformDetailUpdate(deck.player, null);
                }
            });
        }
    }

    @API(status=API.Status.STABLE)
    public final boolean isFindingDetails() {
        return this.findDetails.get();
    }

    @API(status=API.Status.EXPERIMENTAL)
    public synchronized void setPreferredStyle(WaveformStyle style) {
        WaveformStyle oldStyle = this.preferredStyle.getAndSet(style);
        if (oldStyle != style) {
            this.clearAllWaveforms();
            this.primeCache();
        }
    }

    @API(status=API.Status.EXPERIMENTAL)
    public WaveformStyle getPreferredStyle() {
        return this.preferredStyle.get();
    }

    @API(status=API.Status.DEPRECATED)
    @Deprecated
    public final void setColorPreferred(boolean preferColor) {
        this.setPreferredStyle(preferColor ? WaveformStyle.RGB : WaveformStyle.BLUE);
    }

    @API(status=API.Status.DEPRECATED)
    @Deprecated
    public final boolean isColorPreferred() {
        return this.preferredStyle.get() != WaveformStyle.BLUE;
    }

    @Override
    @API(status=API.Status.STABLE)
    public boolean isRunning() {
        return this.running.get();
    }

    private void clearDeckPreview(TrackMetadataUpdate update) {
        if (this.previewHotCache.remove(DeckReference.getDeckReference(update.player, 0)) != null) {
            this.deliverWaveformPreviewUpdate(update.player, null);
        }
    }

    private void clearDeckDetail(TrackMetadataUpdate update) {
        if (this.detailHotCache.remove(DeckReference.getDeckReference(update.player, 0)) != null) {
            this.deliverWaveformDetailUpdate(update.player, null);
        }
    }

    private void clearDeck(TrackMetadataUpdate update) {
        this.clearDeckPreview(update);
        this.clearDeckDetail(update);
    }

    private void clearWaveforms(DeviceAnnouncement announcement) {
        int player = announcement.getDeviceNumber();
        for (DeckReference deck : new HashSet<DeckReference>(this.previewHotCache.keySet())) {
            if (deck.player != player) continue;
            this.previewHotCache.remove(deck);
            if (deck.hotCue != 0) continue;
            this.deliverWaveformPreviewUpdate(player, null);
        }
        for (DeckReference deck : new HashSet<DeckReference>(this.detailHotCache.keySet())) {
            if (deck.player != player) continue;
            this.detailHotCache.remove(deck);
            if (deck.hotCue != 0) continue;
            this.deliverWaveformDetailUpdate(player, null);
        }
    }

    private void updatePreview(TrackMetadataUpdate update, WaveformPreview preview) {
        this.previewHotCache.put(DeckReference.getDeckReference(update.player, 0), preview);
        if (update.metadata.getCueList() != null) {
            for (CueList.Entry entry : update.metadata.getCueList().entries) {
                if (entry.hotCueNumber == 0) continue;
                this.previewHotCache.put(DeckReference.getDeckReference(update.player, entry.hotCueNumber), preview);
            }
        }
        this.deliverWaveformPreviewUpdate(update.player, preview);
    }

    private void updateDetail(TrackMetadataUpdate update, WaveformDetail detail) {
        this.detailHotCache.put(DeckReference.getDeckReference(update.player, 0), detail);
        if (update.metadata.getCueList() != null) {
            for (CueList.Entry entry : update.metadata.getCueList().entries) {
                if (entry.hotCueNumber == 0) continue;
                this.detailHotCache.put(DeckReference.getDeckReference(update.player, entry.hotCueNumber), detail);
            }
        }
        this.deliverWaveformDetailUpdate(update.player, detail);
    }

    @API(status=API.Status.STABLE)
    public Map<DeckReference, WaveformPreview> getLoadedPreviews() {
        this.ensureRunning();
        return Map.copyOf(this.previewHotCache);
    }

    @API(status=API.Status.STABLE)
    public Map<DeckReference, WaveformDetail> getLoadedDetails() {
        this.ensureRunning();
        if (!this.isFindingDetails()) {
            throw new IllegalStateException("WaveformFinder is not configured to find waveform details.");
        }
        return Map.copyOf(this.detailHotCache);
    }

    @API(status=API.Status.STABLE)
    public WaveformPreview getLatestPreviewFor(int player) {
        this.ensureRunning();
        return this.previewHotCache.get(DeckReference.getDeckReference(player, 0));
    }

    @API(status=API.Status.STABLE)
    public WaveformPreview getLatestPreviewFor(DeviceUpdate update) {
        return this.getLatestPreviewFor(update.getDeviceNumber());
    }

    @API(status=API.Status.STABLE)
    public WaveformDetail getLatestDetailFor(int player) {
        this.ensureRunning();
        return this.detailHotCache.get(DeckReference.getDeckReference(player, 0));
    }

    @API(status=API.Status.STABLE)
    public WaveformDetail getLatestDetailFor(DeviceUpdate update) {
        return this.getLatestDetailFor(update.getDeviceNumber());
    }

    private WaveformPreview requestPreviewInternal(DataReference trackReference, TrackMetadataUpdate fromUpdate) {
        WaveformPreview provided;
        MediaDetails sourceDetails = MetadataFinder.getInstance().getMediaDetailsFor(trackReference.getSlotReference());
        if (sourceDetails != null && (provided = MetadataFinder.getInstance().allMetadataProviders.getWaveformPreview(sourceDetails, trackReference)) != null) {
            return provided;
        }
        if (MetadataFinder.getInstance().isPassive() && fromUpdate != null && trackReference.slot != CdjStatus.TrackSourceSlot.COLLECTION) {
            return null;
        }
        ConnectionManager.ClientTask<WaveformPreview> task = client -> this.getWaveformPreview(trackReference.rekordboxId, SlotReference.getSlotReference(trackReference), trackReference.trackType, fromUpdate, client);
        try {
            return ConnectionManager.getInstance().invokeWithClientSession(trackReference.player, task, "requesting waveform preview");
        }
        catch (Exception e) {
            logger.error("Problem requesting waveform preview, returning null", (Throwable)e);
            return null;
        }
    }

    @API(status=API.Status.STABLE)
    public WaveformPreview requestWaveformPreviewFrom(DataReference dataReference) {
        this.ensureRunning();
        for (WaveformPreview cached : this.previewHotCache.values()) {
            if (!cached.dataReference.equals(dataReference)) continue;
            return cached;
        }
        return this.requestPreviewInternal(dataReference, null);
    }

    static boolean retryUnanalyzedTrack(TrackMetadataUpdate fromUpdate, AtomicBoolean retryFlag, TrackMetadataListener retryListener, String description) {
        if (fromUpdate == null || fromUpdate.metadata.trackType != CdjStatus.TrackType.UNANALYZED) {
            logger.info("retryUnanalyzedTrack bailing for {}, fromUpdate: {}", (Object)description, (Object)fromUpdate);
            return false;
        }
        TrackMetadata currentMetadata = MetadataFinder.getInstance().getLatestMetadataFor(fromUpdate.player);
        if (currentMetadata == null || !currentMetadata.equals(fromUpdate.metadata)) {
            logger.info("Track changed while waiting for player {} to analyze {} for track {} in slot {}, current metadata: {}, giving up.", new Object[]{fromUpdate.player, description, fromUpdate.metadata.trackReference.rekordboxId, fromUpdate.metadata.trackReference.slot, currentMetadata});
            return false;
        }
        if (System.nanoTime() - fromUpdate.metadata.timestamp > MAXIMUM_ANALYSIS_WAIT) {
            logger.warn("Waited too long for player {} to analyze {} for track {} in slot {}, giving up.", new Object[]{fromUpdate.player, description, fromUpdate.metadata.trackReference.rekordboxId, fromUpdate.metadata.trackReference.slot});
            return false;
        }
        logger.info("Did not find full {} data yet, still waiting for player {} to analyze track {} in slot {}.", new Object[]{description, fromUpdate.player, fromUpdate.metadata.trackReference.rekordboxId, fromUpdate.metadata.trackReference.slot});
        if (retryFlag.compareAndSet(false, true)) {
            new Thread(() -> {
                try {
                    Thread.sleep(ANALYSIS_UPDATE_INTERVAL);
                }
                catch (InterruptedException e) {
                    logger.info("interrupted while waiting to retry loading {} data for unanalyzed track {}", (Object)description, (Object)currentMetadata);
                }
                retryFlag.set(false);
                if (currentMetadata.equals(MetadataFinder.getInstance().getLatestMetadataFor(fromUpdate.player))) {
                    try {
                        logger.info("Retrying {} requests for unanalyzed track in player {}.", (Object)description, (Object)fromUpdate.player);
                        retryListener.metadataChanged(fromUpdate);
                    }
                    catch (Throwable t) {
                        logger.error("Problem processing retry for {} data of unanalyzed track {}", new Object[]{description, fromUpdate, t});
                    }
                }
            }, "Unanalyzed " + description + " data request retry").start();
        }
        return true;
    }

    WaveformPreview getWaveformPreview(int rekordboxId, SlotReference slot, CdjStatus.TrackType trackType, TrackMetadataUpdate fromUpdate, Client client) throws IOException {
        Message response;
        NumberField idField = new NumberField(rekordboxId);
        if (this.getPreferredStyle() == WaveformStyle.RGB) {
            try {
                response = client.simpleRequest(Message.KnownType.ANLZ_TAG_REQ, Message.KnownType.ANLZ_TAG, client.buildRMST(Message.MenuIdentifier.MAIN_MENU, slot.slot, trackType), idField, new NumberField(878073680L), new NumberField(0x545845L));
                if (response.knownType != Message.KnownType.UNAVAILABLE && response.arguments.get(3).getSize() > 0L) {
                    return new WaveformPreview(new DataReference(slot, rekordboxId, trackType), response, WaveformStyle.RGB);
                }
                if (WaveformFinder.retryUnanalyzedTrack(fromUpdate, this.retrying, this.metadataListener, "waveform")) {
                    return null;
                }
                logger.info("No color waveform preview available for slot {}, id {}; requesting blue version.", (Object)slot, (Object)rekordboxId);
            }
            catch (Exception e) {
                if (WaveformFinder.retryUnanalyzedTrack(fromUpdate, this.retrying, this.metadataListener, "waveform")) {
                    return null;
                }
                logger.info("No color waveform preview available for slot {}, id {}; requesting blue version.", new Object[]{slot, rekordboxId, e});
            }
        } else if (this.getPreferredStyle() == WaveformStyle.THREE_BAND) {
            try {
                response = client.simpleRequest(Message.KnownType.ANLZ_TAG_REQ, Message.KnownType.ANLZ_TAG, client.buildRMST(Message.MenuIdentifier.MAIN_MENU, slot.slot, trackType), idField, new NumberField(911628112L), new NumberField(5784882L));
                if (response.knownType != Message.KnownType.UNAVAILABLE && response.arguments.get(3).getSize() > 0L) {
                    return new WaveformPreview(new DataReference(slot, rekordboxId, trackType), response, WaveformStyle.THREE_BAND);
                }
                if (WaveformFinder.retryUnanalyzedTrack(fromUpdate, this.retrying, this.metadataListener, "waveform")) {
                    return null;
                }
                logger.info("No 3-band waveform preview available for slot {}, id {}; requesting blue version.", (Object)slot, (Object)rekordboxId);
            }
            catch (Exception e) {
                if (WaveformFinder.retryUnanalyzedTrack(fromUpdate, this.retrying, this.metadataListener, "waveform")) {
                    return null;
                }
                logger.info("No 3-band waveform preview available for slot {}, id {}; requesting blue version.", new Object[]{slot, rekordboxId, e});
            }
        }
        response = client.simpleRequest(Message.KnownType.WAVE_PREVIEW_REQ, Message.KnownType.WAVE_PREVIEW, client.buildRMST(Message.MenuIdentifier.DATA, slot.slot, trackType), NumberField.WORD_1, idField, NumberField.WORD_0);
        if (response.knownType != Message.KnownType.UNAVAILABLE && response.arguments.get(3).getSize() > 0L) {
            return new WaveformPreview(new DataReference(slot, rekordboxId, trackType), response, WaveformStyle.BLUE);
        }
        WaveformFinder.retryUnanalyzedTrack(fromUpdate, this.retrying, this.metadataListener, "waveform");
        return null;
    }

    private WaveformDetail requestDetailInternal(DataReference trackReference, TrackMetadataUpdate fromUpdate) {
        WaveformDetail provided;
        MediaDetails sourceDetails = MetadataFinder.getInstance().getMediaDetailsFor(trackReference.getSlotReference());
        if (sourceDetails != null && (provided = MetadataFinder.getInstance().allMetadataProviders.getWaveformDetail(sourceDetails, trackReference)) != null) {
            return provided;
        }
        if (MetadataFinder.getInstance().isPassive() && fromUpdate != null && trackReference.slot != CdjStatus.TrackSourceSlot.COLLECTION) {
            return null;
        }
        ConnectionManager.ClientTask<WaveformDetail> task = client -> this.getWaveformDetail(trackReference.rekordboxId, SlotReference.getSlotReference(trackReference), trackReference.trackType, fromUpdate, client);
        try {
            return ConnectionManager.getInstance().invokeWithClientSession(trackReference.player, task, "requesting waveform detail");
        }
        catch (Exception e) {
            logger.error("Problem requesting waveform preview, returning null", (Throwable)e);
            return null;
        }
    }

    @API(status=API.Status.STABLE)
    public WaveformDetail requestWaveformDetailFrom(DataReference dataReference) {
        this.ensureRunning();
        for (WaveformDetail cached : this.detailHotCache.values()) {
            if (!cached.dataReference.equals(dataReference)) continue;
            return cached;
        }
        return this.requestDetailInternal(dataReference, null);
    }

    WaveformDetail getWaveformDetail(int rekordboxId, SlotReference slot, CdjStatus.TrackType trackType, TrackMetadataUpdate fromUpdate, Client client) throws IOException {
        Message response;
        NumberField idField = new NumberField(rekordboxId);
        if (this.preferredStyle.get() == WaveformStyle.RGB) {
            try {
                response = client.simpleRequest(Message.KnownType.ANLZ_TAG_REQ, Message.KnownType.ANLZ_TAG, client.buildRMST(Message.MenuIdentifier.MAIN_MENU, slot.slot, trackType), idField, new NumberField(894850896L), new NumberField(0x545845L));
                if (response.knownType != Message.KnownType.UNAVAILABLE && response.arguments.get(3).getSize() > 0L) {
                    return new WaveformDetail(new DataReference(slot, rekordboxId, trackType), response, WaveformStyle.RGB);
                }
                if (WaveformFinder.retryUnanalyzedTrack(fromUpdate, this.retrying, this.metadataListener, "waveform")) {
                    return null;
                }
                logger.info("No color waveform detail available for slot {}, id {}; requesting blue version.", (Object)slot, (Object)rekordboxId);
            }
            catch (Exception e) {
                if (WaveformFinder.retryUnanalyzedTrack(fromUpdate, this.retrying, this.metadataListener, "waveform")) {
                    return null;
                }
                logger.info("Problem requesting color waveform detail for slot {}, id {}; requesting blue version.", new Object[]{slot, rekordboxId, e});
            }
        } else if (this.preferredStyle.get() == WaveformStyle.THREE_BAND) {
            try {
                response = client.simpleRequest(Message.KnownType.ANLZ_TAG_REQ, Message.KnownType.ANLZ_TAG, client.buildRMST(Message.MenuIdentifier.MAIN_MENU, slot.slot, trackType), idField, new NumberField(928405328L), new NumberField(5784882L));
                if (response.knownType != Message.KnownType.UNAVAILABLE && response.arguments.get(3).getSize() > 0L) {
                    return new WaveformDetail(new DataReference(slot, rekordboxId, trackType), response, WaveformStyle.THREE_BAND);
                }
                if (WaveformFinder.retryUnanalyzedTrack(fromUpdate, this.retrying, this.metadataListener, "waveform")) {
                    return null;
                }
                logger.info("No 3-band waveform detail available for slot {}, id {}; requesting blue version.", (Object)slot, (Object)rekordboxId);
            }
            catch (Exception e) {
                if (WaveformFinder.retryUnanalyzedTrack(fromUpdate, this.retrying, this.metadataListener, "waveform")) {
                    return null;
                }
                logger.info("Problem requesting 3-band waveform detail for slot {}, id {}; requesting blue version.", new Object[]{slot, rekordboxId, e});
            }
        }
        response = client.simpleRequest(Message.KnownType.WAVE_DETAIL_REQ, Message.KnownType.WAVE_DETAIL, client.buildRMST(Message.MenuIdentifier.MAIN_MENU, slot.slot, trackType), idField, NumberField.WORD_0);
        if (response.knownType != Message.KnownType.UNAVAILABLE && response.arguments.get(3).getSize() > 0L) {
            return new WaveformDetail(new DataReference(slot, rekordboxId, trackType), response, WaveformStyle.BLUE);
        }
        WaveformFinder.retryUnanalyzedTrack(fromUpdate, this.retrying, this.metadataListener, "waveform");
        return null;
    }

    @API(status=API.Status.STABLE)
    public void addWaveformListener(WaveformListener listener) {
        if (listener != null) {
            this.waveformListeners.add(listener);
        }
    }

    @API(status=API.Status.STABLE)
    public void removeWaveformListener(WaveformListener listener) {
        if (listener != null) {
            this.waveformListeners.remove(listener);
        }
    }

    @API(status=API.Status.STABLE)
    public Set<WaveformListener> getWaveformListeners() {
        return Set.copyOf(this.waveformListeners);
    }

    private void deliverWaveformPreviewUpdate(int player, WaveformPreview preview) {
        Set<WaveformListener> listeners = this.getWaveformListeners();
        if (!listeners.isEmpty()) {
            SwingUtilities.invokeLater(() -> {
                WaveformPreviewUpdate update = new WaveformPreviewUpdate(player, preview);
                for (WaveformListener listener : listeners) {
                    try {
                        listener.previewChanged(update);
                    }
                    catch (Throwable t) {
                        logger.warn("Problem delivering waveform preview update to listener", t);
                    }
                }
            });
        }
    }

    private void deliverWaveformDetailUpdate(int player, WaveformDetail detail) {
        if (!this.getWaveformListeners().isEmpty()) {
            SwingUtilities.invokeLater(() -> {
                WaveformDetailUpdate update = new WaveformDetailUpdate(player, detail);
                for (WaveformListener listener : this.getWaveformListeners()) {
                    try {
                        listener.detailChanged(update);
                    }
                    catch (Throwable t) {
                        logger.warn("Problem delivering waveform detail update to listener", t);
                    }
                }
            });
        }
    }

    private void handleUpdate(TrackMetadataUpdate update) {
        boolean foundInCache = false;
        if (update.metadata == null) {
            this.clearDeck(update);
        } else {
            WaveformPreview lastPreview = this.previewHotCache.get(DeckReference.getDeckReference(update.player, 0));
            if (lastPreview == null || !lastPreview.dataReference.equals(update.metadata.trackReference) || update.metadata.trackType == CdjStatus.TrackType.UNANALYZED) {
                for (Map.Entry<DeckReference, WaveformPreview> cached : this.previewHotCache.entrySet()) {
                    if (cached.getKey().hotCue == 0 || !cached.getValue().dataReference.equals(update.metadata.trackReference)) continue;
                    this.updatePreview(update, cached.getValue());
                    foundInCache = true;
                    break;
                }
                if (!foundInCache && this.activePreviewRequests.add(update.player)) {
                    this.clearDeckPreview(update);
                    new Thread(() -> {
                        try {
                            WaveformPreview preview = this.requestPreviewInternal(update.metadata.trackReference, update);
                            if (preview != null) {
                                this.updatePreview(update, preview);
                                if (!preview.equals(lastPreview)) {
                                    WaveformFinder.retryUnanalyzedTrack(update, this.retrying, this.metadataListener, "waveform");
                                }
                            }
                        }
                        catch (Exception e) {
                            logger.warn("Problem requesting waveform preview from update {}", (Object)update, (Object)e);
                        }
                        finally {
                            this.activePreviewRequests.remove(update.player);
                        }
                    }).start();
                }
            }
            foundInCache = false;
            WaveformDetail lastDetail = this.detailHotCache.get(DeckReference.getDeckReference(update.player, 0));
            if (this.isFindingDetails() && (lastDetail == null || !lastDetail.dataReference.equals(update.metadata.trackReference) || update.metadata.trackType == CdjStatus.TrackType.UNANALYZED)) {
                for (Map.Entry<DeckReference, WaveformDetail> cached : this.detailHotCache.entrySet()) {
                    if (cached.getKey().hotCue == 0 || !cached.getValue().dataReference.equals(update.metadata.trackReference)) continue;
                    this.updateDetail(update, cached.getValue());
                    foundInCache = true;
                    break;
                }
                if (!foundInCache && this.activeDetailRequests.add(update.player)) {
                    this.clearDeckDetail(update);
                    new Thread(() -> {
                        try {
                            WaveformDetail detail = this.requestDetailInternal(update.metadata.trackReference, update);
                            if (detail != null) {
                                this.updateDetail(update, detail);
                                if (!detail.equals(lastDetail)) {
                                    WaveformFinder.retryUnanalyzedTrack(update, this.retrying, this.metadataListener, "waveform");
                                }
                            }
                        }
                        catch (Exception e) {
                            logger.warn("Problem requesting waveform detail from update {}", (Object)update, (Object)e);
                        }
                        finally {
                            this.activeDetailRequests.remove(update.player);
                        }
                    }).start();
                }
            }
        }
    }

    private void primeCache() {
        SwingUtilities.invokeLater(() -> {
            if (this.isRunning()) {
                for (Map.Entry<DeckReference, TrackMetadata> entry : MetadataFinder.getInstance().getLoadedTracks().entrySet()) {
                    if (entry.getKey().hotCue != 0) continue;
                    this.handleUpdate(new TrackMetadataUpdate(entry.getKey().player, entry.getValue()));
                }
            }
        });
    }

    @API(status=API.Status.STABLE)
    public synchronized void start() throws Exception {
        if (!this.isRunning()) {
            ConnectionManager.getInstance().addLifecycleListener(this.lifecycleListener);
            ConnectionManager.getInstance().start();
            DeviceFinder.getInstance().addDeviceAnnouncementListener(this.announcementListener);
            MetadataFinder.getInstance().addLifecycleListener(this.lifecycleListener);
            MetadataFinder.getInstance().start();
            MetadataFinder.getInstance().addTrackMetadataListener(this.metadataListener);
            MetadataFinder.getInstance().addMountListener(this.mountListener);
            this.queueHandler = new Thread(() -> {
                while (this.isRunning()) {
                    try {
                        this.handleUpdate(this.pendingUpdates.take());
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Throwable t) {
                        logger.error("Problem processing metadata update", t);
                    }
                }
            });
            this.running.set(true);
            this.queueHandler.start();
            this.deliverLifecycleAnnouncement(logger, true);
            this.primeCache();
        }
    }

    @API(status=API.Status.STABLE)
    public synchronized void stop() {
        if (this.isRunning()) {
            MetadataFinder.getInstance().removeTrackMetadataListener(this.metadataListener);
            this.running.set(false);
            this.pendingUpdates.clear();
            this.queueHandler.interrupt();
            this.queueHandler = null;
            this.clearAllWaveforms();
            this.deliverLifecycleAnnouncement(logger, false);
        }
    }

    private void clearAllWaveforms() {
        HashSet<DeckReference> dyingPreviewCache = new HashSet<DeckReference>(this.previewHotCache.keySet());
        this.previewHotCache.clear();
        HashSet<DeckReference> dyingDetailCache = new HashSet<DeckReference>(this.detailHotCache.keySet());
        this.detailHotCache.clear();
        SwingUtilities.invokeLater(() -> {
            for (DeckReference deck : dyingPreviewCache) {
                if (deck.hotCue != 0) continue;
                this.deliverWaveformPreviewUpdate(deck.player, null);
            }
            for (DeckReference deck : dyingDetailCache) {
                if (deck.hotCue != 0) continue;
                this.deliverWaveformDetailUpdate(deck.player, null);
            }
        });
    }

    @API(status=API.Status.STABLE)
    public static WaveformFinder getInstance() {
        return ourInstance;
    }

    private WaveformFinder() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WaveformFinder[running:").append(this.isRunning()).append(", passive:");
        sb.append(MetadataFinder.getInstance().isPassive()).append(", findingDetails:").append(this.isFindingDetails());
        if (this.isRunning()) {
            sb.append(", loadedPreviews:").append(this.getLoadedPreviews());
            if (this.isFindingDetails()) {
                sb.append(", loadedDetails:").append(this.getLoadedDetails());
            }
        }
        return sb.append("]").toString();
    }

    public static enum ThreeBandLayer {
        LOW(new Color(32, 83, 217)),
        LOW_AND_MIO(new Color(169, 107, 39)),
        MID(new Color(242, 170, 60)),
        HIGH(new Color(255, 255, 255));

        public final Color color;

        private ThreeBandLayer(Color color) {
            this.color = color;
        }
    }

    public static enum WaveformStyle {
        BLUE,
        RGB,
        THREE_BAND;

    }
}

