/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.awt.Color;
import java.nio.ByteBuffer;
import javax.swing.JComponent;
import org.apiguardian.api.API;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.data.DataReference;
import org.deepsymmetry.beatlink.data.TrackMetadata;
import org.deepsymmetry.beatlink.data.WaveformFinder;
import org.deepsymmetry.beatlink.data.WaveformPreviewComponent;
import org.deepsymmetry.beatlink.dbserver.BinaryField;
import org.deepsymmetry.beatlink.dbserver.Message;
import org.deepsymmetry.cratedigger.pdb.RekordboxAnlz;

@API(status=API.Status.STABLE)
public class WaveformPreview {
    @API(status=API.Status.STABLE)
    public static final int LEADING_DBSERVER_COLOR_JUNK_BYTES = 28;
    @API(status=API.Status.STABLE)
    public final DataReference dataReference;
    @API(status=API.Status.STABLE)
    public final Message rawMessage;
    private final ByteBuffer expandedData;
    @API(status=API.Status.DEPRECATED)
    public final boolean isColor;
    @API(status=API.Status.EXPERIMENTAL)
    public final WaveformFinder.WaveformStyle style;
    @API(status=API.Status.STABLE)
    public final int segmentCount;
    @API(status=API.Status.STABLE)
    public final int maxHeight;
    @API(status=API.Status.STABLE)
    public static final Color INTENSE_COLOR = new Color(116, 246, 244);
    @API(status=API.Status.STABLE)
    public static final Color NORMAL_COLOR = new Color(43, 89, 255);

    @API(status=API.Status.STABLE)
    public ByteBuffer getData() {
        this.expandedData.rewind();
        return this.expandedData.slice();
    }

    @API(status=API.Status.STABLE)
    public JComponent createViewComponent(TrackMetadata metadata) {
        return new WaveformPreviewComponent(this, metadata);
    }

    private int getSegmentCount() {
        int bytes = this.getData().remaining();
        switch (this.style) {
            case BLUE: {
                return bytes / 2;
            }
            case THREE_BAND: {
                return bytes / 3;
            }
            case RGB: {
                return bytes / 6;
            }
        }
        throw new IllegalStateException("Unknown waveform style: " + this.style);
    }

    private int getMaxHeight() {
        int result = 0;
        for (int i = 0; i < this.segmentCount; ++i) {
            if (this.style == WaveformFinder.WaveformStyle.THREE_BAND) {
                result = Math.max(result, this.segmentHeight(i, WaveformFinder.ThreeBandLayer.LOW));
                result = Math.max(result, this.segmentHeight(i, WaveformFinder.ThreeBandLayer.MID));
                result = Math.max(result, this.segmentHeight(i, WaveformFinder.ThreeBandLayer.HIGH));
                continue;
            }
            result = Math.max(result, this.segmentHeight(i, false));
        }
        return result;
    }

    WaveformPreview(DataReference reference, Message message) {
        this(reference, message, WaveformFinder.getInstance().getPreferredStyle());
    }

    @API(status=API.Status.STABLE)
    WaveformPreview(DataReference reference, Message message, WaveformFinder.WaveformStyle style) {
        this.isColor = style != WaveformFinder.WaveformStyle.BLUE;
        this.style = style;
        this.dataReference = reference;
        this.rawMessage = message;
        ByteBuffer data = ((BinaryField)this.rawMessage.arguments.get(3)).getValue();
        data.position(style != WaveformFinder.WaveformStyle.BLUE ? 28 : 0);
        this.expandedData = data.slice();
        this.segmentCount = this.getSegmentCount();
        this.maxHeight = this.getMaxHeight();
    }

    @API(status=API.Status.DEPRECATED)
    public WaveformPreview(DataReference reference, RekordboxAnlz anlzFile) {
        this(reference, anlzFile, WaveformFinder.getInstance().getPreferredStyle());
    }

    @API(status=API.Status.STABLE)
    public WaveformPreview(DataReference reference, RekordboxAnlz anlzFile, WaveformFinder.WaveformStyle style) {
        this.dataReference = reference;
        this.rawMessage = null;
        ByteBuffer found = null;
        boolean threeBandFound = false;
        boolean colorFound = false;
        for (RekordboxAnlz.TaggedSection section : anlzFile.sections()) {
            RekordboxAnlz.Wave3bandPreviewTag tag;
            if (style == WaveformFinder.WaveformStyle.THREE_BAND && section.body() instanceof RekordboxAnlz.Wave3bandPreviewTag) {
                tag = (RekordboxAnlz.Wave3bandPreviewTag)section.body();
                found = ByteBuffer.wrap(tag.entries()).asReadOnlyBuffer();
                threeBandFound = true;
                break;
            }
            if (style == WaveformFinder.WaveformStyle.RGB && section.body() instanceof RekordboxAnlz.WaveColorPreviewTag) {
                tag = (RekordboxAnlz.WaveColorPreviewTag)section.body();
                found = ByteBuffer.wrap(tag.entries()).asReadOnlyBuffer();
                colorFound = true;
                break;
            }
            if (!(section.body() instanceof RekordboxAnlz.WavePreviewTag) || (tag = (RekordboxAnlz.WavePreviewTag)section.body()).lenData() < 400L || tag.data() == null) continue;
            byte[] tagBytes = tag.data();
            byte[] bytes = new byte[tagBytes.length * 2];
            for (int i = 0; i < tagBytes.length; ++i) {
                bytes[i * 2] = (byte)(tagBytes[i] & 0x1F);
                bytes[i * 2 + 1] = (byte)(tagBytes[i] >> 5 & 7);
            }
            found = ByteBuffer.wrap(bytes).asReadOnlyBuffer();
        }
        this.expandedData = found;
        this.style = threeBandFound ? WaveformFinder.WaveformStyle.THREE_BAND : (colorFound ? WaveformFinder.WaveformStyle.RGB : WaveformFinder.WaveformStyle.BLUE);
        this.isColor = colorFound;
        if (this.expandedData == null) {
            throw new IllegalStateException("Could not construct WaveformPreview, missing from ANLZ file " + anlzFile);
        }
        this.segmentCount = this.getSegmentCount();
        this.maxHeight = this.getMaxHeight();
    }

    @API(status=API.Status.DEPRECATED)
    public WaveformPreview(DataReference reference, ByteBuffer data, boolean isColor) {
        this(reference, data, isColor ? WaveformFinder.WaveformStyle.RGB : WaveformFinder.WaveformStyle.BLUE);
    }

    @API(status=API.Status.EXPERIMENTAL)
    public WaveformPreview(DataReference reference, ByteBuffer data, WaveformFinder.WaveformStyle style) {
        this.dataReference = reference;
        this.rawMessage = null;
        this.isColor = style == WaveformFinder.WaveformStyle.RGB;
        this.style = style;
        byte[] bytes = new byte[data.remaining()];
        data.get(bytes);
        this.expandedData = ByteBuffer.wrap(bytes).asReadOnlyBuffer();
        this.segmentCount = this.getSegmentCount();
        this.maxHeight = this.getMaxHeight();
    }

    @API(status=API.Status.STABLE)
    public int segmentHeight(int segment, boolean front) {
        ByteBuffer bytes = this.getData();
        switch (this.style) {
            case THREE_BAND: {
                throw new UnsupportedOperationException();
            }
            case RGB: {
                int base = segment * 6;
                int frontHeight = Util.unsign(bytes.get(base + 5));
                if (front) {
                    return frontHeight;
                }
                return Math.max(frontHeight, Math.max(Util.unsign(bytes.get(base + 3)), Util.unsign(bytes.get(base + 4))));
            }
            case BLUE: {
                return this.getData().get(segment * 2) & 0x1F;
            }
        }
        throw new IllegalStateException("Unknown waveform style: " + this.style);
    }

    public int segmentHeight(int segment, WaveformFinder.ThreeBandLayer band) {
        if (this.style != WaveformFinder.WaveformStyle.THREE_BAND) {
            throw new UnsupportedOperationException();
        }
        ByteBuffer bytes = this.getData();
        int base = segment * 3;
        float lowScaled = (float)Util.unsign(bytes.get(base + 2)) * 0.49f;
        if (band == WaveformFinder.ThreeBandLayer.LOW) {
            return Math.round(lowScaled);
        }
        float midScaled = (float)Util.unsign(bytes.get(base)) * 0.32f;
        if (band == WaveformFinder.ThreeBandLayer.MID) {
            return Math.round(lowScaled + midScaled);
        }
        float highScaled = (float)Util.unsign(bytes.get(base + 1)) * 0.25f;
        if (band == WaveformFinder.ThreeBandLayer.HIGH) {
            return Math.round(lowScaled + midScaled + highScaled);
        }
        throw new IllegalStateException("Unrecognized three-band waveform band: " + band);
    }

    @API(status=API.Status.STABLE)
    public Color segmentColor(int segment, boolean front) {
        ByteBuffer bytes = this.getData();
        switch (this.style) {
            case THREE_BAND: {
                throw new UnsupportedOperationException();
            }
            case RGB: {
                int base = segment * 6;
                int backHeight = this.segmentHeight(segment, false);
                if (backHeight == 0) {
                    return Color.BLACK;
                }
                int maxLevel = front ? 255 : 191;
                int red = Util.unsign(bytes.get(base + 3)) * maxLevel / backHeight;
                int green = Util.unsign(bytes.get(base + 4)) * maxLevel / backHeight;
                int blue = Util.unsign(bytes.get(base + 5)) * maxLevel / backHeight;
                return new Color(red, green, blue);
            }
            case BLUE: {
                int intensity = this.getData().get(segment * 2 + 1) & 7;
                return intensity >= 5 ? INTENSE_COLOR : NORMAL_COLOR;
            }
        }
        throw new IllegalStateException("Unknown waveform style: " + this.style);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WaveformPreview)) {
            return false;
        }
        WaveformPreview other = (WaveformPreview)obj;
        return this.getData().equals(other.getData());
    }

    public String toString() {
        return "WaveformPreview[dataReference=" + this.dataReference + ", style: " + this.style + ", size:" + this.getData().remaining() + ", segments:" + this.segmentCount + "]";
    }
}

