/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.dbserver;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.apiguardian.api.API;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.dbserver.BinaryField;
import org.deepsymmetry.beatlink.dbserver.NumberField;
import org.deepsymmetry.beatlink.dbserver.StringField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.STABLE)
public abstract class Field {
    private static final Logger logger = LoggerFactory.getLogger((String)Field.class.getName());

    @API(status=API.Status.STABLE)
    public abstract ByteBuffer getBytes();

    @API(status=API.Status.STABLE)
    public abstract long getSize();

    @API(status=API.Status.STABLE)
    public abstract byte getTypeTag();

    @API(status=API.Status.STABLE)
    public abstract byte getArgumentTag();

    @API(status=API.Status.STABLE)
    public static Field read(DataInputStream is) throws IOException {
        Field result;
        byte tag = is.readByte();
        switch (tag) {
            case 15: 
            case 16: 
            case 17: {
                result = new NumberField(tag, is);
                break;
            }
            case 20: {
                result = new BinaryField(is);
                break;
            }
            case 38: {
                result = new StringField(is);
                break;
            }
            default: {
                throw new IOException("Unable to read a field with type tag " + tag);
            }
        }
        logger.debug("..received> {}", (Object)result);
        return result;
    }

    String getHexString() {
        ByteBuffer bytes = this.getBytes();
        byte[] array = new byte[bytes.remaining()];
        bytes.get(array);
        StringBuilder sb = new StringBuilder();
        for (byte b : array) {
            sb.append(String.format("%02x ", b));
        }
        return sb.toString();
    }

    @API(status=API.Status.STABLE)
    public void write(WritableByteChannel channel) throws IOException {
        logger.debug("..writing> {}", (Object)this);
        Util.writeFully(this.getBytes(), channel);
    }
}

