/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.dbserver;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apiguardian.api.API;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.dbserver.Field;

@API(status=API.Status.STABLE)
public class StringField
extends Field {
    private final byte typeTag = (byte)38;
    private final int size;
    private final String value;
    private final ByteBuffer buffer;

    @API(status=API.Status.STABLE)
    public String getValue() {
        return this.value;
    }

    @API(status=API.Status.STABLE)
    public StringField(DataInputStream is) throws IOException {
        byte[] sizeBytes = new byte[4];
        is.readFully(sizeBytes);
        this.size = (int)Util.bytesToNumber(sizeBytes, 0, 4) * 2;
        byte[] bufBytes = new byte[this.size + 5];
        bufBytes[0] = 38;
        System.arraycopy(sizeBytes, 0, bufBytes, 1, 4);
        is.readFully(bufBytes, 5, this.size);
        this.buffer = ByteBuffer.wrap(bufBytes).asReadOnlyBuffer();
        this.value = new String(bufBytes, 5, this.size - 2, StandardCharsets.UTF_16BE);
    }

    @API(status=API.Status.STABLE)
    public StringField(String text) {
        String delimited = text + "\u0000";
        byte[] bytes = delimited.getBytes(StandardCharsets.UTF_16BE);
        this.size = bytes.length;
        ByteBuffer scratch = ByteBuffer.allocate(this.size + 5);
        scratch.put((byte)38);
        scratch.putInt(this.size / 2);
        scratch.put(bytes);
        this.buffer = scratch.asReadOnlyBuffer();
        this.value = text;
    }

    @Override
    public byte getTypeTag() {
        return 38;
    }

    @Override
    public byte getArgumentTag() {
        return 2;
    }

    @Override
    public ByteBuffer getBytes() {
        this.buffer.rewind();
        return this.buffer.slice();
    }

    @Override
    public long getSize() {
        return this.size;
    }

    public String toString() {
        return "StringField[ size: " + this.size + ", value: \"" + this.value + "\", bytes: " + this.getHexString() + "]";
    }
}

