// This is a generated file! Please edit source .ksy file and use kaitai-struct-compiler to rebuild

package org.deepsymmetry.cratedigger.pdb;

import io.kaitai.struct.ByteBufferKaitaiStream;
import io.kaitai.struct.KaitaiStruct;
import io.kaitai.struct.KaitaiStream;
import java.io.IOException;
import java.util.Map;
import java.util.HashMap;
import java.util.ArrayList;
import java.nio.charset.Charset;


/**
 * These files are created by rekordbox when analyzing audio tracks
 * to facilitate DJ performance. They include waveforms, beat grids
 * (information about the precise time at which each beat occurs),
 * time indices to allow efficient seeking to specific positions
 * inside variable bit-rate audio streams, and lists of memory cues
 * and loop points. They are used by Pioneer professional DJ
 * equipment.
 * 
 * The format has been reverse-engineered to facilitate sophisticated
 * integrations with light and laser shows, videos, and other musical
 * instruments, by supporting deep knowledge of what is playing and
 * what is coming next through monitoring the network communications
 * of the players.
 * @see <a href="https://reverseengineering.stackexchange.com/questions/4311/help-reversing-a-edb-database-file-for-pioneers-rekordbox-software">Source</a>
 */
public class RekordboxAnlz extends KaitaiStruct {
    public static RekordboxAnlz fromFile(String fileName) throws IOException {
        return new RekordboxAnlz(new ByteBufferKaitaiStream(fileName));
    }

    public enum CueEntryStatus {
        DISABLED(0),
        ENABLED(1);

        private final long id;
        CueEntryStatus(long id) { this.id = id; }
        public long id() { return id; }
        private static final Map<Long, CueEntryStatus> byId = new HashMap<Long, CueEntryStatus>(2);
        static {
            for (CueEntryStatus e : CueEntryStatus.values())
                byId.put(e.id(), e);
        }
        public static CueEntryStatus byId(long id) { return byId.get(id); }
    }

    public enum CueListType {
        MEMORY_CUES(0),
        HOT_CUES(1);

        private final long id;
        CueListType(long id) { this.id = id; }
        public long id() { return id; }
        private static final Map<Long, CueListType> byId = new HashMap<Long, CueListType>(2);
        static {
            for (CueListType e : CueListType.values())
                byId.put(e.id(), e);
        }
        public static CueListType byId(long id) { return byId.get(id); }
    }

    public enum PhraseStyle {
        UP_DOWN(1),
        VERSE_BRIDGE(2);

        private final long id;
        PhraseStyle(long id) { this.id = id; }
        public long id() { return id; }
        private static final Map<Long, PhraseStyle> byId = new HashMap<Long, PhraseStyle>(2);
        static {
            for (PhraseStyle e : PhraseStyle.values())
                byId.put(e.id(), e);
        }
        public static PhraseStyle byId(long id) { return byId.get(id); }
    }

    public enum CueEntryType {
        MEMORY_CUE(1),
        LOOP(2);

        private final long id;
        CueEntryType(long id) { this.id = id; }
        public long id() { return id; }
        private static final Map<Long, CueEntryType> byId = new HashMap<Long, CueEntryType>(2);
        static {
            for (CueEntryType e : CueEntryType.values())
                byId.put(e.id(), e);
        }
        public static CueEntryType byId(long id) { return byId.get(id); }
    }

    public enum SectionTags {
        CUES_2(1346588466),
        CUES(1346588482),
        PATH(1347441736),
        BEAT_GRID(1347507290),
        SONG_STRUCTURE(1347638089),
        VBR(1347830354),
        WAVE_PREVIEW(1347895638),
        WAVE_TINY(1347900978),
        WAVE_SCROLL(1347900979),
        WAVE_COLOR_PREVIEW(1347900980),
        WAVE_COLOR_SCROLL(1347900981);

        private final long id;
        SectionTags(long id) { this.id = id; }
        public long id() { return id; }
        private static final Map<Long, SectionTags> byId = new HashMap<Long, SectionTags>(11);
        static {
            for (SectionTags e : SectionTags.values())
                byId.put(e.id(), e);
        }
        public static SectionTags byId(long id) { return byId.get(id); }
    }

    public enum PhraseVerseBridgeId {
        INTRO(1),
        VERSE1(2),
        VERSE2(3),
        VERSE3(4),
        VERSE4(5),
        VERSE5(6),
        VERSE6(7),
        BRIDGE(8),
        CHORUS(9),
        OUTRO(10);

        private final long id;
        PhraseVerseBridgeId(long id) { this.id = id; }
        public long id() { return id; }
        private static final Map<Long, PhraseVerseBridgeId> byId = new HashMap<Long, PhraseVerseBridgeId>(10);
        static {
            for (PhraseVerseBridgeId e : PhraseVerseBridgeId.values())
                byId.put(e.id(), e);
        }
        public static PhraseVerseBridgeId byId(long id) { return byId.get(id); }
    }

    public enum PhraseUpDownId {
        INTRO(1),
        UP(2),
        DOWN(3),
        CHORUS(5),
        OUTRO(6);

        private final long id;
        PhraseUpDownId(long id) { this.id = id; }
        public long id() { return id; }
        private static final Map<Long, PhraseUpDownId> byId = new HashMap<Long, PhraseUpDownId>(5);
        static {
            for (PhraseUpDownId e : PhraseUpDownId.values())
                byId.put(e.id(), e);
        }
        public static PhraseUpDownId byId(long id) { return byId.get(id); }
    }

    public RekordboxAnlz(KaitaiStream _io) {
        this(_io, null, null);
    }

    public RekordboxAnlz(KaitaiStream _io, KaitaiStruct _parent) {
        this(_io, _parent, null);
    }

    public RekordboxAnlz(KaitaiStream _io, KaitaiStruct _parent, RekordboxAnlz _root) {
        super(_io);
        this._parent = _parent;
        this._root = _root == null ? this : _root;
        _read();
    }
    private void _read() {
        this._unnamed0 = this._io.ensureFixedContents(new byte[] { 80, 77, 65, 73 });
        this.lenHeader = this._io.readU4be();
        this.lenFile = this._io.readU4be();
        this._unnamed3 = this._io.readBytes((lenHeader() - _io().pos()));
        this.sections = new ArrayList<TaggedSection>();
        {
            int i = 0;
            while (!this._io.isEof()) {
                this.sections.add(new TaggedSection(this._io, this, _root));
                i++;
            }
        }
    }
    public static class PhraseUpDown extends KaitaiStruct {
        public static PhraseUpDown fromFile(String fileName) throws IOException {
            return new PhraseUpDown(new ByteBufferKaitaiStream(fileName));
        }

        public PhraseUpDown(KaitaiStream _io) {
            this(_io, null, null);
        }

        public PhraseUpDown(KaitaiStream _io, RekordboxAnlz.SongStructureEntry _parent) {
            this(_io, _parent, null);
        }

        public PhraseUpDown(KaitaiStream _io, RekordboxAnlz.SongStructureEntry _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            _read();
        }
        private void _read() {
            this.id = RekordboxAnlz.PhraseUpDownId.byId(this._io.readU2be());
        }
        private PhraseUpDownId id;
        private RekordboxAnlz _root;
        private RekordboxAnlz.SongStructureEntry _parent;
        public PhraseUpDownId id() { return id; }
        public RekordboxAnlz _root() { return _root; }
        public RekordboxAnlz.SongStructureEntry _parent() { return _parent; }
    }

    /**
     * Stores the file path of the audio file to which this analysis
     * applies.
     */
    public static class PathTag extends KaitaiStruct {
        public static PathTag fromFile(String fileName) throws IOException {
            return new PathTag(new ByteBufferKaitaiStream(fileName));
        }

        public PathTag(KaitaiStream _io) {
            this(_io, null, null);
        }

        public PathTag(KaitaiStream _io, RekordboxAnlz.TaggedSection _parent) {
            this(_io, _parent, null);
        }

        public PathTag(KaitaiStream _io, RekordboxAnlz.TaggedSection _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            _read();
        }
        private void _read() {
            this.lenPath = this._io.readU4be();
            if (lenPath() > 1) {
                this.path = new String(this._io.readBytes((lenPath() - 2)), Charset.forName("utf-16be"));
            }
        }
        private long lenPath;
        private String path;
        private RekordboxAnlz _root;
        private RekordboxAnlz.TaggedSection _parent;
        public long lenPath() { return lenPath; }
        public String path() { return path; }
        public RekordboxAnlz _root() { return _root; }
        public RekordboxAnlz.TaggedSection _parent() { return _parent; }
    }

    /**
     * Stores a waveform preview image suitable for display above
     * the touch strip for jumping to a track position.
     */
    public static class WavePreviewTag extends KaitaiStruct {
        public static WavePreviewTag fromFile(String fileName) throws IOException {
            return new WavePreviewTag(new ByteBufferKaitaiStream(fileName));
        }

        public WavePreviewTag(KaitaiStream _io) {
            this(_io, null, null);
        }

        public WavePreviewTag(KaitaiStream _io, RekordboxAnlz.TaggedSection _parent) {
            this(_io, _parent, null);
        }

        public WavePreviewTag(KaitaiStream _io, RekordboxAnlz.TaggedSection _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            _read();
        }
        private void _read() {
            this.lenPreview = this._io.readU4be();
            this._unnamed1 = this._io.readU4be();
            this.data = this._io.readBytes(lenPreview());
        }
        private long lenPreview;
        private long _unnamed1;
        private byte[] data;
        private RekordboxAnlz _root;
        private RekordboxAnlz.TaggedSection _parent;

        /**
         * The length, in bytes, of the preview data itself. This is
         * slightly redundant because it can be computed from the
         * length of the tag.
         */
        public long lenPreview() { return lenPreview; }
        public long _unnamed1() { return _unnamed1; }

        /**
         * The actual bytes of the waveform preview.
         */
        public byte[] data() { return data; }
        public RekordboxAnlz _root() { return _root; }
        public RekordboxAnlz.TaggedSection _parent() { return _parent; }
    }

    /**
     * Holds a list of all the beats found within the track, recording
     * their bar position, the time at which they occur, and the tempo
     * at that point.
     */
    public static class BeatGridTag extends KaitaiStruct {
        public static BeatGridTag fromFile(String fileName) throws IOException {
            return new BeatGridTag(new ByteBufferKaitaiStream(fileName));
        }

        public BeatGridTag(KaitaiStream _io) {
            this(_io, null, null);
        }

        public BeatGridTag(KaitaiStream _io, RekordboxAnlz.TaggedSection _parent) {
            this(_io, _parent, null);
        }

        public BeatGridTag(KaitaiStream _io, RekordboxAnlz.TaggedSection _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            _read();
        }
        private void _read() {
            this._unnamed0 = this._io.readU4be();
            this._unnamed1 = this._io.readU4be();
            this.lenBeats = this._io.readU4be();
            beats = new ArrayList<BeatGridBeat>((int) (lenBeats()));
            for (int i = 0; i < lenBeats(); i++) {
                this.beats.add(new BeatGridBeat(this._io, this, _root));
            }
        }
        private long _unnamed0;
        private long _unnamed1;
        private long lenBeats;
        private ArrayList<BeatGridBeat> beats;
        private RekordboxAnlz _root;
        private RekordboxAnlz.TaggedSection _parent;
        public long _unnamed0() { return _unnamed0; }
        public long _unnamed1() { return _unnamed1; }

        /**
         * The number of beat entries which follow.
         */
        public long lenBeats() { return lenBeats; }

        /**
         * The entries of the beat grid.
         */
        public ArrayList<BeatGridBeat> beats() { return beats; }
        public RekordboxAnlz _root() { return _root; }
        public RekordboxAnlz.TaggedSection _parent() { return _parent; }
    }

    /**
     * A larger, colorful waveform preview image suitable for display
     * above the touch strip for jumping to a track position on newer
     * high-resolution players.
     */
    public static class WaveColorPreviewTag extends KaitaiStruct {
        public static WaveColorPreviewTag fromFile(String fileName) throws IOException {
            return new WaveColorPreviewTag(new ByteBufferKaitaiStream(fileName));
        }

        public WaveColorPreviewTag(KaitaiStream _io) {
            this(_io, null, null);
        }

        public WaveColorPreviewTag(KaitaiStream _io, RekordboxAnlz.TaggedSection _parent) {
            this(_io, _parent, null);
        }

        public WaveColorPreviewTag(KaitaiStream _io, RekordboxAnlz.TaggedSection _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            _read();
        }
        private void _read() {
            this.lenEntryBytes = this._io.readU4be();
            this.lenEntries = this._io.readU4be();
            this._unnamed2 = this._io.readU4be();
            this.entries = this._io.readBytes((lenEntries() * lenEntryBytes()));
        }
        private long lenEntryBytes;
        private long lenEntries;
        private long _unnamed2;
        private byte[] entries;
        private RekordboxAnlz _root;
        private RekordboxAnlz.TaggedSection _parent;

        /**
         * The size of each entry, in bytes. Seems to always be 6.
         */
        public long lenEntryBytes() { return lenEntryBytes; }

        /**
         * The number of waveform data points, each of which takes one
         * byte for each of six channels of information.
         */
        public long lenEntries() { return lenEntries; }
        public long _unnamed2() { return _unnamed2; }
        public byte[] entries() { return entries; }
        public RekordboxAnlz _root() { return _root; }
        public RekordboxAnlz.TaggedSection _parent() { return _parent; }
    }

    /**
     * A larger waveform image suitable for scrolling along as a track
     * plays.
     */
    public static class WaveScrollTag extends KaitaiStruct {
        public static WaveScrollTag fromFile(String fileName) throws IOException {
            return new WaveScrollTag(new ByteBufferKaitaiStream(fileName));
        }

        public WaveScrollTag(KaitaiStream _io) {
            this(_io, null, null);
        }

        public WaveScrollTag(KaitaiStream _io, RekordboxAnlz.TaggedSection _parent) {
            this(_io, _parent, null);
        }

        public WaveScrollTag(KaitaiStream _io, RekordboxAnlz.TaggedSection _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            _read();
        }
        private void _read() {
            this.lenEntryBytes = this._io.readU4be();
            this.lenEntries = this._io.readU4be();
            this._unnamed2 = this._io.readU4be();
            this.entries = this._io.readBytes((lenEntries() * lenEntryBytes()));
        }
        private long lenEntryBytes;
        private long lenEntries;
        private long _unnamed2;
        private byte[] entries;
        private RekordboxAnlz _root;
        private RekordboxAnlz.TaggedSection _parent;

        /**
         * The size of each entry, in bytes. Seems to always be 1.
         */
        public long lenEntryBytes() { return lenEntryBytes; }

        /**
         * The number of waveform data points, each of which takes one
         * byte.
         */
        public long lenEntries() { return lenEntries; }
        public long _unnamed2() { return _unnamed2; }
        public byte[] entries() { return entries; }
        public RekordboxAnlz _root() { return _root; }
        public RekordboxAnlz.TaggedSection _parent() { return _parent; }
    }
    public static class PhraseVerseBridge extends KaitaiStruct {
        public static PhraseVerseBridge fromFile(String fileName) throws IOException {
            return new PhraseVerseBridge(new ByteBufferKaitaiStream(fileName));
        }

        public PhraseVerseBridge(KaitaiStream _io) {
            this(_io, null, null);
        }

        public PhraseVerseBridge(KaitaiStream _io, RekordboxAnlz.SongStructureEntry _parent) {
            this(_io, _parent, null);
        }

        public PhraseVerseBridge(KaitaiStream _io, RekordboxAnlz.SongStructureEntry _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            _read();
        }
        private void _read() {
            this.id = RekordboxAnlz.PhraseVerseBridgeId.byId(this._io.readU2be());
        }
        private PhraseVerseBridgeId id;
        private RekordboxAnlz _root;
        private RekordboxAnlz.SongStructureEntry _parent;
        public PhraseVerseBridgeId id() { return id; }
        public RekordboxAnlz _root() { return _root; }
        public RekordboxAnlz.SongStructureEntry _parent() { return _parent; }
    }

    /**
     * Stores the song structure, also known as phrases (intro, verse, 
     * bridge, chorus, up, down, outro).
     */
    public static class SongStructureTag extends KaitaiStruct {
        public static SongStructureTag fromFile(String fileName) throws IOException {
            return new SongStructureTag(new ByteBufferKaitaiStream(fileName));
        }

        public SongStructureTag(KaitaiStream _io) {
            this(_io, null, null);
        }

        public SongStructureTag(KaitaiStream _io, RekordboxAnlz.TaggedSection _parent) {
            this(_io, _parent, null);
        }

        public SongStructureTag(KaitaiStream _io, RekordboxAnlz.TaggedSection _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            _read();
        }
        private void _read() {
            this.lenEntryBytes = this._io.readU4be();
            this.lenEntries = this._io.readU2be();
            this.style = RekordboxAnlz.PhraseStyle.byId(this._io.readU2be());
            this._unnamed3 = this._io.readBytes(6);
            this.endBeat = this._io.readU2be();
            this._unnamed5 = this._io.readBytes(4);
            entries = new ArrayList<SongStructureEntry>((int) (lenEntries()));
            for (int i = 0; i < lenEntries(); i++) {
                this.entries.add(new SongStructureEntry(this._io, this, _root));
            }
        }
        private long lenEntryBytes;
        private int lenEntries;
        private PhraseStyle style;
        private byte[] _unnamed3;
        private int endBeat;
        private byte[] _unnamed5;
        private ArrayList<SongStructureEntry> entries;
        private RekordboxAnlz _root;
        private RekordboxAnlz.TaggedSection _parent;

        /**
         * The size of each entry, in bytes. Seems to always be 24.
         */
        public long lenEntryBytes() { return lenEntryBytes; }

        /**
         * The number of phrases.
         */
        public int lenEntries() { return lenEntries; }

        /**
         * The phrase style. 1 is the up-down style
         * (white label text in rekordbox) where the main phrases consist
         * of up, down, and chorus. 2 is the bridge-verse style
         * (black label text in rekordbox) where the main phrases consist
         * of verse, chorus, and bridge. Style 3 is mostly identical to
         * bridge-verse style except verses 1-3 are labeled VERSE1 and verses
         * 4-6 are labeled VERSE2 in rekordbox.
         */
        public PhraseStyle style() { return style; }
        public byte[] _unnamed3() { return _unnamed3; }

        /**
         * The beat number at which the last phrase ends. The track may
         * continue after the last phrase ends. If this is the case, it will
         * mostly be silence.
         */
        public int endBeat() { return endBeat; }
        public byte[] _unnamed5() { return _unnamed5; }
        public ArrayList<SongStructureEntry> entries() { return entries; }
        public RekordboxAnlz _root() { return _root; }
        public RekordboxAnlz.TaggedSection _parent() { return _parent; }
    }

    /**
     * A cue extended list entry. Can either describe a memory cue or a
     * loop.
     */
    public static class CueExtendedEntry extends KaitaiStruct {
        public static CueExtendedEntry fromFile(String fileName) throws IOException {
            return new CueExtendedEntry(new ByteBufferKaitaiStream(fileName));
        }

        public CueExtendedEntry(KaitaiStream _io) {
            this(_io, null, null);
        }

        public CueExtendedEntry(KaitaiStream _io, RekordboxAnlz.CueExtendedTag _parent) {
            this(_io, _parent, null);
        }

        public CueExtendedEntry(KaitaiStream _io, RekordboxAnlz.CueExtendedTag _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            _read();
        }
        private void _read() {
            this._unnamed0 = this._io.ensureFixedContents(new byte[] { 80, 67, 80, 50 });
            this.lenHeader = this._io.readU4be();
            this.lenEntry = this._io.readU4be();
            this.hotCue = this._io.readU4be();
            this.type = RekordboxAnlz.CueEntryType.byId(this._io.readU1());
            this._unnamed5 = this._io.readBytes(3);
            this.time = this._io.readU4be();
            this.loopTime = this._io.readU4be();
            this._unnamed8 = this._io.readBytes(12);
            this.lenComment = this._io.readU4be();
            this.comment = new String(this._io.readBytes(lenComment()), Charset.forName("utf-16be"));
            if ((lenEntry() - lenComment()) > 44) {
                this.colorCode = this._io.readU1();
            }
            if ((lenEntry() - lenComment()) > 45) {
                this.colorRed = this._io.readU1();
            }
            if ((lenEntry() - lenComment()) > 46) {
                this.colorGreen = this._io.readU1();
            }
            if ((lenEntry() - lenComment()) > 47) {
                this.colorBlue = this._io.readU1();
            }
            if ((lenEntry() - lenComment()) > 48) {
                this._unnamed15 = this._io.readBytes(((lenEntry() - 48) - lenComment()));
            }
        }
        private byte[] _unnamed0;
        private long lenHeader;
        private long lenEntry;
        private long hotCue;
        private CueEntryType type;
        private byte[] _unnamed5;
        private long time;
        private long loopTime;
        private byte[] _unnamed8;
        private long lenComment;
        private String comment;
        private Integer colorCode;
        private Integer colorRed;
        private Integer colorGreen;
        private Integer colorBlue;
        private byte[] _unnamed15;
        private RekordboxAnlz _root;
        private RekordboxAnlz.CueExtendedTag _parent;
        public byte[] _unnamed0() { return _unnamed0; }
        public long lenHeader() { return lenHeader; }
        public long lenEntry() { return lenEntry; }

        /**
         * If zero, this is an ordinary memory cue, otherwise this a
         * hot cue with the specified number.
         */
        public long hotCue() { return hotCue; }

        /**
         * Indicates whether this is a memory cue or a loop.
         */
        public CueEntryType type() { return type; }
        public byte[] _unnamed5() { return _unnamed5; }

        /**
         * The position, in milliseconds, at which the cue point lies
         * in the track.
         */
        public long time() { return time; }

        /**
         * The position, in milliseconds, at which the player loops
         * back to the cue time if this is a loop.
         */
        public long loopTime() { return loopTime; }
        public byte[] _unnamed8() { return _unnamed8; }
        public long lenComment() { return lenComment; }

        /**
         * The comment assigned to this cue by the DJ, if any, with a trailing NUL.
         */
        public String comment() { return comment; }

        /**
         * A lookup value for a color table? We use this to index to the colors shown in rekordbox.
         */
        public Integer colorCode() { return colorCode; }

        /**
         * The red component of the color to be displayed.
         */
        public Integer colorRed() { return colorRed; }

        /**
         * The green component of the color to be displayed.
         */
        public Integer colorGreen() { return colorGreen; }

        /**
         * The blue component of the color to be displayed.
         */
        public Integer colorBlue() { return colorBlue; }
        public byte[] _unnamed15() { return _unnamed15; }
        public RekordboxAnlz _root() { return _root; }
        public RekordboxAnlz.CueExtendedTag _parent() { return _parent; }
    }

    /**
     * Stores an index allowing rapid seeking to particular times
     * within a variable-bitrate audio file.
     */
    public static class VbrTag extends KaitaiStruct {
        public static VbrTag fromFile(String fileName) throws IOException {
            return new VbrTag(new ByteBufferKaitaiStream(fileName));
        }

        public VbrTag(KaitaiStream _io) {
            this(_io, null, null);
        }

        public VbrTag(KaitaiStream _io, RekordboxAnlz.TaggedSection _parent) {
            this(_io, _parent, null);
        }

        public VbrTag(KaitaiStream _io, RekordboxAnlz.TaggedSection _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            _read();
        }
        private void _read() {
            this._unnamed0 = this._io.readU4be();
            index = new ArrayList<Long>((int) (400));
            for (int i = 0; i < 400; i++) {
                this.index.add(this._io.readU4be());
            }
        }
        private long _unnamed0;
        private ArrayList<Long> index;
        private RekordboxAnlz _root;
        private RekordboxAnlz.TaggedSection _parent;
        public long _unnamed0() { return _unnamed0; }
        public ArrayList<Long> index() { return index; }
        public RekordboxAnlz _root() { return _root; }
        public RekordboxAnlz.TaggedSection _parent() { return _parent; }
    }

    /**
     * A song structure entry, represents a single phrase.
     */
    public static class SongStructureEntry extends KaitaiStruct {
        public static SongStructureEntry fromFile(String fileName) throws IOException {
            return new SongStructureEntry(new ByteBufferKaitaiStream(fileName));
        }

        public SongStructureEntry(KaitaiStream _io) {
            this(_io, null, null);
        }

        public SongStructureEntry(KaitaiStream _io, RekordboxAnlz.SongStructureTag _parent) {
            this(_io, _parent, null);
        }

        public SongStructureEntry(KaitaiStream _io, RekordboxAnlz.SongStructureTag _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            _read();
        }
        private void _read() {
            this.phraseNumber = this._io.readU2be();
            this.beatNumber = this._io.readU2be();
            switch (_parent().style()) {
            case UP_DOWN: {
                this.phraseId = new PhraseUpDown(this._io, this, _root);
                break;
            }
            case VERSE_BRIDGE: {
                this.phraseId = new PhraseVerseBridge(this._io, this, _root);
                break;
            }
            default: {
                this.phraseId = new PhraseVerseBridge(this._io, this, _root);
                break;
            }
            }
            this._unnamed3 = this._io.readBytes((_parent().lenEntryBytes() - 9));
            this.fillIn = this._io.readU1();
            this.fillInBeatNumber = this._io.readU2be();
        }
        private int phraseNumber;
        private int beatNumber;
        private KaitaiStruct phraseId;
        private byte[] _unnamed3;
        private int fillIn;
        private int fillInBeatNumber;
        private RekordboxAnlz _root;
        private RekordboxAnlz.SongStructureTag _parent;

        /**
         * The absolute number of the phrase, starting at one.
         */
        public int phraseNumber() { return phraseNumber; }

        /**
         * The beat number at which the phrase starts.
         */
        public int beatNumber() { return beatNumber; }

        /**
         * Identifier of the phrase label.
         */
        public KaitaiStruct phraseId() { return phraseId; }
        public byte[] _unnamed3() { return _unnamed3; }

        /**
         * If nonzero, fill-in is present.
         */
        public int fillIn() { return fillIn; }

        /**
         * The beat number at which fill-in starts.
         */
        public int fillInBeatNumber() { return fillInBeatNumber; }
        public RekordboxAnlz _root() { return _root; }
        public RekordboxAnlz.SongStructureTag _parent() { return _parent; }
    }

    /**
     * A cue list entry. Can either represent a memory cue or a loop.
     */
    public static class CueEntry extends KaitaiStruct {
        public static CueEntry fromFile(String fileName) throws IOException {
            return new CueEntry(new ByteBufferKaitaiStream(fileName));
        }

        public CueEntry(KaitaiStream _io) {
            this(_io, null, null);
        }

        public CueEntry(KaitaiStream _io, RekordboxAnlz.CueTag _parent) {
            this(_io, _parent, null);
        }

        public CueEntry(KaitaiStream _io, RekordboxAnlz.CueTag _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            _read();
        }
        private void _read() {
            this._unnamed0 = this._io.ensureFixedContents(new byte[] { 80, 67, 80, 84 });
            this.lenHeader = this._io.readU4be();
            this.lenEntry = this._io.readU4be();
            this.hotCue = this._io.readU4be();
            this.status = RekordboxAnlz.CueEntryStatus.byId(this._io.readU4be());
            this._unnamed5 = this._io.readU4be();
            this.orderFirst = this._io.readU2be();
            this.orderLast = this._io.readU2be();
            this.type = RekordboxAnlz.CueEntryType.byId(this._io.readU1());
            this._unnamed9 = this._io.readBytes(3);
            this.time = this._io.readU4be();
            this.loopTime = this._io.readU4be();
            this._unnamed12 = this._io.readBytes(16);
        }
        private byte[] _unnamed0;
        private long lenHeader;
        private long lenEntry;
        private long hotCue;
        private CueEntryStatus status;
        private long _unnamed5;
        private int orderFirst;
        private int orderLast;
        private CueEntryType type;
        private byte[] _unnamed9;
        private long time;
        private long loopTime;
        private byte[] _unnamed12;
        private RekordboxAnlz _root;
        private RekordboxAnlz.CueTag _parent;
        public byte[] _unnamed0() { return _unnamed0; }
        public long lenHeader() { return lenHeader; }
        public long lenEntry() { return lenEntry; }

        /**
         * If zero, this is an ordinary memory cue, otherwise this a
         * hot cue with the specified number.
         */
        public long hotCue() { return hotCue; }

        /**
         * If zero, this entry should be ignored.
         */
        public CueEntryStatus status() { return status; }
        public long _unnamed5() { return _unnamed5; }

        /**
         * @flesniak says: "0xffff for first cue, 0,1,3 for next"
         */
        public int orderFirst() { return orderFirst; }

        /**
         * @flesniak says: "1,2,3 for first, second, third cue, 0xffff for last"
         */
        public int orderLast() { return orderLast; }

        /**
         * Indicates whether this is a memory cue or a loop.
         */
        public CueEntryType type() { return type; }
        public byte[] _unnamed9() { return _unnamed9; }

        /**
         * The position, in milliseconds, at which the cue point lies
         * in the track.
         */
        public long time() { return time; }

        /**
         * The position, in milliseconds, at which the player loops
         * back to the cue time if this is a loop.
         */
        public long loopTime() { return loopTime; }
        public byte[] _unnamed12() { return _unnamed12; }
        public RekordboxAnlz _root() { return _root; }
        public RekordboxAnlz.CueTag _parent() { return _parent; }
    }

    /**
     * Describes an individual beat in a beat grid.
     */
    public static class BeatGridBeat extends KaitaiStruct {
        public static BeatGridBeat fromFile(String fileName) throws IOException {
            return new BeatGridBeat(new ByteBufferKaitaiStream(fileName));
        }

        public BeatGridBeat(KaitaiStream _io) {
            this(_io, null, null);
        }

        public BeatGridBeat(KaitaiStream _io, RekordboxAnlz.BeatGridTag _parent) {
            this(_io, _parent, null);
        }

        public BeatGridBeat(KaitaiStream _io, RekordboxAnlz.BeatGridTag _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            _read();
        }
        private void _read() {
            this.beatNumber = this._io.readU2be();
            this.tempo = this._io.readU2be();
            this.time = this._io.readU4be();
        }
        private int beatNumber;
        private int tempo;
        private long time;
        private RekordboxAnlz _root;
        private RekordboxAnlz.BeatGridTag _parent;

        /**
         * The position of the beat within its musical bar, where beat 1
         * is the down beat.
         */
        public int beatNumber() { return beatNumber; }

        /**
         * The tempo at the time of this beat, in beats per minute,
         * multiplied by 100.
         */
        public int tempo() { return tempo; }

        /**
         * The time, in milliseconds, at which this beat occurs when
         * the track is played at normal (100%) pitch.
         */
        public long time() { return time; }
        public RekordboxAnlz _root() { return _root; }
        public RekordboxAnlz.BeatGridTag _parent() { return _parent; }
    }

    /**
     * A variation of cue_tag which was introduced with the nxs2 line,
     * and adds descriptive names. (Still comes in two forms, either
     * holding memory cues and loop points, or holding hot cues and
     * loop points.) Also includes hot cues D through H and color assignment.
     */
    public static class CueExtendedTag extends KaitaiStruct {
        public static CueExtendedTag fromFile(String fileName) throws IOException {
            return new CueExtendedTag(new ByteBufferKaitaiStream(fileName));
        }

        public CueExtendedTag(KaitaiStream _io) {
            this(_io, null, null);
        }

        public CueExtendedTag(KaitaiStream _io, RekordboxAnlz.TaggedSection _parent) {
            this(_io, _parent, null);
        }

        public CueExtendedTag(KaitaiStream _io, RekordboxAnlz.TaggedSection _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            _read();
        }
        private void _read() {
            this.type = RekordboxAnlz.CueListType.byId(this._io.readU4be());
            this.lenCues = this._io.readU2be();
            this._unnamed2 = this._io.readBytes(2);
            cues = new ArrayList<CueExtendedEntry>((int) (lenCues()));
            for (int i = 0; i < lenCues(); i++) {
                this.cues.add(new CueExtendedEntry(this._io, this, _root));
            }
        }
        private CueListType type;
        private int lenCues;
        private byte[] _unnamed2;
        private ArrayList<CueExtendedEntry> cues;
        private RekordboxAnlz _root;
        private RekordboxAnlz.TaggedSection _parent;

        /**
         * Identifies whether this tag stores ordinary or hot cues.
         */
        public CueListType type() { return type; }

        /**
         * The length of the cue comment list.
         */
        public int lenCues() { return lenCues; }
        public byte[] _unnamed2() { return _unnamed2; }
        public ArrayList<CueExtendedEntry> cues() { return cues; }
        public RekordboxAnlz _root() { return _root; }
        public RekordboxAnlz.TaggedSection _parent() { return _parent; }
    }
    public static class UnknownTag extends KaitaiStruct {
        public static UnknownTag fromFile(String fileName) throws IOException {
            return new UnknownTag(new ByteBufferKaitaiStream(fileName));
        }

        public UnknownTag(KaitaiStream _io) {
            this(_io, null, null);
        }

        public UnknownTag(KaitaiStream _io, RekordboxAnlz.TaggedSection _parent) {
            this(_io, _parent, null);
        }

        public UnknownTag(KaitaiStream _io, RekordboxAnlz.TaggedSection _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            _read();
        }
        private void _read() {
        }
        private RekordboxAnlz _root;
        private RekordboxAnlz.TaggedSection _parent;
        public RekordboxAnlz _root() { return _root; }
        public RekordboxAnlz.TaggedSection _parent() { return _parent; }
    }

    /**
     * A type-tagged file section, identified by a four-byte magic
     * sequence, with a header specifying its length, and whose payload
     * is determined by the type tag.
     */
    public static class TaggedSection extends KaitaiStruct {
        public static TaggedSection fromFile(String fileName) throws IOException {
            return new TaggedSection(new ByteBufferKaitaiStream(fileName));
        }

        public TaggedSection(KaitaiStream _io) {
            this(_io, null, null);
        }

        public TaggedSection(KaitaiStream _io, RekordboxAnlz _parent) {
            this(_io, _parent, null);
        }

        public TaggedSection(KaitaiStream _io, RekordboxAnlz _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            _read();
        }
        private void _read() {
            this.fourcc = this._io.readS4be();
            this.lenHeader = this._io.readU4be();
            this.lenTag = this._io.readU4be();
            switch (fourcc()) {
            case 1346588482: {
                this._raw_body = this._io.readBytes((lenTag() - 12));
                KaitaiStream _io__raw_body = new ByteBufferKaitaiStream(_raw_body);
                this.body = new CueTag(_io__raw_body, this, _root);
                break;
            }
            case 1347900978: {
                this._raw_body = this._io.readBytes((lenTag() - 12));
                KaitaiStream _io__raw_body = new ByteBufferKaitaiStream(_raw_body);
                this.body = new WavePreviewTag(_io__raw_body, this, _root);
                break;
            }
            case 1347900980: {
                this._raw_body = this._io.readBytes((lenTag() - 12));
                KaitaiStream _io__raw_body = new ByteBufferKaitaiStream(_raw_body);
                this.body = new WaveColorPreviewTag(_io__raw_body, this, _root);
                break;
            }
            case 1347895638: {
                this._raw_body = this._io.readBytes((lenTag() - 12));
                KaitaiStream _io__raw_body = new ByteBufferKaitaiStream(_raw_body);
                this.body = new WavePreviewTag(_io__raw_body, this, _root);
                break;
            }
            case 1347900979: {
                this._raw_body = this._io.readBytes((lenTag() - 12));
                KaitaiStream _io__raw_body = new ByteBufferKaitaiStream(_raw_body);
                this.body = new WaveScrollTag(_io__raw_body, this, _root);
                break;
            }
            case 1347638089: {
                this._raw_body = this._io.readBytes((lenTag() - 12));
                KaitaiStream _io__raw_body = new ByteBufferKaitaiStream(_raw_body);
                this.body = new SongStructureTag(_io__raw_body, this, _root);
                break;
            }
            case 1347507290: {
                this._raw_body = this._io.readBytes((lenTag() - 12));
                KaitaiStream _io__raw_body = new ByteBufferKaitaiStream(_raw_body);
                this.body = new BeatGridTag(_io__raw_body, this, _root);
                break;
            }
            case 1347830354: {
                this._raw_body = this._io.readBytes((lenTag() - 12));
                KaitaiStream _io__raw_body = new ByteBufferKaitaiStream(_raw_body);
                this.body = new VbrTag(_io__raw_body, this, _root);
                break;
            }
            case 1347900981: {
                this._raw_body = this._io.readBytes((lenTag() - 12));
                KaitaiStream _io__raw_body = new ByteBufferKaitaiStream(_raw_body);
                this.body = new WaveColorScrollTag(_io__raw_body, this, _root);
                break;
            }
            case 1346588466: {
                this._raw_body = this._io.readBytes((lenTag() - 12));
                KaitaiStream _io__raw_body = new ByteBufferKaitaiStream(_raw_body);
                this.body = new CueExtendedTag(_io__raw_body, this, _root);
                break;
            }
            case 1347441736: {
                this._raw_body = this._io.readBytes((lenTag() - 12));
                KaitaiStream _io__raw_body = new ByteBufferKaitaiStream(_raw_body);
                this.body = new PathTag(_io__raw_body, this, _root);
                break;
            }
            default: {
                this._raw_body = this._io.readBytes((lenTag() - 12));
                KaitaiStream _io__raw_body = new ByteBufferKaitaiStream(_raw_body);
                this.body = new UnknownTag(_io__raw_body, this, _root);
                break;
            }
            }
        }
        private int fourcc;
        private long lenHeader;
        private long lenTag;
        private KaitaiStruct body;
        private RekordboxAnlz _root;
        private RekordboxAnlz _parent;
        private byte[] _raw_body;

        /**
         * A tag value indicating what kind of section this is.
         */
        public int fourcc() { return fourcc; }

        /**
         * The size, in bytes, of the header portion of the tag.
         */
        public long lenHeader() { return lenHeader; }

        /**
         * The size, in bytes, of this entire tag, counting the header.
         */
        public long lenTag() { return lenTag; }
        public KaitaiStruct body() { return body; }
        public RekordboxAnlz _root() { return _root; }
        public RekordboxAnlz _parent() { return _parent; }
        public byte[] _raw_body() { return _raw_body; }
    }

    /**
     * A larger, colorful waveform image suitable for scrolling along
     * as a track plays on newer high-resolution hardware. Also
     * contains a higher-resolution blue/white waveform.
     */
    public static class WaveColorScrollTag extends KaitaiStruct {
        public static WaveColorScrollTag fromFile(String fileName) throws IOException {
            return new WaveColorScrollTag(new ByteBufferKaitaiStream(fileName));
        }

        public WaveColorScrollTag(KaitaiStream _io) {
            this(_io, null, null);
        }

        public WaveColorScrollTag(KaitaiStream _io, RekordboxAnlz.TaggedSection _parent) {
            this(_io, _parent, null);
        }

        public WaveColorScrollTag(KaitaiStream _io, RekordboxAnlz.TaggedSection _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            _read();
        }
        private void _read() {
            this.lenEntryBytes = this._io.readU4be();
            this.lenEntries = this._io.readU4be();
            this._unnamed2 = this._io.readU4be();
            this.entries = this._io.readBytes((lenEntries() * lenEntryBytes()));
        }
        private long lenEntryBytes;
        private long lenEntries;
        private long _unnamed2;
        private byte[] entries;
        private RekordboxAnlz _root;
        private RekordboxAnlz.TaggedSection _parent;

        /**
         * The size of each entry, in bytes. Seems to always be 2.
         */
        public long lenEntryBytes() { return lenEntryBytes; }

        /**
         * The number of columns of waveform data (this matches the
         * non-color waveform length.
         */
        public long lenEntries() { return lenEntries; }
        public long _unnamed2() { return _unnamed2; }
        public byte[] entries() { return entries; }
        public RekordboxAnlz _root() { return _root; }
        public RekordboxAnlz.TaggedSection _parent() { return _parent; }
    }

    /**
     * Stores either a list of ordinary memory cues and loop points, or
     * a list of hot cues and loop points.
     */
    public static class CueTag extends KaitaiStruct {
        public static CueTag fromFile(String fileName) throws IOException {
            return new CueTag(new ByteBufferKaitaiStream(fileName));
        }

        public CueTag(KaitaiStream _io) {
            this(_io, null, null);
        }

        public CueTag(KaitaiStream _io, RekordboxAnlz.TaggedSection _parent) {
            this(_io, _parent, null);
        }

        public CueTag(KaitaiStream _io, RekordboxAnlz.TaggedSection _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            _read();
        }
        private void _read() {
            this.type = RekordboxAnlz.CueListType.byId(this._io.readU4be());
            this.lenCues = this._io.readU4be();
            this.memoryCount = this._io.readU4be();
            cues = new ArrayList<CueEntry>((int) (lenCues()));
            for (int i = 0; i < lenCues(); i++) {
                this.cues.add(new CueEntry(this._io, this, _root));
            }
        }
        private CueListType type;
        private long lenCues;
        private long memoryCount;
        private ArrayList<CueEntry> cues;
        private RekordboxAnlz _root;
        private RekordboxAnlz.TaggedSection _parent;

        /**
         * Identifies whether this tag stores ordinary or hot cues.
         */
        public CueListType type() { return type; }

        /**
         * The length of the cue list.
         */
        public long lenCues() { return lenCues; }

        /**
         * Unsure what this means.
         */
        public long memoryCount() { return memoryCount; }
        public ArrayList<CueEntry> cues() { return cues; }
        public RekordboxAnlz _root() { return _root; }
        public RekordboxAnlz.TaggedSection _parent() { return _parent; }
    }
    private byte[] _unnamed0;
    private long lenHeader;
    private long lenFile;
    private byte[] _unnamed3;
    private ArrayList<TaggedSection> sections;
    private RekordboxAnlz _root;
    private KaitaiStruct _parent;
    public byte[] _unnamed0() { return _unnamed0; }

    /**
     * The number of bytes of this header section.
     */
    public long lenHeader() { return lenHeader; }

    /**
     * The number of bytes in the entire file.
     */
    public long lenFile() { return lenFile; }
    public byte[] _unnamed3() { return _unnamed3; }

    /**
     * The remainder of the file is a sequence of type-tagged sections,
     * identified by a four-byte magic sequence.
     */
    public ArrayList<TaggedSection> sections() { return sections; }
    public RekordboxAnlz _root() { return _root; }
    public KaitaiStruct _parent() { return _parent; }
}
