/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.cratedigger.pdb;

import io.kaitai.struct.ByteBufferKaitaiStream;
import io.kaitai.struct.KaitaiStream;
import io.kaitai.struct.KaitaiStruct;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class RekordboxPdb
extends KaitaiStruct {
    private long _unnamed0;
    private long lenPage;
    private long numTables;
    private long nextUnusedPage;
    private long _unnamed4;
    private long sequence;
    private byte[] gap;
    private ArrayList<Table> tables;
    private RekordboxPdb _root;
    private KaitaiStruct _parent;

    public static RekordboxPdb fromFile(String fileName) throws IOException {
        return new RekordboxPdb((KaitaiStream)new ByteBufferKaitaiStream(fileName));
    }

    public RekordboxPdb(KaitaiStream _io) {
        this(_io, null, null);
    }

    public RekordboxPdb(KaitaiStream _io, KaitaiStruct _parent) {
        this(_io, _parent, null);
    }

    public RekordboxPdb(KaitaiStream _io, KaitaiStruct _parent, RekordboxPdb _root) {
        super(_io);
        this._parent = _parent;
        this._root = _root == null ? this : _root;
        this._read();
    }

    private void _read() {
        this._unnamed0 = this._io.readU4le();
        this.lenPage = this._io.readU4le();
        this.numTables = this._io.readU4le();
        this.nextUnusedPage = this._io.readU4le();
        this._unnamed4 = this._io.readU4le();
        this.sequence = this._io.readU4le();
        this.gap = this._io.readBytes(4L);
        if (!Arrays.equals(this.gap(), new byte[]{0, 0, 0, 0})) {
            throw new KaitaiStream.ValidationNotEqualError(new byte[]{0, 0, 0, 0}, this.gap(), this._io(), "/seq/6");
        }
        this.tables = new ArrayList(((Number)this.numTables()).intValue());
        int i = 0;
        while ((long)i < this.numTables()) {
            this.tables.add(new Table(this._io, this, this._root));
            ++i;
        }
    }

    public long _unnamed0() {
        return this._unnamed0;
    }

    public long lenPage() {
        return this.lenPage;
    }

    public long numTables() {
        return this.numTables;
    }

    public long nextUnusedPage() {
        return this.nextUnusedPage;
    }

    public long _unnamed4() {
        return this._unnamed4;
    }

    public long sequence() {
        return this.sequence;
    }

    public byte[] gap() {
        return this.gap;
    }

    public ArrayList<Table> tables() {
        return this.tables;
    }

    public RekordboxPdb _root() {
        return this._root;
    }

    public KaitaiStruct _parent() {
        return this._parent;
    }

    public static class RowRef
    extends KaitaiStruct {
        private Integer ofsRow;
        private Integer rowBase;
        private Boolean present;
        private KaitaiStruct body;
        private int rowIndex;
        private RekordboxPdb _root;
        private RowGroup _parent;

        public RowRef(KaitaiStream _io, int rowIndex) {
            this(_io, null, null, rowIndex);
        }

        public RowRef(KaitaiStream _io, RowGroup _parent, int rowIndex) {
            this(_io, _parent, null, rowIndex);
        }

        public RowRef(KaitaiStream _io, RowGroup _parent, RekordboxPdb _root, int rowIndex) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this.rowIndex = rowIndex;
            this._read();
        }

        private void _read() {
        }

        public Integer ofsRow() {
            if (this.ofsRow != null) {
                return this.ofsRow;
            }
            long _pos = this._io.pos();
            this._io.seek(this._parent().base() - (6 + 2 * this.rowIndex()));
            this.ofsRow = this._io.readU2le();
            this._io.seek(_pos);
            return this.ofsRow;
        }

        public Integer rowBase() {
            if (this.rowBase != null) {
                return this.rowBase;
            }
            int _tmp = this.ofsRow() + this._parent()._parent().heapPos();
            this.rowBase = _tmp;
            return this.rowBase;
        }

        public Boolean present() {
            if (this.present != null) {
                return this.present;
            }
            boolean _tmp = (this._parent().rowPresentFlags() >> this.rowIndex() & 1) != 0;
            this.present = _tmp;
            return this.present;
        }

        public KaitaiStruct body() {
            if (this.body != null) {
                return this.body;
            }
            if (this.present().booleanValue()) {
                long _pos = this._io.pos();
                this._io.seek(this.rowBase().intValue());
                PageType on = this._parent()._parent().type();
                if (on != null) {
                    switch (this._parent()._parent().type()) {
                        case PLAYLIST_TREE: {
                            this.body = new PlaylistTreeRow(this._io, this, this._root);
                            break;
                        }
                        case KEYS: {
                            this.body = new KeyRow(this._io, this, this._root);
                            break;
                        }
                        case ARTISTS: {
                            this.body = new ArtistRow(this._io, this, this._root);
                            break;
                        }
                        case ALBUMS: {
                            this.body = new AlbumRow(this._io, this, this._root);
                            break;
                        }
                        case GENRES: {
                            this.body = new GenreRow(this._io, this, this._root);
                            break;
                        }
                        case HISTORY_PLAYLISTS: {
                            this.body = new HistoryPlaylistRow(this._io, this, this._root);
                            break;
                        }
                        case ARTWORK: {
                            this.body = new ArtworkRow(this._io, this, this._root);
                            break;
                        }
                        case PLAYLIST_ENTRIES: {
                            this.body = new PlaylistEntryRow(this._io, this, this._root);
                            break;
                        }
                        case LABELS: {
                            this.body = new LabelRow(this._io, this, this._root);
                            break;
                        }
                        case TRACKS: {
                            this.body = new TrackRow(this._io, this, this._root);
                            break;
                        }
                        case HISTORY_ENTRIES: {
                            this.body = new HistoryEntryRow(this._io, this, this._root);
                            break;
                        }
                        case COLORS: {
                            this.body = new ColorRow(this._io, this, this._root);
                        }
                    }
                }
                this._io.seek(_pos);
            }
            return this.body;
        }

        public int rowIndex() {
            return this.rowIndex;
        }

        public RekordboxPdb _root() {
            return this._root;
        }

        public RowGroup _parent() {
            return this._parent;
        }
    }

    public static class Table
    extends KaitaiStruct {
        private PageType type;
        private long emptyCandidate;
        private PageRef firstPage;
        private PageRef lastPage;
        private RekordboxPdb _root;
        private RekordboxPdb _parent;

        public static Table fromFile(String fileName) throws IOException {
            return new Table((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public Table(KaitaiStream _io) {
            this(_io, null, null);
        }

        public Table(KaitaiStream _io, RekordboxPdb _parent) {
            this(_io, _parent, null);
        }

        public Table(KaitaiStream _io, RekordboxPdb _parent, RekordboxPdb _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.type = PageType.byId(this._io.readU4le());
            this.emptyCandidate = this._io.readU4le();
            this.firstPage = new PageRef(this._io, this, this._root);
            this.lastPage = new PageRef(this._io, this, this._root);
        }

        public PageType type() {
            return this.type;
        }

        public long emptyCandidate() {
            return this.emptyCandidate;
        }

        public PageRef firstPage() {
            return this.firstPage;
        }

        public PageRef lastPage() {
            return this.lastPage;
        }

        public RekordboxPdb _root() {
            return this._root;
        }

        public RekordboxPdb _parent() {
            return this._parent;
        }
    }

    public static class DeviceSqlLongUtf16le
    extends KaitaiStruct {
        private int length;
        private int _unnamed1;
        private String text;
        private RekordboxPdb _root;
        private DeviceSqlString _parent;

        public static DeviceSqlLongUtf16le fromFile(String fileName) throws IOException {
            return new DeviceSqlLongUtf16le((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public DeviceSqlLongUtf16le(KaitaiStream _io) {
            this(_io, null, null);
        }

        public DeviceSqlLongUtf16le(KaitaiStream _io, DeviceSqlString _parent) {
            this(_io, _parent, null);
        }

        public DeviceSqlLongUtf16le(KaitaiStream _io, DeviceSqlString _parent, RekordboxPdb _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.length = this._io.readU2le();
            this._unnamed1 = this._io.readU1();
            this.text = new String(this._io.readBytes((long)(this.length() - 4)), Charset.forName("utf-16le"));
        }

        public int length() {
            return this.length;
        }

        public int _unnamed1() {
            return this._unnamed1;
        }

        public String text() {
            return this.text;
        }

        public RekordboxPdb _root() {
            return this._root;
        }

        public DeviceSqlString _parent() {
            return this._parent;
        }
    }

    public static class LabelRow
    extends KaitaiStruct {
        private long id;
        private DeviceSqlString name;
        private RekordboxPdb _root;
        private RowRef _parent;

        public static LabelRow fromFile(String fileName) throws IOException {
            return new LabelRow((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public LabelRow(KaitaiStream _io) {
            this(_io, null, null);
        }

        public LabelRow(KaitaiStream _io, RowRef _parent) {
            this(_io, _parent, null);
        }

        public LabelRow(KaitaiStream _io, RowRef _parent, RekordboxPdb _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.id = this._io.readU4le();
            this.name = new DeviceSqlString(this._io, this, this._root);
        }

        public long id() {
            return this.id;
        }

        public DeviceSqlString name() {
            return this.name;
        }

        public RekordboxPdb _root() {
            return this._root;
        }

        public RowRef _parent() {
            return this._parent;
        }
    }

    public static class PlaylistEntryRow
    extends KaitaiStruct {
        private long entryIndex;
        private long trackId;
        private long playlistId;
        private RekordboxPdb _root;
        private RowRef _parent;

        public static PlaylistEntryRow fromFile(String fileName) throws IOException {
            return new PlaylistEntryRow((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public PlaylistEntryRow(KaitaiStream _io) {
            this(_io, null, null);
        }

        public PlaylistEntryRow(KaitaiStream _io, RowRef _parent) {
            this(_io, _parent, null);
        }

        public PlaylistEntryRow(KaitaiStream _io, RowRef _parent, RekordboxPdb _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.entryIndex = this._io.readU4le();
            this.trackId = this._io.readU4le();
            this.playlistId = this._io.readU4le();
        }

        public long entryIndex() {
            return this.entryIndex;
        }

        public long trackId() {
            return this.trackId;
        }

        public long playlistId() {
            return this.playlistId;
        }

        public RekordboxPdb _root() {
            return this._root;
        }

        public RowRef _parent() {
            return this._parent;
        }
    }

    public static class KeyRow
    extends KaitaiStruct {
        private long id;
        private long id2;
        private DeviceSqlString name;
        private RekordboxPdb _root;
        private RowRef _parent;

        public static KeyRow fromFile(String fileName) throws IOException {
            return new KeyRow((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public KeyRow(KaitaiStream _io) {
            this(_io, null, null);
        }

        public KeyRow(KaitaiStream _io, RowRef _parent) {
            this(_io, _parent, null);
        }

        public KeyRow(KaitaiStream _io, RowRef _parent, RekordboxPdb _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.id = this._io.readU4le();
            this.id2 = this._io.readU4le();
            this.name = new DeviceSqlString(this._io, this, this._root);
        }

        public long id() {
            return this.id;
        }

        public long id2() {
            return this.id2;
        }

        public DeviceSqlString name() {
            return this.name;
        }

        public RekordboxPdb _root() {
            return this._root;
        }

        public RowRef _parent() {
            return this._parent;
        }
    }

    public static class TrackRow
    extends KaitaiStruct {
        private DeviceSqlString unknownString8;
        private DeviceSqlString unknownString6;
        private DeviceSqlString analyzeDate;
        private DeviceSqlString filePath;
        private DeviceSqlString autoloadHotcues;
        private DeviceSqlString dateAdded;
        private DeviceSqlString unknownString3;
        private DeviceSqlString texter;
        private DeviceSqlString kuvoPublic;
        private DeviceSqlString mixName;
        private DeviceSqlString unknownString5;
        private DeviceSqlString unknownString4;
        private DeviceSqlString message;
        private DeviceSqlString unknownString2;
        private DeviceSqlString isrc;
        private DeviceSqlString unknownString7;
        private DeviceSqlString filename;
        private DeviceSqlString analyzePath;
        private DeviceSqlString comment;
        private DeviceSqlString releaseDate;
        private DeviceSqlString title;
        private int _unnamed0;
        private int indexShift;
        private long bitmask;
        private long sampleRate;
        private long composerId;
        private long fileSize;
        private long _unnamed6;
        private int _unnamed7;
        private int _unnamed8;
        private long artworkId;
        private long keyId;
        private long originalArtistId;
        private long labelId;
        private long remixerId;
        private long bitrate;
        private long trackNumber;
        private long tempo;
        private long genreId;
        private long albumId;
        private long artistId;
        private long id;
        private int discNumber;
        private int playCount;
        private int year;
        private int sampleDepth;
        private int duration;
        private int _unnamed26;
        private int colorId;
        private int rating;
        private int _unnamed29;
        private int _unnamed30;
        private ArrayList<Integer> ofsStrings;
        private RekordboxPdb _root;
        private RowRef _parent;

        public static TrackRow fromFile(String fileName) throws IOException {
            return new TrackRow((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public TrackRow(KaitaiStream _io) {
            this(_io, null, null);
        }

        public TrackRow(KaitaiStream _io, RowRef _parent) {
            this(_io, _parent, null);
        }

        public TrackRow(KaitaiStream _io, RowRef _parent, RekordboxPdb _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this._unnamed0 = this._io.readU2le();
            this.indexShift = this._io.readU2le();
            this.bitmask = this._io.readU4le();
            this.sampleRate = this._io.readU4le();
            this.composerId = this._io.readU4le();
            this.fileSize = this._io.readU4le();
            this._unnamed6 = this._io.readU4le();
            this._unnamed7 = this._io.readU2le();
            this._unnamed8 = this._io.readU2le();
            this.artworkId = this._io.readU4le();
            this.keyId = this._io.readU4le();
            this.originalArtistId = this._io.readU4le();
            this.labelId = this._io.readU4le();
            this.remixerId = this._io.readU4le();
            this.bitrate = this._io.readU4le();
            this.trackNumber = this._io.readU4le();
            this.tempo = this._io.readU4le();
            this.genreId = this._io.readU4le();
            this.albumId = this._io.readU4le();
            this.artistId = this._io.readU4le();
            this.id = this._io.readU4le();
            this.discNumber = this._io.readU2le();
            this.playCount = this._io.readU2le();
            this.year = this._io.readU2le();
            this.sampleDepth = this._io.readU2le();
            this.duration = this._io.readU2le();
            this._unnamed26 = this._io.readU2le();
            this.colorId = this._io.readU1();
            this.rating = this._io.readU1();
            this._unnamed29 = this._io.readU2le();
            this._unnamed30 = this._io.readU2le();
            this.ofsStrings = new ArrayList(21);
            for (int i = 0; i < 21; ++i) {
                this.ofsStrings.add(this._io.readU2le());
            }
        }

        public DeviceSqlString unknownString8() {
            if (this.unknownString8 != null) {
                return this.unknownString8;
            }
            long _pos = this._io.pos();
            this._io.seek(this._parent().rowBase() + this.ofsStrings().get(18));
            this.unknownString8 = new DeviceSqlString(this._io, this, this._root);
            this._io.seek(_pos);
            return this.unknownString8;
        }

        public DeviceSqlString unknownString6() {
            if (this.unknownString6 != null) {
                return this.unknownString6;
            }
            long _pos = this._io.pos();
            this._io.seek(this._parent().rowBase() + this.ofsStrings().get(9));
            this.unknownString6 = new DeviceSqlString(this._io, this, this._root);
            this._io.seek(_pos);
            return this.unknownString6;
        }

        public DeviceSqlString analyzeDate() {
            if (this.analyzeDate != null) {
                return this.analyzeDate;
            }
            long _pos = this._io.pos();
            this._io.seek(this._parent().rowBase() + this.ofsStrings().get(15));
            this.analyzeDate = new DeviceSqlString(this._io, this, this._root);
            this._io.seek(_pos);
            return this.analyzeDate;
        }

        public DeviceSqlString filePath() {
            if (this.filePath != null) {
                return this.filePath;
            }
            long _pos = this._io.pos();
            this._io.seek(this._parent().rowBase() + this.ofsStrings().get(20));
            this.filePath = new DeviceSqlString(this._io, this, this._root);
            this._io.seek(_pos);
            return this.filePath;
        }

        public DeviceSqlString autoloadHotcues() {
            if (this.autoloadHotcues != null) {
                return this.autoloadHotcues;
            }
            long _pos = this._io.pos();
            this._io.seek(this._parent().rowBase() + this.ofsStrings().get(7));
            this.autoloadHotcues = new DeviceSqlString(this._io, this, this._root);
            this._io.seek(_pos);
            return this.autoloadHotcues;
        }

        public DeviceSqlString dateAdded() {
            if (this.dateAdded != null) {
                return this.dateAdded;
            }
            long _pos = this._io.pos();
            this._io.seek(this._parent().rowBase() + this.ofsStrings().get(10));
            this.dateAdded = new DeviceSqlString(this._io, this, this._root);
            this._io.seek(_pos);
            return this.dateAdded;
        }

        public DeviceSqlString unknownString3() {
            if (this.unknownString3 != null) {
                return this.unknownString3;
            }
            long _pos = this._io.pos();
            this._io.seek(this._parent().rowBase() + this.ofsStrings().get(3));
            this.unknownString3 = new DeviceSqlString(this._io, this, this._root);
            this._io.seek(_pos);
            return this.unknownString3;
        }

        public DeviceSqlString texter() {
            if (this.texter != null) {
                return this.texter;
            }
            long _pos = this._io.pos();
            this._io.seek(this._parent().rowBase() + this.ofsStrings().get(1));
            this.texter = new DeviceSqlString(this._io, this, this._root);
            this._io.seek(_pos);
            return this.texter;
        }

        public DeviceSqlString kuvoPublic() {
            if (this.kuvoPublic != null) {
                return this.kuvoPublic;
            }
            long _pos = this._io.pos();
            this._io.seek(this._parent().rowBase() + this.ofsStrings().get(6));
            this.kuvoPublic = new DeviceSqlString(this._io, this, this._root);
            this._io.seek(_pos);
            return this.kuvoPublic;
        }

        public DeviceSqlString mixName() {
            if (this.mixName != null) {
                return this.mixName;
            }
            long _pos = this._io.pos();
            this._io.seek(this._parent().rowBase() + this.ofsStrings().get(12));
            this.mixName = new DeviceSqlString(this._io, this, this._root);
            this._io.seek(_pos);
            return this.mixName;
        }

        public DeviceSqlString unknownString5() {
            if (this.unknownString5 != null) {
                return this.unknownString5;
            }
            long _pos = this._io.pos();
            this._io.seek(this._parent().rowBase() + this.ofsStrings().get(8));
            this.unknownString5 = new DeviceSqlString(this._io, this, this._root);
            this._io.seek(_pos);
            return this.unknownString5;
        }

        public DeviceSqlString unknownString4() {
            if (this.unknownString4 != null) {
                return this.unknownString4;
            }
            long _pos = this._io.pos();
            this._io.seek(this._parent().rowBase() + this.ofsStrings().get(4));
            this.unknownString4 = new DeviceSqlString(this._io, this, this._root);
            this._io.seek(_pos);
            return this.unknownString4;
        }

        public DeviceSqlString message() {
            if (this.message != null) {
                return this.message;
            }
            long _pos = this._io.pos();
            this._io.seek(this._parent().rowBase() + this.ofsStrings().get(5));
            this.message = new DeviceSqlString(this._io, this, this._root);
            this._io.seek(_pos);
            return this.message;
        }

        public DeviceSqlString unknownString2() {
            if (this.unknownString2 != null) {
                return this.unknownString2;
            }
            long _pos = this._io.pos();
            this._io.seek(this._parent().rowBase() + this.ofsStrings().get(2));
            this.unknownString2 = new DeviceSqlString(this._io, this, this._root);
            this._io.seek(_pos);
            return this.unknownString2;
        }

        public DeviceSqlString isrc() {
            if (this.isrc != null) {
                return this.isrc;
            }
            long _pos = this._io.pos();
            this._io.seek(this._parent().rowBase() + this.ofsStrings().get(0));
            this.isrc = new DeviceSqlString(this._io, this, this._root);
            this._io.seek(_pos);
            return this.isrc;
        }

        public DeviceSqlString unknownString7() {
            if (this.unknownString7 != null) {
                return this.unknownString7;
            }
            long _pos = this._io.pos();
            this._io.seek(this._parent().rowBase() + this.ofsStrings().get(13));
            this.unknownString7 = new DeviceSqlString(this._io, this, this._root);
            this._io.seek(_pos);
            return this.unknownString7;
        }

        public DeviceSqlString filename() {
            if (this.filename != null) {
                return this.filename;
            }
            long _pos = this._io.pos();
            this._io.seek(this._parent().rowBase() + this.ofsStrings().get(19));
            this.filename = new DeviceSqlString(this._io, this, this._root);
            this._io.seek(_pos);
            return this.filename;
        }

        public DeviceSqlString analyzePath() {
            if (this.analyzePath != null) {
                return this.analyzePath;
            }
            long _pos = this._io.pos();
            this._io.seek(this._parent().rowBase() + this.ofsStrings().get(14));
            this.analyzePath = new DeviceSqlString(this._io, this, this._root);
            this._io.seek(_pos);
            return this.analyzePath;
        }

        public DeviceSqlString comment() {
            if (this.comment != null) {
                return this.comment;
            }
            long _pos = this._io.pos();
            this._io.seek(this._parent().rowBase() + this.ofsStrings().get(16));
            this.comment = new DeviceSqlString(this._io, this, this._root);
            this._io.seek(_pos);
            return this.comment;
        }

        public DeviceSqlString releaseDate() {
            if (this.releaseDate != null) {
                return this.releaseDate;
            }
            long _pos = this._io.pos();
            this._io.seek(this._parent().rowBase() + this.ofsStrings().get(11));
            this.releaseDate = new DeviceSqlString(this._io, this, this._root);
            this._io.seek(_pos);
            return this.releaseDate;
        }

        public DeviceSqlString title() {
            if (this.title != null) {
                return this.title;
            }
            long _pos = this._io.pos();
            this._io.seek(this._parent().rowBase() + this.ofsStrings().get(17));
            this.title = new DeviceSqlString(this._io, this, this._root);
            this._io.seek(_pos);
            return this.title;
        }

        public int _unnamed0() {
            return this._unnamed0;
        }

        public int indexShift() {
            return this.indexShift;
        }

        public long bitmask() {
            return this.bitmask;
        }

        public long sampleRate() {
            return this.sampleRate;
        }

        public long composerId() {
            return this.composerId;
        }

        public long fileSize() {
            return this.fileSize;
        }

        public long _unnamed6() {
            return this._unnamed6;
        }

        public int _unnamed7() {
            return this._unnamed7;
        }

        public int _unnamed8() {
            return this._unnamed8;
        }

        public long artworkId() {
            return this.artworkId;
        }

        public long keyId() {
            return this.keyId;
        }

        public long originalArtistId() {
            return this.originalArtistId;
        }

        public long labelId() {
            return this.labelId;
        }

        public long remixerId() {
            return this.remixerId;
        }

        public long bitrate() {
            return this.bitrate;
        }

        public long trackNumber() {
            return this.trackNumber;
        }

        public long tempo() {
            return this.tempo;
        }

        public long genreId() {
            return this.genreId;
        }

        public long albumId() {
            return this.albumId;
        }

        public long artistId() {
            return this.artistId;
        }

        public long id() {
            return this.id;
        }

        public int discNumber() {
            return this.discNumber;
        }

        public int playCount() {
            return this.playCount;
        }

        public int year() {
            return this.year;
        }

        public int sampleDepth() {
            return this.sampleDepth;
        }

        public int duration() {
            return this.duration;
        }

        public int _unnamed26() {
            return this._unnamed26;
        }

        public int colorId() {
            return this.colorId;
        }

        public int rating() {
            return this.rating;
        }

        public int _unnamed29() {
            return this._unnamed29;
        }

        public int _unnamed30() {
            return this._unnamed30;
        }

        public ArrayList<Integer> ofsStrings() {
            return this.ofsStrings;
        }

        public RekordboxPdb _root() {
            return this._root;
        }

        public RowRef _parent() {
            return this._parent;
        }
    }

    public static class PageRef
    extends KaitaiStruct {
        private Page body;
        private long index;
        private RekordboxPdb _root;
        private KaitaiStruct _parent;
        private byte[] _raw_body;

        public static PageRef fromFile(String fileName) throws IOException {
            return new PageRef((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public PageRef(KaitaiStream _io) {
            this(_io, null, null);
        }

        public PageRef(KaitaiStream _io, KaitaiStruct _parent) {
            this(_io, _parent, null);
        }

        public PageRef(KaitaiStream _io, KaitaiStruct _parent, RekordboxPdb _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.index = this._io.readU4le();
        }

        public Page body() {
            if (this.body != null) {
                return this.body;
            }
            KaitaiStream io = this._root._io();
            long _pos = io.pos();
            io.seek(this._root.lenPage() * this.index());
            this._raw_body = io.readBytes(this._root.lenPage());
            ByteBufferKaitaiStream _io__raw_body = new ByteBufferKaitaiStream(this._raw_body);
            this.body = new Page((KaitaiStream)_io__raw_body, this, this._root);
            io.seek(_pos);
            return this.body;
        }

        public long index() {
            return this.index;
        }

        public RekordboxPdb _root() {
            return this._root;
        }

        public KaitaiStruct _parent() {
            return this._parent;
        }

        public byte[] _raw_body() {
            return this._raw_body;
        }
    }

    public static class ArtistRow
    extends KaitaiStruct {
        private Integer ofsNameFar;
        private DeviceSqlString name;
        private int subtype;
        private int indexShift;
        private long id;
        private int _unnamed3;
        private int ofsNameNear;
        private RekordboxPdb _root;
        private RowRef _parent;

        public static ArtistRow fromFile(String fileName) throws IOException {
            return new ArtistRow((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public ArtistRow(KaitaiStream _io) {
            this(_io, null, null);
        }

        public ArtistRow(KaitaiStream _io, RowRef _parent) {
            this(_io, _parent, null);
        }

        public ArtistRow(KaitaiStream _io, RowRef _parent, RekordboxPdb _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.subtype = this._io.readU2le();
            this.indexShift = this._io.readU2le();
            this.id = this._io.readU4le();
            this._unnamed3 = this._io.readU1();
            this.ofsNameNear = this._io.readU1();
        }

        public Integer ofsNameFar() {
            if (this.ofsNameFar != null) {
                return this.ofsNameFar;
            }
            if (this.subtype() == 100) {
                long _pos = this._io.pos();
                this._io.seek(this._parent().rowBase() + 10);
                this.ofsNameFar = this._io.readU2le();
                this._io.seek(_pos);
            }
            return this.ofsNameFar;
        }

        public DeviceSqlString name() {
            if (this.name != null) {
                return this.name;
            }
            long _pos = this._io.pos();
            this._io.seek(this._parent().rowBase() + (this.subtype() == 100 ? this.ofsNameFar().intValue() : this.ofsNameNear()));
            this.name = new DeviceSqlString(this._io, this, this._root);
            this._io.seek(_pos);
            return this.name;
        }

        public int subtype() {
            return this.subtype;
        }

        public int indexShift() {
            return this.indexShift;
        }

        public long id() {
            return this.id;
        }

        public int _unnamed3() {
            return this._unnamed3;
        }

        public int ofsNameNear() {
            return this.ofsNameNear;
        }

        public RekordboxPdb _root() {
            return this._root;
        }

        public RowRef _parent() {
            return this._parent;
        }
    }

    public static class DeviceSqlLongAscii
    extends KaitaiStruct {
        private int length;
        private int _unnamed1;
        private String text;
        private RekordboxPdb _root;
        private DeviceSqlString _parent;

        public static DeviceSqlLongAscii fromFile(String fileName) throws IOException {
            return new DeviceSqlLongAscii((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public DeviceSqlLongAscii(KaitaiStream _io) {
            this(_io, null, null);
        }

        public DeviceSqlLongAscii(KaitaiStream _io, DeviceSqlString _parent) {
            this(_io, _parent, null);
        }

        public DeviceSqlLongAscii(KaitaiStream _io, DeviceSqlString _parent, RekordboxPdb _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.length = this._io.readU2le();
            this._unnamed1 = this._io.readU1();
            this.text = new String(this._io.readBytes((long)(this.length() - 4)), Charset.forName("ascii"));
        }

        public int length() {
            return this.length;
        }

        public int _unnamed1() {
            return this._unnamed1;
        }

        public String text() {
            return this.text;
        }

        public RekordboxPdb _root() {
            return this._root;
        }

        public DeviceSqlString _parent() {
            return this._parent;
        }
    }

    public static class ArtworkRow
    extends KaitaiStruct {
        private long id;
        private DeviceSqlString path;
        private RekordboxPdb _root;
        private RowRef _parent;

        public static ArtworkRow fromFile(String fileName) throws IOException {
            return new ArtworkRow((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public ArtworkRow(KaitaiStream _io) {
            this(_io, null, null);
        }

        public ArtworkRow(KaitaiStream _io, RowRef _parent) {
            this(_io, _parent, null);
        }

        public ArtworkRow(KaitaiStream _io, RowRef _parent, RekordboxPdb _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.id = this._io.readU4le();
            this.path = new DeviceSqlString(this._io, this, this._root);
        }

        public long id() {
            return this.id;
        }

        public DeviceSqlString path() {
            return this.path;
        }

        public RekordboxPdb _root() {
            return this._root;
        }

        public RowRef _parent() {
            return this._parent;
        }
    }

    public static class HistoryEntryRow
    extends KaitaiStruct {
        private long trackId;
        private long playlistId;
        private long entryIndex;
        private RekordboxPdb _root;
        private RowRef _parent;

        public static HistoryEntryRow fromFile(String fileName) throws IOException {
            return new HistoryEntryRow((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public HistoryEntryRow(KaitaiStream _io) {
            this(_io, null, null);
        }

        public HistoryEntryRow(KaitaiStream _io, RowRef _parent) {
            this(_io, _parent, null);
        }

        public HistoryEntryRow(KaitaiStream _io, RowRef _parent, RekordboxPdb _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.trackId = this._io.readU4le();
            this.playlistId = this._io.readU4le();
            this.entryIndex = this._io.readU4le();
        }

        public long trackId() {
            return this.trackId;
        }

        public long playlistId() {
            return this.playlistId;
        }

        public long entryIndex() {
            return this.entryIndex;
        }

        public RekordboxPdb _root() {
            return this._root;
        }

        public RowRef _parent() {
            return this._parent;
        }
    }

    public static class GenreRow
    extends KaitaiStruct {
        private long id;
        private DeviceSqlString name;
        private RekordboxPdb _root;
        private RowRef _parent;

        public static GenreRow fromFile(String fileName) throws IOException {
            return new GenreRow((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public GenreRow(KaitaiStream _io) {
            this(_io, null, null);
        }

        public GenreRow(KaitaiStream _io, RowRef _parent) {
            this(_io, _parent, null);
        }

        public GenreRow(KaitaiStream _io, RowRef _parent, RekordboxPdb _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.id = this._io.readU4le();
            this.name = new DeviceSqlString(this._io, this, this._root);
        }

        public long id() {
            return this.id;
        }

        public DeviceSqlString name() {
            return this.name;
        }

        public RekordboxPdb _root() {
            return this._root;
        }

        public RowRef _parent() {
            return this._parent;
        }
    }

    public static class RowGroup
    extends KaitaiStruct {
        private Integer base;
        private Integer rowPresentFlags;
        private ArrayList<RowRef> rows;
        private int groupIndex;
        private RekordboxPdb _root;
        private Page _parent;

        public RowGroup(KaitaiStream _io, int groupIndex) {
            this(_io, null, null, groupIndex);
        }

        public RowGroup(KaitaiStream _io, Page _parent, int groupIndex) {
            this(_io, _parent, null, groupIndex);
        }

        public RowGroup(KaitaiStream _io, Page _parent, RekordboxPdb _root, int groupIndex) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this.groupIndex = groupIndex;
            this._read();
        }

        private void _read() {
        }

        public Integer base() {
            if (this.base != null) {
                return this.base;
            }
            int _tmp = (int)(this._root.lenPage() - (long)(this.groupIndex() * 36));
            this.base = _tmp;
            return this.base;
        }

        public Integer rowPresentFlags() {
            if (this.rowPresentFlags != null) {
                return this.rowPresentFlags;
            }
            long _pos = this._io.pos();
            this._io.seek(this.base() - 4);
            this.rowPresentFlags = this._io.readU2le();
            this._io.seek(_pos);
            return this.rowPresentFlags;
        }

        public ArrayList<RowRef> rows() {
            if (this.rows != null) {
                return this.rows;
            }
            this.rows = new ArrayList(this.groupIndex() < this._parent().numGroups() - 1 ? 16 : KaitaiStream.mod((int)(this._parent().numRows() - 1), (int)16) + 1);
            for (int i = 0; i < (this.groupIndex() < this._parent().numGroups() - 1 ? 16 : KaitaiStream.mod((int)(this._parent().numRows() - 1), (int)16) + 1); ++i) {
                this.rows.add(new RowRef(this._io, this, this._root, i));
            }
            return this.rows;
        }

        public int groupIndex() {
            return this.groupIndex;
        }

        public RekordboxPdb _root() {
            return this._root;
        }

        public Page _parent() {
            return this._parent;
        }
    }

    public static class Page
    extends KaitaiStruct {
        private Integer numRows;
        private Integer numGroups;
        private ArrayList<RowGroup> rowGroups;
        private Integer heapPos;
        private Boolean isDataPage;
        private byte[] gap;
        private long pageIndex;
        private PageType type;
        private PageRef nextPage;
        private long _unnamed4;
        private byte[] _unnamed5;
        private int numRowsSmall;
        private int _unnamed7;
        private int _unnamed8;
        private int pageFlags;
        private int freeSize;
        private int usedSize;
        private int _unnamed12;
        private int numRowsLarge;
        private int _unnamed14;
        private int _unnamed15;
        private byte[] heap;
        private RekordboxPdb _root;
        private PageRef _parent;

        public static Page fromFile(String fileName) throws IOException {
            return new Page((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public Page(KaitaiStream _io) {
            this(_io, null, null);
        }

        public Page(KaitaiStream _io, PageRef _parent) {
            this(_io, _parent, null);
        }

        public Page(KaitaiStream _io, PageRef _parent, RekordboxPdb _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.gap = this._io.readBytes(4L);
            if (!Arrays.equals(this.gap(), new byte[]{0, 0, 0, 0})) {
                throw new KaitaiStream.ValidationNotEqualError(new byte[]{0, 0, 0, 0}, this.gap(), this._io(), "/types/page/seq/0");
            }
            this.pageIndex = this._io.readU4le();
            this.type = PageType.byId(this._io.readU4le());
            this.nextPage = new PageRef(this._io, this, this._root);
            this._unnamed4 = this._io.readU4le();
            this._unnamed5 = this._io.readBytes(4L);
            this.numRowsSmall = this._io.readU1();
            this._unnamed7 = this._io.readU1();
            this._unnamed8 = this._io.readU1();
            this.pageFlags = this._io.readU1();
            this.freeSize = this._io.readU2le();
            this.usedSize = this._io.readU2le();
            this._unnamed12 = this._io.readU2le();
            this.numRowsLarge = this._io.readU2le();
            this._unnamed14 = this._io.readU2le();
            this._unnamed15 = this._io.readU2le();
        }

        public Integer numRows() {
            if (this.numRows != null) {
                return this.numRows;
            }
            int _tmp = this.numRowsLarge() > this.numRowsSmall() && this.numRowsLarge() != 8191 ? this.numRowsLarge() : this.numRowsSmall();
            this.numRows = _tmp;
            return this.numRows;
        }

        public Integer numGroups() {
            if (this.numGroups != null) {
                return this.numGroups;
            }
            int _tmp = (this.numRows() - 1) / 16 + 1;
            this.numGroups = _tmp;
            return this.numGroups;
        }

        public ArrayList<RowGroup> rowGroups() {
            if (this.rowGroups != null) {
                return this.rowGroups;
            }
            if (this.isDataPage().booleanValue()) {
                this.rowGroups = new ArrayList(this.numGroups());
                for (int i = 0; i < this.numGroups(); ++i) {
                    this.rowGroups.add(new RowGroup(this._io, this, this._root, i));
                }
            }
            return this.rowGroups;
        }

        public Integer heapPos() {
            if (this.heapPos != null) {
                return this.heapPos;
            }
            int _tmp = this._io().pos();
            this.heapPos = _tmp;
            return this.heapPos;
        }

        public Boolean isDataPage() {
            if (this.isDataPage != null) {
                return this.isDataPage;
            }
            boolean _tmp = (this.pageFlags() & 0x40) == 0;
            this.isDataPage = _tmp;
            return this.isDataPage;
        }

        public byte[] gap() {
            return this.gap;
        }

        public long pageIndex() {
            return this.pageIndex;
        }

        public PageType type() {
            return this.type;
        }

        public PageRef nextPage() {
            return this.nextPage;
        }

        public long _unnamed4() {
            return this._unnamed4;
        }

        public byte[] _unnamed5() {
            return this._unnamed5;
        }

        public int numRowsSmall() {
            return this.numRowsSmall;
        }

        public int _unnamed7() {
            return this._unnamed7;
        }

        public int _unnamed8() {
            return this._unnamed8;
        }

        public int pageFlags() {
            return this.pageFlags;
        }

        public int freeSize() {
            return this.freeSize;
        }

        public int usedSize() {
            return this.usedSize;
        }

        public int _unnamed12() {
            return this._unnamed12;
        }

        public int numRowsLarge() {
            return this.numRowsLarge;
        }

        public int _unnamed14() {
            return this._unnamed14;
        }

        public int _unnamed15() {
            return this._unnamed15;
        }

        public byte[] heap() {
            return this.heap;
        }

        public RekordboxPdb _root() {
            return this._root;
        }

        public PageRef _parent() {
            return this._parent;
        }
    }

    public static class AlbumRow
    extends KaitaiStruct {
        private DeviceSqlString name;
        private int _unnamed0;
        private int indexShift;
        private long _unnamed2;
        private long artistId;
        private long id;
        private long _unnamed5;
        private int _unnamed6;
        private int ofsName;
        private RekordboxPdb _root;
        private RowRef _parent;

        public static AlbumRow fromFile(String fileName) throws IOException {
            return new AlbumRow((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public AlbumRow(KaitaiStream _io) {
            this(_io, null, null);
        }

        public AlbumRow(KaitaiStream _io, RowRef _parent) {
            this(_io, _parent, null);
        }

        public AlbumRow(KaitaiStream _io, RowRef _parent, RekordboxPdb _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this._unnamed0 = this._io.readU2le();
            this.indexShift = this._io.readU2le();
            this._unnamed2 = this._io.readU4le();
            this.artistId = this._io.readU4le();
            this.id = this._io.readU4le();
            this._unnamed5 = this._io.readU4le();
            this._unnamed6 = this._io.readU1();
            this.ofsName = this._io.readU1();
        }

        public DeviceSqlString name() {
            if (this.name != null) {
                return this.name;
            }
            long _pos = this._io.pos();
            this._io.seek(this._parent().rowBase() + this.ofsName());
            this.name = new DeviceSqlString(this._io, this, this._root);
            this._io.seek(_pos);
            return this.name;
        }

        public int _unnamed0() {
            return this._unnamed0;
        }

        public int indexShift() {
            return this.indexShift;
        }

        public long _unnamed2() {
            return this._unnamed2;
        }

        public long artistId() {
            return this.artistId;
        }

        public long id() {
            return this.id;
        }

        public long _unnamed5() {
            return this._unnamed5;
        }

        public int _unnamed6() {
            return this._unnamed6;
        }

        public int ofsName() {
            return this.ofsName;
        }

        public RekordboxPdb _root() {
            return this._root;
        }

        public RowRef _parent() {
            return this._parent;
        }
    }

    public static class DeviceSqlShortAscii
    extends KaitaiStruct {
        private Integer length;
        private String text;
        private int lengthAndKind;
        private RekordboxPdb _root;
        private DeviceSqlString _parent;

        public DeviceSqlShortAscii(KaitaiStream _io, int lengthAndKind) {
            this(_io, null, null, lengthAndKind);
        }

        public DeviceSqlShortAscii(KaitaiStream _io, DeviceSqlString _parent, int lengthAndKind) {
            this(_io, _parent, null, lengthAndKind);
        }

        public DeviceSqlShortAscii(KaitaiStream _io, DeviceSqlString _parent, RekordboxPdb _root, int lengthAndKind) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this.lengthAndKind = lengthAndKind;
            this._read();
        }

        private void _read() {
            this.text = new String(this._io.readBytes((long)(this.length() - 1)), Charset.forName("ascii"));
        }

        public Integer length() {
            if (this.length != null) {
                return this.length;
            }
            int _tmp = this.lengthAndKind() >> 1;
            this.length = _tmp;
            return this.length;
        }

        public String text() {
            return this.text;
        }

        public int lengthAndKind() {
            return this.lengthAndKind;
        }

        public RekordboxPdb _root() {
            return this._root;
        }

        public DeviceSqlString _parent() {
            return this._parent;
        }
    }

    public static class ColorRow
    extends KaitaiStruct {
        private byte[] _unnamed0;
        private int id;
        private int _unnamed2;
        private DeviceSqlString name;
        private RekordboxPdb _root;
        private RowRef _parent;

        public static ColorRow fromFile(String fileName) throws IOException {
            return new ColorRow((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public ColorRow(KaitaiStream _io) {
            this(_io, null, null);
        }

        public ColorRow(KaitaiStream _io, RowRef _parent) {
            this(_io, _parent, null);
        }

        public ColorRow(KaitaiStream _io, RowRef _parent, RekordboxPdb _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this._unnamed0 = this._io.readBytes(5L);
            this.id = this._io.readU2le();
            this._unnamed2 = this._io.readU1();
            this.name = new DeviceSqlString(this._io, this, this._root);
        }

        public byte[] _unnamed0() {
            return this._unnamed0;
        }

        public int id() {
            return this.id;
        }

        public int _unnamed2() {
            return this._unnamed2;
        }

        public DeviceSqlString name() {
            return this.name;
        }

        public RekordboxPdb _root() {
            return this._root;
        }

        public RowRef _parent() {
            return this._parent;
        }
    }

    public static class PlaylistTreeRow
    extends KaitaiStruct {
        private Boolean isFolder;
        private long parentId;
        private byte[] _unnamed1;
        private long sortOrder;
        private long id;
        private long rawIsFolder;
        private DeviceSqlString name;
        private RekordboxPdb _root;
        private RowRef _parent;

        public static PlaylistTreeRow fromFile(String fileName) throws IOException {
            return new PlaylistTreeRow((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public PlaylistTreeRow(KaitaiStream _io) {
            this(_io, null, null);
        }

        public PlaylistTreeRow(KaitaiStream _io, RowRef _parent) {
            this(_io, _parent, null);
        }

        public PlaylistTreeRow(KaitaiStream _io, RowRef _parent, RekordboxPdb _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.parentId = this._io.readU4le();
            this._unnamed1 = this._io.readBytes(4L);
            this.sortOrder = this._io.readU4le();
            this.id = this._io.readU4le();
            this.rawIsFolder = this._io.readU4le();
            this.name = new DeviceSqlString(this._io, this, this._root);
        }

        public Boolean isFolder() {
            if (this.isFolder != null) {
                return this.isFolder;
            }
            boolean _tmp = this.rawIsFolder() != 0L;
            this.isFolder = _tmp;
            return this.isFolder;
        }

        public long parentId() {
            return this.parentId;
        }

        public byte[] _unnamed1() {
            return this._unnamed1;
        }

        public long sortOrder() {
            return this.sortOrder;
        }

        public long id() {
            return this.id;
        }

        public long rawIsFolder() {
            return this.rawIsFolder;
        }

        public DeviceSqlString name() {
            return this.name;
        }

        public RekordboxPdb _root() {
            return this._root;
        }

        public RowRef _parent() {
            return this._parent;
        }
    }

    public static class HistoryPlaylistRow
    extends KaitaiStruct {
        private long id;
        private DeviceSqlString name;
        private RekordboxPdb _root;
        private RowRef _parent;

        public static HistoryPlaylistRow fromFile(String fileName) throws IOException {
            return new HistoryPlaylistRow((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public HistoryPlaylistRow(KaitaiStream _io) {
            this(_io, null, null);
        }

        public HistoryPlaylistRow(KaitaiStream _io, RowRef _parent) {
            this(_io, _parent, null);
        }

        public HistoryPlaylistRow(KaitaiStream _io, RowRef _parent, RekordboxPdb _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.id = this._io.readU4le();
            this.name = new DeviceSqlString(this._io, this, this._root);
        }

        public long id() {
            return this.id;
        }

        public DeviceSqlString name() {
            return this.name;
        }

        public RekordboxPdb _root() {
            return this._root;
        }

        public RowRef _parent() {
            return this._parent;
        }
    }

    public static class DeviceSqlString
    extends KaitaiStruct {
        private int lengthAndKind;
        private KaitaiStruct body;
        private RekordboxPdb _root;
        private KaitaiStruct _parent;

        public static DeviceSqlString fromFile(String fileName) throws IOException {
            return new DeviceSqlString((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public DeviceSqlString(KaitaiStream _io) {
            this(_io, null, null);
        }

        public DeviceSqlString(KaitaiStream _io, KaitaiStruct _parent) {
            this(_io, _parent, null);
        }

        public DeviceSqlString(KaitaiStream _io, KaitaiStruct _parent, RekordboxPdb _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.lengthAndKind = this._io.readU1();
            switch (this.lengthAndKind()) {
                case 64: {
                    this.body = new DeviceSqlLongAscii(this._io, this, this._root);
                    break;
                }
                case 144: {
                    this.body = new DeviceSqlLongUtf16le(this._io, this, this._root);
                    break;
                }
                default: {
                    this.body = new DeviceSqlShortAscii(this._io, this, this._root, this.lengthAndKind());
                }
            }
        }

        public int lengthAndKind() {
            return this.lengthAndKind;
        }

        public KaitaiStruct body() {
            return this.body;
        }

        public RekordboxPdb _root() {
            return this._root;
        }

        public KaitaiStruct _parent() {
            return this._parent;
        }
    }

    public static enum PageType {
        TRACKS(0L),
        GENRES(1L),
        ARTISTS(2L),
        ALBUMS(3L),
        LABELS(4L),
        KEYS(5L),
        COLORS(6L),
        PLAYLIST_TREE(7L),
        PLAYLIST_ENTRIES(8L),
        UNKNOWN_9(9L),
        UNKNOWN_10(10L),
        HISTORY_PLAYLISTS(11L),
        HISTORY_ENTRIES(12L),
        ARTWORK(13L),
        UNKNOWN_14(14L),
        UNKNOWN_15(15L),
        COLUMNS(16L),
        UNKNOWN_17(17L),
        UNKNOWN_18(18L),
        HISTORY(19L);

        private final long id;
        private static final Map<Long, PageType> byId;

        private PageType(long id) {
            this.id = id;
        }

        public long id() {
            return this.id;
        }

        public static PageType byId(long id) {
            return byId.get(id);
        }

        static {
            byId = new HashMap<Long, PageType>(20);
            for (PageType e : PageType.values()) {
                byId.put(e.id(), e);
            }
        }
    }
}

