/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.cratedigger;

import io.kaitai.struct.KaitaiStream;
import io.kaitai.struct.KaitaiStruct;
import io.kaitai.struct.RandomAccessFileKaitaiStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.deepsymmetry.cratedigger.pdb.RekordboxPdb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Database
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(Database.class);
    private final RekordboxPdb pdb;
    public final File sourceFile;
    public final Map<Long, RekordboxPdb.TrackRow> trackIndex;
    public final SortedMap<String, SortedSet<Long>> trackTitleIndex;
    public final SortedMap<Long, SortedSet<Long>> trackArtistIndex;
    public final SortedMap<Long, SortedSet<Long>> trackAlbumIndex;
    public final SortedMap<Long, SortedSet<Long>> trackGenreIndex;
    public final SortedMap<String, Long> historyPlaylistNameIndex;
    public final Map<Long, List<Long>> historyPlaylistIndex;
    public final Map<Long, RekordboxPdb.ArtistRow> artistIndex;
    public final SortedMap<String, SortedSet<Long>> artistNameIndex;
    public final Map<Long, RekordboxPdb.ColorRow> colorIndex;
    public final SortedMap<String, SortedSet<Long>> colorNameIndex;
    public final Map<Long, RekordboxPdb.AlbumRow> albumIndex;
    public final SortedMap<String, SortedSet<Long>> albumNameIndex;
    public final SortedMap<Long, SortedSet<Long>> albumArtistIndex;
    public final Map<Long, RekordboxPdb.LabelRow> labelIndex;
    public final SortedMap<String, SortedSet<Long>> labelNameIndex;
    public final Map<Long, RekordboxPdb.KeyRow> musicalKeyIndex;
    public final SortedMap<String, SortedSet<Long>> musicalKeyNameIndex;
    public final Map<Long, RekordboxPdb.GenreRow> genreIndex;
    public final SortedMap<String, SortedSet<Long>> genreNameIndex;
    public final Map<Long, RekordboxPdb.ArtworkRow> artworkIndex;
    public final Map<Long, List<Long>> playlistIndex;
    public final Map<Long, List<PlaylistFolderEntry>> playlistFolderIndex;

    public Database(File sourceFile) throws IOException {
        this.sourceFile = sourceFile;
        this.pdb = new RekordboxPdb((KaitaiStream)new RandomAccessFileKaitaiStream(sourceFile.getAbsolutePath()));
        TreeMap<String, SortedSet<Long>> mutableTrackTitleIndex = new TreeMap<String, SortedSet<Long>>(String.CASE_INSENSITIVE_ORDER);
        TreeMap<Long, SortedSet<Long>> mutableTrackArtistIndex = new TreeMap<Long, SortedSet<Long>>();
        TreeMap<Long, SortedSet<Long>> mutableTrackAlbumIndex = new TreeMap<Long, SortedSet<Long>>();
        TreeMap<Long, SortedSet<Long>> mutableTrackGenreIndex = new TreeMap<Long, SortedSet<Long>>();
        this.trackIndex = this.indexTracks(mutableTrackTitleIndex, mutableTrackArtistIndex, mutableTrackAlbumIndex, mutableTrackGenreIndex);
        this.trackTitleIndex = this.freezeSecondaryIndex(mutableTrackTitleIndex);
        this.trackAlbumIndex = this.freezeSecondaryIndex(mutableTrackAlbumIndex);
        this.trackArtistIndex = this.freezeSecondaryIndex(mutableTrackArtistIndex);
        this.trackGenreIndex = this.freezeSecondaryIndex(mutableTrackGenreIndex);
        TreeMap<String, SortedSet<Long>> mutableArtistNameIndex = new TreeMap<String, SortedSet<Long>>(String.CASE_INSENSITIVE_ORDER);
        this.artistIndex = this.indexArtists(mutableArtistNameIndex);
        this.artistNameIndex = this.freezeSecondaryIndex(mutableArtistNameIndex);
        TreeMap<String, SortedSet<Long>> mutableColorNameIndex = new TreeMap<String, SortedSet<Long>>(String.CASE_INSENSITIVE_ORDER);
        this.colorIndex = this.indexColors(mutableColorNameIndex);
        this.colorNameIndex = this.freezeSecondaryIndex(mutableColorNameIndex);
        TreeMap<String, SortedSet<Long>> mutableAlbumNameIndex = new TreeMap<String, SortedSet<Long>>(String.CASE_INSENSITIVE_ORDER);
        TreeMap<Long, SortedSet<Long>> mutableAlbumArtistIndex = new TreeMap<Long, SortedSet<Long>>();
        this.albumIndex = this.indexAlbums(mutableAlbumNameIndex, mutableAlbumArtistIndex);
        this.albumNameIndex = this.freezeSecondaryIndex(mutableAlbumNameIndex);
        this.albumArtistIndex = this.freezeSecondaryIndex(mutableAlbumArtistIndex);
        TreeMap<String, SortedSet<Long>> mutableLabelNameIndex = new TreeMap<String, SortedSet<Long>>(String.CASE_INSENSITIVE_ORDER);
        this.labelIndex = this.indexLabels(mutableLabelNameIndex);
        this.labelNameIndex = this.freezeSecondaryIndex(mutableLabelNameIndex);
        TreeMap<String, SortedSet<Long>> mutableMusicalKeyNameIndex = new TreeMap<String, SortedSet<Long>>(String.CASE_INSENSITIVE_ORDER);
        this.musicalKeyIndex = this.indexKeys(mutableMusicalKeyNameIndex);
        this.musicalKeyNameIndex = this.freezeSecondaryIndex(mutableMusicalKeyNameIndex);
        TreeMap<String, SortedSet<Long>> mutableGenreNameIndex = new TreeMap<String, SortedSet<Long>>(String.CASE_INSENSITIVE_ORDER);
        this.genreIndex = this.indexGenres(mutableGenreNameIndex);
        this.genreNameIndex = this.freezeSecondaryIndex(mutableGenreNameIndex);
        this.artworkIndex = this.indexArtwork();
        this.playlistIndex = this.indexPlaylists();
        this.playlistFolderIndex = this.indexPlaylistFolders();
        this.historyPlaylistIndex = this.indexHistoryPlaylists();
        this.historyPlaylistNameIndex = this.indexHistoryPlaylistNames();
    }

    private void indexRows(RekordboxPdb.PageType type, RowHandler handler) {
        boolean done = false;
        for (RekordboxPdb.Table table : this.pdb.tables()) {
            if (table.type() != type) continue;
            if (done) {
                throw new IllegalStateException("More than one table found with type " + type);
            }
            long lastIndex = table.lastPage().index();
            RekordboxPdb.PageRef currentRef = table.firstPage();
            boolean moreLeft = true;
            do {
                RekordboxPdb.Page page;
                if ((page = currentRef.body()).isDataPage().booleanValue()) {
                    for (RekordboxPdb.RowGroup rowGroup : page.rowGroups()) {
                        for (RekordboxPdb.RowRef rowRef : rowGroup.rows()) {
                            if (!rowRef.present().booleanValue()) continue;
                            handler.rowFound(rowRef.body());
                        }
                    }
                }
                if (currentRef.index() == lastIndex) {
                    moreLeft = false;
                    continue;
                }
                currentRef = page.nextPage();
            } while (moreLeft);
            done = true;
        }
        if (!done) {
            throw new IllegalStateException("No table found of type " + type);
        }
    }

    private <K> void addToSecondaryIndex(SortedMap<K, SortedSet<Long>> index, K key, Long id) {
        TreeSet<Long> existingIds = (TreeSet<Long>)index.get(key);
        if (existingIds == null) {
            existingIds = new TreeSet<Long>();
            index.put(key, existingIds);
        }
        existingIds.add(id);
    }

    private <K> SortedMap<K, SortedSet<Long>> freezeSecondaryIndex(SortedMap<K, SortedSet<Long>> index) {
        for (K key : index.keySet()) {
            index.put(key, Collections.unmodifiableSortedSet((SortedSet)index.get(key)));
        }
        return Collections.unmodifiableSortedMap(index);
    }

    private Map<Long, RekordboxPdb.TrackRow> indexTracks(final SortedMap<String, SortedSet<Long>> titleIndex, final SortedMap<Long, SortedSet<Long>> artistIndex, final SortedMap<Long, SortedSet<Long>> albumIndex, final SortedMap<Long, SortedSet<Long>> genreIndex) {
        final HashMap index = new HashMap();
        this.indexRows(RekordboxPdb.PageType.TRACKS, new RowHandler(){

            @Override
            public void rowFound(KaitaiStruct row) {
                RekordboxPdb.TrackRow trackRow = (RekordboxPdb.TrackRow)row;
                long id = trackRow.id();
                index.put(id, trackRow);
                String title = Database.getText(trackRow.title());
                if (title.length() > 0) {
                    Database.this.addToSecondaryIndex(titleIndex, title, id);
                }
                if (trackRow.artistId() > 0L) {
                    Database.this.addToSecondaryIndex(artistIndex, trackRow.artistId(), id);
                }
                if (trackRow.composerId() > 0L) {
                    Database.this.addToSecondaryIndex(artistIndex, trackRow.composerId(), id);
                }
                if (trackRow.originalArtistId() > 0L) {
                    Database.this.addToSecondaryIndex(artistIndex, trackRow.originalArtistId(), id);
                }
                if (trackRow.remixerId() > 0L) {
                    Database.this.addToSecondaryIndex(artistIndex, trackRow.remixerId(), id);
                }
                if (trackRow.albumId() > 0L) {
                    Database.this.addToSecondaryIndex(albumIndex, trackRow.albumId(), id);
                }
                if (trackRow.genreId() > 0L) {
                    Database.this.addToSecondaryIndex(genreIndex, trackRow.genreId(), id);
                }
            }
        });
        logger.info("Indexed " + index.size() + " Tracks.");
        return Collections.unmodifiableMap(index);
    }

    private Map<Long, RekordboxPdb.ArtistRow> indexArtists(final SortedMap<String, SortedSet<Long>> nameIndex) {
        final HashMap index = new HashMap();
        this.indexRows(RekordboxPdb.PageType.ARTISTS, new RowHandler(){

            @Override
            public void rowFound(KaitaiStruct row) {
                RekordboxPdb.ArtistRow artistRow = (RekordboxPdb.ArtistRow)row;
                long id = artistRow.id();
                index.put(id, artistRow);
                String name = Database.getText(artistRow.name());
                if (name.length() > 0) {
                    Database.this.addToSecondaryIndex(nameIndex, name, id);
                }
            }
        });
        logger.info("Indexed " + index.size() + " Artists.");
        return Collections.unmodifiableMap(index);
    }

    private Map<Long, RekordboxPdb.ColorRow> indexColors(final SortedMap<String, SortedSet<Long>> nameIndex) {
        final HashMap index = new HashMap();
        this.indexRows(RekordboxPdb.PageType.COLORS, new RowHandler(){

            @Override
            public void rowFound(KaitaiStruct row) {
                RekordboxPdb.ColorRow colorRow = (RekordboxPdb.ColorRow)row;
                long id = colorRow.id();
                index.put(id, colorRow);
                String name = Database.getText(colorRow.name());
                if (name.length() > 0) {
                    Database.this.addToSecondaryIndex(nameIndex, name, id);
                }
            }
        });
        logger.info("Indexed " + index.size() + " Colors.");
        return Collections.unmodifiableMap(index);
    }

    private Map<Long, RekordboxPdb.AlbumRow> indexAlbums(final SortedMap<String, SortedSet<Long>> nameIndex, final SortedMap<Long, SortedSet<Long>> artistIndex) {
        final HashMap index = new HashMap();
        this.indexRows(RekordboxPdb.PageType.ALBUMS, new RowHandler(){

            @Override
            public void rowFound(KaitaiStruct row) {
                RekordboxPdb.AlbumRow albumRow = (RekordboxPdb.AlbumRow)row;
                long id = albumRow.id();
                index.put(id, albumRow);
                String name = Database.getText(albumRow.name());
                if (name.length() > 0) {
                    Database.this.addToSecondaryIndex(nameIndex, name, id);
                }
                if (albumRow.artistId() > 0L) {
                    Database.this.addToSecondaryIndex(artistIndex, albumRow.artistId(), id);
                }
            }
        });
        logger.info("Indexed " + index.size() + " Albums.");
        return Collections.unmodifiableMap(index);
    }

    private Map<Long, RekordboxPdb.LabelRow> indexLabels(final SortedMap<String, SortedSet<Long>> nameIndex) {
        final HashMap index = new HashMap();
        this.indexRows(RekordboxPdb.PageType.LABELS, new RowHandler(){

            @Override
            public void rowFound(KaitaiStruct row) {
                RekordboxPdb.LabelRow labelRow = (RekordboxPdb.LabelRow)row;
                long id = labelRow.id();
                index.put(id, labelRow);
                String name = Database.getText(labelRow.name());
                if (name.length() > 0) {
                    Database.this.addToSecondaryIndex(nameIndex, name, id);
                }
            }
        });
        logger.info("Indexed " + index.size() + " Labels.");
        return Collections.unmodifiableMap(index);
    }

    private Map<Long, RekordboxPdb.KeyRow> indexKeys(final SortedMap<String, SortedSet<Long>> nameIndex) {
        final HashMap index = new HashMap();
        this.indexRows(RekordboxPdb.PageType.KEYS, new RowHandler(){

            @Override
            public void rowFound(KaitaiStruct row) {
                RekordboxPdb.KeyRow keyRow = (RekordboxPdb.KeyRow)row;
                long id = keyRow.id();
                index.put(id, keyRow);
                String name = Database.getText(keyRow.name());
                if (name.length() > 0) {
                    Database.this.addToSecondaryIndex(nameIndex, name, id);
                }
            }
        });
        logger.info("Indexed " + index.size() + " Musical Keys.");
        return Collections.unmodifiableMap(index);
    }

    private Map<Long, RekordboxPdb.GenreRow> indexGenres(final SortedMap<String, SortedSet<Long>> nameIndex) {
        final HashMap index = new HashMap();
        this.indexRows(RekordboxPdb.PageType.GENRES, new RowHandler(){

            @Override
            public void rowFound(KaitaiStruct row) {
                RekordboxPdb.GenreRow genreRow = (RekordboxPdb.GenreRow)row;
                long id = genreRow.id();
                index.put(id, genreRow);
                String name = Database.getText(genreRow.name());
                if (name.length() > 0) {
                    Database.this.addToSecondaryIndex(nameIndex, name, id);
                }
            }
        });
        logger.info("Indexed " + index.size() + " Genres.");
        return Collections.unmodifiableMap(index);
    }

    private Map<Long, RekordboxPdb.ArtworkRow> indexArtwork() {
        final HashMap index = new HashMap();
        this.indexRows(RekordboxPdb.PageType.ARTWORK, new RowHandler(){

            @Override
            public void rowFound(KaitaiStruct row) {
                RekordboxPdb.ArtworkRow artworkRow = (RekordboxPdb.ArtworkRow)row;
                index.put(artworkRow.id(), artworkRow);
            }
        });
        logger.info("Indexed " + index.size() + " Artwork Paths.");
        return Collections.unmodifiableMap(index);
    }

    private Map<Long, List<Long>> indexPlaylists() {
        final HashMap result = new HashMap();
        this.indexRows(RekordboxPdb.PageType.PLAYLIST_ENTRIES, new RowHandler(){

            @Override
            public void rowFound(KaitaiStruct row) {
                RekordboxPdb.PlaylistEntryRow entryRow = (RekordboxPdb.PlaylistEntryRow)row;
                ArrayList<Long> playlist = (ArrayList<Long>)result.get(entryRow.playlistId());
                if (playlist == null) {
                    playlist = new ArrayList<Long>();
                    result.put(entryRow.playlistId(), playlist);
                }
                while ((long)playlist.size() <= entryRow.entryIndex()) {
                    playlist.add(0L);
                }
                playlist.set((int)entryRow.entryIndex(), entryRow.trackId());
            }
        });
        for (Map.Entry entry : result.entrySet()) {
            result.put((Long)entry.getKey(), Collections.unmodifiableList((List)entry.getValue()));
        }
        logger.info("Indexed " + result.size() + " playlists.");
        return Collections.unmodifiableMap(result);
    }

    private Map<Long, List<PlaylistFolderEntry>> indexPlaylistFolders() {
        final HashMap result = new HashMap();
        this.indexRows(RekordboxPdb.PageType.PLAYLIST_TREE, new RowHandler(){

            @Override
            public void rowFound(KaitaiStruct row) {
                RekordboxPdb.PlaylistTreeRow treeRow = (RekordboxPdb.PlaylistTreeRow)row;
                ArrayList<PlaylistFolderEntry> parent = (ArrayList<PlaylistFolderEntry>)result.get(treeRow.parentId());
                if (parent == null) {
                    parent = new ArrayList<PlaylistFolderEntry>();
                    result.put(treeRow.parentId(), parent);
                }
                while ((long)parent.size() <= treeRow.sortOrder()) {
                    parent.add(null);
                }
                parent.set((int)treeRow.sortOrder(), new PlaylistFolderEntry(Database.getText(treeRow.name()), treeRow.isFolder(), treeRow.id()));
            }
        });
        for (Map.Entry entry : result.entrySet()) {
            result.put((Long)entry.getKey(), Collections.unmodifiableList((List)entry.getValue()));
        }
        logger.info("Indexed " + result.size() + " playlist folders.");
        return Collections.unmodifiableMap(result);
    }

    private SortedMap<String, Long> indexHistoryPlaylistNames() {
        final TreeMap result = new TreeMap();
        this.indexRows(RekordboxPdb.PageType.HISTORY_PLAYLISTS, new RowHandler(){

            @Override
            public void rowFound(KaitaiStruct row) {
                RekordboxPdb.HistoryPlaylistRow historyRow = (RekordboxPdb.HistoryPlaylistRow)row;
                result.put(Database.getText(historyRow.name()), historyRow.id());
            }
        });
        logger.info("Indexed " + result.size() + " history playlists.");
        return Collections.unmodifiableSortedMap(result);
    }

    private Map<Long, List<Long>> indexHistoryPlaylists() {
        final HashMap result = new HashMap();
        this.indexRows(RekordboxPdb.PageType.HISTORY_ENTRIES, new RowHandler(){

            @Override
            public void rowFound(KaitaiStruct row) {
                RekordboxPdb.HistoryEntryRow entryRow = (RekordboxPdb.HistoryEntryRow)row;
                ArrayList<Long> playList = (ArrayList<Long>)result.get(entryRow.playlistId());
                if (playList == null) {
                    playList = new ArrayList<Long>();
                    result.put(entryRow.playlistId(), playList);
                }
                while ((long)playList.size() <= entryRow.entryIndex()) {
                    playList.add(0L);
                }
                playList.set((int)entryRow.entryIndex(), entryRow.trackId());
            }
        });
        for (Map.Entry entry : result.entrySet()) {
            result.put((Long)entry.getKey(), Collections.unmodifiableList((List)entry.getValue()));
        }
        logger.info("Indexed " + result.size() + " history playlists.");
        return Collections.unmodifiableMap(result);
    }

    @Override
    public void close() throws IOException {
        this.pdb._io().close();
    }

    public static String getText(RekordboxPdb.DeviceSqlString string) {
        String text = null;
        if (string.body() instanceof RekordboxPdb.DeviceSqlShortAscii) {
            text = ((RekordboxPdb.DeviceSqlShortAscii)string.body()).text();
        } else if (string.body() instanceof RekordboxPdb.DeviceSqlLongAscii) {
            text = ((RekordboxPdb.DeviceSqlLongAscii)string.body()).text();
        } else if (string.body() instanceof RekordboxPdb.DeviceSqlLongUtf16le) {
            text = ((RekordboxPdb.DeviceSqlLongUtf16le)string.body()).text();
        }
        if (text != null) {
            return text;
        }
        logger.warn("Received unusable DeviceSqlString, returning empty string; lengthAndKind: " + string.lengthAndKind());
        return "";
    }

    public static class PlaylistFolderEntry {
        public final String name;
        public final boolean isFolder;
        public final long id;

        PlaylistFolderEntry(String name, boolean isFolder, long id) {
            this.name = name;
            this.isFolder = isFolder;
            this.id = id;
        }

        public String toString() {
            return "PlaylistFolderEntry[name:" + this.name + ", id:" + this.id + ", isFolder? " + this.isFolder + "]";
        }
    }

    private static interface RowHandler {
        public void rowFound(KaitaiStruct var1);
    }
}

