/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.electro;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.deepsymmetry.electro.MetronomeSnapshot;
import org.deepsymmetry.electro.Snapshot;

public class Metronome
implements Snapshot {
    private final AtomicLong startTime = new AtomicLong(System.currentTimeMillis());
    private final AtomicReference<Double> tempo = new AtomicReference<Double>(120.0);
    private final AtomicInteger beatsPerBar = new AtomicInteger(4);
    private final AtomicInteger barsPerPhrase = new AtomicInteger(8);

    @Override
    public long getStartTime() {
        return this.startTime.get();
    }

    public synchronized void adjustStart(long ms) {
        this.startTime.addAndGet(ms);
    }

    @Override
    public double getTempo() {
        return this.tempo.get();
    }

    public synchronized void setTempo(double bpm) {
        long instant = System.currentTimeMillis();
        long start = this.startTime.get();
        long interval = this.getBeatInterval();
        long beat = Metronome.markerNumber(instant, start, interval);
        double phase = Metronome.markerPhase(instant, start, interval);
        long newInterval = Metronome.beatsToMilliseconds(1L, bpm);
        this.startTime.set(Math.round((double)instant - (double)newInterval * (phase + (double)beat - 1.0)));
        this.tempo.set(bpm);
    }

    @Override
    public int getBeatsPerBar() {
        return this.beatsPerBar.get();
    }

    public void setBeatsPerBar(int beatsPerBar) {
        if (beatsPerBar <= 0) {
            throw new IllegalArgumentException("beatsPerBar must be greater than zero");
        }
        this.beatsPerBar.set(beatsPerBar);
    }

    @Override
    public int getBarsPerPhrase() {
        return this.barsPerPhrase.get();
    }

    public void setBarsPerPhrase(int barsPerPhrase) {
        if (barsPerPhrase <= 0) {
            throw new IllegalArgumentException("barsPerPhrase must be greater than zero");
        }
        this.barsPerPhrase.set(barsPerPhrase);
    }

    public static long beatsToMilliseconds(long beats, double tempo) {
        return Math.round(60000.0 / tempo * (double)beats);
    }

    public static long markerNumber(long instant, long start, long interval) {
        return (instant - start) / interval + 1L;
    }

    public static double markerPhase(long instant, long start, long interval) {
        double ratio = (double)(instant - start) / (double)interval;
        return ratio - Math.floor(ratio);
    }

    public static double normalizePhase(double phase) {
        if (phase < 0.0) {
            return phase - (double)((long)phase) + 1.0;
        }
        return phase - (double)((long)phase);
    }

    @Override
    public synchronized long getBeatInterval() {
        return Metronome.beatsToMilliseconds(1L, this.tempo.get());
    }

    @Override
    public synchronized long getBarInterval() {
        return Metronome.beatsToMilliseconds(this.beatsPerBar.get(), this.tempo.get());
    }

    @Override
    public synchronized long getPhraseInterval() {
        return Metronome.beatsToMilliseconds(this.beatsPerBar.get() * this.barsPerPhrase.get(), this.tempo.get());
    }

    @Override
    public synchronized long getBeat() {
        return Metronome.markerNumber(System.currentTimeMillis(), this.startTime.get(), this.getBeatInterval());
    }

    public synchronized void jumpToBeat(long beat) {
        this.startTime.set(System.currentTimeMillis() - (long)Math.round((beat - 1L) * this.getBeatInterval()));
    }

    @Override
    public synchronized long getTimeOfBeat(long beat) {
        return (beat - 1L) * this.getBeatInterval() + this.startTime.get();
    }

    @Override
    public synchronized double getBeatPhase() {
        return Metronome.markerPhase(System.currentTimeMillis(), this.startTime.get(), this.getBeatInterval());
    }

    private static double findClosestDelta(double delta) {
        return delta > 0.5 ? delta - 1.0 : (delta < -0.5 ? delta + 1.0 : delta);
    }

    public synchronized void setBeatPhase(double phase) {
        double delta = Metronome.findClosestDelta(Metronome.normalizePhase(phase) - this.getBeatPhase());
        long shift = Math.round((double)this.getBeatInterval() * delta);
        this.startTime.addAndGet(-shift);
    }

    @Override
    public synchronized long getBar() {
        return Metronome.markerNumber(System.currentTimeMillis(), this.startTime.get(), this.getBarInterval());
    }

    public synchronized void jumpToBar(long bar) {
        double phase = this.getBeatPhase();
        double closestPhase = phase > 0.5 ? phase - 1.0 : phase;
        double shift = (double)this.getBeatInterval() * closestPhase;
        this.startTime.set(Math.round((double)System.currentTimeMillis() - shift - (double)((bar - 1L) * this.getBarInterval())));
    }

    @Override
    public synchronized long getTimeOfBar(long bar) {
        return (bar - 1L) * this.getBarInterval() + this.startTime.get();
    }

    @Override
    public synchronized double getBarPhase() {
        return Metronome.markerPhase(System.currentTimeMillis(), this.startTime.get(), this.getBarInterval());
    }

    public synchronized void setBarPhase(double phase) {
        double delta = Metronome.findClosestDelta(Metronome.normalizePhase(phase) - this.getBarPhase());
        long shift = Math.round((double)this.getBarInterval() * delta);
        this.startTime.addAndGet(-shift);
    }

    @Override
    public synchronized long getPhrase() {
        return Metronome.markerNumber(System.currentTimeMillis(), this.startTime.get(), this.getPhraseInterval());
    }

    public synchronized void jumpToPhrase(long phrase) {
        double phase = this.getBeatPhase();
        double closestPhase = phase > 0.5 ? phase - 1.0 : phase;
        double shift = (double)this.getBeatInterval() * closestPhase;
        this.startTime.set(Math.round((double)System.currentTimeMillis() - shift - (double)((phrase - 1L) * this.getPhraseInterval())));
    }

    @Override
    public synchronized long getTimeOfPhrase(long phrase) {
        return (phrase - 1L) * this.getPhraseInterval() + this.startTime.get();
    }

    @Override
    public synchronized double getPhrasePhase() {
        return Metronome.markerPhase(System.currentTimeMillis(), this.startTime.get(), this.getPhraseInterval());
    }

    public synchronized void setPhrasePhase(double phase) {
        double delta = Metronome.findClosestDelta(Metronome.normalizePhase(phase) - this.getPhrasePhase());
        long shift = Math.round((double)this.getPhraseInterval() * delta);
        this.startTime.addAndGet(-shift);
    }

    public synchronized Snapshot getSnapshot() {
        return new MetronomeSnapshot(this);
    }

    public synchronized Snapshot getSnapshot(long instant) {
        return new MetronomeSnapshot(this, instant);
    }

    @Override
    public String getMarker() {
        return this.getSnapshot().getMarker();
    }

    @Override
    public long getInstant() {
        return System.currentTimeMillis();
    }

    @Override
    public int getBeatWithinBar() {
        double beatSize = 1.0 / (double)this.beatsPerBar.get();
        return 1 + (int)Math.floor(this.getBarPhase() / beatSize);
    }

    @Override
    public boolean isDownBeat() {
        return this.getBeatWithinBar() == 1;
    }

    @Override
    public int getBeatWithinPhrase() {
        double beatSize = 1.0 / (double)(this.beatsPerBar.get() * this.barsPerPhrase.get());
        return 1 + (int)Math.floor(this.getPhrasePhase() / beatSize);
    }

    @Override
    public boolean isPhraseStart() {
        return this.getBeatWithinPhrase() == 1;
    }

    @Override
    public int getBarWithinPhrase() {
        double barSize = 1.0 / (double)this.barsPerPhrase.get();
        return 1 + (int)Math.floor(this.getPhrasePhase() / barSize);
    }

    public String toString() {
        return "Metronome[" + this.getSnapshot().toString() + "]";
    }
}

