/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.electro;

import java.util.Date;
import org.deepsymmetry.electro.Metronome;
import org.deepsymmetry.electro.Snapshot;

class MetronomeSnapshot
implements Snapshot {
    private final long startTime;
    private final double tempo;
    private final int beatsPerBar;
    private final int barsPerPhrase;
    private final long instant;
    private final double beatInterval;
    private final double barInterval;
    private final double phraseInterval;

    MetronomeSnapshot(Metronome metronome) {
        this(metronome, System.currentTimeMillis());
    }

    MetronomeSnapshot(Metronome metronome, long instant) {
        this.startTime = metronome.getStartTime();
        this.tempo = metronome.getTempo();
        this.beatsPerBar = metronome.getBeatsPerBar();
        this.barsPerPhrase = metronome.getBarsPerPhrase();
        this.instant = instant;
        this.beatInterval = metronome.getBeatInterval();
        this.barInterval = metronome.getBarInterval();
        this.phraseInterval = metronome.getPhraseInterval();
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public double getTempo() {
        return this.tempo;
    }

    @Override
    public int getBeatsPerBar() {
        return this.beatsPerBar;
    }

    @Override
    public int getBarsPerPhrase() {
        return this.barsPerPhrase;
    }

    @Override
    public long getInstant() {
        return this.instant;
    }

    @Override
    public double getBeatInterval() {
        return this.beatInterval;
    }

    @Override
    public double getBarInterval() {
        return this.barInterval;
    }

    @Override
    public double getPhraseInterval() {
        return this.phraseInterval;
    }

    @Override
    public long getBeat() {
        return Metronome.markerNumber(this.instant, this.startTime, this.beatInterval);
    }

    @Override
    public long getBar() {
        return Metronome.markerNumber(this.instant, this.startTime, this.barInterval);
    }

    @Override
    public long getPhrase() {
        return Metronome.markerNumber(this.instant, this.startTime, this.phraseInterval);
    }

    @Override
    public double getBeatPhase() {
        return Metronome.markerPhase(this.instant, this.startTime, this.beatInterval);
    }

    @Override
    public double getBarPhase() {
        return Metronome.markerPhase(this.instant, this.startTime, this.barInterval);
    }

    @Override
    public double getPhrasePhase() {
        return Metronome.markerPhase(this.instant, this.startTime, this.phraseInterval);
    }

    @Override
    public long getTimeOfBeat(long beat) {
        return Math.round((double)(beat - 1L) * this.beatInterval) + this.startTime;
    }

    @Override
    public int getBeatWithinBar() {
        double beatSize = 1.0 / (double)this.beatsPerBar;
        return 1 + (int)Math.floor(this.getBarPhase() / beatSize);
    }

    @Override
    public boolean isDownBeat() {
        return this.getBeatWithinBar() == 1;
    }

    @Override
    public int getBeatWithinPhrase() {
        double beatSize = 1.0 / (double)(this.beatsPerBar * this.barsPerPhrase);
        return 1 + (int)Math.floor(this.getPhrasePhase() / beatSize);
    }

    @Override
    public boolean isPhraseStart() {
        return this.getBeatWithinPhrase() == 1;
    }

    @Override
    public long getTimeOfBar(long bar) {
        return Math.round((double)(bar - 1L) * this.barInterval) + this.startTime;
    }

    @Override
    public int getBarWithinPhrase() {
        double barSize = 1.0 / (double)this.barsPerPhrase;
        return 1 + (int)Math.floor(this.getPhrasePhase() / barSize);
    }

    @Override
    public long getTimeOfPhrase(long phrase) {
        return Math.round((double)(phrase - 1L) * this.phraseInterval) + this.startTime;
    }

    @Override
    public String getMarker() {
        return this.getPhrase() + "." + this.getBarWithinPhrase() + "." + this.getBeatWithinBar();
    }

    public String toString() {
        return "Snapshot[marker: " + this.getMarker() + ", startTime:" + this.startTime + " (" + new Date(this.startTime) + "), instant: " + this.instant + " (" + new Date(this.instant) + "), beatPhase:" + this.getBeatPhase() + ", barPhase:" + this.getBarPhase() + ", phrasePhase:" + this.getPhrasePhase() + ", tempo:" + this.tempo + ", beatsPerBar:" + this.beatsPerBar + ", barsPerPhrase:" + this.barsPerPhrase + ", beatInterval:" + this.beatInterval + ", barInterval:" + this.barInterval + ", phraseInterval:" + this.phraseInterval + "]";
    }
}

