/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.libcarabiner;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.bpsm.edn.Keyword;
import us.bpsm.edn.Symbol;
import us.bpsm.edn.parser.Parseable;
import us.bpsm.edn.parser.Parser;
import us.bpsm.edn.parser.Parsers;

public class Message {
    private static final Logger logger = LoggerFactory.getLogger(Message.class);
    public final String messageType;
    public final Map<String, Object> details;

    public Message(String response) {
        Parseable parseable = Parsers.newParseable((CharSequence)response);
        Parser parser = Parsers.newParser((Parser.Config)Parsers.defaultConfiguration());
        Object read = parser.nextValue(parseable);
        if (!(read instanceof Symbol)) {
            throw new IllegalArgumentException("Carabiner messages must begin with a symbol. Received:" + response);
        }
        this.messageType = ((Symbol)read).getName().intern();
        read = parser.nextValue(parseable);
        if (read == Parser.END_OF_INPUT) {
            this.details = null;
        } else if (read instanceof Map) {
            this.details = Collections.unmodifiableMap(((Map)read).entrySet().stream().collect(HashMap::new, (map, e) -> map.put(((Keyword)e.getKey()).getName().intern(), e.getValue()), Map::putAll));
        } else {
            System.out.println(read);
            throw new IllegalArgumentException("Carabiner message details, if present, must be a map. Received: " + response);
        }
        read = parser.nextValue(parseable);
        if (read != Parser.END_OF_INPUT) {
            throw new IllegalArgumentException("Carabiner messages must consist of a symbol optionally followed by a map. Received: " + response);
        }
    }
}

