/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.libcarabiner;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Runner {
    private static final Logger logger = LoggerFactory.getLogger(Runner.class);
    private static final Runner ourInstance = new Runner();
    private File carabiner;
    private final AtomicReference<Process> process = new AtomicReference<Object>(null);
    private final AtomicInteger port = new AtomicInteger(17000);
    private final AtomicInteger updateInterval = new AtomicInteger(20);

    public static Runner getInstance() {
        return ourInstance;
    }

    private Runner() {
    }

    private String getOSComponent() {
        String osName = System.getProperty("os.name").toLowerCase().replace(" ", "");
        if (osName.equals("macosx") || osName.equals("macos")) {
            return "Mac";
        }
        if (osName.contains("windows")) {
            return "Win";
        }
        if (osName.contains("linux")) {
            return "Linux";
        }
        return osName;
    }

    private String getArchComponent() {
        String arch = System.getProperty("os.arch").toLowerCase().replace(" ", "");
        if (arch.equals("i386")) {
            return "x86";
        }
        if (arch.equals("amd64") || arch.equals("x86_64")) {
            return "x64";
        }
        if (arch.equals("aarch64")) {
            return "arm64";
        }
        if (arch.equals("armhf") || arch.equals("aarch32") || arch.equals("armv7l")) {
            return "arm";
        }
        return arch;
    }

    public String getExecutableName() {
        return "Carabiner_" + this.getOSComponent() + "_" + this.getArchComponent();
    }

    public boolean canRunCarabiner() {
        return Runner.class.getResource(this.getExecutableName()) != null;
    }

    private File createExecutable() throws IOException {
        if (this.carabiner != null) {
            return this.carabiner;
        }
        InputStream binary = Runner.class.getResourceAsStream(this.getExecutableName());
        if (binary == null) {
            throw new IllegalStateException("Incompatible platform: there is no Carabiner binary named " + this.getExecutableName());
        }
        try {
            this.carabiner = File.createTempFile("Carabiner", ".exe");
            this.carabiner.deleteOnExit();
            if (!this.carabiner.canWrite()) {
                throw new IOException("Unable to write to temporary file " + this.carabiner);
            }
            Files.copy(binary, this.carabiner.toPath(), StandardCopyOption.REPLACE_EXISTING);
            if (!this.carabiner.setExecutable(true)) {
                throw new IOException("Unable to make binary file executable, " + this.carabiner);
            }
            return this.carabiner;
        }
        catch (IOException e) {
            throw new IOException("Unable to create temporary directory for the Carabiner executable: " + e, e);
        }
    }

    public void setPort(int carabinerPort) {
        if (carabinerPort < 1 || carabinerPort > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Carabiner port must be in the range 1-32767.");
        }
        if (this.process.get() != null) {
            throw new IllegalStateException("Carabiner port can only be set when it is not running.");
        }
        this.port.set(carabinerPort);
    }

    public void setUpdateInterval(int interval) {
        if (interval < 1 || interval > 1000) {
            throw new IllegalArgumentException("Carabiner update interval must be in the range 1-1000.");
        }
        if (this.process.get() != null) {
            throw new IllegalStateException("Carabiner update interval can only be set when it is not running.");
        }
        this.updateInterval.set(interval);
    }

    private void reportCarabinerEnding() {
        Process wasRunning = this.process.getAndSet(null);
        if (wasRunning != null) {
            try {
                int status = wasRunning.waitFor();
                if (status == 0) {
                    logger.info("Carabiner process exited normally.");
                } else if (status == 143 && !this.getOSComponent().equals("Win") || status == 1 && this.getOSComponent().equals("Win")) {
                    logger.info("Carabiner process forcibly terminated.");
                } else {
                    logger.warn("Carabiner process exited with status " + status);
                }
            }
            catch (InterruptedException e) {
                logger.error("Inexplicably interrupted waiting for Carabiner process to finish", (Throwable)e);
            }
        }
    }

    public synchronized void start() throws IOException {
        if (this.process.get() == null) {
            File binary = this.createExecutable();
            String[] command = new String[]{binary.getAbsolutePath(), "--daemon", "--port", String.valueOf(this.port.get()), "--poll", String.valueOf(this.updateInterval.get())};
            Process started = Runtime.getRuntime().exec(command);
            this.process.set(started);
            new Thread(() -> {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(started.getInputStream()));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        logger.info(line.trim());
                    }
                }
                catch (IOException e) {
                    logger.error("Problem reading Carabiner output", (Throwable)e);
                    this.stop();
                }
                this.reportCarabinerEnding();
            }, "Carabiner Output Logger").start();
            new Thread(() -> {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(started.getErrorStream()));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        logger.error(line.trim());
                    }
                }
                catch (IOException e) {
                    logger.error("Problem reading Carabiner errors", (Throwable)e);
                    this.stop();
                }
                this.reportCarabinerEnding();
            }, "Carabiner Error Logger").start();
        }
    }

    public synchronized void stop() {
        Process wasRunning = this.process.get();
        if (wasRunning != null) {
            wasRunning.destroy();
        }
    }
}

