/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry;

import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.usb4java.Context;
import org.usb4java.Device;
import org.usb4java.DeviceDescriptor;
import org.usb4java.DeviceHandle;
import org.usb4java.DeviceList;
import org.usb4java.LibUsb;
import org.usb4java.LibUsbException;

public class Wayang {
    private static final Context context = new Context();
    private static ByteBuffer transferBuffer = null;
    private static ByteBuffer headerBuffer = null;
    private static final byte[] frameHeader = new byte[]{-1, -52, -86, -120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final int DISPLAY_WIDTH = 960;
    public static final int DISPLAY_HEIGHT = 160;
    private static final int LINES_PER_TRANSFER = 8;
    private static final int BYTES_PER_LINE = 2048;
    private static DeviceHandle pushHandle = null;
    private static BufferedImage displayImage = null;
    private static boolean shutdownHookInstalled = false;

    public static synchronized void close() {
        if (pushHandle != null) {
            displayImage = null;
            LibUsb.close((DeviceHandle)pushHandle);
            pushHandle = null;
        }
        if (transferBuffer != null) {
            LibUsb.exit((Context)context);
            headerBuffer = null;
            transferBuffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Device findPush() {
        DeviceList list = new DeviceList();
        int result = LibUsb.getDeviceList(null, (DeviceList)list);
        if (result < 0) {
            throw new LibUsbException("Unable to get device list", result);
        }
        try {
            for (Device device : list) {
                DeviceDescriptor descriptor;
                result = LibUsb.getDeviceDescriptor((Device)device, (DeviceDescriptor)(descriptor = new DeviceDescriptor()));
                if (result != 0) {
                    throw new LibUsbException("Unable to read device descriptor", result);
                }
                if (descriptor.bDeviceClass() != 0 || descriptor.idVendor() != 10626 || descriptor.idProduct() != 6503) continue;
                Device device2 = device;
                return device2;
            }
        }
        finally {
            LibUsb.freeDeviceList((DeviceList)list, (boolean)true);
        }
        return null;
    }

    private static void openPushDisplay(Device device) {
        DeviceHandle handle = new DeviceHandle();
        int result = LibUsb.open((Device)device, (DeviceHandle)handle);
        if (result != 0) {
            throw new LibUsbException("Unable to open Push 2 USB device", result);
        }
        result = LibUsb.claimInterface((DeviceHandle)handle, (int)0);
        if (result < 0) {
            LibUsb.close((DeviceHandle)handle);
            throw new LibUsbException("Unable to claim interface 0 of Push 2 device", result);
        }
        pushHandle = handle;
        DirectColorModel colorModel = new DirectColorModel(16, 31, 2016, 63488);
        int[] bandMasks = new int[]{31, 2016, 63488};
        WritableRaster raster = WritableRaster.createPackedRaster(1, 960, 160, bandMasks, null);
        displayImage = new BufferedImage(colorModel, raster, false, null);
    }

    public static synchronized BufferedImage open() {
        int result;
        if (!shutdownHookInstalled) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    Wayang.close();
                }
            });
            shutdownHookInstalled = true;
        }
        if ((result = LibUsb.init((Context)context)) != 0) {
            throw new LibUsbException("Unable to initialize libusb", result);
        }
        transferBuffer = ByteBuffer.allocateDirect(16384);
        headerBuffer = ByteBuffer.allocateDirect(frameHeader.length);
        headerBuffer.put(frameHeader);
        try {
            Device device = Wayang.findPush();
            if (device == null) {
                throw new IllegalStateException("Unable to find Ableton Push 2 display device");
            }
            Wayang.openPushDisplay(device);
        }
        catch (RuntimeException e) {
            Wayang.close();
            throw e;
        }
        return displayImage;
    }

    private static final void maskPixels(short[] pixels, byte[] destination) {
        for (int y = 0; y < 8; ++y) {
            for (int x = 0; x < 960; x += 2) {
                int pixelOffset = y * 960 + x;
                int destinationOffset = y * 2048 + x * 2;
                destination[destinationOffset] = (byte)(pixels[pixelOffset] & 0xFF ^ 0xE7);
                destination[destinationOffset + 1] = (byte)(pixels[pixelOffset] >>> 8 ^ 0xF3);
                destination[destinationOffset + 2] = (byte)(pixels[pixelOffset + 1] & 0xFF ^ 0xE7);
                destination[destinationOffset + 3] = (byte)(pixels[pixelOffset + 1] >>> 8 ^ 0xFF);
            }
        }
    }

    public static void sendFrame() {
        if (transferBuffer == null) {
            throw new IllegalStateException("Push 2 device has not been opened");
        }
        IntBuffer transferred = IntBuffer.allocate(1);
        int result = LibUsb.bulkTransfer((DeviceHandle)pushHandle, (byte)1, (ByteBuffer)headerBuffer, (IntBuffer)transferred, (long)1000L);
        if (result != 0) {
            throw new LibUsbException("Transfer of frame header to Push 2 display failed", result);
        }
        short[] pixels = new short[7680];
        byte[] maskedChunk = new byte[16384];
        for (int i = 0; i < 20; ++i) {
            displayImage.getRaster().getDataElements(0, i * 8, 960, 8, pixels);
            Wayang.maskPixels(pixels, maskedChunk);
            transferBuffer.clear();
            transferBuffer.put(maskedChunk);
            transferred.clear();
            result = LibUsb.bulkTransfer((DeviceHandle)pushHandle, (byte)1, (ByteBuffer)transferBuffer, (IntBuffer)transferred, (long)1000L);
            if (result == 0) continue;
            throw new LibUsbException("Transfer of frame header to Push 2 display failed", result);
        }
    }
}

