/*
 * Decompiled with CFR 0.152.
 */
package org.usb4java;

import java.io.FileDescriptor;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.usb4java.BosDescriptor;
import org.usb4java.BosDevCapabilityDescriptor;
import org.usb4java.BufferUtils;
import org.usb4java.ConfigDescriptor;
import org.usb4java.ContainerIdDescriptor;
import org.usb4java.Context;
import org.usb4java.ControlSetup;
import org.usb4java.Device;
import org.usb4java.DeviceDescriptor;
import org.usb4java.DeviceHandle;
import org.usb4java.DeviceList;
import org.usb4java.EndpointDescriptor;
import org.usb4java.HotplugCallback;
import org.usb4java.HotplugCallbackHandle;
import org.usb4java.IsoPacketDescriptor;
import org.usb4java.Loader;
import org.usb4java.PollfdListener;
import org.usb4java.SsEndpointCompanionDescriptor;
import org.usb4java.SsUsbDeviceCapabilityDescriptor;
import org.usb4java.Transfer;
import org.usb4java.TransferCallback;
import org.usb4java.Usb20ExtensionDescriptor;
import org.usb4java.Version;

public final class LibUsb {
    public static final int LOG_LEVEL_NONE = 0;
    public static final int LOG_LEVEL_ERROR = 1;
    public static final int LOG_LEVEL_WARNING = 2;
    public static final int LOG_LEVEL_INFO = 3;
    public static final int LOG_LEVEL_DEBUG = 4;
    public static final int SUCCESS = 0;
    public static final int ERROR_IO = -1;
    public static final int ERROR_INVALID_PARAM = -2;
    public static final int ERROR_ACCESS = -3;
    public static final int ERROR_NO_DEVICE = -4;
    public static final int ERROR_NOT_FOUND = -5;
    public static final int ERROR_BUSY = -6;
    public static final int ERROR_TIMEOUT = -7;
    public static final int ERROR_OVERFLOW = -8;
    public static final int ERROR_PIPE = -9;
    public static final int ERROR_INTERRUPTED = -10;
    public static final int ERROR_NO_MEM = -11;
    public static final int ERROR_NOT_SUPPORTED = -12;
    public static final int ERROR_OTHER = -99;
    public static final int ERROR_COUNT = 14;
    public static final int SPEED_UNKNOWN = 0;
    public static final int SPEED_LOW = 1;
    public static final int SPEED_FULL = 2;
    public static final int SPEED_HIGH = 3;
    public static final int SPEED_SUPER = 4;
    public static final short LOW_SPEED_OPERATION = 1;
    public static final short FULL_SPEED_OPERATION = 2;
    public static final short HIGH_SPEED_OPERATION = 4;
    public static final short SUPER_SPEED_OPERATION = 8;
    public static final int BM_LPM_SUPPORT = 2;
    public static final byte BM_LTM_SUPPORT = 2;
    public static final byte BT_WIRELESS_USB_DEVICE_CAPABILITY = 1;
    public static final byte BT_USB_2_0_EXTENSION = 2;
    public static final byte BT_SS_USB_DEVICE_CAPABILITY = 3;
    public static final byte BT_CONTAINER_ID = 4;
    public static final byte REQUEST_GET_STATUS = 0;
    public static final byte REQUEST_CLEAR_FEATURE = 1;
    public static final byte REQUEST_SET_FEATURE = 3;
    public static final byte REQUEST_SET_ADDRESS = 5;
    public static final byte REQUEST_GET_DESCRIPTOR = 6;
    public static final byte REQUEST_SET_DESCRIPTOR = 7;
    public static final byte REQUEST_GET_CONFIGURATION = 8;
    public static final byte REQUEST_SET_CONFIGURATION = 9;
    public static final byte REQUEST_GET_INTERFACE = 10;
    public static final byte REQUEST_SET_INTERFACE = 11;
    public static final byte REQUEST_SYNCH_FRAME = 12;
    public static final byte REQUEST_SET_SEL = 48;
    public static final byte SET_ISOCH_DELAY = 49;
    public static final byte REQUEST_TYPE_STANDARD = 0;
    public static final byte REQUEST_TYPE_CLASS = 32;
    public static final byte REQUEST_TYPE_VENDOR = 64;
    public static final byte REQUEST_TYPE_RESERVED = 96;
    public static final byte RECIPIENT_DEVICE = 0;
    public static final byte RECIPIENT_INTERFACE = 1;
    public static final byte RECIPIENT_ENDPOINT = 2;
    public static final byte RECIPIENT_OTHER = 3;
    public static final int CAP_HAS_CAPABILITY = 0;
    public static final int CAP_HAS_HOTPLUG = 1;
    public static final int CAP_HAS_HID_ACCESS = 256;
    public static final int CAP_SUPPORTS_DETACH_KERNEL_DRIVER = 257;
    public static final short CONTROL_SETUP_SIZE = 8;
    public static final byte CLASS_PER_INTERFACE = 0;
    public static final byte CLASS_AUDIO = 1;
    public static final byte CLASS_COMM = 2;
    public static final byte CLASS_HID = 3;
    public static final byte CLASS_PHYSICAL = 5;
    public static final byte CLASS_PTP = 6;
    public static final byte CLASS_IMAGE = 6;
    public static final byte CLASS_PRINTER = 7;
    public static final byte CLASS_MASS_STORAGE = 8;
    public static final byte CLASS_HUB = 9;
    public static final byte CLASS_DATA = 10;
    public static final byte CLASS_SMART_CARD = 11;
    public static final byte CLASS_CONTENT_SECURITY = 13;
    public static final byte CLASS_VIDEO = 14;
    public static final byte CLASS_PERSONAL_HEALTHCARE = 15;
    public static final byte CLASS_DIAGNOSTIC_DEVICE = -36;
    public static final byte CLASS_WIRELESS = -32;
    public static final byte CLASS_APPLICATION = -2;
    public static final byte CLASS_VENDOR_SPEC = -1;
    public static final byte DT_DEVICE = 1;
    public static final byte DT_CONFIG = 2;
    public static final byte DT_STRING = 3;
    public static final byte DT_INTERFACE = 4;
    public static final byte DT_ENDPOINT = 5;
    public static final byte DT_BOS = 15;
    public static final byte DT_DEVICE_CAPABILITY = 16;
    public static final byte DT_HID = 33;
    public static final byte DT_REPORT = 34;
    public static final byte DT_PHYSICAL = 35;
    public static final byte DT_HUB = 41;
    public static final byte DT_SUPERSPEED_HUB = 42;
    public static final byte DT_SS_ENDPOINT_COMPANION = 48;
    public static final byte DT_DEVICE_SIZE = 18;
    public static final byte DT_CONFIG_SIZE = 9;
    public static final byte DT_INTERFACE_SIZE = 9;
    public static final byte DT_ENDPOINT_SIZE = 7;
    public static final byte DT_ENDPOINT_AUDIO_SIZE = 9;
    public static final byte DT_HUB_NONVAR_SIZE = 7;
    public static final byte DT_SS_ENDPOINT_COMPANION_SIZE = 6;
    public static final byte DT_BOS_SIZE = 5;
    public static final byte DT_DEVICE_CAPABILITY_SIZE = 3;
    public static final byte BT_USB_2_0_EXTENSION_SIZE = 7;
    public static final byte BT_SS_USB_DEVICE_CAPABILITY_SIZE = 10;
    public static final byte BT_CONTAINER_ID_SIZE = 20;
    public static final byte DT_BOS_MAX_SIZE = 42;
    public static final byte ENDPOINT_IN = -128;
    public static final byte ENDPOINT_OUT = 0;
    public static final byte ENDPOINT_ADDRESS_MASK = 15;
    public static final byte ENDPOINT_DIR_MASK = -128;
    public static final byte TRANSFER_TYPE_MASK = 3;
    public static final byte TRANSFER_TYPE_CONTROL = 0;
    public static final byte TRANSFER_TYPE_ISOCHRONOUS = 1;
    public static final byte TRANSFER_TYPE_BULK = 2;
    public static final byte TRANSFER_TYPE_INTERRUPT = 3;
    public static final byte ISO_SYNC_TYPE_MASK = 12;
    public static final byte ISO_SYNC_TYPE_NONE = 0;
    public static final byte ISO_SYNC_TYPE_ASYNC = 1;
    public static final byte ISO_SYNC_TYPE_ADAPTIVE = 2;
    public static final byte ISO_SYNC_TYPE_SYNC = 3;
    public static final byte ISO_USAGE_TYPE_MASK = 48;
    public static final byte ISO_USAGE_TYPE_DATA = 0;
    public static final byte ISO_USAGE_TYPE_FEEDBACK = 1;
    public static final byte ISO_USAGE_TYPE_IMPLICIT = 2;
    public static final byte TRANSFER_SHORT_NOT_OK = 1;
    public static final byte TRANSFER_FREE_BUFFER = 0;
    public static final byte TRANSFER_FREE_TRANSFER = 4;
    public static final byte TRANSFER_ADD_ZERO_PACKET = 8;
    public static final int TRANSFER_COMPLETED = 0;
    public static final int TRANSFER_ERROR = 1;
    public static final int TRANSFER_TIMED_OUT = 2;
    public static final int TRANSFER_CANCELLED = 3;
    public static final int TRANSFER_STALL = 4;
    public static final int TRANSFER_NO_DEVICE = 5;
    public static final int TRANSFER_OVERFLOW = 6;
    public static final int HOTPLUG_ENUMERATE = 1;
    public static final int HOTPLUG_EVENT_DEVICE_ARRIVED = 1;
    public static final int HOTPLUG_EVENT_DEVICE_LEFT = 2;
    public static final int HOTPLUG_MATCH_ANY = -1;
    private static long globalHotplugId = 1L;
    private static final ConcurrentMap<Long, ImmutablePair<HotplugCallback, Object>> hotplugCallbacks = new ConcurrentHashMap<Long, ImmutablePair<HotplugCallback, Object>>();
    private static final ConcurrentMap<Long, ImmutablePair<PollfdListener, Object>> pollfdListeners = new ConcurrentHashMap<Long, ImmutablePair<PollfdListener, Object>>();

    private LibUsb() {
    }

    public static native int getApiVersion();

    public static synchronized native int init(Context var0);

    public static synchronized native void exit(Context var0);

    public static native void setDebug(Context var0, int var1);

    public static native Version getVersion();

    public static native int getDeviceList(Context var0, DeviceList var1);

    public static native void freeDeviceList(DeviceList var0, boolean var1);

    public static native int getBusNumber(Device var0);

    public static native int getPortNumber(Device var0);

    public static native int getPortNumbers(Device var0, ByteBuffer var1);

    @Deprecated
    public static int getPortPath(Context context, Device device, ByteBuffer path) {
        return LibUsb.getPortNumbers(device, path);
    }

    public static native Device getParent(Device var0);

    public static native int getDeviceAddress(Device var0);

    public static native int getDeviceSpeed(Device var0);

    public static native int getMaxPacketSize(Device var0, byte var1);

    public static native int getMaxIsoPacketSize(Device var0, byte var1);

    public static native Device refDevice(Device var0);

    public static native void unrefDevice(Device var0);

    public static native int open(Device var0, DeviceHandle var1);

    public static native DeviceHandle openDeviceWithVidPid(Context var0, short var1, short var2);

    public static native void close(DeviceHandle var0);

    public static native Device getDevice(DeviceHandle var0);

    public static native int getConfiguration(DeviceHandle var0, IntBuffer var1);

    public static native int setConfiguration(DeviceHandle var0, int var1);

    public static native int claimInterface(DeviceHandle var0, int var1);

    public static native int releaseInterface(DeviceHandle var0, int var1);

    public static native int setInterfaceAltSetting(DeviceHandle var0, int var1, int var2);

    public static native int clearHalt(DeviceHandle var0, byte var1);

    public static native int resetDevice(DeviceHandle var0);

    public static native int kernelDriverActive(DeviceHandle var0, int var1);

    public static native int detachKernelDriver(DeviceHandle var0, int var1);

    public static native int attachKernelDriver(DeviceHandle var0, int var1);

    public static native int setAutoDetachKernelDriver(DeviceHandle var0, boolean var1);

    public static native boolean hasCapability(int var0);

    public static native String errorName(int var0);

    public static native int setLocale(String var0);

    public static native String strError(int var0);

    public static native short le16ToCpu(short var0);

    public static native short cpuToLe16(short var0);

    public static native int getDeviceDescriptor(Device var0, DeviceDescriptor var1);

    static native int deviceDescriptorStructSize();

    public static native int getStringDescriptorAscii(DeviceHandle var0, byte var1, StringBuffer var2);

    public static String getStringDescriptor(DeviceHandle handle, byte index) {
        if (handle == null || index == 0) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        if (LibUsb.getStringDescriptorAscii(handle, index, buffer) >= 0) {
            return buffer.toString();
        }
        return null;
    }

    public static native int getActiveConfigDescriptor(Device var0, ConfigDescriptor var1);

    public static native int getConfigDescriptor(Device var0, byte var1, ConfigDescriptor var2);

    public static native int getConfigDescriptorByValue(Device var0, byte var1, ConfigDescriptor var2);

    public static native void freeConfigDescriptor(ConfigDescriptor var0);

    public static native int getSsEndpointCompanionDescriptor(Context var0, EndpointDescriptor var1, SsEndpointCompanionDescriptor var2);

    public static native void freeSsEndpointCompanionDescriptor(SsEndpointCompanionDescriptor var0);

    public static native int getBosDescriptor(DeviceHandle var0, BosDescriptor var1);

    public static native void freeBosDescriptor(BosDescriptor var0);

    public static native int getUsb20ExtensionDescriptor(Context var0, BosDevCapabilityDescriptor var1, Usb20ExtensionDescriptor var2);

    public static native void freeUsb20ExtensionDescriptor(Usb20ExtensionDescriptor var0);

    public static native int getSsUsbDeviceCapabilityDescriptor(Context var0, BosDevCapabilityDescriptor var1, SsUsbDeviceCapabilityDescriptor var2);

    public static native void freeSsUsbDeviceCapabilityDescriptor(SsUsbDeviceCapabilityDescriptor var0);

    public static native int getContainerIdDescriptor(Context var0, BosDevCapabilityDescriptor var1, ContainerIdDescriptor var2);

    public static native void freeContainerIdDescriptor(ContainerIdDescriptor var0);

    public static int getDescriptor(DeviceHandle handle, byte type, byte index, ByteBuffer data) {
        return LibUsb.controlTransfer(handle, (byte)-128, (byte)6, (short)((type & 0xFF) << 8 | index & 0xFF), (short)0, data, 1000L);
    }

    public static int getStringDescriptor(DeviceHandle handle, byte index, short langId, ByteBuffer data) {
        return LibUsb.controlTransfer(handle, (byte)-128, (byte)6, (short)(0x300 | index & 0xFF), langId, data, 1000L);
    }

    public static native int controlTransfer(DeviceHandle var0, byte var1, byte var2, short var3, short var4, ByteBuffer var5, long var6);

    public static native int bulkTransfer(DeviceHandle var0, byte var1, ByteBuffer var2, IntBuffer var3, long var4);

    public static native int interruptTransfer(DeviceHandle var0, byte var1, ByteBuffer var2, IntBuffer var3, long var4);

    public static native int tryLockEvents(Context var0);

    public static native void lockEvents(Context var0);

    public static native void unlockEvents(Context var0);

    public static native int eventHandlingOk(Context var0);

    public static native int eventHandlerActive(Context var0);

    public static native void lockEventWaiters(Context var0);

    public static native void unlockEventWaiters(Context var0);

    public static native int waitForEvent(Context var0, long var1);

    public static native int handleEventsTimeoutCompleted(Context var0, long var1, IntBuffer var3);

    public static native int handleEventsTimeout(Context var0, long var1);

    public static native int handleEvents(Context var0);

    public static native int handleEventsCompleted(Context var0, IntBuffer var1);

    public static native int handleEventsLocked(Context var0, long var1);

    public static native int pollfdsHandleTimeouts(Context var0);

    public static native int getNextTimeout(Context var0, LongBuffer var1);

    public static synchronized void setPollfdNotifiers(Context context, PollfdListener listener, Object userData) {
        long contextId = context == null ? 0L : context.getPointer();
        if (listener == null) {
            LibUsb.unsetPollfdNotifiersNative(context);
            pollfdListeners.remove(contextId);
        } else {
            LibUsb.setPollfdNotifiersNative(context, contextId);
            pollfdListeners.put(contextId, new ImmutablePair<PollfdListener, Object>(listener, userData));
        }
    }

    static void triggerPollfdAdded(FileDescriptor fd, int events, long contextId) {
        ImmutablePair listener = (ImmutablePair)pollfdListeners.get(contextId);
        if (listener != null) {
            ((PollfdListener)listener.left).pollfdAdded(fd, events, listener.right);
        }
    }

    static void triggerPollfdRemoved(FileDescriptor fd, long contextId) {
        ImmutablePair listener = (ImmutablePair)pollfdListeners.get(contextId);
        if (listener != null) {
            ((PollfdListener)listener.left).pollfdRemoved(fd, listener.right);
        }
    }

    static native void setPollfdNotifiersNative(Context var0, long var1);

    static native void unsetPollfdNotifiersNative(Context var0);

    public static Transfer allocTransfer() {
        return LibUsb.allocTransfer(0);
    }

    public static native Transfer allocTransfer(int var0);

    public static native void freeTransfer(Transfer var0);

    public static native int submitTransfer(Transfer var0);

    public static native int cancelTransfer(Transfer var0);

    public static ByteBuffer controlTransferGetData(Transfer transfer) {
        return BufferUtils.slice(transfer.buffer(), 8, transfer.buffer().limit() - 8);
    }

    public static ControlSetup controlTransferGetSetup(Transfer transfer) {
        return new ControlSetup(transfer.buffer());
    }

    public static void fillControlSetup(ByteBuffer buffer, byte bmRequestType, byte bRequest, short wValue, short wIndex, short wLength) {
        ControlSetup setup = new ControlSetup(buffer);
        setup.setBmRequestType(bmRequestType);
        setup.setBRequest(bRequest);
        setup.setWValue(wValue);
        setup.setWIndex(wIndex);
        setup.setWLength(wLength);
    }

    public static void fillControlTransfer(Transfer transfer, DeviceHandle handle, ByteBuffer buffer, TransferCallback callback, Object userData, long timeout) {
        transfer.setDevHandle(handle);
        transfer.setEndpoint((byte)0);
        transfer.setType((byte)0);
        transfer.setTimeout(timeout);
        transfer.setBuffer(buffer);
        transfer.setUserData(userData);
        transfer.setCallback(callback);
        ControlSetup setup = new ControlSetup(buffer);
        transfer.setLength(8 + (setup.wLength() & 0xFFFF));
    }

    public static void fillBulkTransfer(Transfer transfer, DeviceHandle handle, byte endpoint, ByteBuffer buffer, TransferCallback callback, Object userData, long timeout) {
        transfer.setDevHandle(handle);
        transfer.setEndpoint(endpoint);
        transfer.setType((byte)2);
        transfer.setTimeout(timeout);
        transfer.setBuffer(buffer);
        transfer.setUserData(userData);
        transfer.setCallback(callback);
    }

    public static void fillInterruptTransfer(Transfer transfer, DeviceHandle handle, byte endpoint, ByteBuffer buffer, TransferCallback callback, Object userData, long timeout) {
        transfer.setDevHandle(handle);
        transfer.setEndpoint(endpoint);
        transfer.setType((byte)3);
        transfer.setTimeout(timeout);
        transfer.setBuffer(buffer);
        transfer.setUserData(userData);
        transfer.setCallback(callback);
    }

    public static void fillIsoTransfer(Transfer transfer, DeviceHandle handle, byte endpoint, ByteBuffer buffer, int numIsoPackets, TransferCallback callback, Object userData, long timeout) {
        transfer.setDevHandle(handle);
        transfer.setEndpoint(endpoint);
        transfer.setType((byte)1);
        transfer.setTimeout(timeout);
        transfer.setBuffer(buffer);
        transfer.setNumIsoPackets(numIsoPackets);
        transfer.setUserData(userData);
        transfer.setCallback(callback);
    }

    public static void setIsoPacketLengths(Transfer transfer, int length) {
        for (IsoPacketDescriptor isoDesc : transfer.isoPacketDesc()) {
            isoDesc.setLength(length);
        }
    }

    public static ByteBuffer getIsoPacketBuffer(Transfer transfer, int packet) {
        if (packet >= transfer.numIsoPackets()) {
            return null;
        }
        IsoPacketDescriptor[] isoDescriptors = transfer.isoPacketDesc();
        int offset = 0;
        for (int i = 0; i < packet; ++i) {
            offset += isoDescriptors[i].length();
        }
        return BufferUtils.slice(transfer.buffer(), offset, isoDescriptors[packet].length());
    }

    public static ByteBuffer getIsoPacketBufferSimple(Transfer transfer, int packet) {
        if (packet >= transfer.numIsoPackets()) {
            return null;
        }
        IsoPacketDescriptor[] isoDescriptors = transfer.isoPacketDesc();
        int offset = isoDescriptors[0].length() * packet;
        return BufferUtils.slice(transfer.buffer(), offset, isoDescriptors[packet].length());
    }

    static int hotplugCallback(Context context, Device device, int event, long hotplugId) {
        ImmutablePair callback = (ImmutablePair)hotplugCallbacks.get(hotplugId);
        int result = 0;
        if (callback != null) {
            result = ((HotplugCallback)callback.left).processEvent(context, device, event, callback.right);
        }
        if (result == 1) {
            hotplugCallbacks.remove(hotplugId);
        }
        return result;
    }

    public static synchronized int hotplugRegisterCallback(Context context, int events, int flags, int vendorId, int productId, int deviceClass, HotplugCallback callback, Object userData, HotplugCallbackHandle callbackHandle) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        hotplugCallbacks.put(globalHotplugId, new ImmutablePair<HotplugCallback, Object>(callback, userData));
        int result = LibUsb.hotplugRegisterCallbackNative(context, events, flags, vendorId == -1 ? -1 : vendorId & 0xFFFF, productId == -1 ? -1 : productId & 0xFFFF, deviceClass == -1 ? -1 : deviceClass & 0xFF, callbackHandle, globalHotplugId);
        if (result == 0) {
            ++globalHotplugId;
        } else {
            hotplugCallbacks.remove(globalHotplugId);
        }
        return result;
    }

    static native int hotplugRegisterCallbackNative(Context var0, int var1, int var2, int var3, int var4, int var5, HotplugCallbackHandle var6, long var7);

    public static void hotplugDeregisterCallback(Context context, HotplugCallbackHandle callbackHandle) {
        long handle = LibUsb.hotplugDeregisterCallbackNative(context, callbackHandle);
        hotplugCallbacks.remove(handle);
    }

    static native long hotplugDeregisterCallbackNative(Context var0, HotplugCallbackHandle var1);

    static {
        Loader.load();
    }
}

