/*
 * Decompiled with CFR 0.152.
 */
package org.defne.ejb.service;

import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.EJBContext;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.interceptor.ExcludeClassInterceptors;
import javax.interceptor.Interceptors;
import org.defne.ejb.service.TransactionalInterceptor;
import org.defne.service.Message;
import org.defne.service.annotation.ServiceScanner;
import org.defne.service.exception.SecurityException;
import org.defne.service.exception.ServiceNotFoundException;
import org.defne.service.executor.IServiceExecutor;
import org.defne.utility.Utility;
import org.defne.utility.exception.DefneException;
import org.defne.utility.reflection.ReflectionUtils;

@Interceptors(value={TransactionalInterceptor.class})
public class ServiceExecutor
implements IServiceExecutor {
    private ServiceScanner serviceScanner = null;
    @Resource
    private EJBContext context;

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public Message executeWithTransaction(Message inputBag) throws DefneException {
        return this.execute(inputBag);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public Message executeWithNewTransaction(Message inputBag) throws DefneException {
        return this.execute(inputBag);
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    @ExcludeClassInterceptors
    public Message executeWithoutTransaction(Message inputBag) throws DefneException {
        return this.execute(inputBag);
    }

    @PostConstruct
    protected void postConstruct() {
        this.serviceScanner = ServiceScanner.getInstance();
    }

    private Message execute(Message inputBag) throws DefneException {
        Message outputBag = null;
        try {
            ServiceScanner.ServiceMethod serviceMethod = this.serviceScanner.getServiceMethod(ReflectionUtils.getThreadClassLoader(), inputBag.getServiceName(), inputBag.getServiceMethodName());
            if (serviceMethod == null) {
                throw new ServiceNotFoundException("Service with name : " + inputBag.getServiceName() + ", method : " + inputBag.getServiceMethodName() + " not found");
            }
            Set roles = serviceMethod.getRoles();
            boolean securityPass = false;
            for (String role : roles) {
                if (!this.context.isCallerInRole(role)) continue;
                securityPass = true;
                break;
            }
            if (!securityPass) {
                throw new SecurityException("You are not authorized to execute service method. Service name : " + inputBag.getServiceName() + ", service method : " + inputBag.getServiceMethodName());
            }
            outputBag = (Message)serviceMethod.getServiceMethod().invoke(null, inputBag);
        }
        catch (Exception e) {
            Utility.throwsDefneException((Exception)e);
        }
        return outputBag;
    }
}

