/*
 * @Copyright 2010, MechSoft 
 * MechSoft, Mechanical and Software Solutions 
 * 
 * Licensed under the Apache License, Version 2.0 (the 
 * "License"); you may not use this file except in compliance 
 * with the License. You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.defne.owb;

import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.defne.service.Message;
import org.defne.service.executor.IServiceExecutorProxy;
import org.defne.utility.exception.DefneException;
import org.defne.utility.log.ILogger;
import org.defne.utility.log.LoggerProvider;

public class PojoServiceExecutor
{
    private static final ILogger logger = LoggerProvider.getLogProvider(PojoServiceExecutor.class);
    
    @SuppressWarnings("unchecked")
    private static IServiceExecutorProxy getPojoServiceExecutor()
    {
        try
        {
            InitialContext context = new InitialContext();
            BeanManager beanManager = (BeanManager)context.lookup("java:comp/BeanManager");
            Bean<OwbPojoServiceExecutorProxy> executor = (Bean<OwbPojoServiceExecutorProxy>) beanManager.getBeans("OwbPojoServiceExecutorProxy").iterator().next();
                        
            return (IServiceExecutorProxy)beanManager.getReference(executor, IServiceExecutorProxy.class, 
                    beanManager.createCreationalContext(executor));
        }
        catch (NamingException e)
        {
            logger.error(e);
            throw new DefneException("Unable to get IPojoServiceExecutor.",e);
        }
    }

    
    public static Message execute(Message inputBag) throws DefneException
    {
        IServiceExecutorProxy proxy = getPojoServiceExecutor();
        
        return proxy.execute(inputBag);
    }

    
}
