/*
 * @Copyright 2010, MechSoft 
 * MechSoft, Mechanical and Software Solutions 
 * 
 * Licensed under the Apache License, Version 2.0 (the 
 * "License"); you may not use this file except in compliance 
 * with the License. You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.defne.owb.beans;

import java.lang.reflect.Method;

import org.defne.owb.interceptors.binding.Transactional;
import org.defne.service.Message;
import org.defne.service.executor.IPojoServiceExecutor;
import org.defne.utility.Utility;
import org.defne.utility.exception.DefneException;

/**
 * Implementation of the {@link IPojoServiceExecutor} contract.
 * <p>
 * Transaction is provided by the 
 * </p>
 * @author gurkanerdogdu
 *
 */
public class OwbPojoServiceExecutor implements IPojoServiceExecutor
{
    
    public OwbPojoServiceExecutor()
    {
        
    }
    
    /**
     * {@inheritDoc}
     */
    @Override
    public Message executeWithNewTransaction(Message inputBag) throws DefneException
    {
        throw new DefneException("OwbPojoServiceExecutor # executeWithNewTransaction is " +
        		"not supported on Pojo based executions");
    }
    
    /**
     * {@inheritDoc}
     */
    @Transactional
    @Override
    public Message executeWithTransaction(Message inputBag) throws DefneException
    {
        return execute(inputBag);
    }
    
    /**
     * {@inheritDoc}
     */
    @Override
    public Message executeWithoutTransaction(Message inputBag) throws DefneException
    {
        return execute(inputBag);
    }
    
    /**
     * Execute the given service.
     * 
     * @param inputBag the input bag
     * @return the service bag
     * @throws Exception the exception
     */
    private Message execute(Message inputBag) throws DefneException
    {
        Message outputBag = null;
        try
        {
            Method serviceMethod = inputBag.getMessageParameter(Method.class, "METHOD");            
            outputBag = (Message) serviceMethod.invoke(null, new Object[]{inputBag});            
        }
        catch (Exception e)
        {
            Throwable result = e;            
            if(result instanceof DefneException)
            {
                throw (DefneException)result;
            }
            
            result = Utility.getTargetException(e);
            if(result instanceof DefneException)
            {
                throw (DefneException)result;
            }
            
            throw new DefneException(result);
        }

        return outputBag;
    }
    

}
