/*
 * Decompiled with CFR 0.152.
 */
package org.defne.owb;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import org.defne.owb.bindings.EjbExecutorProxy;
import org.defne.service.Message;
import org.defne.service.MessageFactory;
import org.defne.service.executor.IServiceExecutorProxy;
import org.defne.service.executor.ServiceExecutorProxyProvider;
import org.defne.service.executor.ServiceExecutorProxyTypes;
import org.defne.service.util.ServiceUtility;
import org.defne.utility.exception.DefneException;
import org.defne.utility.log.ILogger;
import org.defne.utility.log.LoggerProvider;

@Named(value="OwbEjbServiceExecutorProxy")
@ApplicationScoped
@EjbExecutorProxy
public class OwbEjbServiceExecutorProxy
implements IServiceExecutorProxy {
    private static final ILogger logger = LoggerProvider.getLogProvider(OwbEjbServiceExecutorProxy.class);
    private String ejbJndiName;
    private IServiceExecutorProxy proxy;

    @PostConstruct
    public void init() {
        this.proxy = ServiceExecutorProxyProvider.getServiceExecutorProxy((ServiceExecutorProxyTypes)ServiceExecutorProxyTypes.EJB);
    }

    public Message execute(Message inputBag) {
        Message outputBag;
        block3: {
            outputBag = MessageFactory.newMessage((String)inputBag.getServiceName(), (String)inputBag.getServiceMethodName());
            try {
                if (this.ejbJndiName == null) {
                    throw new DefneException("Service Executor EJB Jndi name is null");
                }
                inputBag.putMessageParameter("org.defne.service.BagValue_5", (Object)this.ejbJndiName);
                outputBag = this.proxy.execute(inputBag);
            }
            catch (DefneException exception) {
                if (!logger.isErrorEnabled()) break block3;
                logger.error(ServiceUtility.getErrorMessage((Message)outputBag, (DefneException)exception), exception.getCause());
                outputBag = ServiceUtility.getServiceExecutionError((Message)outputBag, (DefneException)exception);
            }
        }
        return outputBag;
    }

    public String getEjbJndiName() {
        return this.ejbJndiName;
    }

    public void setEjbJndiName(String ejbJndiName) {
        this.ejbJndiName = ejbJndiName;
    }

    @PreDestroy
    public void destroy() {
        this.clear(this.ejbJndiName);
    }

    public void clear(Object clearObject) {
        this.proxy.clear(clearObject);
    }
}

