/*
 * Decompiled with CFR 0.152.
 */
package org.defne.owb;

import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.EntityManagerFactory;
import org.defne.jpa.api.EmfProvider;
import org.defne.jpa.impl.ServiceBagEnitityManagerProvider;
import org.defne.owb.bindings.PojoExecutorProxy;
import org.defne.security.spi.IPrincipal;
import org.defne.service.Message;
import org.defne.service.MessageFactory;
import org.defne.service.TransactionPolicy;
import org.defne.service.annotation.ServiceScanner;
import org.defne.service.exception.SecurityException;
import org.defne.service.exception.ServiceNotFoundException;
import org.defne.service.executor.IPojoServiceExecutor;
import org.defne.service.executor.IServiceExecutorProxy;
import org.defne.service.util.ServiceUtility;
import org.defne.utility.exception.DefneException;
import org.defne.utility.factories.SingletonProvider;
import org.defne.utility.log.ILogger;
import org.defne.utility.log.LoggerProvider;
import org.defne.utility.reflection.ReflectionUtils;

@Named(value="OwbPojoServiceExecutorProxy")
@ApplicationScoped
@PojoExecutorProxy
public class OwbPojoServiceExecutorProxy
implements IServiceExecutorProxy {
    private static final ILogger logger = LoggerProvider.getLogProvider(OwbPojoServiceExecutorProxy.class);
    @Inject
    private IPojoServiceExecutor pojoServiceExecutor;
    @Inject
    private IPrincipal principal;
    private ServiceScanner serviceScanner = null;

    public void clear(Object clearObject) {
        this.pojoServiceExecutor = null;
    }

    @PostConstruct
    protected void postConstruct() {
        this.serviceScanner = ServiceScanner.getInstance();
    }

    public Message execute(Message inBag) throws DefneException {
        Message oBag;
        block11: {
            oBag = MessageFactory.newMessage((String)inBag.getServiceName(), (String)inBag.getServiceMethodName());
            try {
                ServiceScanner.ServiceMethod serviceMethod = this.serviceScanner.getServiceMethod(ReflectionUtils.getThreadClassLoader(), inBag.getServiceName(), inBag.getServiceMethodName());
                if (serviceMethod == null) {
                    throw new ServiceNotFoundException("Service with name : " + inBag.getServiceName() + ", method : " + inBag.getServiceMethodName() + " not found");
                }
                String[] userRoles = this.principal.roles();
                Set serviceRoles = serviceMethod.getRoles();
                boolean securityPass = false;
                if (serviceRoles.isEmpty()) {
                    securityPass = true;
                } else {
                    for (String serviceRole : serviceRoles) {
                        if (userRoles == null || userRoles.length <= 0) continue;
                        for (String userRole : userRoles) {
                            if (!userRole.equals(serviceRole)) continue;
                            securityPass = true;
                            break;
                        }
                        if (!securityPass) continue;
                        break;
                    }
                }
                if (!securityPass) {
                    throw new SecurityException("You are not authorized to execute service method. Service name : " + inBag.getServiceName() + ", service method : " + inBag.getServiceMethodName());
                }
                inBag.putMessageParameter("METHOD", (Object)serviceMethod.getServiceMethod());
                TransactionPolicy transactionPolicy = null;
                transactionPolicy = inBag.isExist("org.defne.service.BagValue_4") ? (TransactionPolicy)inBag.getMessageParameter(TransactionPolicy.class, "org.defne.service.BagValue_4") : serviceMethod.getTransactionPolicy();
                boolean useJpaLogic = false;
                useJpaLogic = inBag.isExist("org.defne.service.BagValue_11") ? (Boolean)inBag.getMessageParameter(Boolean.class, "org.defne.service.BagValue_11") : (transactionPolicy.equals((Object)TransactionPolicy.WITH_TRANSACTION) || transactionPolicy.equals((Object)TransactionPolicy.NEW_TRANSACTION) ? true : serviceMethod.isUseEm());
                if (useJpaLogic) {
                    String emfUnitName = null;
                    emfUnitName = inBag.isExist("org.defne.service.BagValue_6") ? (String)inBag.getMessageParameter(String.class, "org.defne.service.BagValue_6") : serviceMethod.getEmUnitName();
                    EmfProvider emfProvider = (EmfProvider)SingletonProvider.getSingletonInstance((String)"org.defne.jpa.impl.DefaultEmfProvider", (ClassLoader)ReflectionUtils.getThreadClassLoader());
                    EntityManagerFactory factory = emfProvider.getEntityManagerFactory(emfUnitName);
                    if (factory == null) {
                        throw new DefneException("There is no JPA EntityManagerFactory for the EMF unit name : " + emfUnitName);
                    }
                    boolean putEntityManager = false;
                    putEntityManager = inBag.isExist("org.defne.service.BagValue_3") ? (inBag.isExist("org.defne.service.BagValue_12") ? ((Boolean)inBag.getMessageParameter(Boolean.class, "org.defne.service.BagValue_12")).booleanValue() : transactionPolicy.equals((Object)TransactionPolicy.NEW_TRANSACTION)) : true;
                    if (putEntityManager) {
                        inBag.putMessageParameter("org.defne.service.BagValue_3", (Object)new ServiceBagEnitityManagerProvider(factory.createEntityManager()));
                    }
                }
                oBag = transactionPolicy.equals((Object)TransactionPolicy.NO_TRANSACTION) ? this.pojoServiceExecutor.executeWithoutTransaction(inBag) : this.pojoServiceExecutor.executeWithTransaction(inBag);
            }
            catch (DefneException e) {
                if (!logger.isErrorEnabled()) break block11;
                logger.error(ServiceUtility.getErrorMessage((Message)inBag, (DefneException)e), e.getCause());
                oBag = ServiceUtility.getServiceExecutionError((Message)oBag, (DefneException)e);
            }
        }
        return oBag;
    }

    @PreDestroy
    protected void preDestroy() {
        EmfProvider emfProvider = (EmfProvider)SingletonProvider.getSingletonInstance((String)"org.defne.jpa.impl.DefaultEmfProvider", (ClassLoader)ReflectionUtils.getThreadClassLoader());
        emfProvider.removeEntityManagerFactories();
        this.pojoServiceExecutor = null;
        this.principal = null;
        this.serviceScanner = null;
    }
}

