/*
 * Decompiled with CFR 0.152.
 */
package org.defne.owb;

import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.defne.service.Message;
import org.defne.service.executor.IServiceExecutorProxy;
import org.defne.utility.exception.DefneException;
import org.defne.utility.log.ILogger;
import org.defne.utility.log.LoggerProvider;

public class PojoServiceExecutor {
    private static final ILogger logger = LoggerProvider.getLogProvider(PojoServiceExecutor.class);

    private static IServiceExecutorProxy getPojoServiceExecutor() {
        try {
            InitialContext context = new InitialContext();
            BeanManager beanManager = (BeanManager)context.lookup("java:comp/BeanManager");
            Bean executor = (Bean)beanManager.getBeans("OwbPojoServiceExecutorProxy").iterator().next();
            return (IServiceExecutorProxy)beanManager.getReference(executor, IServiceExecutorProxy.class, beanManager.createCreationalContext((Contextual)executor));
        }
        catch (NamingException e) {
            logger.error((Throwable)e);
            throw new DefneException("Unable to get IPojoServiceExecutor.", (Throwable)e);
        }
    }

    public static Message execute(Message inputBag) throws DefneException {
        IServiceExecutorProxy proxy = PojoServiceExecutor.getPojoServiceExecutor();
        return proxy.execute(inputBag);
    }
}

