/*
 * Decompiled with CFR 0.152.
 */
package org.defne.owb.interceptors;

import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.defne.jpa.impl.ServiceBagEnitityManagerProvider;
import org.defne.owb.interceptors.binding.Transactional;
import org.defne.service.Message;
import org.defne.utility.exception.DefneException;
import org.defne.utility.log.ILogger;
import org.defne.utility.log.LoggerProvider;

@Interceptor
@Transactional
public class TransactionalInterceptor {
    private static final ILogger logger = LoggerProvider.getLogProvider(TransactionalInterceptor.class);

    @AroundInvoke
    public Object aroundInvoke(InvocationContext invocationContext) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("Calling method : " + invocationContext.getMethod());
        }
        boolean active = false;
        EntityManager manager = null;
        EntityTransaction entityTransaction = null;
        ServiceBagEnitityManagerProvider provider = null;
        Message inputBag = null;
        try {
            inputBag = (Message)invocationContext.getParameters()[0];
            if (!inputBag.isExist("org.defne.service.BagValue_3")) {
                throw new DefneException("EntityManager is null but it is required to execute service name : " + inputBag.getServiceName() + " for service method : " + inputBag.getServiceMethodName());
            }
            provider = (ServiceBagEnitityManagerProvider)inputBag.getMessageParameter(ServiceBagEnitityManagerProvider.class, "org.defne.service.BagValue_3");
            if (provider == null || (manager = provider.getEntityManager()) == null) {
                throw new DefneException("EntityManager is null but it is required to execute service name : " + inputBag.getServiceName() + " for service method : " + inputBag.getServiceMethodName());
            }
            entityTransaction = manager.getTransaction();
            if (entityTransaction != null) {
                active = entityTransaction.isActive();
            }
            if (!active) {
                entityTransaction.begin();
            }
            Object object = invocationContext.proceed();
            return object;
        }
        catch (Exception e) {
            if (!active && entityTransaction != null && entityTransaction.isActive()) {
                entityTransaction.rollback();
            }
            throw e;
        }
        finally {
            if (!active) {
                if (entityTransaction != null && entityTransaction.isActive()) {
                    entityTransaction.commit();
                }
                if (manager != null) {
                    manager.close();
                }
                if (provider != null) {
                    provider.destroyEntityManager();
                    inputBag.removeMessageParameter("org.defne.service.BagValue_3");
                }
            }
        }
    }
}

