/*
 * @Copyright 2010, MechSoft 
 * MechSoft, Mechanical and Software Solutions 
 * 
 * Licensed under the Apache License, Version 2.0 (the 
 * "License"); you may not use this file except in compliance 
 * with the License. You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.defne.security.impl;

import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;

import org.apache.catalina.Group;
import org.apache.catalina.Role;
import org.apache.catalina.User;
import org.apache.catalina.realm.GenericPrincipal;
import org.defne.security.spi.IPrincipal;

@RequestScoped
@Alternative
public class SiwpasProvidedPrincipal implements IPrincipal
{
    private @Inject Principal currentPrincipal;
    
    @Override
    public String[] roles()
    {
        if(this.currentPrincipal instanceof GenericPrincipal)
        {
            GenericPrincipal gpr = (GenericPrincipal)this.currentPrincipal;
            if(gpr != null)
            {
                return gpr.getRoles();
            }
        }
        else if(this.currentPrincipal instanceof User)
        {
            User user = (User)this.currentPrincipal;
            if(user != null)
            {
                Iterator<Role> roles = user.getRoles();
                Set<String> listRoles = new HashSet<String>();
                if(roles != null)
                {
                    while(roles.hasNext())
                    {
                        listRoles.add(roles.next().getRolename());
                    }
                }
                
                Iterator<Group> groups = user.getGroups();
                if(groups != null)
                {
                    while(groups.hasNext())
                    {
                        Group group = groups.next();
                        roles = group.getRoles();
                        if(roles != null)
                        {
                            while(roles.hasNext())
                            {
                                listRoles.add(roles.next().getRolename());
                            }
                        }                        
                    }
                }
                
                String[] actualRoles = new String[listRoles.size()];
                actualRoles = listRoles.toArray(actualRoles);
                return actualRoles;
            }
        }
        
        return new String[0];
    }

}
