/*
 * Decompiled with CFR 0.152.
 */
package org.defne.security.impl;

import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import org.apache.catalina.Group;
import org.apache.catalina.Role;
import org.apache.catalina.User;
import org.apache.catalina.realm.GenericPrincipal;
import org.defne.security.spi.IPrincipal;

@RequestScoped
@Alternative
public class SiwpasProvidedPrincipal
implements IPrincipal {
    @Inject
    private Principal currentPrincipal;

    @Override
    public String[] roles() {
        User user;
        if (this.currentPrincipal instanceof GenericPrincipal) {
            GenericPrincipal gpr = (GenericPrincipal)this.currentPrincipal;
            if (gpr != null) {
                return gpr.getRoles();
            }
        } else if (this.currentPrincipal instanceof User && (user = (User)this.currentPrincipal) != null) {
            Iterator groups;
            Iterator roles = user.getRoles();
            HashSet<String> listRoles = new HashSet<String>();
            if (roles != null) {
                while (roles.hasNext()) {
                    listRoles.add(((Role)roles.next()).getRolename());
                }
            }
            if ((groups = user.getGroups()) != null) {
                while (groups.hasNext()) {
                    Group group = (Group)groups.next();
                    roles = group.getRoles();
                    if (roles == null) continue;
                    while (roles.hasNext()) {
                        listRoles.add(((Role)roles.next()).getRolename());
                    }
                }
            }
            String[] actualRoles = new String[listRoles.size()];
            actualRoles = listRoles.toArray(actualRoles);
            return actualRoles;
        }
        return new String[0];
    }
}

