/*
 * @Copyright 2010, MechSoft 
 * MechSoft, Mechanical and Software Solutions 
 * 
 * Licensed under the Apache License, Version 2.0 (the 
 * "License"); you may not use this file except in compliance 
 * with the License. You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.defne.utility;

/**
 * Some assertions.
 * 
 * @version $Rev$ $Date$
 *
 */
public final class Assertions
{   
    /**Constant*/
    private static final String UNKNOWN_PARAMETER_NAME = "unknown";

    /**Constant*/
    private static final String PARAMETER_IS_NULL = " parameter is null";
    
    /**
     * Private constructor.
     */
    private Assertions()
    {
        throw new UnsupportedOperationException();
    }
    
    /**
     * Checks the given parameter for nullability.
     * @param object controlled object
     * @param message message
     */
    public static void checkForNull(Object object, String message)
    {
        if (object == null)
        {
            throw new NullPointerException(message);
        }
    }
    
    /**
     * Checks the given parameter for nullability.
     * @param object controlled object
     * @param parameterName parameter name
     */
    public static void checkForNullParameter(Object object, String parameterName)
    {
        if(object == null)
        {
            if(parameterName == null)
            {
                parameterName = UNKNOWN_PARAMETER_NAME;
            }
            
            StringBuilder builder = new StringBuilder();
            builder.append(parameterName);
            builder.append(PARAMETER_IS_NULL);
            
            throw new NullPointerException(builder.toString());
        }        
    }
    

}
