/*
 * @Copyright 2010, MechSoft 
 * MechSoft, Mechanical and Software Solutions 
 * 
 * Licensed under the Apache License, Version 2.0 (the 
 * "License"); you may not use this file except in compliance 
 * with the License. You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.defne.utility.exception;

/**
 * Main root exception for all general types of exceptions. Specific runtime
 * exceptions could extend {@link DefneException} for more specific exceptions.
 */
public class DefneException extends RuntimeException
{

    // Default id
    private static final long serialVersionUID = 1L;

    /**
     * Instantiates a new green exception.
     */
    public DefneException()
    {
        super();
    }

    /**
     * Instantiates a new green exception.
     * 
     * @param message the message
     */
    public DefneException(String message)
    {
        super(message);
    }

    /**
     * Instantiates a new green exception.
     * 
     * @param cause the cause
     */
    public DefneException(Throwable cause)
    {
        super(cause);
    }

    /**
     * Instantiates a new green exception.
     * 
     * @param message the message
     * @param cause the cause
     */
    public DefneException(String message, Throwable cause)
    {
        super(message, cause);
    }

}